/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.config;

import com.evermind.server.jms.config.JMSRouterJobConfig;
import com.evermind.server.jms.config.XMLJMSRouterConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLJMSRouterJobConfig
extends JMSRouterJobConfig {
    public static final String JOB_NODE = "router-job";
    public static final String JOB_NODE_NAME_ATTR = "job-name";

    public XMLJMSRouterJobConfig() {
    }

    public XMLJMSRouterJobConfig(String jobName, Properties props) {
        this.setJobName(jobName);
        this.setProperties(props);
    }

    public XMLJMSRouterJobConfig(Node node) {
        this.setJobName(XMLJMSRouterConfig.getNodeAttribute(node, JOB_NODE_NAME_ATTR));
        String jobPrefix = "job." + this.getJobName();
        List attrList = this.getAttrList();
        Iterator iter = attrList.iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            this.setProperty(jobPrefix + "." + attrName, XMLJMSRouterConfig.getNodeAttribute(node, attrName));
        }
        List hiddenList = this.getHiddenAttrList();
        iter = hiddenList.iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            this.setProperty(jobPrefix + "." + attrName, XMLJMSRouterConfig.getNodeAttribute(node, attrName));
        }
        List elemList = this.getElemList();
        iter = elemList.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.setProperty(jobPrefix + "." + name, XMLJMSRouterJobConfig.getSubnodeValue(node, name));
        }
    }

    public final synchronized void writeXML(PrintWriter out, String indent) throws IOException {
        String propName;
        String jobPrefix = "job." + this.getJobName() + ".";
        String nextIndent = indent + "    ";
        StringBuffer strbuf = new StringBuffer(1000).append(indent).append("<").append(JOB_NODE);
        out.println(strbuf.toString());
        strbuf.delete(0, strbuf.length());
        strbuf.append(nextIndent).append(JOB_NODE_NAME_ATTR).append("=\"").append(this.getJobName()).append("\" ");
        out.println(strbuf.toString());
        strbuf.delete(0, strbuf.length());
        Iterator iter = this.getAttrList().iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            propName = jobPrefix + attrName;
            strbuf.append(nextIndent).append(attrName).append("=\"").append(this.getPropNonNull(propName)).append("\" ");
            out.println(strbuf.toString());
            strbuf.delete(0, strbuf.length());
        }
        out.println(indent + ">");
        iter = this.getElemList().iterator();
        while (iter.hasNext()) {
            String elemName = (String)iter.next();
            propName = jobPrefix + elemName;
            strbuf.append(nextIndent).append("<").append(elemName).append(">").append(this.getPropNonNull(propName)).append("</").append(elemName).append(">");
            if (!iter.hasNext()) continue;
            strbuf.append("\n");
        }
        out.println(strbuf.toString());
        strbuf.delete(0, strbuf.length());
        strbuf.append(indent).append("</").append(JOB_NODE).append(">");
        out.println(strbuf.toString());
    }

    public static String getSubnodeValue(Node parent, String subnode) {
        Node node = XMLJMSRouterJobConfig.getSubnode(parent, subnode);
        return node == null ? null : XMLJMSRouterJobConfig.getStringValue(node);
    }

    public static Node getSubnode(Node parent, String subnode) {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(subnode)) continue;
                return node;
            }
        }
        return null;
    }

    public static String getStringValue(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String value = child.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    private String getPropNonNull(String propName) {
        String propVal = this.getProperty(propName);
        return propVal == null ? "" : propVal;
    }
}

