/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.PQContainer;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerFile;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.Tset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.management.j2ee.statistics.Stats;
import oracle.oc4j.admin.management.callbackinterfaces.JMSStatisticsProviderCallBackIf;
import oracle.oc4j.admin.management.mbeans.JMSStore;
import oracle.oc4j.admin.management.shared.statistic.JMSStoreStatsImpl;

public final class ServerStore
implements JMSStatisticsProviderCallBackIf {
    private final ServerDestination m_sdest;
    private final ConsumerInfo m_cons;
    private final ServerFile m_file;
    private final String m_name;
    private final JMSStats m_jstats;
    private final JMSStats m_jstatsPrime;
    private final JMSStoreStatsImpl m_stats;
    private final Tset m_isClosed = new Tset(false);
    private int m_pending = 0;
    private int m_size = 0;
    private final PQContainer m_pq = new PQContainer();
    private final Map m_sess = new HashMap();
    private final Map m_enq = new HashMap();
    private final Map m_deq = new HashMap();
    private final Map m_msgs = new HashMap();
    private final Map m_objs = new HashMap();
    private double m_pagingThreshold;
    private static boolean s_saveAllExpired;
    private static final JMSTraceLogger s_traceLogger;
    private static final boolean m_msgSizeIsValid;
    private static final String JMSSTORE = "JMSStore";
    private static final int DO_PERSIST = 1111;
    private static final int DO_DEQ = 2222;
    private static final int DO_EXPIRE = 3333;
    private static final int DO_SCAN = 4444;

    ServerStore(String dName, ServerDestination sdest, ConsumerInfo cons) throws Exception {
        String self;
        String sName;
        this.setConfigProperties();
        this.m_sdest = sdest;
        this.m_cons = cons;
        this.m_file = cons != null && !cons.isDurable() ? ServerFile.getDummy() : this.m_sdest.getFile();
        this.m_name = dName + (cons == null ? "" : "," + cons);
        Destination d = this.m_sdest.getDestination();
        String parent = dName;
        if (JMSUtils.isQ(d)) {
            sName = "destination=" + JMSUtils.getName(d);
            self = "Store." + sName;
            this.m_jstats = JMSStats.create(parent, self, JMSSTORE);
            this.m_jstatsPrime = null;
        } else {
            String dmsSubscriberType;
            sName = "destination=" + JMSUtils.getName(cons.getDestination());
            if (cons.isDurable()) {
                self = "clientID=" + cons.getClientID() + ",subscriber=" + cons.getName();
                dmsSubscriberType = "JMSStoreDurableSubscriber";
            } else {
                self = "consumer=" + cons.getCount();
                dmsSubscriberType = "JMSStoreNonDurableSubscriber";
            }
            String selfParent = "Store." + sName;
            this.m_jstatsPrime = JMSStats.create(parent, selfParent, JMSSTORE);
            this.m_jstats = JMSStats.create(parent + "/" + selfParent, self, dmsSubscriberType);
        }
        this.m_jstats.setMBean(new JMSStore(this, self, sdest.getID(), JMSUtils.getName(d)));
        this.m_jstats.state("destination", sName, true);
        if (m_msgSizeIsValid) {
            this.m_jstats.state("storeSize", new Long(0L));
        }
        this.m_jstats.state("messageCount", new Long(0L));
        this.m_jstats.state("pendingMessageCount", new Long(0L));
        this.initEvent("messageCommitted");
        this.initEvent("messageRolledBack");
        this.initEvent("messageEnqueued");
        this.initEvent("messageDequeued");
        this.initEvent("messageRecovered");
        this.initEvent("messageExpired");
        this.initEvent("messageDiscarded");
        this.initEvent("messagePagedOut");
        this.initEvent("messagePagedIn");
        this.m_stats = new JMSStoreStatsImpl(this.getMetricPath());
    }

    private void setConfigProperties() {
        KnobsController kc = KnobsController.getKnobsController();
        this.m_pagingThreshold = (Double)kc.listenToConfigProperty("oc4j.jms.pagingThreshold", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                ServerStore.this.setPagingThreshold((Double)event.getPropertyValue());
            }
        });
        s_saveAllExpired = (Boolean)kc.listenToConfigProperty("oc4j.jms.saveAllExpired", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                ServerStore.setSaveAllExpired((Boolean)event.getPropertyValue());
            }
        });
    }

    public String toString() {
        return "ServerStore[" + this.m_name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws Exception {
        block6: {
            if (this.m_isClosed.testAndSet(true)) {
                return;
            }
            try {
                this.cleanMessages();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.clearAll();
                }
                catch (Throwable ex) {
                    s_traceLogger.fine("fine", ex);
                }
                this.m_jstats.close();
                throw throwable;
            }
            try {
                this.clearAll();
                break block6;
            }
            catch (Throwable ex) {
                s_traceLogger.fine("fine", ex);
            }
            {
            }
        }
        this.m_jstats.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enq(String connID, Object sessionID, boolean keepState, EvermindMessage msg) throws JMSException {
        long tok = this.startPhase("enq");
        try {
            if (msg.getJMSDestination() == null) {
                msg.setJMSDestination(this.m_sdest.getDestination());
            }
            msg.setJMSRedelivered(false);
            msg.setDeliveryCount(1);
            this.addMessage(msg);
            this.storeMessage(msg, sessionID, keepState);
            if (keepState) {
                String id = msg.getID();
                this.ensureSession(sessionID);
                ((Set)this.m_sess.get(sessionID)).add(id);
                this.m_enq.put(id, sessionID);
                ++this.m_pending;
            }
            this.event("messageEnqueued");
        }
        finally {
            this.stopPhase("enq", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage deq(ConsumerInfo cons, Object sessionID, String txid, boolean keepState) throws JMSException {
        long tok = this.startPhase("deq");
        try {
            List ret = this.foreach(2222, sessionID, txid, keepState, cons.getSelector());
            if (ret.size() == 0) {
                EvermindMessage evermindMessage = null;
                return evermindMessage;
            }
            EvermindMessage msg = (EvermindMessage)ret.get(0);
            if (keepState) {
                this.ensureSession(sessionID);
                String id = msg.getID();
                if (this.enqSession(id) == null) {
                    ((Set)this.m_sess.get(sessionID)).add(id);
                    this.m_deq.put(id, sessionID);
                    ++this.m_pending;
                } else {
                    ((Set)this.m_sess.get(sessionID)).remove(id);
                    this.m_enq.remove(id);
                }
            }
            this.event("messageDequeued");
            EvermindMessage evermindMessage = msg;
            return evermindMessage;
        }
        finally {
            this.stopPhase("deq", tok);
        }
    }

    public synchronized void expireMessages() {
        long tok = this.startPhase("expireMessages");
        try {
            this.foreach(3333, null, null, false, null);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("expireMessages", ex);
        }
        this.updateStats();
        this.stopPhase("expireMessages", tok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listMessages(Object sessionID, MessageSelector selector) throws JMSException {
        long tok = this.startPhase("listMessages");
        try {
            List list = this.foreach(4444, sessionID, "", false, selector);
            return list;
        }
        finally {
            this.stopPhase("listMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage peekMessage(String msgID) throws JMSException {
        long tok = this.startPhase("peekMessage");
        try {
            if (!this.m_msgs.containsKey(msgID)) {
                EvermindMessage evermindMessage = null;
                return evermindMessage;
            }
            EvermindMessage msg = (EvermindMessage)this.m_msgs.get(msgID);
            if (msg == null || this.isExpired(msg) || this.inDeq(msgID)) {
                EvermindMessage evermindMessage = null;
                return evermindMessage;
            }
            EvermindMessage evermindMessage = this.checkPageIn(msg, true);
            return evermindMessage;
        }
        finally {
            this.stopPhase("peekMessage", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Object sessionID) throws JMSException {
        long tok = this.startPhase("commit");
        try {
            if (!this.m_sess.containsKey(sessionID)) {
                return;
            }
            Iterator iter = ((Set)this.m_sess.get(sessionID)).iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                Object sid = this.getSession(id);
                if (sid == null || !sid.equals(sessionID)) continue;
                if (this.inDeq(id)) {
                    this.remove((EvermindMessage)this.m_msgs.get(id), null);
                    this.m_objs.remove(id);
                }
                this.event("messageCommitted");
                --this.m_pending;
            }
            this.removeSession(sessionID);
        }
        finally {
            this.stopPhase("commit", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Object sessionID) throws JMSException {
        long tok = this.startPhase("rollback");
        try {
            if (!this.m_sess.containsKey(sessionID)) {
                return;
            }
            this.doRollback(sessionID);
            this.removeSession(sessionID);
        }
        finally {
            this.stopPhase("rollback", tok);
        }
    }

    public synchronized void addConsumer(ConsumerInfo cons) throws JMSException {
        long tok = this.startPhase("addConsumer");
        this.stopPhase("addConsumer", tok);
    }

    public synchronized void removeConsumer(ConsumerInfo cons) throws JMSException {
        long tok = this.startPhase("removeConsumer");
        this.stopPhase("removeConsumer", tok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listDurableConsumers() {
        long tok = this.startPhase("listDurableConsumers");
        try {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            this.stopPhase("listDurableConsumers", tok);
        }
    }

    synchronized int getTransactionCount() {
        return this.m_sess.size();
    }

    synchronized void loadMessage(EvermindMessage msg, Integer objid) throws Exception {
        if (this.m_msgs.containsKey(msg.getID())) {
            EvermindMessage omsg = (EvermindMessage)this.m_msgs.get(msg.getID());
            if (omsg.getDeliveryCount() > msg.getDeliveryCount()) {
                this.m_file.removeObject(objid, null);
            } else {
                this.removeObject(msg.getID(), null);
                this.addMessage(msg);
                this.m_objs.put(msg.getID(), objid);
            }
        } else {
            this.addMessage(msg);
            this.m_objs.put(msg.getID(), objid);
            SessionID sid = (SessionID)this.m_file.getOpenXATxID(objid);
            if (sid != null) {
                this.ensureSession(sid);
                ((Set)this.m_sess.get(sid)).add(msg.getID());
                if (this.m_file.wasEnqueuedInOpenTx(sid, objid)) {
                    this.m_enq.put(msg.getID(), sid);
                } else {
                    this.m_deq.put(msg.getID(), sid);
                }
            }
            this.event("messageRecovered");
        }
        this.checkPageOut(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rasa() throws JMSException {
        this.m_pending = 0;
        try {
            this.m_file.rasa(this.m_objs.values().iterator());
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("rasa(" + this.m_file + ")", ex);
        }
        finally {
            this.m_objs.clear();
        }
    }

    synchronized boolean hasMessages() {
        return this.m_msgs.size() > 0;
    }

    synchronized void cleanMessages() throws JMSException {
        Iterator iter = this.m_sess.keySet().iterator();
        while (iter.hasNext()) {
            Object sessionID = iter.next();
            if (this.m_file.isXASession(sessionID)) continue;
            this.doRollback(sessionID);
            iter.remove();
        }
        this.foreach(3333, null, null, false, null);
        this.foreach(1111, null, null, false, null);
    }

    public Stats getJSR77Stats() {
        return this.m_stats;
    }

    public String getMetricPath() {
        return this.m_jstats.getName();
    }

    protected synchronized void updateStats() {
        JMSServer server;
        this.m_jstats.state("messageCount", new Long(this.m_msgs.size()));
        this.m_jstats.state("pendingMessageCount", new Long(this.m_pending));
        int size = 0;
        if (m_msgSizeIsValid) {
            Iterator iter = this.m_msgs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                size += ((EvermindMessage)entry.getValue()).getSize();
            }
            this.m_size = size;
            this.m_jstats.state("storeSize", new Long(size));
        }
        if ((server = JMSServer.getServer()) != null) {
            JMSProvider provider = server.getProvider();
            provider.messageCountTotal += (long)this.m_msgs.size();
            provider.pendingMessageCountTotal += (long)this.m_pending;
            provider.storeSizeTotal += (long)size;
        }
    }

    private boolean isTemp() {
        return JMSUtils.isTemp(this.m_sdest.getDestination());
    }

    private void addMessage(EvermindMessage msg) {
        this.m_pq.add(msg);
        this.m_msgs.put(msg.getID(), msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List foreach(int cmd, Object sessionID, String txid, boolean keepState, MessageSelector selector) throws JMSException {
        ArrayList<Object> ret = cmd == 2222 || cmd == 4444 ? new ArrayList<Object>() : null;
        Iterator iter = this.m_pq.iterator();
        while (iter.hasNext()) {
            EvermindMessage msg = (EvermindMessage)iter.next();
            switch (cmd) {
                case 1111: {
                    this.doPersist(msg, iter);
                    break;
                }
                case 2222: {
                    this.setJMSX(msg, txid);
                    if (!this.isVisible(msg, sessionID, selector)) break;
                    boolean nKeepState = keepState && !this.inEnq(msg.getID());
                    EvermindMessage rmsg = this.checkPageIn(msg, nKeepState);
                    ret.add(nKeepState ? JMSUtils.checkClone(rmsg) : rmsg);
                    if (!nKeepState) {
                        this.remove(msg, iter);
                    } else {
                        this.m_pq.remove(msg, iter);
                    }
                    this.removeObject(msg.getID(), nKeepState ? sessionID : null);
                    return ret;
                }
                case 3333: {
                    this.doExpire(msg, iter);
                    break;
                }
                case 4444: {
                    this.setJMSX(msg, txid);
                    if (!this.isVisible(msg, sessionID, selector)) break;
                    ret.add(msg.getID());
                }
            }
        }
        return ret;
    }

    private void removeSession(Object sessionID) {
        Iterator iter = ((Set)this.m_sess.get(sessionID)).iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            this.m_enq.remove(id);
            this.m_deq.remove(id);
        }
        this.m_sess.remove(sessionID);
    }

    private void doExpire(EvermindMessage msg, Iterator iter) throws JMSException {
        this.checkPageOut(msg);
        String id = msg.getID();
        if (this.getSession(id) != null) {
            return;
        }
        if (this.isExpired(msg)) {
            this.remove(msg, iter);
            this.removeObject(id, null);
            this.event("messageExpired");
            if (s_saveAllExpired || this.isPersistent()) {
                if (!this.isPersistent()) {
                    msg.setJMSDeliveryMode(1);
                }
                JMSServer.saveExpired(msg, this.m_cons);
            }
        }
    }

    private boolean isPersistent() {
        return !this.isTemp() && this.m_file != null && !this.m_file.isDummy();
    }

    private void doPersist(EvermindMessage msg, Iterator iter) throws JMSException {
        String id = msg.getID();
        if (msg.getJMSDeliveryMode() != 2) {
            this.remove(msg, iter);
            this.removeObject(id, null);
        }
    }

    private void doRollback(Object sessionID) throws JMSException {
        Iterator iter = ((Set)this.m_sess.get(sessionID)).iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Object sid = this.getSession(id);
            if (sid == null || !sid.equals(sessionID)) continue;
            EvermindMessage msg = (EvermindMessage)this.m_msgs.get(id);
            if (this.inEnq(id)) {
                this.remove(msg, null);
                this.m_objs.remove(id);
                if (!this.inDeq(id)) {
                    this.event("messageDiscarded");
                }
            } else {
                msg.setJMSRedelivered(true);
                msg.setDeliveryCount(msg.getDeliveryCount() + 1);
                this.addMessage(msg);
                try {
                    this.checkPageIn(msg);
                    this.m_objs.put(id, this.m_file.replaceObject((Integer)this.m_objs.get(id), msg.toBytes()));
                    this.checkPageOut(msg);
                }
                catch (Throwable ex) {
                    JMSUtils.toJMSException("replaceObject(" + id + "," + sessionID + ")", ex);
                }
                this.event("messageRecovered");
            }
            this.event("messageRolledBack");
            --this.m_pending;
        }
    }

    private void setJMSX(EvermindMessage msg, String txid) throws JMSException {
        msg.forceObjectProperty("JMSXConsumerTXID", txid);
        msg.forceObjectProperty("JMSXRcvTimestamp", new Long(System.currentTimeMillis()));
    }

    private boolean inEnq(String id) {
        return this.m_enq.containsKey(id);
    }

    private boolean inDeq(String id) {
        return this.m_deq.containsKey(id);
    }

    private Object enqSession(String id) {
        return this.m_enq.containsKey(id) ? this.m_enq.get(id) : null;
    }

    private Object deqSession(String id) {
        return this.m_deq.containsKey(id) ? this.m_deq.get(id) : null;
    }

    private Object getSession(String id) {
        return this.inEnq(id) ? this.enqSession(id) : (this.inDeq(id) ? this.deqSession(id) : null);
    }

    private void storeMessage(EvermindMessage msg, Object sessionID, boolean keepState) throws JMSException {
        if (msg.getJMSDeliveryMode() != 2) {
            return;
        }
        try {
            this.m_objs.put(msg.getID(), this.m_file.writeObject(msg.toBytes(), keepState ? sessionID : null));
            this.checkPageOut(msg);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("storeMessage(" + msg.getID() + "," + (keepState ? sessionID : null) + ")", ex);
        }
    }

    private void remove(EvermindMessage msg, Iterator iter) {
        this.m_pq.remove(msg, iter);
        this.m_msgs.remove(msg.getID());
    }

    private void removeObject(String id, Object sessionID) throws JMSException {
        try {
            this.m_file.removeObject((Integer)this.m_objs.get(id), sessionID);
            if (JMSUtils.isNull(sessionID)) {
                this.m_objs.remove(id);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("removeObject(" + id + "," + sessionID + ")", ex);
        }
    }

    private void ensureSession(Object sessionID) {
        if (!this.m_sess.containsKey(sessionID)) {
            this.m_sess.put(sessionID, new HashSet());
        }
    }

    private boolean isExpired(EvermindMessage msg) {
        long exp = msg.getExpiration();
        return exp != 0L && exp < System.currentTimeMillis();
    }

    private boolean isVisible(EvermindMessage msg, Object sessionID, MessageSelector selector) {
        if (this.isExpired(msg)) {
            return false;
        }
        String id = msg.getID();
        if (this.inDeq(id)) {
            return false;
        }
        if (!(!this.inEnq(id) || JMSServer.INTRA_SESSION && this.enqSession(id).equals(sessionID))) {
            return false;
        }
        return selector.selects(msg);
    }

    private void clearAll() {
        this.m_pq.clear();
        this.m_sess.clear();
        this.m_enq.clear();
        this.m_deq.clear();
        this.m_msgs.clear();
        this.m_objs.clear();
    }

    private boolean doPaging(EvermindMessage msg) throws JMSException {
        return msg != null && msg.getJMSDeliveryMode() == 2 && this.isPersistent() && this.m_msgs.containsKey(msg.getID()) && this.m_objs.containsKey(msg.getID());
    }

    private boolean lowMemory() {
        Runtime rt = Runtime.getRuntime();
        double used = 1.0 - (double)rt.freeMemory() / (double)rt.totalMemory();
        return used > this.m_pagingThreshold;
    }

    private void checkPageOut(EvermindMessage msg) throws JMSException {
        if (!this.doPaging(msg)) {
            return;
        }
        if (msg.isPaged()) {
            return;
        }
        if (!this.lowMemory()) {
            return;
        }
        msg.pageOut();
        this.event("messagePagedOut");
        s_traceLogger.fine("{0}: paging out: {1}", new Object[]{this, msg});
        JMSUtils.gc();
    }

    private EvermindMessage checkPageIn(EvermindMessage msg) throws JMSException {
        return this.checkPageIn(msg, false);
    }

    private EvermindMessage checkPageIn(EvermindMessage msg, boolean retClone) throws JMSException {
        if (!this.doPaging(msg)) {
            return msg;
        }
        if (!msg.isPaged()) {
            return msg;
        }
        String id = msg.getID();
        Integer objid = (Integer)this.m_objs.get(id);
        try {
            msg.pageIn((EvermindMessage)ServerFile.reconstruct(this.m_file.readObject(objid)));
            this.event("messagePagedIn");
            s_traceLogger.fine("{0}: paging in:  {1}", new Object[]{this, msg});
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readObject(" + msg + ") -> " + objid, ex);
        }
        if (retClone) {
            EvermindMessage nmsg = msg.cloneMessage();
            this.checkPageOut(msg);
            msg = nmsg;
        }
        return msg;
    }

    private void initEvent(String event) {
        if (!this.m_isClosed.test()) {
            this.m_jstats.initEvent(event);
            if (JMSServer.getServer() != null && JMSServer.getServer().getStats() != null) {
                JMSServer.getServer().getStats().initEvent(event);
            }
        }
    }

    private void event(String event) {
        if (!this.m_isClosed.test()) {
            this.m_jstats.event(event);
            if (JMSServer.getServer() != null && JMSServer.getServer().getStats() != null) {
                JMSServer.getServer().getStats().event(event);
            }
        }
    }

    private long startPhase(String func) {
        return this.m_isClosed.test() ? 0L : this.m_jstats.phase(func);
    }

    private void stopPhase(String func, long tok) {
        if (!this.m_isClosed.test()) {
            this.m_jstats.phase(func, tok);
        }
    }

    private static void setSaveAllExpired(boolean newValue) {
        s_saveAllExpired = newValue;
    }

    private synchronized void setPagingThreshold(double newValue) {
        this.m_pagingThreshold = newValue;
        ArrayList<JMSException> exList = new ArrayList<JMSException>();
        Iterator msgIter = this.m_msgs.values().iterator();
        while (this.lowMemory() && msgIter.hasNext()) {
            EvermindMessage msg = (EvermindMessage)msgIter.next();
            try {
                this.checkPageOut(msg);
            }
            catch (JMSException jmsex) {
                exList.add(jmsex);
            }
        }
        if (exList.size() > 0) {
            s_traceLogger.fine("setPagingThreshold", JMSUtils.makeJMSException("setPagingThreshold", exList));
        }
    }

    static {
        s_traceLogger = new JMSTraceLogger(ServerStore.class);
        m_msgSizeIsValid = (Boolean)KnobsController.getKnobsController().getConfigProperty("oc4j.jms.computeMsgsize");
    }
}

