/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ThreadState;
import com.evermind.server.jms.OrionServerSessionPool;
import com.evermind.util.ServerProperties;
import java.sql.SQLException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsSession;

public class OrionServerSession
implements ServerSession,
Runnable {
    private OrionServerSessionPool pool;
    private Session session;
    private OracleConnection oraJdbcConn;
    private Connection connection;
    private Destination destination;
    private MessageConsumer consumer;
    protected String messageSelector;
    protected ApplicationServerTransaction transaction;
    protected boolean migrateThread_flag;

    public OrionServerSession(OrionServerSessionPool pool, Session session) {
        this.pool = pool;
        this.session = session;
    }

    public OrionServerSession(OrionServerSessionPool pool, OracleConnection oraJdbcConn, Connection connection, Session session, Destination destination, MessageConsumer consumer, String messageSelector) {
        this.pool = pool;
        this.oraJdbcConn = oraJdbcConn;
        this.connection = connection;
        this.session = session;
        this.destination = destination;
        this.consumer = consumer;
        this.messageSelector = messageSelector;
        this.migrateThread_flag = false;
        this.Print("OrionServerSession()::end:");
    }

    public synchronized void markDestroyed() {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println(System.currentTimeMillis() + " Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::markDestroyed: begin; OrionServerSession=" + this);
        }
        if (this.session != null && this.session.getClass().getName().equals("oracle.jms.AQjmsSession")) {
            ((AQjmsSession)this.session).markClosed();
        }
    }

    public synchronized void destroy() {
        block16: {
            block15: {
                block14: {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: begin; OrionServerSession=" + this);
                    }
                    try {
                        if (this.session != null) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JMS session");
                            }
                            this.session.close();
                        }
                    }
                    catch (JMSException e) {
                        if (!ServerProperties.getApplicationServerDebug()) break block14;
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JMS session: exc=" + e.getMessage());
                    }
                }
                this.session = null;
                this.consumer = null;
                this.cleanTransaction();
                try {
                    if (this.connection != null) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JMS connection");
                        }
                        this.connection.close();
                    }
                }
                catch (JMSException e) {
                    if (!ServerProperties.getApplicationServerDebug()) break block15;
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JMS connection: exc=" + e.getMessage());
                }
            }
            this.connection = null;
            try {
                if (this.oraJdbcConn != null) {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JDBC connection");
                    }
                    this.oraJdbcConn.close();
                }
            }
            catch (SQLException e) {
                if (!ServerProperties.getApplicationServerDebug()) break block16;
                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: closing JDBC connection: exc=" + e.getMessage());
            }
        }
        this.oraJdbcConn = null;
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::destroy: end");
        }
    }

    public void release(boolean donotreturnpool) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::release: begin; OrionServerSession=" + this);
        }
        this.cleanTransaction();
        this.pool.release(this, true, donotreturnpool);
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::release: end");
        }
    }

    public void setTransaction(ApplicationServerTransaction newTransaction) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::setTransaction: begin/end; " + "OrionServerSession=" + this + "|new txn=" + (newTransaction == null ? "null" : newTransaction));
        }
        this.transaction = newTransaction;
    }

    public void cleanTransaction() {
        if (this.getTransaction() != null) {
            block4: {
                if (ServerProperties.getApplicationServerDebug()) {
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::cleanTransaction: active txn=" + this.getTransaction() + "; rollback");
                }
                try {
                    this.getTransaction().rollback();
                }
                catch (Throwable thre) {
                    if (!ServerProperties.getApplicationServerDebug()) break block4;
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::cleanTransaction: exc=" + thre.getMessage());
                }
            }
            this.setTransaction(null);
        }
    }

    public void Print(String str) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSession::Print: " + str + "\n\tOrionServerSession=" + this + "\n\toraJdbcConn       =" + this.oraJdbcConn);
        }
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public ApplicationServerTransaction getTransaction() {
        return this.transaction;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.pool;
    }

    public boolean isMigrateThread() {
        return this.migrateThread_flag;
    }

    public Session getSession() {
        return this.session;
    }

    public void start() {
        this.pool.server.getRequestThreadPool().launch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.session.run();
        }
        finally {
            this.pool.release(this);
        }
    }
}

