/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.Tset;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.management.j2ee.statistics.JMSConsumerStats;
import javax.management.j2ee.statistics.JMSEndpointStats;

public class EvermindMessageConsumer
extends JMSObject
implements MessageConsumer,
JMSDomain {
    private final JMSConsumerStats m_stats;
    private final int m_consID;
    private final EvermindSession m_sess;
    private final Destination m_dest;
    private final String m_name;
    private final String m_selector;
    private final boolean m_noLocal;
    private final int m_domain;
    private final String m_ppName;
    private MessageListener m_listener = null;
    private Thread m_thr = null;
    private final Tset m_connDead = new Tset(false);
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindMessageConsumer.class);

    EvermindMessageConsumer(EvermindSession sess, Destination dest, String name, String selector, boolean noLocal, int domain) throws JMSException {
        super("Consumer", sess);
        if (dest == null) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01600"));
        }
        EvermindDestination.checkDestination(dest);
        if (!JMSUtils.isNull(selector)) {
            MessageSelector.getSelector(selector);
        }
        if (JMSUtils.isTemp(dest) && JMSUtils.isT(dest) && !JMSUtils.isNull(name)) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01700", dest, name));
        }
        if (JMSUtils.isTemp(dest)) {
            EvermindTemporaryDestination td = (EvermindTemporaryDestination)dest;
            td.assertConnection(sess.getConnection().getID());
            td.attach(this);
        }
        this.m_consID = sess.getServer().createConsumer(JMSUtils.getName(dest), name, selector, noLocal);
        this.m_sess = sess;
        this.m_name = name;
        this.m_dest = dest;
        this.m_selector = selector;
        this.m_noLocal = noLocal;
        this.m_domain = domain;
        this.m_sess.attach(this);
        this.state("domain", JMSUtils.pp(this.m_domain), true);
        this.state("destination", JMSUtils.getName(this.m_dest), true);
        this.state("selector", JMSUtils.fold(this.m_selector), true);
        if (JMSUtils.isT(dest)) {
            if (!JMSUtils.isNull(this.m_name)) {
                this.state("name", this.m_name, true);
            }
            this.state("noLocal", new Boolean(this.m_noLocal), true);
        }
        this.m_ppName = JMSUtils.isQ(this.m_dest) ? "" : "," + this.m_name + "," + this.m_sess.getConnection().clientID() + "," + this.m_noLocal;
        this.initPhase("messageWaitTime");
        this.initEvent("expiredMessageCount");
        this.initEvent("messageCount");
        this.initEvent("pendingMessageCount");
        this.m_stats = EvermindMessageConsumer.getProxy().getJMSConsumerStats(JMSUtils.getName(this.m_dest), this.getJMSStats().getName());
        this.m_sess.add((JMSEndpointStats)this.m_stats);
        this.state("stats", this.m_stats, true);
    }

    public String toString() {
        return (this.m_domain == 0 ? "QueueReceiver" : (this.m_domain == 1 ? "TopicSubscriber" : "MessageConsumer")) + "[" + this.getID() + "," + this.m_dest + this.m_ppName + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized MessageListener getMessageListener() throws JMSException {
        this.lock("getMessageListener");
        try {
            MessageListener messageListener = this.m_listener;
            return messageListener;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String getMessageSelector() throws JMSException {
        this.lock("getMessageSelector");
        try {
            String string = this.m_selector;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Message receive() throws JMSException {
        this.lock("receive");
        try {
            Message message = this.blockingReceive();
            return message;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Message receive(long timeout) throws JMSException {
        this.lock("receive");
        try {
            if (timeout < 0L) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01701", this, new Long(timeout)));
            }
            Message message = timeout == 0L ? this.blockingReceive() : this.getOneMessage(timeout + System.currentTimeMillis());
            return message;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Message receiveNoWait() throws JMSException {
        this.lock("receiveNoWait");
        try {
            Message message = this.getOneMessage(System.currentTimeMillis());
            return message;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setMessageListener(MessageListener listener) throws JMSException {
        this.lock("setMessageListener");
        try {
            this.doListener(listener);
            this.state("messageListener", listener);
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isXA() {
        return this.m_sess.isXA();
    }

    public final int getDomain() {
        return this.m_domain;
    }

    protected final void localClose() throws JMSException {
        this.doListener(null);
        this.m_sess.getServer().closeConsumer(this.m_consID);
        this.m_sess.remove((JMSEndpointStats)this.m_stats);
    }

    protected final void localNextTrans() {
        this.initEvent("pendingMessageCount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized Destination getDestination() throws JMSException {
        this.lock("getDestination");
        try {
            Destination destination = this.m_dest;
            return destination;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean isNoLocal() throws JMSException {
        this.lock("getNoLocal");
        try {
            boolean bl = this.m_noLocal;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    final String getName() {
        return this.m_name;
    }

    private void assertNoListener() throws JMSException {
        if (this.m_listener != null) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01702", this, this.m_listener));
        }
        this.m_sess.assertNoListener();
    }

    private void checkConnection() {
        if (this.m_connDead.test()) {
            return;
        }
        try {
            JMSException jex = this.m_sess.getServer().ping();
            if (jex != null) {
                this.m_connDead.set(true);
            }
        }
        catch (Throwable ex) {
            this.m_connDead.set(true);
        }
    }

    private void doListener(MessageListener listener) throws JMSException {
        this.m_listener = listener;
        this.m_thr = null;
        if (this.m_listener == null) {
            this.m_sess.removeListener(this.getID());
        } else {
            this.startListener();
            this.m_sess.addListener(this.getID());
        }
    }

    private void startListener() throws JMSException {
        final EvermindMessageConsumer me = this;
        this.m_thr = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long delay = 1L;
                while (true) {
                    boolean ok = false;
                    EvermindMessageConsumer evermindMessageConsumer = me;
                    synchronized (evermindMessageConsumer) {
                        if (!me.isOpen() || me.m_connDead.test() || EvermindMessageConsumer.this.m_listener == null || EvermindMessageConsumer.this.m_thr != Thread.currentThread()) {
                            break;
                        }
                        ok = me.handleMessage();
                    }
                    delay = JMSUtils.delaySome(delay, ok);
                }
                me.stopListener();
            }
        });
        this.m_thr.setDaemon(true);
        this.m_thr.setName("Listener[" + this.getID() + "]");
        this.m_thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMessage() {
        boolean ret = false;
        try {
            this.lock("onMessage");
            try {
                try {
                    ret = this.m_sess.handleMessage(this.m_consID, this.m_listener, this, this.getJMSStats());
                }
                catch (Throwable lex) {
                    s_traceLogger.fine("onMessage", lex);
                    this.checkConnection();
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (JMSException ex) {
            s_traceLogger.fine("onMessage", ex);
            this.checkConnection();
        }
        return ret;
    }

    private void stopListener() {
        this.m_sess.removeListener(this.getID());
    }

    private Message blockingReceive() throws JMSException {
        long timeout = JMSUtils.getMessagePoll() + System.currentTimeMillis();
        Message msg = null;
        while (this.isOpen() && (msg = this.getOneMessage(timeout)) == null) {
            JMSUtils.sleep(JMSUtils.getMessagePoll());
        }
        return msg;
    }

    private Message getOneMessage(long timeout) throws JMSException {
        this.assertNoListener();
        Message msg = null;
        long delay = 1L;
        while ((msg = this.m_sess.getOneMessage(this.m_consID, this.getJMSStats())) == null) {
            delay = JMSUtils.delaySome(delay, false);
            if (System.currentTimeMillis() <= timeout) continue;
            break;
        }
        return msg;
    }
}

