/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.SessionID;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class EvermindMessageBrowser
extends JMSObject
implements JMSDomain {
    private final EvermindSession m_sess;
    private final Destination m_dest;
    private final String m_name;
    private final String m_selector;
    private final int m_domain;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindMessageBrowser.class);

    protected EvermindMessageBrowser(EvermindSession sess, Destination d, String name, String selector) throws JMSException {
        super("Browser", sess);
        if (d == null) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01600"));
        }
        EvermindDestination.checkDestination(d);
        if (!JMSUtils.isNull(selector)) {
            MessageSelector.getSelector(selector);
        }
        if (JMSUtils.isT(d) && JMSUtils.isNull(name)) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01601"));
        }
        if (JMSUtils.isTemp(d)) {
            EvermindTemporaryDestination td = (EvermindTemporaryDestination)d;
            td.assertConnection(sess.getConnection().getID());
            td.attach(this);
        }
        this.m_sess = sess;
        this.m_dest = d;
        this.m_name = name;
        this.m_selector = selector;
        this.m_domain = JMSUtils.isNull(this.m_name) ? 0 : 1;
        this.m_sess.attach(this);
        this.state("destination", JMSUtils.getName(this.m_dest), true);
        this.state("name", JMSUtils.fold(this.m_name), true);
        this.state("selector", JMSUtils.fold(this.m_selector), true);
        this.state("domain", JMSUtils.pp(this.m_domain), true);
    }

    public String toString() {
        String n = JMSUtils.isNull(this.m_name) ? "" : "," + this.m_name;
        return JMSUtils.pp(false, this.m_domain) + "Browser[" + this.getID() + "," + this.m_dest + n + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration getEnumeration() throws JMSException {
        this.lock("getEnumeration");
        try {
            BrowserEnumeration browserEnumeration = new BrowserEnumeration(this, this.m_sess.getServer().listMessages(JMSUtils.getName(this.m_dest), this.m_name, new SessionID(this.m_sess.getID()), this.m_selector));
            return browserEnumeration;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getMessageSelector() throws JMSException {
        this.lock("getMessageSelector");
        try {
            String string = this.m_selector;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isXA() {
        return this.m_sess.isXA();
    }

    public int getDomain() {
        return this.m_domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Destination getDestination(String func) throws JMSException {
        this.lock(func);
        try {
            Destination destination = this.m_dest;
            return destination;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Message peek(String func, String mid) {
        boolean doUnlock = false;
        EvermindMessage msg = null;
        try {
            doUnlock = this.lock(func);
            msg = this.m_sess.getServer().peekMessage(JMSUtils.getName(this.m_dest), this.m_name, mid);
            if (msg != null) {
                msg.setHdrReadOnly(true);
                msg.setReadOnly(true);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("peek", ex);
        }
        finally {
            if (doUnlock) {
                this.unlock();
            }
        }
        return msg;
    }

    private static final class BrowserEnumeration
    implements Enumeration {
        private final EvermindMessageBrowser m_brow;
        private final List m_msgs;
        private final Iterator m_iter;
        private Message m_msg = null;

        BrowserEnumeration(EvermindMessageBrowser brow, List msgs) {
            this.m_brow = brow;
            this.m_msgs = msgs;
            this.m_iter = this.m_msgs.iterator();
        }

        public synchronized boolean hasMoreElements() {
            if (this.m_brow.isClosed()) {
                return false;
            }
            this.peek("hasMoreElements");
            return this.m_msg != null;
        }

        public synchronized Object nextElement() {
            if (this.m_brow.isClosed()) {
                throw new NoSuchElementException(JMSMessages.getMessage("J2EE JMS-01602", this.m_brow));
            }
            this.peek("nextElement");
            if (this.m_msg == null) {
                throw new NoSuchElementException(JMSMessages.getMessage("J2EE JMS-01603", this.m_brow));
            }
            Message ret = this.m_msg;
            this.m_msg = null;
            return ret;
        }

        private void peek(String func) {
            if (this.m_msg != null) {
                return;
            }
            while (this.m_iter.hasNext()) {
                String mid = (String)this.m_iter.next();
                this.m_msg = this.m_brow.peek(func, mid);
                if (this.m_msg == null) continue;
                break;
            }
        }
    }
}

