/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindBytesMessage;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMapMessage;
import com.evermind.server.jms.EvermindMessageConsumer;
import com.evermind.server.jms.EvermindObjectMessage;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindStreamMessage;
import com.evermind.server.jms.EvermindTextMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.PropertyMap;
import com.evermind.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class EvermindMessage
implements Serializable,
Message {
    private final PropertyMap m_props = new PropertyMap(this, true);
    private transient boolean m_isReadOnly = false;
    private transient boolean m_isHdrReadOnly = false;
    private String m_jmsCorrelationID = null;
    private int m_jmsDeliveryMode = 2;
    private Destination m_jmsDestination = null;
    private long m_jmsExpiration = 0L;
    private String m_jmsMessageID = null;
    private int m_jmsPriority = 4;
    private boolean m_jmsRedelivered = false;
    private Serializable m_jmsReplyTo = null;
    private long m_jmsTimestamp = 0L;
    private String m_jmsType = null;
    private boolean m_noMsgID = false;
    private boolean m_noTimestamp = false;
    private long m_order = 0L;
    private transient boolean m_isPaged = false;
    private transient EvermindSession m_sess = null;
    private transient boolean m_inXA = false;
    private transient int m_size = 0;
    private String m_cons = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindMessage.class);
    private static Set s_hdrKey = new HashSet();
    private static Vector s_jmsxProps = new Vector();
    private static final boolean COMPUTE_MSGSIZE;
    public static final int WAITING = 1;
    public static final int READY = 2;
    public static final int EXPIRED = 3;
    public static final int RETAINED = 4;
    private static final String PFX = "JMS_OC4J_";
    public static final String OC4J_CLIENTID = "JMS_OC4J_ClientID";
    public static final String OC4J_CONSUMER = "JMS_OC4J_Consumer";
    public static final String OC4J_EXCEPTION = "JMS_OC4J_Exception_";
    public static final String OC4J_NAME = "JMS_OC4J_Name";
    public static final String OC4J_NOLOCAL = "JMS_OC4J_NoLocal";
    public static final String OC4J_SELECTOR = "JMS_OC4J_Selector";
    public static final String OC4J_TYPE = "JMS_OC4J_Type";
    static final long serialVersionUID = 7606555498504780805L;

    EvermindMessage() throws JMSException {
        this.forceObjectProperty(OC4J_TYPE, this.getType());
    }

    public final synchronized EvermindMessage cloneMessage() throws JMSException {
        EvermindMessage ret = null;
        try {
            this.fixate();
            ret = this.makeSelf();
            this.m_props.copyInto(ret.m_props);
            ret.m_jmsCorrelationID = this.m_jmsCorrelationID;
            ret.m_jmsDeliveryMode = this.m_jmsDeliveryMode;
            ret.m_jmsDestination = this.m_jmsDestination;
            ret.m_jmsExpiration = this.m_jmsExpiration;
            ret.m_jmsMessageID = this.m_jmsMessageID;
            ret.m_jmsPriority = this.m_jmsPriority;
            ret.m_jmsRedelivered = this.m_jmsRedelivered;
            ret.m_jmsReplyTo = this.m_jmsReplyTo;
            ret.m_jmsTimestamp = this.m_jmsTimestamp;
            ret.m_jmsType = this.m_jmsType;
            ret.m_noMsgID = this.m_noMsgID;
            ret.m_noTimestamp = this.m_noTimestamp;
            ret.m_order = this.m_order;
            ret.m_sess = this.m_sess;
            ret.m_inXA = this.m_inXA;
            ret.m_cons = null;
            this.cloneBody(ret);
        }
        catch (Exception ex) {
            JMSUtils.toJMSException("cloneMessage(" + this + ")", ex);
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.m_sess = null;
        super.finalize();
    }

    public String toString() {
        return this.getJMSClass() + "[" + this.m_jmsMessageID + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String toXML() {
        String string;
        StringWriter sw = null;
        PrintWriter out = null;
        try {
            String type = this.getType();
            sw = new StringWriter();
            out = new PrintWriter(sw);
            out.println("<" + type + ">");
            this.xmlHeaders(out);
            EvermindMessage.xmlProperties(out, "properties", this.m_props);
            this.xmlBody(out);
            out.println("</" + type + ">");
            out.flush();
            sw.flush();
            string = sw.toString();
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(out);
            JMSUtils.closeIt(sw);
            throw throwable;
        }
        JMSUtils.closeIt(out);
        JMSUtils.closeIt(sw);
        return string;
    }

    private String getType() {
        return this instanceof BytesMessage ? "bytesmessage" : (this instanceof MapMessage ? "mapmessage" : (this instanceof ObjectMessage ? "objectmessage" : (this instanceof StreamMessage ? "streammessage" : (this instanceof TextMessage ? "textmessage" : "message"))));
    }

    private String getJMSClass() {
        return this instanceof BytesMessage ? "BytesMessage" : (this instanceof MapMessage ? "MapMessage" : (this instanceof ObjectMessage ? "ObjectMessage" : (this instanceof StreamMessage ? "StreamMessage" : (this instanceof TextMessage ? "TextMessage" : "Message"))));
    }

    private void xmlHeaders(PrintWriter out) {
        String pfx = "    ";
        String delMode = JMSUtils.ppDelMode(this.m_jmsDeliveryMode);
        out.println(pfx + "<header>");
        EvermindMessage.pp(out, "JMSCorrelationID", "" + JMSUtils.fold(this.m_jmsCorrelationID));
        EvermindMessage.pp(out, "JMSDeliveryMode ", "" + delMode);
        EvermindMessage.pp(out, "JMSDestination  ", "" + this.m_jmsDestination);
        EvermindMessage.pp(out, "JMSExpiration   ", "" + this.m_jmsExpiration);
        EvermindMessage.pp(out, "JMSMessageID    ", "" + JMSUtils.fold(this.m_noMsgID ? null : this.m_jmsMessageID));
        EvermindMessage.pp(out, "JMSPriority     ", "" + this.m_jmsPriority);
        EvermindMessage.pp(out, "JMSRedelivered  ", "" + this.m_jmsRedelivered);
        EvermindMessage.pp(out, "JMSReplyTo      ", "" + (Destination)this.m_jmsReplyTo);
        EvermindMessage.pp(out, "JMSTimestamp    ", "" + (this.m_noTimestamp ? 0L : this.m_jmsTimestamp));
        EvermindMessage.pp(out, "JMSType         ", "" + JMSUtils.fold(this.m_jmsType));
        out.println(pfx + "</header>");
    }

    private static String encode(Object v) {
        return v == null ? "" : (v instanceof byte[] ? URLEncoder.encode(new String((byte[])v)) : "" + v);
    }

    protected static void pp(PrintWriter out, Object v) {
        EvermindMessage.pp(out, EvermindMessage.pType(v), EvermindMessage.encode(v));
    }

    private static void pp(PrintWriter out, String n, String v) {
        String pfx = "        ";
        out.println(pfx + "<" + n + " value=\"" + XMLUtils.encode(v) + "\"" + " />");
    }

    protected static void xmlProperties(PrintWriter out, String tag, PropertyMap map) {
        String pfx = "    ";
        out.println(pfx + "<" + tag + ">");
        try {
            ArrayList l = new ArrayList();
            Enumeration e = map.getMapNames();
            while (e.hasMoreElements()) {
                l.add(e.nextElement());
            }
            Object[] keys = l.toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String k = (String)keys[i];
                Object v = map.getObject(k);
                EvermindMessage.xmlProperty(out, k, v);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("xmlProperties", ex);
        }
        out.println(pfx + "</" + tag + ">");
    }

    private static void xmlProperty(PrintWriter out, String k, Object v) throws JMSException {
        String pfx = "        ";
        String type = EvermindMessage.pType(v);
        out.println(pfx + "<" + type + " key=\"" + XMLUtils.encode(k) + "\"" + " value=\"" + EvermindMessage.encode(v) + "\"" + " />");
    }

    private static String pType(Object v) {
        return v == null ? "null     " : (v instanceof Boolean ? "boolean  " : (v instanceof Byte ? "byte     " : (v instanceof byte[] ? "bytearray" : (v instanceof Character ? "char     " : (v instanceof Double ? "double   " : (v instanceof Float ? "float    " : (v instanceof Integer ? "int      " : (v instanceof Long ? "long     " : (v instanceof Short ? "short    " : "string   ")))))))));
    }

    protected void xmlBody(PrintWriter out) {
    }

    protected static void xmlOctets(PrintWriter out, String name, byte[] data) {
        String pfx = "    ";
        out.println(pfx + "<" + name + ">");
        out.println(pfx + "    <octets size=\"" + (data == null ? 0 : data.length) + "\" >");
        if (data != null && data.length > 0) {
            out.println(EvermindMessage.encode(data));
        }
        out.println(pfx + "    </octets>");
        out.println(pfx + "</" + name + ">");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.fixate();
        out.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] toBytes() throws IOException {
        ByteArrayOutputStream bout = null;
        DataOutputStream dout = null;
        byte[] buf = null;
        try {
            bout = new ByteArrayOutputStream();
            dout = new DataOutputStream(bout);
            this.writeTo(dout);
            dout.flush();
            bout.flush();
            buf = bout.toByteArray();
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(dout);
            JMSUtils.closeIt(bout);
            throw throwable;
        }
        JMSUtils.closeIt(dout);
        JMSUtils.closeIt(bout);
        return buf;
    }

    final synchronized void writeTo(DataOutput dout) throws IOException {
        this.fixate();
        dout.writeByte((byte)this.getTypeID());
        this.m_props.writeTo(dout);
        JMSUtils.packWrite(this.m_jmsCorrelationID, dout);
        dout.writeByte((byte)this.m_jmsDeliveryMode);
        JMSUtils.cuteWrite(this.m_jmsDestination, dout);
        dout.writeLong(this.m_jmsExpiration);
        JMSUtils.packWrite(this.m_jmsMessageID, dout);
        dout.writeByte((byte)this.m_jmsPriority);
        dout.writeBoolean(this.m_jmsRedelivered);
        JMSUtils.cuteWrite((Destination)this.m_jmsReplyTo, dout);
        dout.writeLong(this.m_jmsTimestamp);
        JMSUtils.packWrite(this.m_jmsType, dout);
        dout.writeBoolean(this.m_noMsgID);
        dout.writeBoolean(this.m_noTimestamp);
        dout.writeLong(this.m_order);
        JMSUtils.packWrite(this.m_cons, dout);
        this.writeBodyTo(dout);
    }

    protected void writeBodyTo(DataOutput dout) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvermindMessage toMessage(byte[] buf) throws IOException {
        EvermindMessage msg;
        block5: {
            ByteArrayInputStream binp = null;
            DataInputStream dinp = null;
            msg = null;
            try {
                binp = new ByteArrayInputStream(buf);
                dinp = new DataInputStream(binp);
                msg = EvermindMessage.readMessage(dinp);
                JMSUtils.closeIt(dinp);
            }
            catch (JMSException ex) {
                JMSUtils.toIOException("toMessage", ex);
                break block5;
            }
            finally {
                JMSUtils.closeIt(dinp);
                JMSUtils.closeIt(binp);
            }
            JMSUtils.closeIt(binp);
        }
        return msg;
    }

    static EvermindMessage readMessage(DataInput dinp) throws IOException, JMSException {
        EvermindMessage msg = EvermindMessage.makeMe(dinp.readByte());
        msg.readFrom(dinp);
        return msg;
    }

    static EvermindMessage makeMe(int code) throws IOException, JMSException {
        EvermindMessage msg = null;
        switch (code) {
            case 1: {
                msg = new EvermindBytesMessage();
                break;
            }
            case 2: {
                msg = new EvermindMapMessage();
                break;
            }
            case 3: {
                msg = new EvermindMessage();
                break;
            }
            case 4: {
                msg = new EvermindObjectMessage();
                break;
            }
            case 5: {
                msg = new EvermindStreamMessage();
                break;
            }
            case 6: {
                msg = new EvermindTextMessage();
                break;
            }
            default: {
                JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02602", "makeMe", "" + code, ""));
            }
        }
        return msg;
    }

    private void readFrom(DataInput dinp) throws IOException {
        this.m_props.readFrom(dinp);
        this.m_jmsCorrelationID = (String)JMSUtils.packRead(dinp);
        this.m_jmsDeliveryMode = dinp.readByte();
        this.m_jmsDestination = JMSUtils.cuteRead(dinp);
        this.m_jmsExpiration = dinp.readLong();
        this.m_jmsMessageID = (String)JMSUtils.packRead(dinp);
        this.m_jmsPriority = dinp.readByte();
        this.m_jmsRedelivered = dinp.readBoolean();
        this.m_jmsReplyTo = (Serializable)JMSUtils.cuteRead(dinp);
        this.m_jmsTimestamp = dinp.readLong();
        this.m_jmsType = (String)JMSUtils.packRead(dinp);
        this.m_noMsgID = dinp.readBoolean();
        this.m_noTimestamp = dinp.readBoolean();
        this.m_order = dinp.readLong();
        this.m_cons = (String)JMSUtils.packRead(dinp);
        this.readBodyFrom(dinp);
    }

    protected void readBodyFrom(DataInput dinp) throws IOException {
    }

    public synchronized void acknowledge() throws JMSException {
        if (this.m_sess == null) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01500", this));
        }
        if (this.m_inXA) {
            return;
        }
        this.m_sess.acknowledge();
    }

    public synchronized void clearBody() throws JMSException {
        this.setReadOnly(false);
    }

    public final synchronized void clearProperties() throws JMSException {
        this.m_props.clear();
        this.forceObjectProperty(OC4J_TYPE, this.getType());
        this.setHdrReadOnly(false);
    }

    public final synchronized boolean getBooleanProperty(String key) throws JMSException {
        return this.m_props.getBoolean(key);
    }

    public final synchronized byte getByteProperty(String key) throws JMSException {
        return this.m_props.getByte(key);
    }

    public final synchronized double getDoubleProperty(String key) throws JMSException {
        return this.m_props.getDouble(key);
    }

    public final synchronized float getFloatProperty(String key) throws JMSException {
        return this.m_props.getFloat(key);
    }

    public final synchronized int getIntProperty(String key) throws JMSException {
        return this.m_props.getInt(key);
    }

    public final synchronized long getLongProperty(String key) throws JMSException {
        return this.m_props.getLong(key);
    }

    public final synchronized Object getObjectProperty(String key) throws JMSException {
        return this.m_props.getObject(key);
    }

    public final synchronized short getShortProperty(String key) throws JMSException {
        return this.m_props.getShort(key);
    }

    public final synchronized String getStringProperty(String key) throws JMSException {
        return this.m_props.getString(key);
    }

    public final synchronized String getJMSCorrelationID() throws JMSException {
        return this.m_jmsCorrelationID;
    }

    public final synchronized byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.m_jmsCorrelationID == null ? null : this.m_jmsCorrelationID.getBytes();
    }

    public final synchronized int getJMSDeliveryMode() throws JMSException {
        return this.m_jmsDeliveryMode;
    }

    public final synchronized Destination getJMSDestination() throws JMSException {
        return this.m_jmsDestination;
    }

    public final synchronized long getJMSExpiration() throws JMSException {
        return this.m_jmsExpiration;
    }

    public final synchronized String getJMSMessageID() throws JMSException {
        return this.m_noMsgID ? null : this.m_jmsMessageID;
    }

    public final synchronized int getJMSPriority() throws JMSException {
        return this.m_jmsPriority;
    }

    public final synchronized boolean getJMSRedelivered() throws JMSException {
        return this.m_jmsRedelivered;
    }

    public final synchronized Destination getJMSReplyTo() throws JMSException {
        return (Destination)this.m_jmsReplyTo;
    }

    public final synchronized long getJMSTimestamp() throws JMSException {
        return this.m_noTimestamp ? 0L : this.m_jmsTimestamp;
    }

    public final synchronized String getJMSType() throws JMSException {
        return this.m_jmsType;
    }

    public final synchronized void setBooleanProperty(String key, boolean val) throws JMSException {
        this.setObjectProperty(key, new Boolean(val));
    }

    public final synchronized void setByteProperty(String key, byte val) throws JMSException {
        this.setObjectProperty(key, new Byte(val));
    }

    public final synchronized void setDoubleProperty(String key, double val) throws JMSException {
        this.setObjectProperty(key, new Double(val));
    }

    public final synchronized void setFloatProperty(String key, float val) throws JMSException {
        this.setObjectProperty(key, new Float(val));
    }

    public final synchronized void setIntProperty(String key, int val) throws JMSException {
        this.setObjectProperty(key, new Integer(val));
    }

    public final synchronized void setLongProperty(String key, long val) throws JMSException {
        this.setObjectProperty(key, new Long(val));
    }

    public final synchronized void setObjectProperty(String key, Object val) throws JMSException {
        this.assertHdrWriteable();
        this.m_props.setObject(key, val);
    }

    public final synchronized void setShortProperty(String key, short val) throws JMSException {
        this.setObjectProperty(key, new Short(val));
    }

    public final synchronized void setStringProperty(String key, String val) throws JMSException {
        this.setObjectProperty(key, val);
    }

    public final synchronized void setJMSCorrelationID(String val) throws JMSException {
        this.m_jmsCorrelationID = val;
    }

    public final synchronized void setJMSCorrelationIDAsBytes(byte[] val) throws JMSException {
        this.m_jmsCorrelationID = val == null ? null : new String(val);
    }

    public final synchronized void setJMSDeliveryMode(int val) throws JMSException {
        this.m_jmsDeliveryMode = val;
    }

    public final synchronized void setJMSDestination(Destination val) throws JMSException {
        this.m_jmsDestination = val;
    }

    public final synchronized void setJMSExpiration(long val) throws JMSException {
        this.m_jmsExpiration = val;
    }

    public final synchronized void setJMSMessageID(String val) throws JMSException {
        this.m_jmsMessageID = val;
        this.m_noMsgID = false;
    }

    public final synchronized void setJMSPriority(int val) throws JMSException {
        this.m_jmsPriority = val;
    }

    public final synchronized void setJMSRedelivered(boolean val) throws JMSException {
        this.m_jmsRedelivered = val;
    }

    public final synchronized void setJMSReplyTo(Destination val) throws JMSException {
        EvermindDestination.checkDestination(val);
        this.m_jmsReplyTo = (Serializable)val;
    }

    public final synchronized void setJMSTimestamp(long val) throws JMSException {
        this.m_jmsTimestamp = val;
        this.m_noTimestamp = false;
    }

    public final synchronized void setJMSType(String val) throws JMSException {
        this.m_jmsType = val;
    }

    public final synchronized Enumeration getPropertyNames() throws JMSException {
        return this.m_props.getMapNames();
    }

    public final synchronized boolean propertyExists(String key) throws JMSException {
        return this.m_props.itemExists(key);
    }

    public int getTypeID() {
        return 3;
    }

    final synchronized void setID(String id, boolean noMsgID) {
        this.m_jmsMessageID = id;
        this.m_noMsgID = noMsgID;
    }

    final synchronized String getID() {
        return this.m_jmsMessageID;
    }

    final synchronized void setOrder(long order) {
        this.m_order = order;
    }

    final synchronized long getOrder() {
        return this.m_order;
    }

    final synchronized void setTimestamp(long ms, boolean noTimestamp) {
        this.m_jmsTimestamp = ms;
        this.m_noTimestamp = noTimestamp;
    }

    final synchronized long getTimestamp() {
        return this.m_jmsTimestamp;
    }

    final synchronized int getPriority() {
        return this.m_jmsPriority;
    }

    final synchronized long getExpiration() {
        return this.m_jmsExpiration;
    }

    final synchronized int getSize() {
        this.computeSize();
        return this.m_size;
    }

    final synchronized void setSize(int size) {
        this.m_size = size;
    }

    final synchronized long getRcvTimestamp() {
        long ret = 0L;
        try {
            Object o = this.m_props.getObject("JMSXRcvTimestamp");
            ret = o == null || !(o instanceof Long) ? System.currentTimeMillis() - this.m_jmsTimestamp : (Long)o - this.m_jmsTimestamp;
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getWaitTime", ex);
        }
        return ret;
    }

    final synchronized int getDeliveryCount() {
        int ret = 1;
        try {
            Object v = this.m_props.getObject("JMSXDeliveryCount");
            if (v != null && v instanceof Integer) {
                ret = (Integer)v;
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getDeliveryCount", ex);
        }
        return ret;
    }

    final synchronized void setDeliveryCount(int c) {
        try {
            this.m_props.setObject("JMSXDeliveryCount", new Integer(c));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("setDeliveryCount", ex);
        }
    }

    protected synchronized void fixate() throws IOException {
    }

    protected EvermindMessage makeSelf() throws JMSException {
        return new EvermindMessage();
    }

    protected synchronized void cloneBody(EvermindMessage ret) throws JMSException {
    }

    synchronized void pageOut() throws JMSException {
        this.m_isPaged = true;
        this.clearBody();
    }

    synchronized boolean isPaged() {
        return this.m_isPaged;
    }

    synchronized void pageIn(EvermindMessage msg) throws JMSException {
        this.m_isPaged = false;
        msg.cloneBody(this);
    }

    public final synchronized void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        this.fixate();
        JMSUtils.write(this, dataOut);
    }

    final synchronized void setReadOnly(boolean isReadOnly) {
        this.m_isReadOnly = isReadOnly;
    }

    final synchronized void setHdrReadOnly(boolean isHdrReadOnly) {
        this.m_isHdrReadOnly = isHdrReadOnly;
    }

    final synchronized void assertReadable() throws MessageNotReadableException {
        if (!this.m_isReadOnly) {
            throw new MessageNotReadableException(JMSMessages.getMessage("J2EE JMS-01501", this));
        }
    }

    final synchronized void assertWriteable() throws MessageNotWriteableException {
        if (this.m_isReadOnly) {
            throw new MessageNotWriteableException(JMSMessages.getMessage("J2EE JMS-01502", this));
        }
    }

    final synchronized void assertHdrWriteable() throws MessageNotWriteableException {
        if (this.m_isHdrReadOnly) {
            throw new MessageNotWriteableException(JMSMessages.getMessage("J2EE JMS-01503", this));
        }
    }

    static synchronized boolean isJMSHeader(String k) {
        return k != null && s_hdrKey.contains(k);
    }

    final synchronized void forceObjectProperty(String key, Object val) throws JMSException {
        this.m_props.setObject(key, val);
    }

    static synchronized Enumeration getJMSXPropertyNames() {
        return s_jmsxProps.elements();
    }

    final synchronized void setSession(EvermindSession sess) {
        this.m_sess = sess;
    }

    final synchronized String getConsumer() {
        return this.m_cons;
    }

    final synchronized void setConsumer(String cons) {
        this.m_cons = cons;
    }

    final synchronized void setInXA(boolean inXA) {
        this.m_inXA = inXA;
    }

    private void computeSize() {
        if (this.m_size != 0 || !COMPUTE_MSGSIZE) {
            return;
        }
        try {
            byte[] data = JMSUtils.toBytes(this);
            this.m_size = data.length;
        }
        catch (Throwable ex) {
            s_traceLogger.fine("computeSize", ex);
        }
    }

    static void copyExceptionHeaders(Message ret, Message src) throws JMSException {
        ret.setJMSCorrelationID(src.getJMSMessageID());
        ret.setJMSDeliveryMode(src.getJMSDeliveryMode());
        ret.setJMSPriority(src.getJMSPriority());
        ret.setJMSType(src.getJMSType());
        ret.setJMSDestination(null);
        ret.setJMSExpiration(0L);
        ret.setJMSMessageID("ID:" + JMSUtils.newID("Message"));
        ret.setJMSReplyTo(null);
        ret.setStringProperty("JMS_OC4J_JMSCorrelationID", src.getJMSCorrelationID());
        ret.setIntProperty("JMS_OC4J_JMSDeliveryMode", src.getJMSDeliveryMode());
        ret.setStringProperty("JMS_OC4J_JMSDestination", "" + src.getJMSDestination());
        ret.setLongProperty("JMS_OC4J_JMSExpiration", src.getJMSExpiration());
        ret.setStringProperty("JMS_OC4J_JMSMessageID", src.getJMSMessageID());
        ret.setIntProperty("JMS_OC4J_JMSPriority", src.getJMSPriority());
        ret.setBooleanProperty("JMS_OC4J_JMSRedelivered", src.getJMSRedelivered());
        ret.setStringProperty("JMS_OC4J_JMSReplyTo", "" + src.getJMSReplyTo());
        ret.setLongProperty("JMS_OC4J_JMSTimestamp", src.getJMSTimestamp());
        ret.setStringProperty("JMS_OC4J_JMSType", src.getJMSType());
        Enumeration e = src.getPropertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (JMSUtils.isNull(k) || k.startsWith(PFX)) continue;
            Object v = src.getObjectProperty(k);
            if (k.startsWith("JMSX")) {
                k = PFX + k;
            }
            ret.setObjectProperty(k, v);
        }
        ret.setStringProperty(OC4J_TYPE, src.getStringProperty(OC4J_TYPE));
    }

    final synchronized EvermindMessage wrapException(Map headers) throws JMSException {
        this.setHdrReadOnly(false);
        this.setIntProperty("JMSXState", 4);
        EvermindObjectMessage nmsg = new EvermindObjectMessage(this);
        nmsg.setIntProperty("JMSXState", 4);
        EvermindMessage.copyExceptionHeaders(nmsg, this);
        EvermindMessage.setHeaders(nmsg, headers);
        return nmsg;
    }

    final synchronized void wrapExpired() throws JMSException {
        this.setHdrReadOnly(false);
        this.setIntProperty("JMSXState", 3);
    }

    final synchronized EvermindMessage wrapUndeliverable(String clientID, EvermindMessageConsumer cons, List exList) throws JMSException {
        this.setHdrReadOnly(false);
        this.setIntProperty("JMSXState", 4);
        EvermindObjectMessage nmsg = new EvermindObjectMessage(this);
        nmsg.setIntProperty("JMSXState", 4);
        EvermindMessage.copyExceptionHeaders(nmsg, this);
        if (cons != null) {
            if (!JMSUtils.isNull(cons.getName())) {
                nmsg.setStringProperty(OC4J_CLIENTID, JMSUtils.fold(clientID));
                nmsg.setStringProperty(OC4J_NAME, JMSUtils.fold(cons.getName()));
            } else {
                nmsg.setStringProperty(OC4J_CONSUMER, JMSUtils.fold(cons.getID()));
            }
            nmsg.setStringProperty(OC4J_SELECTOR, JMSUtils.fold(cons.getMessageSelector()));
            if (cons.getDestination() instanceof Topic) {
                nmsg.setBooleanProperty(OC4J_NOLOCAL, cons.isNoLocal());
            }
        }
        if (exList != null) {
            for (int i = 0; i < exList.size(); ++i) {
                nmsg.setStringProperty(OC4J_EXCEPTION + i, ((Throwable)exList.get(i)).toString());
            }
        }
        return nmsg;
    }

    static final void setHeaders(Message msg, Map headers) throws JMSException {
        Iterator iter = headers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                msg.setStringProperty(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                msg.setBooleanProperty(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Byte) {
                msg.setByteProperty(key, ((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Double) {
                msg.setDoubleProperty(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                msg.setFloatProperty(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Integer) {
                msg.setIntProperty(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                msg.setLongProperty(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Short) {
                msg.setShortProperty(key, ((Short)value).shortValue());
                continue;
            }
            if (!(value instanceof Object)) continue;
            msg.setObjectProperty(key, value);
        }
    }

    protected static final JMSServerProxy getProxy() {
        return JMSServerProxy.getProxy();
    }

    static {
        s_hdrKey.add("JMSCorrelationID");
        s_hdrKey.add("JMSDeliveryMode");
        s_hdrKey.add("JMSDestination");
        s_hdrKey.add("JMSExpiration");
        s_hdrKey.add("JMSMessageID");
        s_hdrKey.add("JMSPriority");
        s_hdrKey.add("JMSRedelivered");
        s_hdrKey.add("JMSReplyTo");
        s_hdrKey.add("JMSTimestamp");
        s_hdrKey.add("JMSType");
        s_jmsxProps.addElement("JMSXAppID");
        s_jmsxProps.addElement("JMSXConsumerTXID");
        s_jmsxProps.addElement("JMSXDeliveryCount");
        s_jmsxProps.addElement("JMSXGroupID");
        s_jmsxProps.addElement("JMSXGroupSeq");
        s_jmsxProps.addElement("JMSXProducerTXID");
        s_jmsxProps.addElement("JMSXRcvTimestamp");
        s_jmsxProps.addElement("JMSXState");
        s_jmsxProps.addElement("JMSXUserID");
        COMPUTE_MSGSIZE = (Boolean)EvermindMessage.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.computeMsgsize");
    }
}

