/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public final class CMTMessageConsumer
implements MessageConsumer {
    private final CMTSession m_sess;
    private final MessageConsumer m_cons;

    CMTMessageConsumer(CMTSession sess, MessageConsumer cons) {
        this.m_sess = sess;
        this.m_cons = cons;
    }

    public MessageConsumer unwrap() {
        return this.m_cons;
    }

    public String toString() {
        return "CMTMessageConsumer[" + this.m_sess + "," + this.m_cons + "]";
    }

    public void close() throws JMSException {
        this.m_cons.close();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.m_cons.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        return this.m_cons.getMessageSelector();
    }

    public synchronized Message receive() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_cons.receive();
    }

    public synchronized Message receive(long ms) throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_cons.receive(ms);
    }

    public synchronized Message receiveNoWait() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_cons.receiveNoWait();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.m_cons.setMessageListener(listener);
    }
}

