/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTSession;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;

public final class CMTConnection
implements Connection {
    private final XAConnection m_conn;

    CMTConnection(XAConnection conn) {
        this.m_conn = conn;
    }

    public XAConnection unwrap() {
        return this.m_conn;
    }

    public String toString() {
        return "CMTConnection[" + this.m_conn + "]";
    }

    public void close() throws JMSException {
        this.m_conn.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination d, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createConnectionConsumer(d, selector, pool, maxMsgs);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic t, String name, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createDurableConnectionConsumer(t, name, selector, pool, maxMsgs);
    }

    public Session createSession(boolean xact, int ackMode) throws JMSException {
        return new CMTSession(this.m_conn.createXASession());
    }

    public String getClientID() throws JMSException {
        return this.m_conn.getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.m_conn.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.m_conn.getMetaData();
    }

    public void setClientID(String id) throws JMSException {
        this.m_conn.setClientID(id);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.m_conn.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.m_conn.start();
    }

    public void stop() throws JMSException {
        this.m_conn.stop();
    }
}

