/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.deployment.SecurityRoleReferenceContainer;
import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.server.http.deployment.WebComponentDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.oc4j.admin.management.callbackinterfaces.ServletCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletDescriptor
extends WebComponentDescriptor
implements SecurityRoleReferenceContainer,
Serializable,
Comparable,
ServletCallBackIf,
WebApp24Descriptor {
    protected URL url;
    protected boolean preload;
    protected String jspPage;
    protected int initializationOrder = -1;
    protected boolean active;
    protected boolean shared;
    protected boolean autoReload = true;
    protected List securityRoleReferences;
    protected String runAsRoleName;
    protected String runAsDescription;
    protected static final String SECURITY_ROLE_REFS = "securityRoleReferences";
    protected Object runtimeInfo;
    protected AbstractDescribable parent;
    protected ArrayList propertyChangeList = null;
    private boolean isPre24WebXml = false;
    private boolean isPartOfOrionWeb = false;

    public ServletDescriptor() {
    }

    public ServletDescriptor(AbstractDescribable parent, URL url) {
        this.parent = parent;
        this.url = url;
    }

    public ServletDescriptor(Node node, URL url, PropertyChangeListener listener, AbstractDescribable parent) throws InstantiationException {
        this(node, url, listener, parent, false);
    }

    public ServletDescriptor(Node node, URL url, PropertyChangeListener listener, AbstractDescribable parent, boolean isPre24) throws InstantiationException {
        this.url = url;
        this.parent = parent;
        this.isPre24WebXml = isPre24;
        if (listener != null) {
            this.addPropertyChangeListener(listener);
        }
        NodeList nodes = node.getChildNodes();
        this.autoReload = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "auto-reload"));
        Object paramName = null;
        Object paramValue = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("icon")) {
                this.setIcon(new IconDescriptor(nodes.item(i)));
                continue;
            }
            if (name.equals("servlet-name")) {
                this.setName(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (name.equals("display-name")) {
                if (this.getName() != null && ServerProperties.getOracleCtsUseCtsFlags() && !this.isPre24WebXml) {
                    throw new InstantiationException("servlet subelement is not defined in correct order: display-name");
                }
                this.setDisplayName(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (name.equals("servlet-class")) {
                this.setClassName(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (name.equals("security-role-ref")) {
                this.addSecurityRoleReference(new SecurityRoleReference(nodes.item(i)));
                continue;
            }
            if (name.equals("jsp-file")) {
                this.jspPage = XMLUtils.getStringValue(nodes.item(i));
                if (this.jspPage == null || this.jspPage.startsWith("/")) continue;
                this.jspPage = "/" + this.jspPage;
                continue;
            }
            if (name.equals("init-param")) {
                this.parseInitParameter(nodes.item(i), url, false);
                continue;
            }
            if (name.equals("relative-init-param")) {
                this.parseInitParameter(nodes.item(i), url, true);
                continue;
            }
            if (name.equals("load-on-startup")) {
                String order = XMLUtils.getStringValue(nodes.item(i));
                if (order != null && order.length() > 0) {
                    try {
                        this.initializationOrder = Integer.parseInt(order);
                        if (this.initializationOrder < 0) continue;
                        this.preload = true;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                this.preload = true;
                this.initializationOrder = Integer.MAX_VALUE;
                continue;
            }
            if (name.equals("run-as")) {
                this.parseRunAs(nodes.item(i));
                continue;
            }
            throw new InstantiationException("Invalid servlet subtag: " + name);
        }
        if (this.getName() == null) {
            throw new InstantiationException("Missing servlet-name subtag in servlet tag");
        }
        if (this.getClassName() == null && this.jspPage == null) {
            throw new InstantiationException("No servlet-class and no jsp-file specified for servlet '" + this.getName() + "'");
        }
    }

    public void parseRunAs(Node node) throws InstantiationException {
        this.runAsDescription = XMLUtils.getSubnodeValue(node, "description");
        this.runAsRoleName = XMLUtils.getSubnodeValue(node, "role-name");
    }

    public void addSecurityRoleReference(SecurityRoleReference reference) {
        if (this.securityRoleReferences == null) {
            this.securityRoleReferences = new ArrayList();
        }
        this.securityRoleReferences.add(reference);
        this.firePropertyChangeEvent(SECURITY_ROLE_REFS, null, reference);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setClassName(String servletClass) {
        super.setClassName(servletClass);
        this.jspPage = null;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean getAutoReload() {
        return this.autoReload;
    }

    public boolean getLoadOnStartup() {
        return this.preload;
    }

    public int getLoadOnStartupOrder() {
        return this.initializationOrder;
    }

    public void setLoadOnStartup(boolean startup) {
        this.preload = startup;
    }

    public void setLoadOnStartupOrder(int order) {
        this.initializationOrder = order;
    }

    public String getJSPPage() {
        return this.jspPage;
    }

    public List getSecurityRoleReferences() {
        if (this.securityRoleReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoleReferences;
    }

    public String getRunAsRoleName() {
        return this.runAsRoleName;
    }

    public void setRunAsRoleName(String roleName) {
        this.runAsRoleName = roleName;
    }

    public String getRunAsDescription() {
        return this.runAsDescription;
    }

    public void setRunAsDescription(String description) {
        this.runAsDescription = description;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<servlet>");
        if (this.getIcon() != null) {
            this.getIcon().writeXML(out, indention + "\t");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<servlet-name>" + XMLUtils.encode(this.getName()) + "</servlet-name>");
        }
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getClassName() != null) {
            out.println(indention + "\t<servlet-class>" + XMLUtils.encode(this.getClassName()) + "</servlet-class>");
        }
        if (this.jspPage != null) {
            out.println(indention + "\t<jsp-file>" + XMLUtils.encode(this.jspPage) + "</jsp-file>");
        }
        this.writeInitParams(out, indention + "\t");
        if (this.preload) {
            out.println(indention + "\t<load-on-startup>" + this.initializationOrder + "</load-on-startup>");
        }
        if (this.runAsRoleName != null) {
            out.println(indention + "\t<run-as>");
            if (this.runAsDescription != null) {
                out.println(indention + "\t\t<description>" + XMLUtils.encode(this.runAsDescription) + "</description>");
            }
            out.println(indention + "\t\t<role-name>" + XMLUtils.encode(this.runAsRoleName) + "</role-name>");
            out.println(indention + "\t</run-as>");
        }
        if (this.securityRoleReferences != null) {
            XMLUtils.writeAll(this.securityRoleReferences, out, indention + "\t");
        }
        out.println(indention + "</servlet>");
    }

    public int compareTo(Object other) {
        if (!(other instanceof ServletDescriptor)) {
            return 0;
        }
        if (((ServletDescriptor)other).initializationOrder < 0 && this.initializationOrder >= 0) {
            return -1;
        }
        if (this.initializationOrder < 0 && ((ServletDescriptor)other).initializationOrder >= 0) {
            return 1;
        }
        return this.initializationOrder - ((ServletDescriptor)other).initializationOrder;
    }

    public void setJSPPage(String name) {
        this.jspPage = name;
        super.setClassName(null);
    }

    public void removeSecurityRoleReference(SecurityRoleReference reference) {
        if (this.securityRoleReferences == null) {
            return;
        }
        this.securityRoleReferences.remove(reference);
        this.firePropertyChangeEvent(SECURITY_ROLE_REFS, reference, null);
    }

    public String toString() {
        return this.getName();
    }

    public void setLoadOnStartup(int order) {
        this.setLoadOnStartupOrder(order);
        this.setLoadOnStartup(order >= 0);
        this.firePropertyChangeEvent("loadOnStartup", null, new Integer(order));
    }

    public Object getDeploymentDescriptor() {
        return this.parent;
    }

    public void firePropertyChangeEvent(String property, Object value, Object newValue) {
        if (this.propertyChangeList == null) {
            this.propertyChangeList = new ArrayList();
        }
        if (!this.propertyChangeList.contains(property)) {
            this.propertyChangeList.add(property);
        }
        this.parent.firePropertyChangeEvent("servlet-" + property, null, null);
        super.firePropertyChangeEvent(property, value, newValue);
    }

    public ArrayList getPropertyChangeList() {
        return this.propertyChangeList;
    }

    public boolean isPartOfOrionWeb() {
        return this.isPartOfOrionWeb;
    }

    public void setPartOfOrionWeb(boolean partOfOrionWeb) {
        this.isPartOfOrionWeb = partOfOrionWeb;
    }

    public void writeWebApp24XML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<servlet>");
        this.writeXMLElement(out, indention, "description", this.getDescription());
        this.writeXMLElement(out, indention, "display-name", this.getDisplayName());
        if (this.getIcon() != null) {
            this.getIcon().writeXML(out, indention + "\t");
        }
        this.writeXMLElement(out, indention, "servlet-name", this.getName());
        this.writeXMLElement(out, indention, "servlet-class", this.getClassName());
        this.writeXMLElement(out, indention, "jsp-file", this.jspPage);
        this.writeWebAppInitParams(out, indention + "\t");
        if (this.preload) {
            this.writeXMLElement(out, indention, "load-on-startup", "" + this.initializationOrder);
        }
        if (this.runAsRoleName != null) {
            out.println(indention + "\t<run-as>");
            this.writeXMLElement(out, indention + "\t", "description", this.runAsDescription);
            this.writeXMLElement(out, indention + "\t", "role-name", this.runAsRoleName);
            out.println(indention + "\t</run-as>");
        }
        if (this.securityRoleReferences != null) {
            XMLUtils.writeAll(this.securityRoleReferences, out, indention + "\t");
        }
        out.println(indention + "</servlet>");
    }
}

