/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ServletMapping;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OJSPConfigDescriptor
implements XMLizable {
    private static final String CR = System.getProperty("line.separator", "\n");
    HttpApplicationDescriptor config;
    List properties;

    public OJSPConfigDescriptor(HttpApplicationDescriptor config) {
        this.config = config;
        this.properties = new ArrayList();
    }

    public OJSPConfigDescriptor(HttpApplicationDescriptor config, Node node) {
        this(config);
        this.parseOJSPConfig(node);
    }

    public List getProperties() {
        return this.properties;
    }

    public void addImplicitServletMapping(String servletName, String urlPattern, OJSPPropertyGroup propgroup) {
        if (servletName != null) {
            this.config.addServletMapping(new OJSPConfigImplicitServletMapping(servletName, urlPattern, propgroup));
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<ojsp-config>");
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            OJSPPropertyGroup propgroup = (OJSPPropertyGroup)i.next();
            out.println(propgroup.toXML(indention + "\t"));
        }
        out.println(indention + "</ojsp-config>");
    }

    private void parseOJSPConfig(Node parent) {
        int parse_order = 0;
        NodeList nodes = parent.getChildNodes();
        String jspServletName = null;
        Iterator i = this.config.getServletMappings().iterator();
        while (i.hasNext()) {
            ServletMapping mapping = (ServletMapping)i.next();
            if (!mapping.getURLPattern().equals("*.jsp")) continue;
            jspServletName = mapping.getServletName();
            break;
        }
        if (nodes != null) {
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                NodeList subNodes;
                Node node = nodes.item(i2);
                String name = node.getNodeName();
                if (name.charAt(0) == '#' || !name.equals("ojsp-property-group") || (subNodes = node.getChildNodes()) == null) continue;
                OJSPPropertyGroup propgroup = new OJSPPropertyGroup();
                for (int x = 0; x < subNodes.getLength(); ++x) {
                    Node subNode = subNodes.item(x);
                    String subNodeName = subNode.getNodeName();
                    String subNodeValue = XMLUtils.getStringValue(subNode);
                    if (subNodeName.charAt(0) == '#') continue;
                    if (subNodeName.equals("url-pattern")) {
                        propgroup.urlPatterns.add(subNodeValue);
                        continue;
                    }
                    if (!subNodeName.equals("default-buffer-size")) continue;
                    propgroup.defaultBufferSize = subNodeValue;
                }
                if (!propgroup.isValid()) continue;
                propgroup.order = parse_order++;
                this.properties.add(propgroup);
                Iterator j = propgroup.urlPatterns.iterator();
                while (j.hasNext()) {
                    String x = (String)j.next();
                    this.addImplicitServletMapping(jspServletName, x, propgroup);
                }
            }
        }
    }

    public static class OJSPConfigImplicitServletMapping
    extends ServletMapping {
        protected OJSPPropertyGroup propgroup;

        public OJSPConfigImplicitServletMapping(String servletName, String urlPattern, OJSPPropertyGroup propgroup) {
            this.servletName = servletName;
            this.urlPattern = urlPattern;
            this.propgroup = propgroup;
        }

        public OJSPPropertyGroup getOJSPPropertyGroup() {
            return this.propgroup;
        }

        public void writeXML(PrintWriter out, String indention) {
        }
    }

    public static class OJSPPropertyGroup
    implements Comparable,
    Serializable {
        public List urlPatterns = new ArrayList();
        public String defaultBufferSize = "";
        public Boolean isXML = null;
        public int order = 0;

        public boolean isValid() {
            return true;
        }

        public int compareTo(Object o) {
            OJSPPropertyGroup other = (OJSPPropertyGroup)o;
            return this.order > other.order ? 1 : -1;
        }

        public String toXML(String indent) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent + "<ojsp-property-group>" + CR);
            Iterator i = this.urlPatterns.iterator();
            while (i.hasNext()) {
                buffer.append(indent + "\t<url-pattern>" + (String)i.next() + "</url-pattern>" + CR);
            }
            if (!this.defaultBufferSize.equals("")) {
                buffer.append(indent + "\t<default-buffer-size>" + this.defaultBufferSize + "</default-buffer-size>" + CR);
            }
            buffer.append(indent + "</ojsp-property-group>");
            return buffer.toString();
        }
    }
}

