/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.SimpleBase64InputStream;
import com.evermind.io.SimpleBase64OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class HttpTunnelProxyServletIOStream {
    private OutputStream httpEndOut;
    private InputStream rmiEndIn;
    private PipedInputStream pis;
    private OutputStream rmiEndOut;
    private ByteArrayOutputStream rmiOutputBuffer;
    private ByteArrayOutputStream baos;
    private boolean flushed;
    private Integer syncObj = new Integer(1);

    public HttpTunnelProxyServletIOStream() throws IOException {
        this.httpEndOut = new PipedOutputStream();
        this.pis = new PipedInputStream();
        this.pis.connect((PipedOutputStream)this.httpEndOut);
        this.rmiEndIn = new SimpleBase64InputStream(this.pis);
        this.rmiOutputBuffer = new FlushableByteArrayOutputStream();
        this.rmiEndOut = new SimpleBase64OutputStream(this.rmiOutputBuffer);
    }

    public void close() throws IOException {
        this.rmiEndOut.close();
        this.rmiOutputBuffer.close();
        this.httpEndOut.close();
        this.pis.close();
        this.rmiEndIn.close();
    }

    public OutputStream getHttpEndOut() {
        return this.httpEndOut;
    }

    public OutputStream getRmiEndOut() {
        return this.rmiEndOut;
    }

    public InputStream getRmiEndIn() {
        return this.rmiEndIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHttpEndInData() {
        Integer n = this.syncObj;
        synchronized (n) {
            while (!this.flushed) {
                try {
                    this.syncObj.wait();
                }
                catch (InterruptedException e) {}
            }
            byte[] bytes = this.rmiOutputBuffer.toByteArray();
            this.flushed = false;
            this.rmiOutputBuffer.reset();
            return bytes;
        }
    }

    public void reset() {
        this.flushed = false;
        this.rmiOutputBuffer.reset();
    }

    public class FlushableByteArrayOutputStream
    extends ByteArrayOutputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Integer n = HttpTunnelProxyServletIOStream.this.syncObj;
            synchronized (n) {
                HttpTunnelProxyServletIOStream.this.flushed = true;
                HttpTunnelProxyServletIOStream.this.syncObj.notify();
            }
        }
    }
}

