/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import com.evermind.compiler.LinkedCompiler;
import com.evermind.io.IOUtils;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.file.FileContext;
import com.evermind.net.AccessRegionSet;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationComponentCallBackIf;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.Refreshable;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleContainer;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.deployment.UserManagerConfig;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.EJBOutputStream;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.PersistenceUnitManagerFactory;
import com.evermind.server.http.BasicHttpAuthenticator;
import com.evermind.server.http.CertificateHttpAuthenticator;
import com.evermind.server.http.ContentType;
import com.evermind.server.http.DirectoryRequestDispatcher;
import com.evermind.server.http.ErrorRequestDispatcher;
import com.evermind.server.http.EvermindFilterConfig;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.EvermindServletConfig;
import com.evermind.server.http.FileDependency;
import com.evermind.server.http.FileInformation;
import com.evermind.server.http.FileRequestDispatcher;
import com.evermind.server.http.FixPathRequestDispatcher;
import com.evermind.server.http.FormHttpAuthenticator;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpApplicationInputStream;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpApplicationRestarter;
import com.evermind.server.http.HttpAuthenticator;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpQueryParser;
import com.evermind.server.http.HttpSessionManager;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.JGroupHttpService;
import com.evermind.server.http.JGroupHttpSession;
import com.evermind.server.http.JSPBeanInfo;
import com.evermind.server.http.JSPCompilationException;
import com.evermind.server.http.JSPFileNotFoundException;
import com.evermind.server.http.JSPPage;
import com.evermind.server.http.JSPPageCompilationContext;
import com.evermind.server.http.JSPStaticInclude;
import com.evermind.server.http.JspInterface;
import com.evermind.server.http.JspServletInstanceInfo;
import com.evermind.server.http.OC4JRequestDispatcher;
import com.evermind.server.http.PersistenceHttpService;
import com.evermind.server.http.PersistenceHttpSession;
import com.evermind.server.http.ProtectedRegion;
import com.evermind.server.http.RequestDispatcherCache;
import com.evermind.server.http.RuntimeExpirationSetting;
import com.evermind.server.http.RuntimeFilterMapping;
import com.evermind.server.http.ServletFilter;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.server.http.ServletRequestDispatcher;
import com.evermind.server.http.SessionAsyncInvalidateHandler;
import com.evermind.server.http.SessionReplicationService;
import com.evermind.server.http.TagLibraryArchive;
import com.evermind.server.http.TagLibraryStorage;
import com.evermind.server.http.WrapperClassGenerator;
import com.evermind.server.http.administration.HttpSessionRuntimeInfo;
import com.evermind.server.http.deployment.ErrorPage;
import com.evermind.server.http.deployment.ExpirationSetting;
import com.evermind.server.http.deployment.FilterDescriptor;
import com.evermind.server.http.deployment.FilterMapping;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ListenerDescriptor;
import com.evermind.server.http.deployment.MimeMapping;
import com.evermind.server.http.deployment.ResourceCollection;
import com.evermind.server.http.deployment.SecurityConstraint;
import com.evermind.server.http.deployment.ServletDescriptor;
import com.evermind.server.http.deployment.ServletMapping;
import com.evermind.server.http.deployment.TagLibraryUse;
import com.evermind.server.http.deployment.WARAnnotationParser;
import com.evermind.server.http.deployment.WARDependencyManager;
import com.evermind.util.ArrayUtils;
import com.evermind.util.AttributeContainer;
import com.evermind.util.Base64Utils;
import com.evermind.util.ByteString;
import com.evermind.util.ByteStringCache;
import com.evermind.util.ClassUtils;
import com.evermind.util.HTTPProperties;
import com.evermind.util.MarkupUtils;
import com.evermind.util.StringUtils;
import com.evermind.xml.XMLConfig;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.naming.J2EEContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.rmi.Remote;
import java.security.AccessController;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.VersionNumber;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.management.callbackinterfaces.ServletCallBackIf;
import oracle.oc4j.admin.management.util.CollectionModificationEvent;
import oracle.oc4j.admin.management.util.CollectionModificationListener;
import oracle.oc4j.admin.management.util.NotifyingMap;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;
import oracle.oc4j.hooks.WebApplicationProtocol;
import oracle.oc4j.loader.CompilingSearchPolicy;
import oracle.oc4j.loader.OC4JProtectionPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationType;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SecurityUtil;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.security.jazn.oc4j.WebSSOAuthenticator;

public class HttpApplication
implements HttpSessionContext,
ServletContext,
ContextContainer,
JSPPageCompilationContext,
AttributeContainer,
ApplicationComponentCallBackIf,
Refreshable {
    private static final boolean WINDOWS;
    public static final String HTTP_SESSION_SHARING_SFSB_JAR = "OC4JINTERNAL_httpSession.jar";
    public static final String HTTP_SESSION_SHARING_SFSB_BEAN = "WebAppsClusterBean";
    private static boolean disallowAlias;
    public static final int SERIALIZATION_VERSION = 1;
    public static final Object COMPILING_JSP;
    public static final boolean RETURN_LOGIN = false;
    private static final ByteString jspextn;
    private static final ByteString jspxextn;
    static final ByteString SPECIFIC_END_HOLDER;
    static final ByteString SLASH_BYTESTRING;
    static final ByteString JSP_PRECOMPILE_BYTESTING;
    static final ByteString EMPTY_BYTESTRING;
    static final byte[] SECURE_COOKIE_ATTRIBUTE;
    static final byte[] HTTPONLY_COOKIE_ATTRIBUTE;
    static final String DEFAULT_CHARSET_ENCODING = "ISO-8859-1";
    private static final int TRANSFER_SERIALIZABLE = 1;
    private static final int TRANSFER_REMOTEOBJECT = 2;
    private static final int TRANSFER_END = 3;
    boolean shared;
    boolean isAccessLog = true;
    Context componentContext;
    HttpApplicationConfig config;
    String defaultContentType;
    ByteString servletDirectory;
    protected boolean distributable;
    public HttpQueryParser queryParser;
    protected ServletContextListener[] contextListeners;
    protected ServletContextAttributeListener[] contextAttributeListeners;
    protected HttpSessionAttributeListener[] sessionAttributeListeners;
    protected HttpSessionListener[] sessionListeners;
    protected HttpSessionActivationListener[] sessionActivationListeners;
    protected ServletRequestListener[] requestListeners;
    protected ServletRequestAttributeListener[] requestAttributeListeners;
    protected List jspTldListenerDescriptors = null;
    protected boolean initializing;
    protected int responseBufferSize = 2048;
    protected List restartHookList;
    protected ArrayList invalidateSessions = new ArrayList(3);
    protected Application application;
    protected String defaultCharSet;
    protected ByteString defaultServletName;
    protected ServletInstanceInfo defaultServletInstance;
    protected File jspCacheFile;
    protected String jspCacheTlds;
    protected int jspTldCacheLevel;
    protected String jspTaglibLocations;
    protected boolean jspPrintNull = true;
    protected boolean iso8859Convert = true;
    protected boolean flushAllJSP = true;
    protected boolean flushAllJSPAtPageUpdate = false;
    protected final HashMap jspPages = new HashMap();
    protected Set compilingJSPPages = null;
    private File libraryContextFile;
    private FileDependency[] libraryContextContent;
    private int libraryContextCheckCount;
    private File tldContextFile;
    private FileDependency[] tldContextContent;
    private int tldContextCheckCount;
    protected boolean development;
    protected boolean secure;
    protected TagLibraryStorage tagLibraryStorage;
    JspServletInstanceInfo jspServletInstance;
    private boolean destroyed;
    private String documentRoot;
    private Context documentRootContext;
    long configLastModifiedCheckExpires;
    protected ServletMapping[] servletMappings = new ServletMapping[0];
    protected ServletMapping[] postServletMappings;
    private SessionReplicationService replicationService;
    ByteString[] defaultDocument;
    HttpAuthenticator authenticator;
    Servlet accessController;
    protected String[] virtualDirectory;
    protected String[] realDirectory;
    protected long started;
    private Map servletInstancesLock = new ConcurrentReaderHashMap();
    private Map servletInstances = new NotifyingMap(this.servletInstancesLock);
    private Map jspfileServletInstances = new HashMap();
    String contextPath;
    protected long lastModifiedCheckExpires;
    Map sessions = new HashMap();
    HttpSite site;
    String name;
    ByteString root;
    Map attributes = new HashMap();
    boolean used = true;
    long lastUsed;
    String[] errorPage;
    List exceptionPages;
    ServletInstanceInfo[] sessionTracker;
    ServletFilter[] orionFilter;
    ServletInstanceInfo[] requestTracker;
    RuntimeFilterMapping[] filterMappings;
    Filter securityFilter;
    boolean securityFilterInited = false;
    HttpSessionManager sessionManager;
    Map contentTypes;
    Map chainingHandlers;
    protected Map initParameters;
    public static final int SESSION_ID_LENGTH = 32;
    private static final byte SESSIONID_ROUTE_SEP = 46;
    private byte[] sessionCookiePrefix;
    private StringBuffer sessionCookieSuffixBuffer;
    private byte[] sessionCookieSuffix;
    AccessRegionSet accessRegion;
    boolean useHttpCompression = false;
    private File temporaryDirectory;
    protected UserManager userManager;
    private PolicyClassLoader classLoader;
    private String classPathCache;
    private static final String DEFAULT_PATH_ENCODING = "UTF-8";
    private Map libraries;
    protected RuntimeExpirationSetting[] expirationSettings;
    protected boolean autoJoinSession;
    protected boolean directoryBrowsingAllowed;
    protected Map roles;
    protected RequestDispatcherCache[] requestDispatcherCache = new RequestDispatcherCache[10];
    private int httpApplicationState = 1;
    private SynchronizedInt httpReqCount = new SynchronizedInt(0);
    private static final String OVERRIDE_COOKIEPATH_KEY = "oc4j.cookie.overridePath";
    private static final String m_overrideCookiePath;
    ContentType lastType;
    private ConcurrentReaderHashMap filePaths = new ConcurrentReaderHashMap();
    private static final File NULL_FILE;
    private SessionAsyncInvalidateHandler sessionAsyncInvalidateHandler;
    private NounIntf noun;
    private PhaseEventIntf resolveServletPhase;
    protected NounIntf webNoun;
    protected NounIntf servletsNoun;
    PhaseEventIntf processRequestPhase;
    PhaseEventIntf contextProcessRequestPhase;
    PhaseEventIntf resolveContextPhase;
    PhaseEventIntf parseRequestPhase;
    PhaseEventIntf sessionActivationPhase;
    private FileDependency[] webClasses;
    private boolean descriptorUpdated = false;
    private boolean userManagerUpdated = false;
    private boolean invalidateApplication = false;
    private PersistenceUnitManager persistenceUnitManager;
    private static Logger m_traceLogger;
    private boolean m_processAnnotations;
    private Map tagClassMap;
    protected boolean isCustomSessionCookieName = false;
    protected byte[] sessionCookieNameBytes = "jsessionid".getBytes();
    protected byte[] sessionCookieNameUppercaseBytes = "JSESSIONID".getBytes();
    private String sessionCookiePath;
    private String sessionCookieName;
    private ConcurrentReaderHashMap myFilesStats = new ConcurrentReaderHashMap();
    protected final ConcurrentReaderHashMap cachedFiles = new ConcurrentReaderHashMap();
    static final int MAXIMUM_CACHE_SIZE = 102400;
    static final byte[] PRECONDITION_FAILED_MESSAGE;
    private static final char[] base64CharTable;
    protected ProtectedRegion[] protectedRegions;
    private Map filterInstances;
    private static final String JDK50_MARKER_METHOD = "getDeclaredAnnotations";

    protected HttpApplication() {
    }

    public HttpApplication(Application application, HttpSite site, HttpApplicationConfig config, String root, String modulePath, boolean shared) throws InstantiationException {
        this(application, site, config, root, modulePath, shared, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApplication(Application application, HttpSite site, HttpApplicationConfig config, String root, String modulePath, boolean shared, boolean accessLog) throws InstantiationException {
        this.application = application;
        WebApplicationProtocol.PRE_INIT.fire(config.getURL(), config, this);
        config.setHttpApplication(this);
        WebApplicationProtocol.POST_INIT.fire(config.getURL(), config, this);
        try {
            WebApplicationProtocol.PRE_START.fire(this);
            ((NotifyingMap)this.servletInstances).addCollectionModificationListener(new ServletInstancesCollectionModificationListener());
            String allowAliasProp = HTTPProperties.getAllowFileAlias();
            disallowAlias = allowAliasProp == null ? WINDOWS : allowAliasProp.equalsIgnoreCase("false");
            this.jspTaglibLocations = config.getTaglibLocations();
            this.jspPrintNull = config.getJspPrintNull();
            this.iso8859Convert = config.isISO8859Convert();
            this.development = config.isDevelopment();
            if (ApplicationServer.serverExtensionProviders != null) {
                for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    ApplicationServer.serverExtensionProviders[i].preInitHttpApplication((AttributeContainer)((Object)config), this);
                }
            }
            try {
                if (application.getServer().getVerbosityLevel() > 3 && m_traceLogger.isLoggable(Level.FINE)) {
                    m_traceLogger.log(Level.FINE, "Web-App " + application.getName() + ":" + config.getName() + " (" + site.getConfig().getAddress() + ":" + site.getConfig().getPort() + (root == null ? "" : root) + ") started...");
                }
            }
            catch (Throwable t) {
                m_traceLogger.log(Level.FINEST, "Exception: " + t.getMessage(), t);
            }
            this.distributable = config.isDistributable();
            this.defaultCharSet = config.getDefaultCharSet();
            this.responseBufferSize = config.getDefaultBufferSize();
            this.config = config;
            this.shared = shared;
            this.isAccessLog = accessLog;
            this.site = site;
            this.name = config.getName();
            this.contextPath = root;
            if (this.contextPath == null) {
                this.contextPath = "";
            }
            this.setDocumentRoot(config.getDocumentRoot());
            this.directoryBrowsingAllowed = config.getDirectoryBrowsingAllowed();
            this.userManager = application.getUserManager();
            this.m_processAnnotations = this.isJDK50() && !this.isWarFull();
            this.jspCacheTlds = config.getJspCacheTlds();
            this.jspTldCacheLevel = this.getJspTldCacheLevel(this.jspCacheTlds);
            if (this.m_processAnnotations) {
                if (this.jspTldCacheLevel == 1) {
                    this.jspTldCacheLevel = -1;
                } else if (this.jspTldCacheLevel == 0) {
                    this.jspTldCacheLevel = -2;
                }
            }
            if (this.contextPath != null && this.contextPath.length() > 1) {
                this.root = this.application.getServer().byteStringCache.getByteString(this.contextPath);
            } else {
                this.contextPath = "";
            }
            this.setErrorPages(config.getErrorPages());
            this.autoJoinSession = config.getAutoJoinSession();
            this.lastModifiedCheckExpires = config.getLastModifiedCheckInterval();
            this.defaultDocument = StringUtils.toByteString(config.getDefaultDocuments());
            this.accessRegion = config.getAccessRegionSet();
            this.defaultContentType = config.getDefaultContentType();
            this.initParameters = config.getInitParameters();
            this.initVirtualDirectories(config.getVirtualMappings());
            this.sessionCookieName = null;
            if (this.sessionCookieName != null) {
                this.isCustomSessionCookieName = true;
            } else {
                this.sessionCookieName = "jsessionid";
            }
            String sessionNameUpperCase = this.sessionCookieName.toUpperCase();
            this.sessionCookieNameBytes = this.sessionCookieName.getBytes();
            this.sessionCookieNameUppercaseBytes = sessionNameUpperCase.getBytes();
            this.sessionCookieName = sessionNameUpperCase;
            this.sessionCookiePrefix = "Set-Cookie: JSESSIONID=".getBytes();
            this.sessionCookieSuffixBuffer = new StringBuffer();
            String cookieDomain = config.getSessionCookieDomain();
            this.sessionCookieSuffixBuffer = new StringBuffer();
            if (cookieDomain != null) {
                this.sessionCookieSuffixBuffer.append("; Domain=");
                this.sessionCookieSuffixBuffer.append(cookieDomain);
            }
            this.sessionCookiePath = config.getSessionCookiePath();
            this.sessionCookieSuffixBuffer.append("; path=");
            if (this.sessionCookiePath == null) {
                if (m_overrideCookiePath != null) {
                    this.sessionCookiePath = m_overrideCookiePath;
                } else {
                    this.sessionCookiePath = this.getContextPath();
                    if (this.sessionCookiePath == null || this.sessionCookiePath.length() == 0 || HTTPProperties.getOracleAuthorizationShare()) {
                        this.sessionCookiePath = "/";
                    }
                    this.sessionCookiePath = this.sessionCookiePath.replaceAll(" ", "%20");
                }
            }
            this.sessionCookieSuffixBuffer.append(this.sessionCookiePath);
            this.sessionCookieSuffix = this.sessionCookieSuffixBuffer.toString().getBytes();
            if (config.isClustered() && !config.isDistributable()) {
                String webAppPath;
                String string = webAppPath = config.getURL() == null ? this.application.getConfig().getURL() + "/" + modulePath : config.getURL().toString();
                if (webAppPath.endsWith("/") || webAppPath.endsWith(File.separator)) {
                    webAppPath = webAppPath.substring(0, webAppPath.length() - 1);
                }
                m_traceLogger.log(Level.FINE, "Warning: web-application '" + application.getConfig().getDisplayName() + " - " + config.getDisplayName() + "' is configured to be clustered, but it is not marked as distributable (containing a <distributable /> tag) in it's web.xml (" + webAppPath + "/WEB-INF/web.xml).This will result in load balancing but no failover(no replication) for this application.");
                ((HttpApplicationDescriptor)config).setClustered(false);
            }
            this.sessionAsyncInvalidateHandler = new SessionAsyncInvalidateHandler(this.application.getServer().getThreadPool());
            this.initClassLoader();
            this.createDefaultPersistenceUnitManager();
            this.initReplicationService(config);
            this.initDynamic(config);
            if (ApplicationServer.serverExtensionProviders != null) {
                for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    ApplicationServer.serverExtensionProviders[i].postInitHttpApplication((AttributeContainer)((Object)config), this);
                }
            }
            this.started = System.currentTimeMillis();
            this.log(ApplicationServer.VERSION + " Started");
        }
        finally {
            WebApplicationProtocol.POST_START.fire(this);
        }
    }

    protected String getSessionCookiePath() {
        return this.sessionCookiePath;
    }

    protected String getSessionCookieName() {
        return this.sessionCookieName;
    }

    protected void createDefaultPersistenceUnitManager() {
        this.setPersistenceUnitManager(PersistenceUnitManagerFactory.createPersistenceUnitManager(this));
        if (this.getPersistenceUnitManager() != null) {
            this.getPersistenceUnitManager().initialize();
        }
    }

    private void initReplicationService(HttpApplicationConfig config) {
        this.setReplicationService(new LocalSessionService());
        if (config.isClustered() && config.isDistributable()) {
            try {
                JGroupConfig jconfig = config.getClusterConfig();
                if (jconfig != null && jconfig.useDatabase()) {
                    this.setReplicationService(new PersistenceHttpService(this, config));
                } else if (jconfig != null && jconfig.isEnabled()) {
                    this.setReplicationService(new JGroupHttpService(this, config));
                }
            }
            catch (Exception e) {
                m_traceLogger.log(Level.FINE, "Unable to initialize clustering: " + e.getMessage() + " (" + e.getClass().getName() + ")");
            }
        }
    }

    protected void setReplicationService(SessionReplicationService service) {
        this.replicationService = service;
    }

    protected byte[] getSessionCookiePrefix() {
        return this.sessionCookiePrefix;
    }

    protected byte[] getSessionCookieSuffix() {
        int maxAge = this.config.getSessionCookieMaxAge();
        if (maxAge > 0) {
            String suffix = this.sessionCookieSuffixBuffer.toString() + "; Expires=" + HttpDateFormat.format3(System.currentTimeMillis() + (long)maxAge * 1000L);
            return suffix.getBytes();
        }
        return this.sessionCookieSuffix;
    }

    public synchronized void addServletContextListener(ServletContextListener listener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ServletContextListener[1];
        } else {
            ServletContextListener[] newListeners = new ServletContextListener[this.contextListeners.length + 1];
            System.arraycopy(this.contextListeners, 0, newListeners, 0, this.contextListeners.length);
            this.contextListeners = newListeners;
        }
        this.contextListeners[this.contextListeners.length - 1] = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSession(ByteString id) {
        EvermindHttpSession session;
        Map map = this.sessions;
        synchronized (map) {
            session = (EvermindHttpSession)this.sessions.remove(id);
        }
        if (session != null) {
            this.invalidateSession(session, true);
        }
    }

    protected void invalidateSession(EvermindHttpSession session, boolean executeListeners) {
        this.invalidateSession(session, false, executeListeners);
    }

    protected void invalidateLocalSession(EvermindHttpSession session) {
        this.invalidateSession(session, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(EvermindHttpSession session, boolean isLocal, boolean executeListeners) {
        if (session != null) {
            if (this.sessionListeners != null && executeListeners) {
                HttpSessionListener[] listeners = this.sessionListeners;
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    listeners[i].sessionDestroyed(event);
                }
            }
            session.destroy(false, executeListeners);
            Map map = this.sessions;
            synchronized (map) {
                if (this.sessions.containsKey(session.id)) {
                    session = (EvermindHttpSession)this.sessions.remove(session.id);
                }
            }
            if (session != null && !isLocal) {
                this.replicationService.invalidateSession(session.id);
            }
            if (ApplicationServer.DMS_GATE && session != null) {
                session.getSessionActivationPhase().stop(session.getSessionActivationToken());
            }
        }
    }

    public synchronized void addServletContextAttributeListener(ServletContextAttributeListener listener) {
        if (this.contextAttributeListeners == null) {
            this.contextAttributeListeners = new ServletContextAttributeListener[1];
        } else {
            ServletContextAttributeListener[] newListeners = new ServletContextAttributeListener[this.contextAttributeListeners.length + 1];
            System.arraycopy(this.contextAttributeListeners, 0, newListeners, 0, this.contextAttributeListeners.length);
            this.contextAttributeListeners = newListeners;
        }
        this.contextAttributeListeners[this.contextAttributeListeners.length - 1] = listener;
    }

    public synchronized void addSessionAttributeListener(HttpSessionAttributeListener listener) {
        if (this.sessionAttributeListeners == null) {
            this.sessionAttributeListeners = new HttpSessionAttributeListener[1];
        } else {
            HttpSessionAttributeListener[] newListeners = new HttpSessionAttributeListener[this.sessionAttributeListeners.length + 1];
            System.arraycopy(this.sessionAttributeListeners, 0, newListeners, 0, this.sessionAttributeListeners.length);
            this.sessionAttributeListeners = newListeners;
        }
        this.sessionAttributeListeners[this.sessionAttributeListeners.length - 1] = listener;
    }

    public synchronized void addSessionListener(HttpSessionListener listener) {
        if (this.sessionListeners == null) {
            this.sessionListeners = new HttpSessionListener[1];
        } else {
            HttpSessionListener[] newListeners = new HttpSessionListener[this.sessionListeners.length + 1];
            System.arraycopy(this.sessionListeners, 0, newListeners, 0, this.sessionListeners.length);
            this.sessionListeners = newListeners;
        }
        this.sessionListeners[this.sessionListeners.length - 1] = listener;
    }

    public synchronized void addSessionActivationListener(HttpSessionActivationListener listener) {
        if (this.sessionActivationListeners == null) {
            this.sessionActivationListeners = new HttpSessionActivationListener[1];
        } else {
            HttpSessionActivationListener[] newActivationListeners = new HttpSessionActivationListener[this.sessionActivationListeners.length + 1];
            System.arraycopy(this.sessionActivationListeners, 0, newActivationListeners, 0, this.sessionActivationListeners.length);
            this.sessionActivationListeners = newActivationListeners;
        }
        this.sessionActivationListeners[this.sessionActivationListeners.length - 1] = listener;
    }

    public synchronized void addRequestListener(ServletRequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new ServletRequestListener[1];
        } else {
            ServletRequestListener[] newListeners = new ServletRequestListener[this.requestListeners.length + 1];
            System.arraycopy(this.requestListeners, 0, newListeners, 0, this.requestListeners.length);
            this.requestListeners = newListeners;
        }
        this.requestListeners[this.requestListeners.length - 1] = listener;
    }

    public synchronized void addRequestAttributeListener(ServletRequestAttributeListener listener) {
        if (this.requestAttributeListeners == null) {
            this.requestAttributeListeners = new ServletRequestAttributeListener[1];
        } else {
            ServletRequestAttributeListener[] newListeners = new ServletRequestAttributeListener[this.requestAttributeListeners.length + 1];
            System.arraycopy(this.requestAttributeListeners, 0, newListeners, 0, this.requestAttributeListeners.length);
            this.requestAttributeListeners = newListeners;
        }
        this.requestAttributeListeners[this.requestAttributeListeners.length - 1] = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws InstantiationException {
        WebApplicationProtocol.PRE_RESET.fire(this);
        this.lastType = null;
        for (int i = 0; i < 10; ++i) {
            this.requestDispatcherCache[i] = null;
        }
        this.destroyServlets();
        this.flushAllJSP();
        ConcurrentReaderHashMap i = this.filePaths;
        synchronized (i) {
            this.filePaths.clear();
        }
        this.tagLibraryStorage = null;
        this.destroyContextListeners();
        try {
            this.persist();
        }
        catch (Throwable t) {
            m_traceLogger.log(Level.FINE, "Error saving application state: " + t.getClass().getName() + " (" + t.getMessage() + ")");
        }
        this.classPathCache = null;
        if (this.myFilesStats != null) {
            this.myFilesStats.clear();
        }
        this.initClassLoader();
        this.initDynamic(this.config);
        WebApplicationProtocol.POST_RESET.fire(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDynamic(HttpApplicationConfig config) throws InstantiationException {
        block14: {
            ClassLoader applicationContextClassLoader2;
            this.contextListeners = null;
            this.contextAttributeListeners = null;
            this.sessionListeners = null;
            this.sessionAttributeListeners = null;
            this.requestListeners = null;
            this.requestAttributeListeners = null;
            this.initExpirationSettings();
            this.initDefaultServlets();
            this.initServletMappings();
            List mimeTypes = config.getMimeMappings();
            this.contentTypes = mimeTypes == null ? new HashMap() : this.mapContentTypes(mimeTypes);
            this.chainingHandlers = this.mapChainingHandlers(config.getChainingProperties());
            if (this.chainingHandlers != null && this.chainingHandlers.size() == 0) {
                this.chainingHandlers = null;
            }
            this.initServletDir(config);
            URL jspCacheURL = config.getJSPCacheDirectoryURL();
            if (jspCacheURL != null) {
                String filename = jspCacheURL.getFile();
                if (filename.endsWith("/")) {
                    filename = filename.substring(0, filename.length() - 1);
                }
                this.jspCacheFile = new File(filename);
            }
            this.initAuthenticator();
            this.initAccessController();
            if (!config.isClustered()) {
                try {
                    this.restore();
                }
                catch (Exception e) {
                    if (HTTPProperties.getHttpClusterDebug()) {
                        m_traceLogger.log(Level.FINE, "Exception: " + e.getMessage(), e);
                    }
                    m_traceLogger.log(Level.FINE, "Error restoring application state: " + e.getClass().getName() + " (" + e.getMessage() + ")");
                    this.log("Error restoring application state", e);
                }
            }
            this.classLoader.commit();
            this.parseMetaData();
            this.initLifecycleConfig();
            ThreadState state = ThreadState.getInheritableCurrentState();
            ContextContainer previousContainer = state.contextContainer;
            try {
                state.contextContainer = this;
                this.injectListenerResources();
                if (this.contextListeners != null) {
                    for (int i = 0; i < this.contextListeners.length; ++i) {
                        this.contextListeners[i].contextInitialized(new ServletContextEvent((ServletContext)this));
                    }
                }
                this.initPreloadServlets();
                Object var8_8 = null;
                state.contextContainer = previousContainer;
                if (Thread.currentThread().getContextClassLoader() != this.classLoader) break block14;
                if (m_traceLogger.isLoggable(Level.FINE)) {
                    m_traceLogger.log(Level.FINE, "Thread has the wrong classloader. Resetting the classloader associated with this thread " + Thread.currentThread().getContextClassLoader() + " to be that of the thread pool's classloader");
                }
                applicationContextClassLoader2 = ApplicationServer.getInstance().getThreadPool().getClassLoader();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                state.contextContainer = previousContainer;
                if (Thread.currentThread().getContextClassLoader() == this.classLoader) {
                    if (m_traceLogger.isLoggable(Level.FINE)) {
                        m_traceLogger.log(Level.FINE, "Thread has the wrong classloader. Resetting the classloader associated with this thread " + Thread.currentThread().getContextClassLoader() + " to be that of the thread pool's classloader");
                    }
                    ClassLoader applicationContextClassLoader2 = ApplicationServer.getInstance().getThreadPool().getClassLoader();
                    AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), applicationContextClassLoader2));
                }
                throw throwable;
            }
            AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), applicationContextClassLoader2));
            {
            }
        }
    }

    public synchronized void initServletDir(HttpApplicationConfig config) {
        String inputServletDir = config.getServletDirectory();
        if (inputServletDir != null && inputServletDir.length() > 0) {
            if (!inputServletDir.endsWith("/")) {
                inputServletDir = inputServletDir.concat("/");
            }
            this.servletDirectory = this.application.getServer().byteStringCache.getByteString(inputServletDir);
        } else {
            this.servletDirectory = this.application.getServer().byteStringCache.getByteString("");
        }
    }

    public synchronized ByteString getServletDir() {
        return this.servletDirectory;
    }

    public int getExpires(ByteString requestURI) {
        if (this.expirationSettings == null) {
            return 0;
        }
        RuntimeExpirationSetting[] settings = this.expirationSettings;
        for (int i = 0; i < settings.length; ++i) {
            RuntimeExpirationSetting setting = settings[i];
            if (setting.start != null && !requestURI.startsWith(setting.start) || setting.end != null && !requestURI.endsWith(setting.end)) continue;
            return setting.expirationTime;
        }
        return 0;
    }

    public void initExpirationSettings() {
        List settings = this.config.getExpirationSettings();
        if (!settings.isEmpty()) {
            this.expirationSettings = new RuntimeExpirationSetting[settings.size()];
            for (int i = 0; i < settings.size(); ++i) {
                ExpirationSetting setting = (ExpirationSetting)settings.get(i);
                this.expirationSettings[i] = new RuntimeExpirationSetting();
                this.expirationSettings[i].expirationTime = setting.getExpirationTime();
                String urlPattern = setting.getURLPattern();
                if (urlPattern == null) {
                    urlPattern = "*";
                }
                if (!(urlPattern.equals("*") || urlPattern.equals("/*") || urlPattern.equals("/*.*"))) {
                    int wildcardPos = urlPattern.indexOf(42);
                    if (wildcardPos < 0) {
                        this.expirationSettings[i].start = this.application.getServer().byteStringCache.getByteString(urlPattern);
                    } else if (wildcardPos == urlPattern.length() - 1) {
                        this.expirationSettings[i].start = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(0, wildcardPos));
                    } else {
                        this.expirationSettings[i].start = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(0, wildcardPos));
                        this.expirationSettings[i].end = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(wildcardPos + 1));
                    }
                }
                if (this.expirationSettings[i].start == null) continue;
                if (this.expirationSettings[i].start.length == 0) {
                    this.expirationSettings[i].start = null;
                    continue;
                }
                if (this.expirationSettings[i].start.length == 1 && this.expirationSettings[i].start.data[this.expirationSettings[i].start.offset] == 47) {
                    this.expirationSettings[i].start = null;
                    continue;
                }
                if (this.expirationSettings[i].start.data[this.expirationSettings[i].start.offset] == 47) continue;
                this.expirationSettings[i].start = SLASH_BYTESTRING.concat(this.expirationSettings[i].start);
            }
        }
    }

    protected void setDocumentRoot(Context context) throws InstantiationException {
        if (context == null) {
            throw new InstantiationException("No document root set");
        }
        this.documentRootContext = context;
        try {
            if (context instanceof FileContext) {
                this.documentRoot = ((FileContext)context).getFile().getCanonicalFile().toString();
            }
        }
        catch (Exception e) {
            throw new InstantiationException("Invalid document root");
        }
    }

    public HttpSession getSession(String name) {
        return null;
    }

    public Enumeration getIds() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    EvermindHttpSession getExistingSession(ByteString name) {
        return this.replicationService.getExistingSession(name);
    }

    public ServletContext getContext(String path) {
        try {
            return path.startsWith("/") ? this.site.getApplication(new ByteString(path)) : null;
        }
        catch (InstantiationException e) {
            this.site.log("Error initializing application for " + path + ": " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public Enumeration getInitParameterNames() {
        if (this.initParameters == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this.initParameters.keySet());
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path.charAt(0) != '/') {
            throw new MalformedURLException("Path must start with a '/'");
        }
        String realPath = this.getRealPath(HTTPProperties.getHttpFileDontCollapse() ? path : HttpApplication.collapseParentDirs(path), true);
        if (realPath != null) {
            if (path.indexOf("..") >= 0 && !this.isPublicPath(realPath)) {
                return null;
            }
            File file = new File(realPath);
            try {
                if (OC4JSecurity.exists(file)) {
                    return file.toURL();
                }
                return null;
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLegalFileSystemPath(String path, boolean checkCache) {
        if (!WINDOWS) {
            return true;
        }
        int end = path.length();
        if (end == 0 || end == 1 && path.charAt(0) == '/') {
            return true;
        }
        if (checkCache) {
            ConcurrentReaderHashMap concurrentReaderHashMap = this.filePaths;
            synchronized (concurrentReaderHashMap) {
                Object file = this.filePaths.get(path);
                if (file != null) {
                    return file != NULL_FILE;
                }
            }
        }
        char[] data = new char[end];
        path.getChars(0, end, data, 0);
        int start = 0;
        if (data[start] == '/') {
            ++start;
        }
        while (start < end) {
            boolean foundSeparator = false;
            int index = start;
            do {
                switch (data[index]) {
                    case ' ': {
                        if (index == end - 1 || data[index + 1] == '/') {
                            return false;
                        }
                        ++index;
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '|': {
                        return false;
                    }
                    case '.': {
                        if (index == end - 1) {
                            return false;
                        }
                        foundSeparator = true;
                        break;
                    }
                    case '/': {
                        foundSeparator = true;
                        break;
                    }
                    default: {
                        ++index;
                    }
                }
            } while (!foundSeparator && index < end);
            int length = index - start;
            switch (data[start]) {
                case 'A': 
                case 'a': {
                    char c;
                    if (length != 3 || (c = data[start + 1]) != 'U' && c != 'u' || (c = data[start + 2]) != 'X' && c != 'x') break;
                    return false;
                }
                case 'C': 
                case 'c': {
                    char c;
                    if (!(length != 3 || (c = data[start + 1]) != 'O' && c != 'o' || (c = data[start + 2]) != 'N' && c != 'n')) {
                        return false;
                    }
                    if (!(length != 4 || (c = data[start + 1]) != 'O' && c != 'o' || (c = data[start + 2]) != 'M' && c != 'm' || (c = data[start + 3]) < '1' || c > '9')) {
                        return false;
                    }
                    if (length != 6 || (c = data[start + 1]) != 'L' && c != 'l' || (c = data[start + 2]) != 'O' && c != 'o' || (c = data[start + 3]) != 'C' && c != 'c' || (c = data[start + 4]) != 'K' && c != 'k' || data[start + 5] != '$') break;
                    return false;
                }
                case 'L': 
                case 'l': {
                    char c;
                    if (length != 4 || (c = data[start + 1]) != 'P' && c != 'p' || (c = data[start + 2]) != 'T' && c != 't' || (c = data[start + 3]) < '1' || c > '9') break;
                    return false;
                }
                case 'N': 
                case 'n': {
                    char c;
                    if (length != 3 || (c = data[start + 1]) != 'U' && c != 'u' || (c = data[start + 2]) != 'L' && c != 'l') break;
                    return false;
                }
                case 'P': 
                case 'p': {
                    char c;
                    if (length != 3 || (c = data[start + 1]) != 'R' && c != 'r' || (c = data[start + 2]) != 'N' && c != 'n') break;
                    return false;
                }
            }
            start += length + 1;
        }
        return true;
    }

    public boolean isPublicPath(String path) {
        try {
            String canonicalPath = new File(path).getCanonicalPath();
            if (this.documentRoot == null || !canonicalPath.startsWith(this.documentRoot)) {
                boolean found = false;
                if (this.virtualDirectory != null) {
                    for (int i = 0; i < this.virtualDirectory.length; ++i) {
                        if (!canonicalPath.startsWith(this.virtualDirectory[i])) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            return true;
        }
        return true;
    }

    public HttpQueryParser getQueryParser() {
        if (this.queryParser == null) {
            this.queryParser = new HttpQueryParser();
        }
        return this.queryParser;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL resource = this.getResource(path);
            if (resource == null) {
                return null;
            }
            return resource.openConnection().getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(final String path) {
        if (path == null || path.length() < 1 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must begin with a \"/\"");
        }
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getRequestDispatcher(path);
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return HttpApplication.this.unprivileged_getRequestDispatcher(path);
            }
        };
        return (RequestDispatcher)OC4JSecurity.doPrivileged(action);
    }

    public RequestDispatcher unprivileged_getRequestDispatcher(String path) {
        return this.site.getRequestDispatcher(this, new ByteString(path));
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public void logAndPrint(String message, Throwable t) {
        this.application.logAndPrint(this.config.getShortName() + ": " + message, t);
    }

    public void logAndPrint(String message) {
        this.application.logAndPrint(this.config.getShortName() + ": " + message);
    }

    public void log(String message) {
        this.application.log(this.config.getShortName() + ": " + message);
    }

    public void log(Exception e, String message) {
        this.log(message, e);
    }

    public void log(String message, Throwable t) {
        this.application.log(this.config.getShortName() + ": " + message, t);
    }

    public void log(String message, Throwable t, EvermindHttpServletRequest request) {
        Object requestInfo = null;
        if (request == null) {
            try {
                request = ThreadState.getInheritableCurrentState().getApplicationServerThread().httpHandler.request;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (request != null && this.site.logRequestInfo) {
            StringBuffer requestInfoBuffer = new StringBuffer();
            requestInfoBuffer.append("\r\n\r\nRequest information:\r\n");
            requestInfoBuffer.append(request.getHeadersFormatted());
            requestInfoBuffer.append("\r\n");
            message = message + requestInfoBuffer.toString();
        }
        if (t == null) {
            this.log(message);
        } else {
            this.log(message, t);
        }
    }

    public String getRealPath(String path) {
        if (path == null) {
            path = "";
        }
        return this.getRealPath(HTTPProperties.getHttpFileDontCollapse() ? path : HttpApplication.collapseParentDirs(path), true);
    }

    private String getRealPath(String path, boolean checkCache) {
        if (path.startsWith("/..")) {
            return null;
        }
        if (this.virtualDirectory != null) {
            for (int i = 0; i < this.virtualDirectory.length; ++i) {
                if (!path.startsWith(this.virtualDirectory[i]) || path.length() != this.virtualDirectory[i].length() && path.charAt(this.virtualDirectory[i].length()) != '/') continue;
                return this.realDirectory[i].concat(path.substring(this.virtualDirectory[i].length()).replace('/', File.separatorChar));
            }
        }
        if (this.documentRoot != null && this.isLegalFileSystemPath(path, checkCache)) {
            path = path.length() > 0 && this.documentRoot.length() > 0 && !path.startsWith("/") && !this.documentRoot.endsWith("/") ? "/".concat(path) : path;
            return this.documentRoot.concat(path.replace('/', File.separatorChar));
        }
        return null;
    }

    public String getServerInfo() {
        return ApplicationServer.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            Object previous = null;
            previous = this.attributes.put(name, value);
            if (previous != null) {
                if (this.contextAttributeListeners != null) {
                    for (int i = 0; i < this.contextAttributeListeners.length; ++i) {
                        this.contextAttributeListeners[i].attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, previous));
                    }
                }
            } else if (this.contextAttributeListeners != null) {
                for (int i = 0; i < this.contextAttributeListeners.length; ++i) {
                    this.contextAttributeListeners[i].attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, value));
                }
            }
        }
        if (this.replicationService.isReplicateServletContext()) {
            if (value instanceof Serializable) {
                this.replicationService.sendContextValueUpdate(name, (Serializable)value);
            }
            this.replicationService.updateContextRMIValue(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeSilently(String name, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (name.equals("user.manager")) {
            try {
                return UserManagerConfig.ultimate(this.userManager);
            }
            catch (InstantiationException e) {
                return null;
            }
        }
        if (name.startsWith("orion.") && name.equals("orion.application")) {
            return this.application;
        }
        if (name.equals("javax.servlet.context.tempdir")) {
            if (this.temporaryDirectory == null) {
                this.temporaryDirectory = this.config.getTemporaryDirectory();
                if (!this.temporaryDirectory.exists()) {
                    this.temporaryDirectory.mkdir();
                }
            }
            return this.temporaryDirectory;
        }
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            Object value = this.attributes.remove(name);
            if (this.contextAttributeListeners != null && value != null) {
                for (int i = 0; i < this.contextAttributeListeners.length; ++i) {
                    this.contextAttributeListeners[i].attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, value));
                }
            }
        }
        if (this.replicationService.isReplicateServletContext()) {
            this.replicationService.sendContextValueUpdate(name, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttributeSilently(String name) {
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration getAttributeNames() {
        Map map = this.attributes;
        synchronized (map) {
            return Collections.enumeration(this.attributes.keySet());
        }
    }

    protected User tryFindUser(ByteString id) {
        return this.site.findTheSessionUser(id, this);
    }

    protected void createSession(EvermindHttpServletRequest request, EvermindHttpServletResponse response, ByteString requestedId, boolean useSSLSession, ByteString summittedSessionId) {
        this.createSession(request, response, requestedId, useSSLSession, summittedSessionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSession(EvermindHttpServletRequest request, EvermindHttpServletResponse response, ByteString requestedId, boolean useSSLSession, ByteString submittedSessionId, boolean executeListeners) {
        ByteString id = null;
        EvermindHttpSession session = null;
        Map map = this.sessions;
        synchronized (map) {
            id = this.getSessionId(request, requestedId);
            request.session = session = this.createSession(id, request.socket.getInetAddress().getAddress());
            if (HTTPProperties.getHttpSessionDebug() && m_traceLogger.isLoggable(Level.FINE)) {
                m_traceLogger.log(Level.FINE, "Created session with id '" + id + "' at " + new Date(session.getCreationTime()) + ", secureRequest: " + request.isSecure());
            }
            if (this.config.getSendSessionCookie() && !useSSLSession) {
                response.sessionCookiePrefix = this.sessionCookiePrefix;
                response.sessionCookieValue = id.data;
            }
            this.sessions.put(id, session);
        }
        if (HTTPProperties.getOracleAuthorizationShare()) {
            session.user = this.tryFindUser(id);
        }
        if (executeListeners && this.sessionListeners != null) {
            HttpSessionListener[] listeners = this.sessionListeners;
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].sessionCreated(new HttpSessionEvent((HttpSession)session));
            }
        }
        if (this.sessionTracker != null) {
            for (int i = 0; i < this.sessionTracker.length; ++i) {
                try {
                    if (this.sessionTracker[i].autoReload && (this.sessionTracker[i].invalidated || this.sessionTracker[i].file != null && (this.sessionTracker[i].file.lastModified() > this.sessionTracker[i].binaryLastModified || this.sessionTracker[i].sourceFile != null && this.sessionTracker[i].sourceFile.lastModified() > this.sessionTracker[i].sourceLastModified))) {
                        this.flushServlet(this.sessionTracker[i].name, true);
                        this.sessionTracker[i] = this.findServlet(this.sessionTracker[i].name);
                    }
                    try {
                        this.sessionTracker[i].servlet.service((ServletRequest)request, (ServletResponse)response);
                        if (!executeListeners || !(this.sessionTracker[i].servlet instanceof HttpSessionBindingListener)) continue;
                        session.putValue(i == 0 ? "sessionTracker" : "sessionTracker" + i, this.sessionTracker[i].servlet);
                    }
                    catch (Throwable t) {
                        this.log("Error in " + this.sessionTracker[i].name, t, request);
                    }
                    continue;
                }
                catch (ServletException e) {
                    this.log("Error calling SessionTracker", e);
                }
            }
        }
    }

    private EvermindHttpSession createSession(ByteString id, byte[] address) {
        return this.replicationService.createSession(this, id, this.config.getSessionTimeout(), null);
    }

    public static int getSessionIp(byte[] address) {
        if (address == null) {
            return 0;
        }
        return (address[0] << 24) + (address[1] << 16 & 0xFF0000) + (address[2] << 8 & 0xFF00) + (address[3] & 0xFF);
    }

    private ByteString getSessionId(EvermindHttpServletRequest request, ByteString requestedId) {
        ByteString id;
        if (request.isSecure() && requestedId != null && this.sessions.get(requestedId) != null) {
            requestedId = null;
        }
        if (requestedId == null) {
            byte[] idByte;
            while (this.sessions.get(id = new ByteString(idByte = EvermindHttpSession.encodeSession(this.site.cookieSuffix))) != null) {
            }
        } else {
            byte[] idByte = requestedId.getBytes(true);
            id = requestedId;
            id.offset = 0;
            id.length = idByte.length;
            id.data = idByte;
        }
        return id;
    }

    public JSPBeanInfo getBean(String implementationType, String type, List prefixes) {
        JSPBeanInfo info = new JSPBeanInfo();
        info.application = this;
        if (implementationType == null && type != null) {
            if (type.equals("int")) {
                info.type = Integer.TYPE;
            } else if (type.equals("long")) {
                info.type = Long.TYPE;
            } else if (type.equals("float")) {
                info.type = Float.TYPE;
            } else if (type.equals("double")) {
                info.type = Double.TYPE;
            } else if (type.equals("boolean")) {
                info.type = Boolean.TYPE;
            } else if (type.equals("byte")) {
                info.type = Byte.TYPE;
            } else if (type.equals("char")) {
                info.type = Character.TYPE;
            } else if (type.equals("short")) {
                info.type = Short.TYPE;
            }
            if (info.type != null) {
                return info;
            }
        }
        try {
            block39: {
                String searchName;
                String prefix;
                int i;
                block38: {
                    if (implementationType != null) {
                        try {
                            info.implementationType = implementationType.endsWith("[]") ? ClassUtils.findClass(ClassUtils.getCodedNotation(implementationType), (ClassLoader)this.classLoader) : Class.forName(implementationType, true, (ClassLoader)this.classLoader);
                        }
                        catch (ClassNotFoundException e) {
                            if (prefixes != null && implementationType.indexOf(46) < 0) {
                                for (i = 0; i < prefixes.size(); ++i) {
                                    try {
                                        prefix = (String)prefixes.get(i);
                                        if (!prefix.endsWith(".*")) continue;
                                        searchName = prefix.substring(0, prefix.length() - 1).concat(implementationType);
                                        info.implementationType = searchName.endsWith("[]") ? ClassUtils.findClass(ClassUtils.getCodedNotation(searchName), (ClassLoader)this.classLoader) : Class.forName(searchName, true, (ClassLoader)this.classLoader);
                                        implementationType = searchName;
                                        break;
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (info.implementationType != null) break block38;
                            throw e;
                        }
                    }
                }
                try {
                    info.type = type.endsWith("[]") ? ClassUtils.findClass(ClassUtils.getCodedNotation(type), (ClassLoader)this.classLoader) : Class.forName(type, true, (ClassLoader)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    if (prefixes != null && type.indexOf(46) < 0) {
                        for (i = 0; i < prefixes.size(); ++i) {
                            try {
                                prefix = (String)prefixes.get(i);
                                if (!prefix.endsWith(".*")) continue;
                                searchName = prefix.substring(0, prefix.length() - 1).concat(type);
                                info.type = searchName.endsWith("[]") ? ClassUtils.findClass(ClassUtils.getCodedNotation(searchName), (ClassLoader)this.classLoader) : Class.forName(searchName, true, (ClassLoader)this.classLoader);
                                type = searchName;
                                break;
                            }
                            catch (ClassNotFoundException cnfe) {
                                // empty catch block
                            }
                        }
                    }
                    if (info.type != null) break block39;
                    throw e;
                }
            }
            if (info.implementationType == null) {
                info.implementationType = info.type;
            }
            info.file = implementationType != null ? this.getClassFile(info.implementationType, false) : this.getClassFile(info.type, false);
            if (info.file != null) {
                info.lastModified = info.file.lastModified();
                info.sourceFile = implementationType != null ? this.getClassFile(info.implementationType, true) : this.getClassFile(info.type, true);
                if (info.sourceFile != null) {
                    info.sourceLastModified = info.sourceFile.lastModified();
                }
            } else {
                info.lastModified = -1L;
            }
            return info;
        }
        catch (ClassNotFoundException e) {
            if (implementationType != null && implementationType.indexOf(46) < 0) {
                return this.getBean("java.lang." + implementationType, type, prefixes);
            }
            if (type != null && type.indexOf(46) < 0) {
                return this.getBean(implementationType, "java.lang." + type, prefixes);
            }
            return null;
        }
    }

    public String getInitParameter(String name) {
        if (this.initParameters == null) {
            return null;
        }
        return (String)this.initParameters.get(name);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getNamedDispatcher(new ByteString(name));
    }

    public RequestDispatcher getNamedDispatcher(ByteString servletName) {
        ServletRequestDispatcher dispatcher = new ServletRequestDispatcher(this, true);
        ByteString query = null;
        int index = servletName.indexOf('?');
        if (index >= 0) {
            query = servletName.substring(index + 1, servletName.length());
            servletName = servletName.substring(0, index);
        }
        dispatcher.servletPath = dispatcher.requestURI = this.getServletDir().concat(servletName);
        try {
            ServletInstanceInfo info = this.findServlet(servletName);
            if (info != null) {
                dispatcher.info = info;
                if (info.application != null) {
                    dispatcher.setApplication(info.application);
                }
                dispatcher.setQueryString(query);
                return dispatcher;
            }
        }
        catch (ServletException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletInstanceInfo loadServlet(ByteString name, boolean createServletDispatcher) throws ClassNotFoundException, ServletException, IOException, JSPCompilationException {
        Notifier notifier;
        boolean isJsp;
        ServletInstanceInfo info;
        ThreadState state = ThreadState.getInheritableCurrentState();
        ServletDescriptor descriptor = this.config.getJSPDescriptor(name.toString());
        if (descriptor != null) {
            return this.loadJspServlet(state, name, descriptor);
        }
        descriptor = this.config.getServletDescriptor(name.toString(), createServletDispatcher);
        if (descriptor == null) {
            return null;
        }
        boolean shared = descriptor.isShared();
        String classNameString = descriptor.getClassName();
        ByteString className = classNameString == null ? name : this.application.getServer().byteStringCache.getByteString(classNameString);
        className = className.trim();
        Class<?> servletClass = null;
        if (shared && (info = this.site.server.getSharedServlet(name)) != null) {
            return info;
        }
        boolean bl = isJsp = className.toString().indexOf("JspServlet") != -1;
        if (isJsp) {
            this.jspServletInstance = new JspServletInstanceInfo(this);
            info = this.jspServletInstance;
        } else {
            info = new ServletInstanceInfo(this);
        }
        info.descriptor = descriptor;
        info.shared = shared;
        info.name = (ByteString)name.clone();
        if (className != null && !isJsp && (notifier = Notifier.getNotifier()) != null) {
            try {
                String[] params = new String[]{className.toString(), this.config.getName()};
                notifier.sendNotification("INITIALIZING_SERVLET_FOR_WEB_APP", params);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            info.type = servletClass = Class.forName(className.toString(), true, (ClassLoader)this.classLoader);
        }
        catch (NoClassDefFoundError e) {
            if (disallowAlias) {
                throw new ClassNotFoundException();
            }
            throw e;
        }
        info.file = this.getClassFile(servletClass, false);
        if (info.file != null) {
            info.binaryLastModified = info.file.lastModified();
            info.sourceFile = this.getClassFile(servletClass, true);
            info.sourceLastModified = info.sourceFile != null ? info.sourceFile.lastModified() : -1L;
        } else {
            info.binaryLastModified = -1L;
            info.sourceLastModified = -1L;
        }
        try {
            Object servletInstance = servletClass.newInstance();
            if (!(servletInstance instanceof Servlet)) {
                throw new ServletException(className.toString() + " does not implement Servlet.");
            }
            info.servlet = (Servlet)servletInstance;
        }
        catch (Exception e) {
            throw new ServletException("Error instantiating servlet", (Throwable)e);
        }
        if (isJsp) {
            this.jspServletInstance.initializeJsp();
        }
        info.config = new EvermindServletConfig(this, descriptor.getInitParameters(), info.name);
        info.autoReload = descriptor.getAutoReload();
        info.runAsRoleName = descriptor.getRunAsRoleName();
        ContextContainer previous = state.contextContainer;
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
        ServletInstanceInfo previousInfo = thread.servletInfo;
        thread.servletInfo = info;
        try {
            state.contextContainer = this;
            this.injectResource(info.servlet);
            boolean inv = this.invokeLifecycleMethod(info.servlet, descriptor.getPostConstructMethod());
            if (!inv) {
                throw new ServletException("@PostConstruct method invocation failed. Servlet will NOT be put into service.");
            }
            info.servlet.init(info.config);
        }
        finally {
            thread.servletInfo = previousInfo;
            state.contextContainer = previous;
        }
        if (info.servlet instanceof SingleThreadModel) {
            info.singleThreaded = true;
        }
        if (shared) {
            this.site.server.putSharedServlet(name, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletInstanceInfo loadJspServlet(ThreadState state, ByteString name, ServletDescriptor descriptor) throws ClassNotFoundException, ServletException, IOException, JSPCompilationException {
        JspInterface ojsp = null;
        if (this.jspServletInstance != null) {
            ojsp = this.jspServletInstance.jsp;
        }
        if (ojsp != null) {
            return this.getOjspJspFileServletInst(state, ojsp, name, descriptor);
        }
        JSPPage page = this.getJSP(this.application.getServer().byteStringCache.getByteString(descriptor.getJSPPage()));
        Map map = this.servletInstancesLock;
        synchronized (map) {
            return (ServletInstanceInfo)this.servletInstances.get(this.application.getServer().byteStringCache.getByteString(descriptor.getName()));
        }
    }

    private boolean isJspExtension(ByteString servletPath) {
        return servletPath.endsWith(jspextn) || servletPath.endsWith(jspxextn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServletInstanceInfo getOjspJspFileServletInst(ThreadState state, JspInterface ojsp, ByteString name, ServletDescriptor descriptor) throws ClassNotFoundException, ServletException, IOException {
        JspServletInstanceInfo info;
        boolean shared = descriptor.isShared();
        Class jspClass = ojsp.getJspClass(null, descriptor.getJSPPage());
        String className = jspClass.getClass().getName();
        if (shared && (info = (JspServletInstanceInfo)this.site.server.getSharedServlet(name)) != null) {
            return info;
        }
        info = new JspServletInstanceInfo(this);
        info.descriptor = descriptor;
        info.shared = shared;
        info.name = (ByteString)name.clone();
        info.type = jspClass;
        info.file = ojsp.getJspClassFile(null, descriptor.getJSPPage());
        if (info.file != null) {
            info.binaryLastModified = info.file.lastModified();
        }
        info.sourceFile = this.getJspSrcFile(descriptor.getJSPPage());
        if (info.sourceFile != null) {
            info.sourceLastModified = info.sourceFile.lastModified();
        }
        try {
            info.servlet = (Servlet)jspClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException(className.toString() + " does not implement Servlet", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(className.toString(), e);
        }
        info.config = new EvermindServletConfig(this, descriptor.getInitParameters(), info.name);
        info.autoReload = descriptor.getAutoReload();
        info.runAsRoleName = descriptor.getRunAsRoleName();
        ContextContainer previous = state.contextContainer;
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
        ServletInstanceInfo previousInfo = thread.servletInfo;
        thread.servletInfo = info;
        try {
            state.contextContainer = this;
            info.servlet.init(info.config);
        }
        finally {
            thread.servletInfo = previousInfo;
            state.contextContainer = previous;
        }
        if (shared) {
            this.site.server.putSharedServlet(name, info);
        }
        if (info.servlet instanceof SingleThreadModel) {
            info.singleThreaded = true;
        }
        this.setJspFileServletInstanceInfo(descriptor.getJSPPage(), info);
        return info;
    }

    private void setJspFileServletInstanceInfo(String jspfile, ServletInstanceInfo info) {
        this.jspfileServletInstances.put(jspfile, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletInstanceInfo getJspFileServletInstanceInfo(String jspfile) {
        ServletInstanceInfo info = null;
        Map map = this.jspfileServletInstances;
        synchronized (map) {
            info = (ServletInstanceInfo)this.jspfileServletInstances.get(jspfile);
        }
        return info;
    }

    File getJspSrcFile(String jspFile) {
        File f = new File(this.getRealPath("/") + jspFile);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUnusedCacheFiles() {
        this.timeoutJSPs();
        ConcurrentReaderHashMap concurrentReaderHashMap = this.cachedFiles;
        synchronized (concurrentReaderHashMap) {
            Iterator iterator = this.cachedFiles.values().iterator();
            while (iterator.hasNext()) {
                FileInformation info = (FileInformation)iterator.next();
                if ((info.flags & 1) == 0) {
                    iterator.remove();
                }
                info.flags = (byte)(info.flags & 0xFFFFFFFE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestDispatcher getRequestDispatcher(ByteString path, EvermindHttpServletRequest request, EvermindHttpServletResponse response) throws IOException, ServletException {
        FileInformation fileInformation;
        File requestedFile;
        boolean isDirectory;
        boolean endsWithSlash;
        ByteString originalPath;
        block116: {
            Cloneable unmodifiedPath;
            Object originalRequestedFile;
            Object dispatcher2;
            if (this.root != null && path.length == 0) {
                FixPathRequestDispatcher fixDispatcher = new FixPathRequestDispatcher(this.getRequestDispatcher(SLASH_BYTESTRING, null, null));
                fixDispatcher.requestURI = EMPTY_BYTESTRING;
                fixDispatcher.application = this;
                fixDispatcher.queryString = request.queryString;
                return fixDispatcher;
            }
            originalPath = path;
            HttpSite site = this.site;
            String pathEncString = null;
            if (this.jspServletInstance != null && this.config.getEnableJSPDispatcherShortCut()) {
                boolean _jspPageExists;
                if (this.config.getSimpleJspMapping()) {
                    _jspPageExists = this.isJspExtension(path);
                } else {
                    pathEncString = path.toString(DEFAULT_PATH_ENCODING);
                    _jspPageExists = this.jspServletInstance.isJspPageExists(pathEncString);
                }
                if (_jspPageExists) {
                    ServletInstanceInfo info;
                    File file;
                    String realPath;
                    if (disallowAlias && (realPath = this.getRealPath(HttpApplication.collapseParentDirs(path.toString()), false)) != null && (file = new File(realPath)) != null && !file.getCanonicalPath().equals(file.getAbsolutePath())) {
                        return null;
                    }
                    ServletRequestDispatcher dispatcher2 = ServletRequestDispatcher.getDispatcher(this);
                    dispatcher2.requestURI = path;
                    dispatcher2.servletPath = path;
                    dispatcher2.pathInfo = null;
                    if (request != null && request.queryString != null && request.isDispatcherChainEmpty()) {
                        dispatcher2.setQueryString(request.queryString);
                    }
                    dispatcher2.info = (info = this.getJspFileServletInstanceInfo(path.toString())) != null ? info : this.jspServletInstance;
                    if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                        throw new SecurityException();
                    }
                    return dispatcher2;
                }
            } else {
                boolean pathIsNull = false;
                dispatcher2 = this.jspPages;
                synchronized (dispatcher2) {
                    pathIsNull = this.jspPages.get(path) == null;
                }
                if (this.jspServletInstance != null && !pathIsNull) {
                    dispatcher2 = ServletRequestDispatcher.getDispatcher(this);
                    ((ServletRequestDispatcher)dispatcher2).requestURI = path;
                    ((ServletRequestDispatcher)dispatcher2).servletPath = path;
                    ((ServletRequestDispatcher)dispatcher2).pathInfo = null;
                    ((ServletRequestDispatcher)dispatcher2).info = this.jspServletInstance;
                    if (request != null && request.isDispatcherChainEmpty()) {
                        ((OC4JRequestDispatcher)dispatcher2).setQueryString(request.queryString);
                        if (!this.checkAuthenticationAndAuthorize(request, response, path)) {
                            throw new SecurityException();
                        }
                    }
                    return dispatcher2;
                }
            }
            ByteString servletDir = this.getServletDir();
            if (HTTPProperties.getEnableWebdir() && servletDir.length() > 0 && path.startsWith(servletDir)) {
                int servletDirNameLength;
                int servletNameEndPos;
                dispatcher2 = ServletRequestDispatcher.getDispatcher(this);
                ((ServletRequestDispatcher)dispatcher2).requestURI = path;
                if (request != null && request.isDispatcherChainEmpty()) {
                    ((OC4JRequestDispatcher)dispatcher2).setQueryString(request.queryString);
                }
                if ((servletNameEndPos = originalPath.indexOf('/', (servletDirNameLength = servletDir.length()) + 1)) < 0) {
                    ((ServletRequestDispatcher)dispatcher2).servletPath = originalPath;
                    servletNameEndPos = originalPath.length();
                } else {
                    ((ServletRequestDispatcher)dispatcher2).servletPath = originalPath.substring(0, servletNameEndPos);
                    ((ServletRequestDispatcher)dispatcher2).pathInfo = originalPath.substring(servletNameEndPos, originalPath.length());
                }
                ByteString servletName = path.substring(servletDirNameLength, servletNameEndPos);
                ServletInstanceInfo info = this.findServlet(servletName, true);
                if (info != null) {
                    ((ServletRequestDispatcher)dispatcher2).requestURI = path;
                    ((ServletRequestDispatcher)dispatcher2).info = info;
                    if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                        throw new SecurityException();
                    }
                    return dispatcher2;
                }
            }
            endsWithSlash = false;
            boolean isWelcomeFile = path.endsWith(SLASH_BYTESTRING);
            isDirectory = false;
            requestedFile = null;
            fileInformation = null;
            if (this.servletMappings != null) {
                int matchResult;
                originalRequestedFile = null;
                unmodifiedPath = path;
                boolean foundWelcomeServlet = false;
                if (isWelcomeFile) {
                    ByteString newPath = null;
                    for (int i = 0; i < this.defaultDocument.length; ++i) {
                        File subFilePath;
                        int matchResult2;
                        newPath = originalPath.concat(this.defaultDocument[i]);
                        if (this.servletMappings != null && (matchResult2 = ServletMapping.findMatch(newPath, newPath, false, HTTPProperties.getOc4JDeveloperUseCTSInfo(), this.servletMappings)) != Integer.MIN_VALUE) {
                            ServletMapping mapping = this.servletMappings[matchResult2];
                            if (mapping.getType() == 2) {
                                foundWelcomeServlet = true;
                            } else if (mapping.getType() == 0 || mapping.getType() == 1) {
                                foundWelcomeServlet = true;
                                break;
                            }
                        }
                        if ((subFilePath = this.getFileForPath(newPath)) != null && subFilePath.exists()) {
                            isDirectory = false;
                            requestedFile = subFilePath;
                            int pathLength = path.length;
                            if (pathLength != 0 && path.data[path.offset + pathLength - 1] == 47) break;
                            byte[] newData = new byte[pathLength + 1 + this.defaultDocument[i].length];
                            System.arraycopy(path.data, path.offset, newData, 0, pathLength);
                            newData[path.length] = 47;
                            System.arraycopy(path.data, path.offset, newData, 0, pathLength);
                            System.arraycopy(this.defaultDocument[i].data, this.defaultDocument[i].offset, newData, path.length + 1, this.defaultDocument[i].length);
                            path = this.application.getServer().byteStringCache.getByteString(newData);
                            endsWithSlash = false;
                            break;
                        }
                        foundWelcomeServlet = false;
                    }
                    if (foundWelcomeServlet) {
                        path = newPath;
                        if (request != null) {
                            request.resolvedRequestURI = (ByteString)path.clone();
                        }
                        endsWithSlash = false;
                        originalRequestedFile = requestedFile;
                        requestedFile = null;
                    }
                }
                if ((matchResult = ServletMapping.findMatch(originalPath, path, endsWithSlash, HTTPProperties.getOc4JDeveloperUseCTSInfo(), this.servletMappings)) != Integer.MIN_VALUE) {
                    ServletInstanceInfo info;
                    int pathLength;
                    int prefixLength;
                    boolean doTrailingSlashRedirect = false;
                    if (matchResult < 0) {
                        doTrailingSlashRedirect = true;
                        matchResult = -matchResult;
                    }
                    ServletMapping mapping = this.servletMappings[matchResult];
                    int mappingType = mapping.getType();
                    ByteString prefix = mapping.getPrefix();
                    ServletRequestDispatcher dispatcher3 = ServletRequestDispatcher.getDispatcher(this);
                    if (mappingType == 1) {
                        dispatcher3.servletPath = prefix;
                        dispatcher3.requestURI = dispatcher3.info instanceof JspServletInstanceInfo ? path : originalPath;
                    } else {
                        dispatcher3.servletPath = mappingType == 0 ? prefix : path;
                        if (!path.startsWith('/')) {
                            ByteString slash = new ByteString("/");
                            dispatcher3.requestURI = slash.concat(path);
                        } else {
                            dispatcher3.requestURI = path;
                        }
                    }
                    if (request != null && request.isDispatcherChainEmpty()) {
                        dispatcher3.setQueryString(request.queryString);
                    }
                    if (mappingType == 1 && (prefixLength = prefix == null ? 0 : (prefix.length > 0 && prefix.data[prefix.offset + prefix.length - 1] == 47 ? prefix.length() - 1 : prefix.length())) < (pathLength = originalPath.length())) {
                        dispatcher3.pathInfo = originalPath.substring(prefixLength, originalPath.length());
                    }
                    if ((info = mapping.getServletInfo()) != null) {
                        if (info.invalidated) {
                            info = null;
                        } else if (info.autoReload && info.lastModifiedCheck < HttpDateFormat.currentTimeLong && info.file != null) {
                            info.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
                            if (info.file.lastModified() != info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() != info.sourceLastModified) {
                                this.flushServlet(mapping.getServletNameAsByteString(), true);
                                info = null;
                            }
                        }
                    }
                    if (info == null) {
                        info = this.findServlet(mapping.getServletNameAsByteString());
                        mapping.setServletInfo(info);
                    }
                    if (info == null) {
                        if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                            throw new SecurityException();
                        }
                        String errorMessage = "The Servlet Mapping at path: " + path.toString() + " specifies an unknown servlet: " + mapping.getServletName();
                        ErrorRequestDispatcher errorDispatcher = new ErrorRequestDispatcher(500, errorMessage);
                        if (doTrailingSlashRedirect) {
                            FixPathRequestDispatcher fixDispatcher = new FixPathRequestDispatcher(errorDispatcher);
                            fixDispatcher.requestURI = path;
                            fixDispatcher.application = this;
                            return fixDispatcher;
                        }
                        return errorDispatcher;
                    }
                    dispatcher3.info = info;
                    dispatcher3.fileInformation = fileInformation;
                    dispatcher3.requestedFile = requestedFile;
                    if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                        throw new SecurityException();
                    }
                    if (doTrailingSlashRedirect) {
                        FixPathRequestDispatcher fixDispatcher = new FixPathRequestDispatcher(dispatcher3);
                        fixDispatcher.requestURI = path;
                        fixDispatcher.application = this;
                        return fixDispatcher;
                    }
                    if (!(info == null || info instanceof JspServletInstanceInfo && isDirectory)) {
                        return dispatcher3;
                    }
                }
                if (foundWelcomeServlet) {
                    originalPath = SLASH_BYTESTRING;
                    path = unmodifiedPath;
                    endsWithSlash = true;
                    requestedFile = originalRequestedFile;
                }
            }
            while (path.charAt(path.length - 1) == '/') {
                path = path.substring(0, path.length() - 1);
                endsWithSlash = true;
                if (path.length != 0) continue;
            }
            try {
                FileQuickStats fileQuickStats;
                fileInformation = (FileInformation)this.cachedFiles.get(path);
                requestedFile = fileInformation == null ? (!endsWithSlash && pathEncString != null ? this.getFileForPath(path, pathEncString) : this.getFileForPath(path)) : fileInformation.file;
                if (requestedFile == null) break block116;
                if (fileInformation != null && HttpDateFormat.currentTimeLong > fileInformation.lastModifiedCheckExpires) {
                    if (requestedFile.lastModified() != fileInformation.modifiedDate) {
                        originalRequestedFile = this.cachedFiles;
                        synchronized (originalRequestedFile) {
                            this.cachedFiles.remove(path);
                        }
                        fileInformation = null;
                    } else {
                        originalRequestedFile = HttpDateFormat.lock;
                        synchronized (originalRequestedFile) {
                            fileInformation.lastModifiedCheckExpires = HttpDateFormat.currentTimeLong + this.lastModifiedCheckExpires;
                        }
                    }
                }
                if ((fileQuickStats = (FileQuickStats)this.myFilesStats.get(requestedFile)) != null && requestedFile.lastModified() != fileQuickStats.lastModified) {
                    unmodifiedPath = this.myFilesStats;
                    synchronized (unmodifiedPath) {
                        this.myFilesStats.remove(requestedFile);
                    }
                    fileQuickStats = null;
                }
                if (fileQuickStats == null) {
                    fileQuickStats = new FileQuickStats();
                    fileQuickStats.isDirectory = requestedFile.isDirectory();
                    fileQuickStats.exists = requestedFile.exists();
                    fileQuickStats.lastModified = requestedFile.lastModified();
                    int maxFileInfoCacheEntries = HTTPProperties.getMaxFileInfoCacheEntries();
                    if (-1 < maxFileInfoCacheEntries) {
                        ConcurrentReaderHashMap foundWelcomeServlet = this.myFilesStats;
                        synchronized (foundWelcomeServlet) {
                            if (maxFileInfoCacheEntries != 0 && maxFileInfoCacheEntries < this.myFilesStats.size()) {
                                this.myFilesStats.clear();
                            }
                            this.myFilesStats.put(requestedFile, fileQuickStats);
                        }
                    }
                }
                if (fileInformation == null && fileQuickStats.isDirectory) {
                    isDirectory = true;
                    if (!endsWithSlash) {
                        if (this.servletMappings != null) {
                            for (int i = 0; i < this.servletMappings.length; ++i) {
                                ServletMapping mapping = this.servletMappings[i];
                                if (mapping.getType() != 0 || !mapping.getPrefix().equals(path)) continue;
                                isDirectory = false;
                                break;
                            }
                        }
                        if (isDirectory) {
                            FixPathRequestDispatcher fixDispatcher = new FixPathRequestDispatcher(this.getRequestDispatcher(originalPath.concat(SLASH_BYTESTRING), request, response));
                            fixDispatcher.requestURI = path;
                            fixDispatcher.application = this;
                            return fixDispatcher;
                        }
                    }
                    ByteString pathWithSlash = path.concat('/');
                    for (int i = 0; i < this.defaultDocument.length; ++i) {
                        ByteString newPath = pathWithSlash.concat(this.defaultDocument[i]);
                        File subFilePath = this.getFileForPath(newPath);
                        if (subFilePath == null || !subFilePath.exists()) continue;
                        isDirectory = false;
                        requestedFile = subFilePath;
                        int pathLength = path.length;
                        if (pathLength != 0 && path.data[path.offset + pathLength - 1] == 47) break;
                        byte[] newData = new byte[pathLength + 1 + this.defaultDocument[i].length];
                        System.arraycopy(path.data, path.offset, newData, 0, pathLength);
                        newData[path.length] = 47;
                        System.arraycopy(path.data, path.offset, newData, 0, pathLength);
                        System.arraycopy(this.defaultDocument[i].data, this.defaultDocument[i].offset, newData, path.length + 1, this.defaultDocument[i].length);
                        path = this.application.getServer().byteStringCache.getByteString(newData);
                        endsWithSlash = false;
                        break;
                    }
                }
                if (fileInformation == null) {
                    if (!fileQuickStats.exists) {
                        requestedFile = null;
                    } else {
                        String requestedPath = requestedFile.getPath();
                        String realPath = this.getRealPath(path.toString());
                        if (realPath == null) {
                            requestedFile = null;
                        } else if (!requestedPath.endsWith(realPath) && requestedPath.toLowerCase().endsWith(realPath.toLowerCase())) {
                            requestedFile = null;
                        }
                    }
                }
            }
            catch (IOException e) {
                fileInformation = null;
                requestedFile = null;
            }
        }
        if (requestedFile == null) {
            if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                throw new SecurityException();
            }
            return this.getDefaultDispatcher(request, originalPath);
        }
        if (isDirectory) {
            ByteString investigatePath;
            ByteString byteString = investigatePath = path.endsWith(SLASH_BYTESTRING) ? path : path.concat(SLASH_BYTESTRING);
            if (request != null && !this.checkAuthenticationAndAuthorize(request, response, investigatePath)) {
                throw new SecurityException();
            }
            RequestDispatcher defaultDisaptcher = this.getDefaultDispatcher(request, originalPath);
            if (defaultDisaptcher != null) {
                return defaultDisaptcher;
            }
            if (this.directoryBrowsingAllowed) {
                return new DirectoryRequestDispatcher(requestedFile, this, path.length > 1);
            }
            if (request != null && !this.checkAuthenticationAndAuthorize(request, response, investigatePath)) {
                throw new SecurityException();
            }
            return ErrorRequestDispatcher.DIRECTORY_BROWSING_NOT_ALLOWED;
        }
        int dotPos = path.lastIndexOf('.') + 1;
        ByteString contentTypeName = null;
        String contentTypeNameString = null;
        if (dotPos > 0 && !endsWithSlash) {
            ByteString suffix;
            ContentType type = null;
            ContentType lastType = this.lastType;
            if (lastType != null) {
                ByteString lastSuffix = lastType.extension;
                if (lastSuffix.length == path.length - dotPos) {
                    boolean correct = true;
                    for (int i = 0; i < lastSuffix.length; ++i) {
                        if (lastSuffix.data[lastSuffix.offset + i] == path.data[path.offset + dotPos + i]) continue;
                        correct = false;
                        break;
                    }
                    if (correct) {
                        type = lastType;
                    }
                }
            }
            if (type == null && (type = (ContentType)this.contentTypes.get(suffix = path.substring(dotPos))) != null) {
                this.lastType = type;
            }
            if (type != null) {
                if (type.handlerName != null) {
                    ServletInstanceInfo info;
                    ServletRequestDispatcher dispatcher = ServletRequestDispatcher.getDispatcher(this);
                    dispatcher.requestURI = path;
                    dispatcher.servletPath = path;
                    dispatcher.pathInfo = null;
                    if (request != null && request.isDispatcherChainEmpty()) {
                        dispatcher.setQueryString(request.queryString);
                    }
                    if ((info = type.handler) != null) {
                        if (info.invalidated) {
                            info = null;
                        } else if (info.autoReload && info.lastModifiedCheck < HttpDateFormat.currentTimeLong && info.file != null) {
                            info.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
                            if (info.file.lastModified() > info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() != info.sourceLastModified) {
                                this.flushServlet(type.handlerName, true);
                                info = null;
                            }
                        }
                    }
                    if (info == null) {
                        ByteString servletName = type.handlerName;
                        type.handler = info = this.findServlet(servletName);
                        if (info != null) {
                            type.handlerName = info.name;
                        }
                    }
                    if (info == null) {
                        if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                            throw new SecurityException();
                        }
                        return new ErrorRequestDispatcher(500, "Failed to find/initialize parser for ".concat(path.toString()) + " (" + type.handlerName + ")");
                    }
                    dispatcher.info = info;
                    if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
                        throw new SecurityException();
                    }
                    return dispatcher;
                }
                contentTypeName = type.nameArray;
                contentTypeNameString = type.name;
            }
        }
        if (request != null && !this.checkAuthenticationAndAuthorize(request, response, path)) {
            throw new SecurityException();
        }
        if (this.defaultServletName != null) {
            return this.getDefaultDispatcher(request, originalPath);
        }
        if (path.concat('/').equals(originalPath)) {
            return null;
        }
        FileRequestDispatcher dispatcher = new FileRequestDispatcher(this, requestedFile, path, contentTypeName, contentTypeNameString, fileInformation);
        if (request != null && request.queryString != null && request.isDispatcherChainEmpty()) {
            dispatcher.setQueryString(request.queryString);
        }
        return dispatcher;
    }

    public RequestDispatcher getDefaultDispatcher(EvermindHttpServletRequest request, ByteString path) throws ServletException {
        ServletMapping[] mappings = this.postServletMappings;
        if (mappings != null) {
            for (int i = 0; i < mappings.length; ++i) {
                ServletInstanceInfo info;
                ServletMapping mapping = mappings[i];
                if (!path.endsWith(mapping.getSuffix())) continue;
                ServletRequestDispatcher dispatcher = ServletRequestDispatcher.getDispatcher(this);
                dispatcher.requestURI = path;
                dispatcher.servletPath = path;
                dispatcher.pathInfo = null;
                if (request != null && request.isDispatcherChainEmpty()) {
                    dispatcher.setQueryString(request.queryString);
                }
                if ((info = mapping.getServletInfo()) != null) {
                    if (info.invalidated) {
                        info = null;
                    } else if (info.autoReload && info.lastModifiedCheck < HttpDateFormat.currentTimeLong && info.file != null) {
                        info.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
                        if (info.file.lastModified() > info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() != info.sourceLastModified) {
                            this.flushServlet(mapping.getServletNameAsByteString(), true);
                            info = null;
                        }
                    }
                }
                if (info == null) {
                    info = this.findServlet(mapping.getServletNameAsByteString());
                    mapping.setServletInfo(info);
                }
                if (info == null) {
                    return new ErrorRequestDispatcher(500, "Failed to find/initialize parser for ".concat(path.toString()) + " (" + mapping.getServletName() + ")");
                }
                dispatcher.info = info;
                return dispatcher;
            }
        }
        if (this.defaultServletName != null) {
            ServletRequestDispatcher dispatcher = ServletRequestDispatcher.getDispatcher(this);
            dispatcher.requestURI = path;
            dispatcher.servletPath = path;
            if (request != null && request.isDispatcherChainEmpty()) {
                dispatcher.setQueryString(request.queryString);
            }
            if (this.defaultServletInstance != null) {
                if (this.defaultServletInstance.invalidated) {
                    this.defaultServletInstance = null;
                } else if (this.defaultServletInstance.autoReload && this.defaultServletInstance.lastModifiedCheck < HttpDateFormat.currentTimeLong && this.defaultServletInstance.file != null) {
                    this.defaultServletInstance.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
                    if (this.defaultServletInstance.file.lastModified() > this.defaultServletInstance.binaryLastModified || this.defaultServletInstance.sourceFile != null && this.defaultServletInstance.sourceFile.lastModified() != this.defaultServletInstance.sourceLastModified) {
                        this.flushServlet(this.defaultServletName, true);
                        this.defaultServletInstance = null;
                    }
                }
            }
            if (this.defaultServletInstance == null) {
                this.defaultServletInstance = this.findServlet(this.defaultServletName);
            }
            dispatcher.info = this.defaultServletInstance;
            if (dispatcher.info == null) {
                this.servletClassNotFound(this.defaultServletName, true);
            }
            return dispatcher;
        }
        return null;
    }

    protected void addCachedDispatcher(ByteString originalPath, ByteString path, RequestDispatcher dispatcher) {
    }

    public byte[] getETag(String path, long lastModified, long length) {
        int i;
        lastModified -= length;
        int nameHash = path.hashCode();
        byte[] id = new byte[15];
        id[0] = 34;
        id[14] = 34;
        for (i = 1; i < 9; ++i) {
            id[i] = (byte)base64CharTable[(int)lastModified & 0x3F];
            lastModified >>= 6;
        }
        for (i = 9; i < 14; ++i) {
            id[i] = (byte)base64CharTable[nameHash & 0x3F];
            nameHash >>= 6;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest genericRequest, ServletResponse genericResponse, File file, ByteString requestURI, boolean include, FileInformation info) throws ServletException, IOException {
        block94: {
            try {
                String method;
                int fileLength;
                long fileLastModified;
                EvermindHttpServletRequest request = (EvermindHttpServletRequest)genericRequest;
                EvermindHttpServletResponse response = (EvermindHttpServletResponse)genericResponse;
                String filePath = file.getPath();
                if (info == null) {
                    Object object = this.cachedFiles;
                    synchronized (object) {
                        ByteString lookupInfo = requestURI;
                        info = (FileInformation)this.cachedFiles.get(lookupInfo);
                    }
                    if (info != null) {
                        fileLastModified = info.modifiedDate;
                        object = HttpDateFormat.lock;
                        synchronized (object) {
                            if (info.lastModifiedCheckExpires < HttpDateFormat.currentTimeLong) {
                                info.lastModifiedCheckExpires = HttpDateFormat.currentTimeLong + this.lastModifiedCheckExpires;
                                if (info.modifiedDate != file.lastModified()) {
                                    fileLastModified = file.lastModified();
                                    info = null;
                                }
                            }
                        }
                    } else {
                        fileLastModified = file.lastModified();
                    }
                } else {
                    fileLastModified = info.modifiedDate;
                }
                byte[] eTag = null;
                if (info != null) {
                    fileLength = info.data.length;
                    eTag = info.eTag;
                } else {
                    fileLength = (int)file.length();
                    if (response.outputFetchStatus == 2) {
                        response.writer.flush();
                    }
                    if (response.out != null && response.out.contentLength > 0) {
                        fileLength += response.out.contentLength;
                    }
                    if (this.site.sendETag) {
                        eTag = this.getETag(filePath, fileLength, fileLastModified);
                    }
                }
                if (!include) {
                    request.requestURI = requestURI;
                    if (info != null) {
                        response.lastModifiedHeader = info.lastModifiedHeader;
                        response.contentLengthHeader = info.contentLengthHeader;
                        response.eTagHeader = info.eTagHeader;
                        response.lastModified = fileLastModified;
                        response.contentLength = fileLength;
                        if (info.expires != 0) {
                            response.expiresHeader = info.expires == -1 ? HttpDateFormat.neverExpiresHeader : ("Expires: " + HttpDateFormat.format(System.currentTimeMillis() + (long)info.expires * 1000L)).getBytes();
                        }
                    } else {
                        response.lastModifiedHeader = "Last-Modified: ".concat(HttpDateFormat.format(fileLastModified)).getBytes();
                        response.lastModified = fileLastModified;
                        response.contentLengthHeader = "Content-Length: ".concat(String.valueOf(fileLength)).getBytes();
                        if (this.site.sendETag) {
                            response.eTagHeader = "ETag: ".concat(new String(eTag)).getBytes();
                        }
                        response.contentLength = fileLength;
                        int expires = this.getExpires(requestURI);
                        if (expires != 0) {
                            response.expiresHeader = expires == -1 ? HttpDateFormat.neverExpiresHeader : ("Expires: " + HttpDateFormat.format(System.currentTimeMillis() + (long)expires * 1000L)).getBytes();
                        }
                    }
                }
                if ((method = request.method) != "GET" && method != "POST") {
                    if (method == "HEAD") {
                        return;
                    }
                    if (method == "DELETE") {
                        if (request.getProtocol().endsWith("1.1")) {
                            response.sendError(405, "DELETE is not supported by this URL");
                        } else {
                            response.sendError(400, "DELETE is not supported by this URL");
                        }
                        return;
                    }
                    if (method == "OPTIONS") {
                        response.setHeader("Allow", "GET, HEAD, OPTIONS, TRACE");
                        return;
                    }
                    if (method == "TRACE") {
                        String CRLF = "\r\n";
                        String responseString = "TRACE " + request.getRequestURI() + " " + request.getProtocol();
                        Enumeration reqHeaderEnum = request.getHeaderNames();
                        while (reqHeaderEnum.hasMoreElements()) {
                            String headerName = (String)reqHeaderEnum.nextElement();
                            responseString = responseString + CRLF + headerName + ": " + request.getHeader(headerName);
                        }
                        responseString = responseString + CRLF;
                        int responseLength = responseString.length();
                        response.setContentType("message/http");
                        response.contentLengthHeader = null;
                        response.setContentLength(responseLength);
                        ServletOutputStream out = response.getOutputStream();
                        out.print(responseString);
                        out.close();
                        return;
                    }
                    if (request.getProtocol().endsWith("1.1")) {
                        response.sendError(405, method + " is not supported by this URL");
                    } else {
                        response.sendError(400, method + " is not supported by this URL");
                    }
                    return;
                }
                int start = -1;
                int end = -1;
                if (!include && !response.isLoginOrErrorPage) {
                    String interval;
                    int lineStart = request.headerLineLength;
                    int pos = lineStart + 5;
                    byte[] input = request.getInput();
                    try {
                        int lineLength;
                        while ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) != 0) {
                            if (lineLength > 4 && input[pos - 3] == 105 && input[pos - 2] == 102 && input[pos - 1] == 45) {
                                int base;
                                int testLength;
                                int lengthPos;
                                while (input[pos] == EvermindHttpServletRequest.IF_MODIFIED_SINCE_HEADER[pos - lineStart - 2]) {
                                    if (++pos - lineStart - 2 != EvermindHttpServletRequest.IF_MODIFIED_SINCE_HEADER.length) continue;
                                    try {
                                        while (input[pos] == 32) {
                                            ++pos;
                                        }
                                        if (HttpDateFormat.parse(input, pos, lineStart + lineLength - pos).getTime() / 1000L < fileLastModified / 1000L) break;
                                        lengthPos = lineStart + lineLength - 1;
                                        testLength = 0;
                                        base = 1;
                                        while (input[lengthPos] >= 48 && input[lengthPos] <= 57) {
                                            testLength += (input[lengthPos--] - 48) * base;
                                            base *= 10;
                                        }
                                        if (input[lengthPos] != 61 || input[lengthPos - 1] != 104 || input[lengthPos - 2] != 116 || input[lengthPos - 3] != 103 || input[lengthPos - 4] != 110 || input[lengthPos - 5] != 101 || input[lengthPos - 6] != 108 || testLength == fileLength) {
                                            response.status = 304;
                                            response.contentLength = -1;
                                            response.contentLengthHeader = null;
                                            response.lastModifiedHeader = null;
                                            response.lastModified = -1L;
                                            response.eTagHeader = null;
                                            return;
                                        }
                                        break;
                                    }
                                    catch (ParseException e) {
                                        // empty catch block
                                        break;
                                    }
                                }
                                pos = lineStart + 5;
                                if (lineLength > 4 && input[pos - 3] == 105 && input[pos - 2] == 102 && input[pos - 1] == 45) {
                                    while (input[pos] == EvermindHttpServletRequest.IF_UNMODIFIED_SINCE_HEADER[pos - lineStart - 2]) {
                                        if (++pos - lineStart - 2 != EvermindHttpServletRequest.IF_UNMODIFIED_SINCE_HEADER.length) continue;
                                        try {
                                            while (input[pos] == 32) {
                                                ++pos;
                                            }
                                            if (HttpDateFormat.parse(input, pos, lineStart + lineLength - pos).getTime() / 1000L >= fileLastModified / 1000L) break;
                                            lengthPos = lineStart + lineLength - 1;
                                            testLength = 0;
                                            base = 1;
                                            while (input[lengthPos] >= 48 && input[lengthPos] <= 57) {
                                                testLength += (input[lengthPos--] - 48) * base;
                                                base *= 10;
                                            }
                                            if (input[lengthPos] != 61 || input[lengthPos - 1] != 104 || input[lengthPos - 2] != 116 || input[lengthPos - 3] != 103 || input[lengthPos - 4] != 110 || input[lengthPos - 5] != 101 || input[lengthPos - 6] != 108 || testLength != fileLength) {
                                                response.status = 412;
                                                response.setContentType("text/html");
                                                response.contentLengthHeader = null;
                                                response.setContentLength(PRECONDITION_FAILED_MESSAGE.length);
                                                ServletOutputStream out = response.getOutputStream();
                                                out.write(PRECONDITION_FAILED_MESSAGE);
                                                return;
                                            }
                                            break;
                                        }
                                        catch (ParseException e) {
                                            // empty catch block
                                            break;
                                        }
                                    }
                                }
                                if (this.site.sendETag) {
                                    pos = lineStart + 5;
                                    if (lineLength > 4 && input[pos - 3] == 105 && input[pos - 2] == 102 && input[pos - 1] == 45) {
                                        while (input[pos] == EvermindHttpServletRequest.IF_MATCH_HEADER[pos - lineStart - 2]) {
                                            if (++pos - lineStart - 2 != EvermindHttpServletRequest.IF_MATCH_HEADER.length) continue;
                                            while (input[pos] == 32) {
                                                ++pos;
                                            }
                                            if (ArrayUtils.ifMatchEtag(input, pos, lineStart + lineLength - pos, eTag, 0, eTag.length)) break;
                                            response.status = 412;
                                            response.setContentType("text/html");
                                            response.contentLengthHeader = null;
                                            response.setContentLength(PRECONDITION_FAILED_MESSAGE.length);
                                            ServletOutputStream out = response.getOutputStream();
                                            out.write(PRECONDITION_FAILED_MESSAGE);
                                            return;
                                        }
                                    }
                                    pos = lineStart + 5;
                                    if (lineLength > 4 && input[pos - 3] == 105 && input[pos - 2] == 102 && input[pos - 1] == 45) {
                                        while (input[pos] == EvermindHttpServletRequest.IF_NONE_MATCH_HEADER[pos - lineStart - 2]) {
                                            if (++pos - lineStart - 2 != EvermindHttpServletRequest.IF_NONE_MATCH_HEADER.length) continue;
                                            while (input[pos] == 32) {
                                                ++pos;
                                            }
                                            if (!ArrayUtils.ifMatchEtag(input, pos, lineStart + lineLength - pos, eTag, 0, eTag.length)) break;
                                            response.status = 412;
                                            response.setContentType("text/html");
                                            response.contentLengthHeader = null;
                                            response.setContentLength(PRECONDITION_FAILED_MESSAGE.length);
                                            ServletOutputStream out = response.getOutputStream();
                                            out.write(PRECONDITION_FAILED_MESSAGE);
                                            return;
                                        }
                                    }
                                }
                            }
                            pos = (lineStart += lineLength) + 5;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if ((interval = request.getHeader(EvermindHttpServletRequest.RANGE_HEADER)) != null && interval.startsWith("bytes=")) {
                        try {
                            String ifRange = request.getHeader(EvermindHttpServletRequest.IF_RANGE_HEADER);
                            if (ifRange == null || this.site.sendETag && ifRange.startsWith("\"") && ifRange.equals(new String(eTag)) || !ifRange.startsWith("\"") && HttpDateFormat.parse(ifRange).getTime() / 1000L == fileLastModified / 1000L) {
                                int lengthPos = ifRange == null ? -1 : ifRange.length() - 1;
                                int testLength = 0;
                                int base = 1;
                                while (lengthPos >= 7 && input[lengthPos] >= 48 && input[lengthPos] <= 57) {
                                    testLength += (input[lengthPos--] - 48) * base;
                                    base *= 10;
                                }
                                if (ifRange == null || lengthPos < 7 || ifRange.charAt(lengthPos) != '=' || ifRange.charAt(lengthPos - 1) != 'h' || ifRange.charAt(lengthPos - 2) != 't' || ifRange.charAt(lengthPos - 3) != 'g' || ifRange.charAt(lengthPos - 4) != 'n' || ifRange.charAt(lengthPos - 5) != 'e' || ifRange.charAt(lengthPos - 6) != 'l' || testLength == fileLength) {
                                    interval = interval.substring(6);
                                    StringTokenizer tokenizer = new StringTokenizer(interval, ",");
                                    ArrayList<Range> ranges = new ArrayList<Range>();
                                    while (tokenizer.hasMoreElements() && ranges != null) {
                                        int parseSectionStart;
                                        int parseSectionEnd;
                                        String rangeString = tokenizer.nextToken();
                                        int lineIndex = rangeString.indexOf(45);
                                        if (lineIndex < 0) {
                                            ranges = null;
                                            continue;
                                        }
                                        if (lineIndex == 0) {
                                            parseSectionEnd = Integer.parseInt(rangeString.substring(1));
                                            parseSectionStart = fileLength - parseSectionEnd;
                                            parseSectionEnd = fileLength - 1;
                                        } else if (lineIndex == rangeString.length() - 1) {
                                            parseSectionStart = Integer.parseInt(rangeString.substring(0, lineIndex));
                                            parseSectionEnd = fileLength - 1;
                                        } else {
                                            parseSectionStart = Integer.parseInt(rangeString.substring(0, lineIndex));
                                            parseSectionEnd = Integer.parseInt(rangeString.substring(lineIndex + 1, rangeString.length()));
                                        }
                                        if (parseSectionEnd >= fileLength) {
                                            parseSectionEnd = fileLength - 1;
                                        }
                                        if (parseSectionStart < 0 || parseSectionEnd < 0 || parseSectionStart > parseSectionEnd) {
                                            ranges = null;
                                            continue;
                                        }
                                        ranges.add(new Range(parseSectionStart, parseSectionEnd));
                                    }
                                    if (ranges != null) {
                                        info = null;
                                        if (ranges.size() == 1) {
                                            Range firstRange = (Range)ranges.get(0);
                                            start = firstRange.getStart();
                                            end = firstRange.getEnd() + 1;
                                            response.status = 206;
                                            response.contentLengthHeader = ("Content-Length: " + (end - start)).getBytes();
                                            response.contentLength = end - start;
                                            response.setHeader("Content-Range", "bytes " + start + '-' + (end - 1) + '/' + fileLength);
                                        } else if (ranges.size() > 1) {
                                            response.status = 206;
                                            MultipartContent multipart = new MultipartContent(file, ranges, response.getContentType(), fileLength);
                                            response.setContentType(multipart.getBoundaryHeader());
                                            response.setContentLength(multipart.getContentLength());
                                            multipart.writeTo((OutputStream)response.getOutputStream());
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                        catch (ParseException e) {
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                try {
                    byte[] cache;
                    if (info == null) {
                        FileInputStream fileIn = new FileInputStream(file);
                        if (fileLength > 102400 || start >= 0 && end >= 0) {
                            if (end >= 0) {
                                fileLength = end - start;
                            }
                            if (start > 0) {
                                fileIn.skip(start);
                            }
                            if (response.outputFetchStatus == 2) {
                                PrintWriter out = response.getWriter();
                                InputStreamReader r = new InputStreamReader((InputStream)fileIn, response.getCharacterEncoding());
                                char[] buf = new char[25600];
                                int count = 0;
                                while ((count = r.read(buf)) != -1) {
                                    out.write(buf, 0, count);
                                }
                                r.close();
                            } else {
                                ServletOutputStream out = response.getOutputStream();
                                byte[] cache2 = new byte[102400];
                                while (fileLength > 102400) {
                                    fileIn.read(cache2);
                                    out.write(cache2);
                                    fileLength -= 102400;
                                }
                                fileIn.read(cache2, 0, fileLength);
                                out.write(cache2, 0, fileLength);
                            }
                            fileIn.close();
                            return;
                        }
                        cache = new byte[fileLength];
                        fileIn.read(cache);
                        fileIn.close();
                        ConcurrentReaderHashMap concurrentReaderHashMap = this.cachedFiles;
                        synchronized (concurrentReaderHashMap) {
                            ByteString toPut = (ByteString)requestURI.clone();
                            this.cachedFiles.put(toPut, new FileInformation(file.lastModified(), cache, response.lastModifiedHeader, response.contentLengthHeader, response.eTagHeader, eTag, file, this.getExpires(requestURI)));
                        }
                    } else {
                        cache = info.data;
                        info.flags = (byte)(info.flags | 1);
                    }
                    if (response.outputFetchStatus == 2) {
                        PrintWriter out = response.getWriter();
                        out.write(new String(cache, 0, cache.length, response.getCharacterEncoding()));
                        break block94;
                    }
                    ServletOutputStream out = response.getOutputStream();
                    out.write(cache, 0, cache.length);
                }
                catch (ClassCastException e) {}
            }
            catch (IOException e) {
                genericResponse.setContentLength(-1);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeGeneric(ServletRequest genericRequest, ServletResponse genericResponse, File file, ByteString requestURI, boolean include, FileInformation info) throws ServletException, IOException {
        try {
            String method;
            int fileLength;
            long fileLastModified;
            HttpServletResponse response;
            HttpServletRequest request;
            try {
                request = (HttpServletRequest)genericRequest;
                response = (HttpServletResponse)genericResponse;
            }
            catch (ClassCastException e) {
                if (!(genericRequest instanceof HttpServletRequest)) {
                    throw new ClassCastException(genericRequest.getClass().getName() + " does not implement javax.servlet.http.HttpServletRequest, if you're extending javax.servlet.ServletRequestWrapper then try extending javax.servlet.http.HttpServletRequestWrapper instead");
                }
                throw new ClassCastException(genericResponse.getClass().getName() + " does not implement javax.servlet.http.HttpServletResponse, if you're extending javax.servlet.ServletResponseWrapper then try extending javax.servlet.http.HttpServletRequestWrapper instead");
            }
            Object localizedFile = null;
            String filePath = file.getPath();
            if (info == null) {
                Object object = this.cachedFiles;
                synchronized (object) {
                    ByteString lookupInfo = requestURI;
                    info = (FileInformation)this.cachedFiles.get(lookupInfo);
                }
                if (info != null) {
                    fileLastModified = info.modifiedDate;
                    object = HttpDateFormat.lock;
                    synchronized (object) {
                        if (info.lastModifiedCheckExpires < HttpDateFormat.currentTimeLong) {
                            info.lastModifiedCheckExpires = HttpDateFormat.currentTimeLong + this.lastModifiedCheckExpires;
                            if (info.modifiedDate != file.lastModified()) {
                                fileLastModified = file.lastModified();
                                info = null;
                            }
                        }
                    }
                } else {
                    fileLastModified = file.lastModified();
                }
            } else {
                fileLastModified = info.modifiedDate;
            }
            byte[] eTag = null;
            if (info != null) {
                fileLength = info.data.length;
                eTag = info.eTag;
            } else {
                fileLength = (int)file.length();
                if (this.site.sendETag) {
                    eTag = this.getETag(filePath, fileLength, fileLastModified);
                }
            }
            if (!include) {
                response.setDateHeader("Last-Modified", fileLastModified);
            }
            if ((method = request.getMethod()) != "GET" && method != "POST") {
                if (method == "HEAD") {
                    return;
                }
                if (method == "DELETE") {
                    if (request.getProtocol().endsWith("1.1")) {
                        response.sendError(405, "DELETE is not supported by this URL");
                    } else {
                        response.sendError(400, "DELETE is not supported by this URL");
                    }
                    return;
                }
                if (method == "OPTIONS") {
                    response.setHeader("Allow", "GET, HEAD, OPTIONS, TRACE");
                    return;
                }
                if (method == "TRACE") {
                    String CRLF = "\r\n";
                    String responseString = "TRACE " + request.getRequestURI() + " " + request.getProtocol();
                    Enumeration reqHeaderEnum = request.getHeaderNames();
                    while (reqHeaderEnum.hasMoreElements()) {
                        String headerName = (String)reqHeaderEnum.nextElement();
                        responseString = responseString + CRLF + headerName + ": " + request.getHeader(headerName);
                    }
                    responseString = responseString + CRLF;
                    int responseLength = responseString.length();
                    response.setContentType("message/http");
                    response.setContentLength(responseLength);
                    ServletOutputStream out = response.getOutputStream();
                    out.print(responseString);
                    out.close();
                    return;
                }
                if (request.getProtocol().endsWith("1.1")) {
                    response.sendError(405, method + " is not supported by this URL");
                } else {
                    response.sendError(400, method + " is not supported by this URL");
                }
                return;
            }
            int start = -1;
            int end = -1;
            if (!include) {
                if (this.checkModifieds(request, response, fileLastModified)) {
                    return;
                }
                String interval = request.getHeader("range");
                if (interval != null && interval.startsWith("bytes=")) {
                    try {
                        String ifRange = request.getHeader("if-range");
                        if (ifRange == null || !ifRange.startsWith("\"") && HttpDateFormat.parse(ifRange).getTime() / 1000L == fileLastModified / 1000L) {
                            interval = interval.substring(6);
                            StringTokenizer tokenizer = new StringTokenizer(interval, ",");
                            ArrayList<Range> ranges = new ArrayList<Range>();
                            while (tokenizer.hasMoreElements() && ranges != null) {
                                int parseSectionStart;
                                int parseSectionEnd;
                                String rangeString = tokenizer.nextToken();
                                int lineIndex = rangeString.indexOf(45);
                                if (lineIndex < 0) {
                                    ranges = null;
                                    continue;
                                }
                                if (lineIndex == 0) {
                                    parseSectionEnd = Integer.parseInt(rangeString.substring(1));
                                    parseSectionStart = fileLength - parseSectionEnd;
                                    parseSectionEnd = fileLength - 1;
                                } else if (lineIndex == rangeString.length() - 1) {
                                    parseSectionStart = Integer.parseInt(rangeString.substring(0, lineIndex));
                                    parseSectionEnd = fileLength - 1;
                                } else {
                                    parseSectionStart = Integer.parseInt(rangeString.substring(0, lineIndex));
                                    parseSectionEnd = Integer.parseInt(rangeString.substring(lineIndex + 1, rangeString.length()));
                                }
                                if (parseSectionEnd >= fileLength) {
                                    parseSectionEnd = fileLength - 1;
                                }
                                if (parseSectionStart < 0 || parseSectionEnd < 0 || parseSectionStart > parseSectionEnd) {
                                    ranges = null;
                                    continue;
                                }
                                ranges.add(new Range(parseSectionStart, parseSectionEnd));
                            }
                            if (ranges != null) {
                                info = null;
                                if (ranges.size() == 1) {
                                    Range firstRange = (Range)ranges.get(0);
                                    start = firstRange.getStart();
                                    end = firstRange.getEnd() + 1;
                                    response.setStatus(206);
                                    response.setContentLength(end - start);
                                    response.setHeader("Content-Range", "bytes " + start + '-' + (end - 1) + '/' + fileLength);
                                } else if (ranges.size() > 1) {
                                    response.setStatus(206);
                                    MultipartContent multipart = new MultipartContent(file, ranges, response.getContentType(), fileLength);
                                    response.setContentType(multipart.getBoundaryHeader());
                                    response.setContentLength(multipart.getContentLength());
                                    multipart.writeTo((OutputStream)response.getOutputStream());
                                    return;
                                }
                            }
                        }
                    }
                    catch (ParseException e) {
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            try {
                byte[] cache;
                if (info == null) {
                    Object out;
                    FileInputStream fileIn = new FileInputStream(file);
                    if (fileLength > 102400 || start >= 0 && end >= 0) {
                        if (end >= 0) {
                            fileLength = end - start;
                        }
                        out = response.getOutputStream();
                        if (start > 0) {
                            fileIn.skip(start);
                        }
                        byte[] cache2 = new byte[102400];
                        while (fileLength > 102400) {
                            fileIn.read(cache2);
                            ((OutputStream)out).write(cache2);
                            fileLength -= 102400;
                        }
                        fileIn.read(cache2, 0, fileLength);
                        ((OutputStream)out).write(cache2, 0, fileLength);
                        fileIn.close();
                        return;
                    }
                    cache = new byte[fileLength];
                    fileIn.read(cache);
                    fileIn.close();
                    out = this.cachedFiles;
                    synchronized (out) {
                        ByteString toPut = (ByteString)requestURI.clone();
                        this.cachedFiles.put(toPut, new FileInformation(file.lastModified(), cache, ("Last-Modified: " + HttpDateFormat.format(fileLastModified)).getBytes(), ("Content-Length: " + String.valueOf(fileLength)).getBytes(), null, null, file, this.getExpires(requestURI)));
                    }
                } else {
                    cache = info.data;
                    info.flags = (byte)(info.flags | 1);
                }
                try {
                    ServletOutputStream out = response.getOutputStream();
                    out.write(cache, 0, cache.length);
                }
                catch (IllegalStateException e) {
                    PrintWriter writer = response.getWriter();
                    for (int i = 0; i < cache.length; ++i) {
                        writer.write(cache[i]);
                    }
                }
            }
            catch (ClassCastException e) {
            }
        }
        catch (IOException e) {
            genericResponse.setContentLength(-1);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushServlet(ByteString name, boolean flushClass) {
        Map map = this.servletInstancesLock;
        synchronized (map) {
            if (flushClass) {
                try {
                    this.reset();
                }
                catch (InstantiationException e) {
                    this.log("Error resetting state: " + e);
                }
            } else {
                ServletInstanceInfo info;
                try {
                    info = (ServletInstanceInfo)this.servletInstances.get(name);
                }
                catch (ClassCastException e) {
                    info = null;
                }
                if (info == null) {
                    return;
                }
                this.servletInstances.remove(name);
                if (info.shared) {
                    this.site.server.removeSharedServlet(info.name);
                }
                info.invalidated = true;
            }
        }
    }

    protected boolean checkModifieds(HttpServletRequest request, HttpServletResponse response, long fileLastModified) throws IOException {
        String ifUnmodifiedSince;
        String ifModifiedSince = request.getHeader("if-modified-since");
        if (ifModifiedSince != null) {
            try {
                if (HttpDateFormat.parse(ifModifiedSince).getTime() / 1000L >= fileLastModified / 1000L) {
                    response.setStatus(304);
                    response.setContentLength(-1);
                    return true;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((ifUnmodifiedSince = request.getHeader("if-unmodified-since")) != null) {
            try {
                if (HttpDateFormat.parse(ifUnmodifiedSince).getTime() / 1000L < fileLastModified / 1000L) {
                    response.setStatus(412);
                    response.setContentType("text/html");
                    response.setContentLength(PRECONDITION_FAILED_MESSAGE.length);
                    ServletOutputStream out = response.getOutputStream();
                    out.write(PRECONDITION_FAILED_MESSAGE);
                    return true;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return false;
    }

    public Map mapChainingHandlers(Properties properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, ByteString> handlers = new HashMap<String, ByteString>();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            ByteString value = this.application.getServer().byteStringCache.getByteString((String)entry.getValue());
            handlers.put(key, value);
        }
        return handlers;
    }

    public Map mapContentTypes(List contentTypeProperties) {
        HashMap<ByteString, ContentType> contentTypes = new HashMap<ByteString, ContentType>();
        Iterator iterator = contentTypeProperties.iterator();
        ArrayList<ServletMapping> postMappings = new ArrayList<ServletMapping>();
        while (iterator.hasNext()) {
            MimeMapping entry = (MimeMapping)iterator.next();
            String key = (String)entry.getKey();
            ContentType type = new ContentType();
            type.extension = this.application.getServer().byteStringCache.getByteString(key.getBytes());
            type.name = (String)entry.getValue();
            type.nameArray = this.application.getServer().byteStringCache.getByteString(((String)entry.getValue()).getBytes());
            if (entry.getRequestHandler() != null) {
                type.handlerName = this.application.getServer().byteStringCache.getByteString(entry.getRequestHandler().getBytes());
            }
            String abbrev = ".".concat(key);
            if (this.servletMappings != null) {
                for (int i = 0; i < this.servletMappings.length; ++i) {
                    ServletMapping mapping = this.servletMappings[i];
                    if (mapping.getType() != 2 || !mapping.getSuffix().toString().equals(abbrev)) continue;
                    postMappings.add(mapping);
                    type.handler = mapping.getServletInfo();
                    type.handlerName = mapping.getServletNameAsByteString();
                    ServletMapping[] newMappings = new ServletMapping[this.servletMappings.length - 1];
                    System.arraycopy(this.servletMappings, 0, newMappings, 0, i);
                    System.arraycopy(this.servletMappings, i + 1, newMappings, i, newMappings.length - i);
                    if (newMappings.length == 0) {
                        this.servletMappings = null;
                        break;
                    }
                    this.servletMappings = newMappings;
                    --i;
                }
            }
            ByteString byteKey = this.application.getServer().byteStringCache.getByteString(key);
            for (int i = 0; i < byteKey.length; ++i) {
                if (byteKey.data[i + byteKey.offset] < 65 || byteKey.data[i + byteKey.offset] > 90) continue;
                byteKey = (ByteString)byteKey.clone();
            }
            byteKey.makeLowerCase();
            contentTypes.put(byteKey, type);
        }
        if (!postMappings.isEmpty()) {
            this.postServletMappings = postMappings.toArray(new ServletMapping[postMappings.size()]);
        }
        return contentTypes;
    }

    private File getFileForPath(ByteString rawPath) throws IOException {
        return this.getFileForPath(rawPath, rawPath.toString(DEFAULT_PATH_ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileForPath(ByteString rawPath, String path) throws IOException {
        File file;
        if (rawPath.length != 0 && path.length() == 0) {
            path = "/\ufffd";
        }
        if ((file = (File)this.filePaths.get(path = HttpApplication.collapseParentDirs(path))) != null) {
            if (file == NULL_FILE) {
                return null;
            }
            return file;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this.filePaths;
        synchronized (concurrentReaderHashMap) {
            String realPath;
            int maxFileInfoCacheEntries = HTTPProperties.getMaxFileInfoCacheEntries();
            if (0 < maxFileInfoCacheEntries && maxFileInfoCacheEntries < this.filePaths.size()) {
                if (this.application.getServer().getVerbosityLevel() > 3) {
                    m_traceLogger.log(Level.FINE, "Clear filePaths cache. The size is " + this.filePaths.size());
                }
                this.filePaths.clear();
            }
            if ((realPath = this.getRealPath(path, false)) == null) {
                if (-1 < maxFileInfoCacheEntries) {
                    this.filePaths.put(path, NULL_FILE);
                }
                return null;
            }
            file = new File(realPath);
            file = file.getCanonicalFile();
            String allowAlliasProp = HTTPProperties.getAllowFileAlias();
            if (disallowAlias && !file.getCanonicalPath().equals(realPath)) {
                if (-1 < maxFileInfoCacheEntries) {
                    this.filePaths.put(path, NULL_FILE);
                }
                return null;
            }
            if (-1 < maxFileInfoCacheEntries) {
                this.filePaths.put(path, file);
            }
            return file;
        }
    }

    protected ServletInstanceInfo findServlet(ByteString name) throws ServletException {
        return this.findServlet(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ServletInstanceInfo findServlet(ByteString name, boolean createServletDispatcher) throws ServletException {
        Map map;
        ServletInstanceInfo info;
        ByteString clonedName = null;
        try {
            info = (ServletInstanceInfo)this.servletInstances.get(name);
            if (info == null) {
                Map map2 = this.servletInstancesLock;
                synchronized (map2) {
                    info = (ServletInstanceInfo)this.servletInstances.get(name);
                    if (info == null) {
                        if (clonedName == null) {
                            clonedName = this.getApplication().getServer().byteStringCache.getByteString(name);
                        }
                        this.servletInstances.put(clonedName, new Object());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            map = this.servletInstancesLock;
            synchronized (map) {
                info = null;
                while (info == null) {
                    Object loaderObject = this.servletInstances.get(name);
                    if (loaderObject instanceof ServletInstanceInfo) {
                        info = (ServletInstanceInfo)loaderObject;
                        break;
                    }
                    if (loaderObject == null) break;
                    try {
                        this.servletInstancesLock.wait(500L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
        }
        if (info != null && info.autoReload && info.lastModifiedCheck < HttpDateFormat.currentTimeLong && info.file != null) {
            info.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
            if (info.page != null && !info.page.isUpToDate() || info.file.lastModified() > info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() != info.sourceLastModified) {
                Map e = this.servletInstancesLock;
                synchronized (e) {
                    if (this.servletInstances.get(name) != info) return this.findServlet(name);
                    this.flushServlet(info.name, true);
                    return this.findServlet(name);
                }
            }
        }
        try {
            if (info != null) return info;
            Object compilerObject = null;
            map = this.servletInstancesLock;
            synchronized (map) {
                block28: {
                    ServletInstanceInfo servletInstanceInfo;
                    block27: {
                        compilerObject = this.servletInstances.get(name);
                        try {
                            info = this.loadServlet(name, createServletDispatcher);
                            if (clonedName == null) {
                                clonedName = this.getApplication().getServer().byteStringCache.getByteString(name);
                            }
                            if (info == null) {
                                servletInstanceInfo = null;
                                Object var12_13 = null;
                                if (this.servletInstances.get(name) != compilerObject) return servletInstanceInfo;
                                this.servletInstances.remove(name);
                                break block27;
                            }
                            this.servletInstances.put(clonedName, info);
                            this.servletInstancesLock.notifyAll();
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            if (this.servletInstances.get(name) != compilerObject) throw throwable;
                            this.servletInstances.remove(name);
                            this.servletInstancesLock.notifyAll();
                            throw throwable;
                        }
                    }
                    this.servletInstancesLock.notifyAll();
                    return servletInstanceInfo;
                }
                Object var12_14 = null;
                if (this.servletInstances.get(name) != compilerObject) return info;
                this.servletInstances.remove(name);
                this.servletInstancesLock.notifyAll();
                return info;
            }
        }
        catch (ClassNotFoundException e) {
            this.servletClassNotFound(name, false);
            return info;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable t) {
            this.log("Error initializing servlet", t);
            throw new ServletException("Error initializing servlet", t);
        }
    }

    private void servletClassNotFound(ByteString servletName, boolean isDefault) throws ServletException {
        ServletDescriptor descriptor = this.config.getServletDescriptor(servletName.toString(), isDefault);
        String className = null;
        className = descriptor != null && descriptor.getClassName() != null ? descriptor.getClassName() : servletName.toString();
        String message = null;
        message = isDefault ? "Error instantiating default servlet '" : "Error instantiating servlet '";
        String webAppName = this.config.getName();
        message = message + servletName + "'. Servlet class " + className + " not found in web-application " + webAppName;
        throw new ServletException(message);
    }

    public void initPreloadServlets() {
        ServletDescriptor descriptor;
        int i;
        List descriptors = this.config.getServlets();
        ArrayList<ServletDescriptor> preloadServlets = new ArrayList<ServletDescriptor>();
        for (i = 0; i < descriptors.size(); ++i) {
            descriptor = (ServletDescriptor)descriptors.get(i);
            if (!descriptor.getLoadOnStartup()) continue;
            preloadServlets.add(descriptor);
        }
        descriptors = this.config.getJSPs();
        for (i = 0; i < descriptors.size(); ++i) {
            descriptor = (ServletDescriptor)descriptors.get(i);
            if (!descriptor.getLoadOnStartup()) continue;
            preloadServlets.add(descriptor);
        }
        Collections.sort(preloadServlets);
        Iterator iterator = preloadServlets.iterator();
        while (iterator.hasNext()) {
            descriptor = (ServletDescriptor)iterator.next();
            try {
                if (this.findServlet(new ByteString(descriptor.getName())) != null) continue;
                this.log("load-on-startup servlet " + descriptor.getName() + " not found");
            }
            catch (ServletException e) {
                this.log("Error preloading servlet", e);
            }
        }
    }

    public RequestDispatcher getLocalDispatcher(ByteString path, ThreadState state) {
        EvermindHttpServletResponse thResp;
        byte[] data = path.data;
        int end = path.offset + path.length;
        int index = -1;
        block10: for (int i = path.offset; i < end; ++i) {
            switch (data[i]) {
                case 59: {
                    path = new ByteString(data, path.offset, i - path.offset);
                    end = i;
                    continue block10;
                }
                case 63: {
                    if (index != -1) continue block10;
                    index = i - path.offset;
                }
            }
        }
        ApplicationServerThread th = state.getApplicationServerThread();
        EvermindHttpServletRequest thReq = th != null ? th.httpHandler.request : null;
        EvermindHttpServletResponse evermindHttpServletResponse = thResp = th != null ? th.httpHandler.response : null;
        if (index >= 0) {
            ByteString uri = path.substring(0, index);
            ByteString query = path.substring(index + 1, path.length());
            try {
                RequestDispatcher dispatcher = this.getRequestDispatcher(uri, thReq, thResp);
                if (dispatcher == null) {
                    return null;
                }
                if (dispatcher instanceof ServletRequestDispatcher) {
                    ((ServletRequestDispatcher)dispatcher).setQueryString(query);
                }
                return dispatcher;
            }
            catch (IOException e) {
            }
            catch (ServletException e) {
                // empty catch block
            }
        }
        try {
            return this.getRequestDispatcher(path, thReq, thResp);
        }
        catch (IOException e) {
            return null;
        }
        catch (ServletException e) {
            return null;
        }
    }

    private void initServletMappings() {
        this.servletMappings = null;
        this.defaultServletName = null;
        this.defaultServletInstance = null;
        List mappings = this.config.getServletMappings();
        if (mappings.isEmpty()) {
            return;
        }
        ArrayList<ServletMapping> list = new ArrayList<ServletMapping>();
        ByteStringCache cache = this.application.getServer().byteStringCache;
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            ServletMapping mapping = (ServletMapping)((ServletMapping)iterator.next()).clone();
            if (mapping.init(this.contextPath, cache)) {
                list.add(mapping);
                continue;
            }
            this.defaultServletName = mapping.getServletNameAsByteString();
        }
        if (list.isEmpty()) {
            this.servletMappings = null;
            return;
        }
        Collections.sort(list);
        this.servletMappings = list.toArray(new ServletMapping[list.size()]);
    }

    private void initDefaultServlets() throws InstantiationException {
        List requestTrackers;
        List sessionTrackers;
        int i;
        List filterMappings;
        if (SecurityUtil.isJAZN(this.userManager)) {
            this.securityFilter = SecurityUtil.toJAZN(this.userManager).getFilter(this.config.getJAZNWebAppConfig());
            this.securityFilterInited = false;
        }
        if (!(filterMappings = this.config.getFilterMappings()).isEmpty()) {
            int _idxUrlPatternFilterPattern = 0;
            int _idxServletNameFilterPattern = 0;
            for (int i2 = 0; i2 < filterMappings.size(); ++i2) {
                if (((FilterMapping)filterMappings.get(i2)).getURLPattern() == null) continue;
                ++_idxServletNameFilterPattern;
            }
            RuntimeFilterMapping[] runtimeFilterMappings = new RuntimeFilterMapping[filterMappings.size()];
            int _idx = 0;
            for (i = 0; i < runtimeFilterMappings.length; ++i) {
                FilterMapping mapping = (FilterMapping)filterMappings.get(i);
                _idx = mapping.getURLPattern() == null ? _idxServletNameFilterPattern++ : _idxUrlPatternFilterPattern++;
                runtimeFilterMappings[_idx] = new RuntimeFilterMapping();
                FilterDescriptor filter = this.config.getFilter(mapping.getFilterName());
                if (filter == null) {
                    throw new InstantiationError("No filter named '" + mapping.getFilterName() + "' as specified by filter-mapping found in the web-app");
                }
                runtimeFilterMappings[_idx].filter = filter;
                String urlPattern = mapping.getURLPattern();
                String servletName = mapping.getServletName();
                if (servletName != null) {
                    runtimeFilterMappings[_idx].servletName = this.application.getServer().byteStringCache.getByteString(servletName);
                }
                if (urlPattern == null) {
                    urlPattern = "*";
                }
                if (!(urlPattern.equals("*") || urlPattern.equals("/*") || urlPattern.equals("/*.*"))) {
                    int wildcardPos = urlPattern.indexOf(42);
                    if (wildcardPos < 0) {
                        runtimeFilterMappings[_idx].start = this.application.getServer().byteStringCache.getByteString(urlPattern);
                    } else if (wildcardPos == urlPattern.length() - 1) {
                        runtimeFilterMappings[_idx].start = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(0, wildcardPos));
                    } else {
                        runtimeFilterMappings[_idx].start = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(0, wildcardPos));
                        runtimeFilterMappings[_idx].end = this.application.getServer().byteStringCache.getByteString(urlPattern.substring(wildcardPos + 1));
                    }
                }
                if (runtimeFilterMappings[_idx].start != null) {
                    if (runtimeFilterMappings[_idx].start.length == 0) {
                        runtimeFilterMappings[_idx].start = null;
                    } else if (runtimeFilterMappings[_idx].start.length == 1 && runtimeFilterMappings[_idx].start.data[runtimeFilterMappings[_idx].start.offset] == 47) {
                        runtimeFilterMappings[_idx].start = null;
                    } else if (runtimeFilterMappings[_idx].start.data[runtimeFilterMappings[_idx].start.offset] != 47) {
                        runtimeFilterMappings[_idx].start = SLASH_BYTESTRING.concat(runtimeFilterMappings[_idx].start);
                    }
                }
                runtimeFilterMappings[_idx].dispatchMode = mapping.getDispatchMode();
            }
            this.filterMappings = runtimeFilterMappings;
        }
        List listeners = this.config.getListeners();
        if (!(listeners = this.addJspTldListeners(listeners)).isEmpty()) {
            for (int i3 = 0; i3 < listeners.size(); ++i3) {
                ListenerDescriptor listener = (ListenerDescriptor)listeners.get(i3);
                try {
                    Class<?> type = Class.forName(listener.getClassName(), true, this.getClassLoader());
                    Object instance = type.newInstance();
                    boolean hit = false;
                    if (instance instanceof ServletContextListener) {
                        this.addServletContextListener((ServletContextListener)instance);
                        hit = true;
                    }
                    if (instance instanceof ServletContextAttributeListener) {
                        this.addServletContextAttributeListener((ServletContextAttributeListener)instance);
                        hit = true;
                    }
                    if (instance instanceof HttpSessionListener) {
                        this.addSessionListener((HttpSessionListener)instance);
                        hit = true;
                    }
                    if (instance instanceof HttpSessionActivationListener) {
                        this.addSessionActivationListener((HttpSessionActivationListener)instance);
                        hit = true;
                    }
                    if (instance instanceof HttpSessionAttributeListener) {
                        this.addSessionAttributeListener((HttpSessionAttributeListener)instance);
                        hit = true;
                    }
                    if (instance instanceof ServletRequestListener) {
                        this.addRequestListener((ServletRequestListener)instance);
                        hit = true;
                    }
                    if (instance instanceof ServletRequestAttributeListener) {
                        this.addRequestAttributeListener((ServletRequestAttributeListener)instance);
                        hit = true;
                    }
                    if (hit) continue;
                    throw new InstantiationException("Listener class '" + listener.getClassName() + "' was dit not implement 'javax.servlet.ServletContextListener', 'javax.servlet.ServletContextAttributeListener', 'javax.servlet.http.HttpSessionListener', 'javax.servlet.http.HttpSessionAttributeListener' 'javax.servlet.ServletRequestListener', or 'javax.servlet.ServletRequestAttributeListener'");
                }
                catch (IllegalAccessException e) {
                    throw new InstantiationException("Error loading listener '" + listener.getClassName() + "', it could not be instantiated due to access problems: " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new InstantiationException("Error loading listener '" + listener.getClassName() + "', class not found");
                }
            }
        }
        if ((sessionTrackers = this.config.getSessionTrackers()).size() > 0) {
            ArrayList<ServletInstanceInfo> sessionTrackerInstances = new ArrayList<ServletInstanceInfo>();
            for (i = 0; i < sessionTrackers.size(); ++i) {
                try {
                    String servletName = (String)sessionTrackers.get(i);
                    ServletInstanceInfo info = this.findServlet(new ByteString(servletName));
                    if (info == null) {
                        throw new InstantiationException("session-tracker servlet '" + servletName + "' not found");
                    }
                    sessionTrackerInstances.add(info);
                    continue;
                }
                catch (ServletException e) {
                    // empty catch block
                }
            }
            if (sessionTrackerInstances.size() > 0) {
                this.sessionTracker = sessionTrackerInstances.toArray(new ServletInstanceInfo[sessionTrackerInstances.size()]);
            }
        }
        if ((requestTrackers = this.config.getRequestTrackers()).size() > 0) {
            ArrayList<ServletInstanceInfo> requestTrackerInstances = new ArrayList<ServletInstanceInfo>();
            for (int i4 = 0; i4 < requestTrackers.size(); ++i4) {
                try {
                    String servletName = (String)requestTrackers.get(i4);
                    ServletInstanceInfo info = this.findServlet(new ByteString(servletName));
                    if (info == null) {
                        throw new InstantiationException("request-tracker servlet '" + servletName + "' not found");
                    }
                    requestTrackerInstances.add(info);
                    continue;
                }
                catch (ServletException e) {
                    // empty catch block
                }
            }
            if (requestTrackerInstances.size() > 0) {
                this.requestTracker = requestTrackerInstances.toArray(new ServletInstanceInfo[requestTrackerInstances.size()]);
            }
        }
    }

    private void buildTldCache(JspInterface ojsp) throws InstantiationException {
        if (JspServletInstanceInfo.jspTldCacheIsUsed(this.jspTldCacheLevel)) {
            if (ApplicationServer.getInstance().getGlobalTldCache() == null) {
                if (this.application.getServer().getVerbosityLevel() > 3) {
                    m_traceLogger.log(Level.FINE, "Building Global TagLibrary Persistent Cache");
                }
                ApplicationServer.getInstance().buildGlobalTldCache(ojsp, this.jspTldCacheLevel, this.getRealPath("/"));
            }
            URL jspCacheDirectory = this.config.getJSPCacheDirectoryURL();
            try {
                if (jspCacheDirectory != null) {
                    if (this.application.getServer().getVerbosityLevel() > 3) {
                        m_traceLogger.log(Level.FINE, "Building Application TagLibrary Persistent Cache for " + this.config.getName());
                    }
                    Object applicationTldCache = ojsp.newApplicationCache(this.getRealPath("/"), this.getClassLoader(), jspCacheDirectory, this.application.getServer().getVerbosityLevel(), this.jspTldCacheLevel);
                    this.config.setTldCache(applicationTldCache);
                }
            }
            catch (Throwable t) {
                HttpMessages.warningApplicationTldCacheBuildFailure(this.config.getName(), t);
            }
        }
    }

    public Map getTagClassMap() {
        if (!this.m_processAnnotations) {
            return null;
        }
        if (JspServletInstanceInfo.jspTldCacheIsUsed(this.jspTldCacheLevel)) {
            JspInterface ojsp;
            if (this.jspServletInstance == null) {
                try {
                    ojsp = JspServletInstanceInfo.getJspInterfaceInstance();
                }
                catch (Throwable t) {
                    HttpMessages.warningApplicationTldCacheBuildFailure(this.config.getName(), t);
                    return null;
                }
            } else {
                ojsp = this.jspServletInstance;
            }
            if (this.tagClassMap == null) {
                this.tagClassMap = ojsp.getTagClassMap();
            }
        }
        return this.tagClassMap;
    }

    private List addJspTldListeners(List listeners) throws InstantiationException {
        List tldListeners = this.getJspTldListeners();
        if (!tldListeners.isEmpty()) {
            tldListeners = this.getTldListenerDescriptors(tldListeners);
            if (!listeners.isEmpty()) {
                listeners.addAll(tldListeners);
            } else {
                listeners = new ArrayList(tldListeners);
            }
        }
        return listeners;
    }

    private List getJspTldListeners() throws InstantiationException {
        JspInterface ojsp = this.jspServletInstance == null ? JspServletInstanceInfo.getJspInterfaceInstance() : this.jspServletInstance;
        List tldListeners = new ArrayList();
        if (JspServletInstanceInfo.jspTldCacheIsUsed(this.jspTldCacheLevel)) {
            this.buildTldCache(ojsp);
            try {
                tldListeners = ojsp.getTldListeners(this.config.getTldCache());
            }
            catch (Throwable t) {
                m_traceLogger.log(Level.FINE, "IO error obtaining listeners from Tag Library Descriptor Cache : " + t.getMessage(), t);
            }
        } else {
            if (this.m_processAnnotations) {
                this.tagClassMap = new HashMap();
            }
            tldListeners = ojsp.getJspTaglibListeners(this.getRealPath("/"), this.getClassLoader(), this.tagClassMap);
        }
        return tldListeners;
    }

    public String getMimeType(String path) {
        ContentType type;
        int pos = path.lastIndexOf(46);
        if (pos >= 0 && (type = (ContentType)this.contentTypes.get(new ByteString(path.substring(pos + 1)))) != null) {
            return type.name;
        }
        return null;
    }

    void setContentTypes(Map contentTypes) {
        this.contentTypes = contentTypes;
    }

    private void initAuthenticator() throws InstantiationException {
        if (this.config.getSSOAuth()) {
            WebSSOAuthenticator ssoAuthenticator = new WebSSOAuthenticator();
            this.authenticator = ssoAuthenticator;
        } else {
            this.authenticator = null;
            if (SecurityUtil.isJAZN(this.userManager)) {
                this.authenticator = SecurityUtil.toJAZN(this.userManager).getHttpAuthenticator(this.config.getJAZNWebAppConfig(), this.config.getAuthMethod());
            }
            if (this.authenticator == null) {
                if (this.config.getAuthMethod() == 4) {
                    FormHttpAuthenticator formAuthenticator = new FormHttpAuthenticator(this.config.getFormLoginPage(), this.config.getFormErrorPage());
                    this.authenticator = formAuthenticator;
                } else if (this.config.getAuthMethod() == 8) {
                    this.authenticator = new CertificateHttpAuthenticator();
                } else if (this.config.getAuthMethod() != 2) {
                    BasicHttpAuthenticator basicAuthenticator = new BasicHttpAuthenticator();
                    basicAuthenticator.setRealm(this.config.getRealm());
                    this.authenticator = basicAuthenticator;
                }
            }
        }
    }

    public void initAccessController() throws InstantiationException {
        List constraints = this.config.getSecurityConstraints();
        if (constraints.size() == 0) {
            this.protectedRegions = null;
            return;
        }
        ArrayList<ProtectedRegion> regions = new ArrayList<ProtectedRegion>();
        Iterator iterator = constraints.iterator();
        while (iterator.hasNext()) {
            SecurityConstraint constraint = (SecurityConstraint)iterator.next();
            List resources = constraint.getResourceCollections();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceCollection collection = (ResourceCollection)resources.get(i);
                List urlPatterns = collection.getURLPatterns();
                for (int x = 0; x < urlPatterns.size(); ++x) {
                    ProtectedRegion region = new ProtectedRegion();
                    String pattern = (String)urlPatterns.get(x);
                    int wildcardPos = pattern.indexOf(42);
                    if (wildcardPos < 0) {
                        region.prefix = this.application.getServer().byteStringCache.getByteString(pattern);
                        region.hasWildCard = false;
                        region.allMethods = pattern.equals("/");
                    } else if (wildcardPos == pattern.length() - 1) {
                        region.prefix = this.application.getServer().byteStringCache.getByteString(pattern.substring(0, wildcardPos > 1 && pattern.charAt(wildcardPos - 1) == '/' ? wildcardPos - 1 : wildcardPos));
                        region.hasWildCard = true;
                        region.allMethods = wildcardPos == 1;
                    } else {
                        region.prefix = this.application.getServer().byteStringCache.getByteString(pattern.substring(0, wildcardPos));
                        region.suffix = this.application.getServer().byteStringCache.getByteString(pattern.substring(wildcardPos + 1));
                        region.hasWildCard = wildcardPos == 0;
                        region.allMethods = false;
                    }
                    region.method = collection.getMethodMask();
                    region.constraint = constraint;
                    if (constraint.getTransportGuarantee() != 0) {
                        region.requiresSSL = true;
                    }
                    regions.add(region);
                }
            }
        }
        this.protectedRegions = regions.toArray(new ProtectedRegion[regions.size()]);
    }

    public void initVirtualDirectories(Map map) throws InstantiationException {
        if (map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        ArrayList<String> virtualList = new ArrayList<String>();
        ArrayList<String> realList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String realPath;
            Map.Entry entry = iterator.next();
            String virtualPath = (String)entry.getKey();
            if (virtualPath.length() != 0 && virtualPath.charAt(0) != '/') continue;
            if (virtualPath.endsWith("/")) {
                virtualPath = virtualPath.substring(0, virtualPath.length() - 1);
            }
            if ((realPath = (String)entry.getValue()).startsWith("file:/")) {
                try {
                    realPath = new URL(realPath).getFile();
                }
                catch (MalformedURLException e) {
                    throw new InstantiationException("Bad virtual path, " + realPath + ": " + e.getMessage());
                }
                if (realPath.endsWith(File.separator)) {
                    realPath = realPath.substring(0, realPath.length() - 1);
                }
            }
            try {
                realPath = new File(realPath).getCanonicalFile().getPath();
            }
            catch (Exception e) {
                // empty catch block
            }
            virtualList.add(virtualPath);
            realList.add(realPath);
        }
        if (virtualList.size() > 0) {
            this.virtualDirectory = virtualList.toArray(new String[virtualList.size()]);
            this.realDirectory = realList.toArray(new String[realList.size()]);
        }
    }

    protected void initClassLoader() throws InstantiationException {
        if (this.classLoader != null) {
            this.classLoader.close();
        }
        File webRootDir = ContextUtils.getFile(this.config.getDocumentRoot(), false);
        webRootDir = FileUtils.getCanonicalFile((File)webRootDir);
        File webInfDir = new File(webRootDir, "WEB-INF");
        File webLibDir = new File(webInfDir, "lib");
        File webClassesDir = new File(webInfDir, "classes");
        this.createClassLoader(webRootDir, webClassesDir);
        this.populateLoader(webRootDir, webInfDir, webClassesDir, webLibDir);
    }

    private void createClassLoader(File webRootDir, File webClassesDir) throws InstantiationException {
        String webModuleName = this.config.getName();
        String applicationName = this.application.getName();
        if (applicationName.startsWith("application ")) {
            applicationName = applicationName.substring("application ".length());
        }
        String loaderName = applicationName + ".web." + webModuleName;
        String originDescription = this.config.getURL().getPath();
        VersionNumber version = ClassLoaderQuery.getNextUnusedVersionFor((String)loaderName);
        ClassLoader parent = this.application.getClassLoader();
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_APP_ELEMENT, originDescription);
        ConfigurationPolicy configPolicy = OC4JConfigurationPolicy.WEB;
        SearchPolicy searchPolicy = this.getSearchPolicy(webRootDir, webClassesDir);
        ProtectionPolicy protectionPolicy = OC4JProtectionPolicy.applicationPolicy(applicationName);
        this.classLoader = new PolicyClassLoader(loaderName, version, parent, origin, configPolicy, searchPolicy, protectionPolicy);
    }

    private SearchPolicy getSearchPolicy(File webRootDir, File webClassesDir) throws InstantiationException {
        SearchPolicy result = SearchPolicy.STANDARD;
        if (this.config.getSearchLocalClassesFirst()) {
            result = SearchPolicy.WEB_LOCAL_FIRST;
        }
        if (this.config.isDevelopment()) {
            File sourceDir = this.getSourceDirectory(webRootDir);
            CompilingSearchPolicy step = new CompilingSearchPolicy(this.application.getServer(), this, sourceDir, webClassesDir);
            result = result.prepend("development", (SearchPolicy)step);
        }
        return result;
    }

    private void populateLoader(File webRootDir, File webInfDir, File webClassesDir, File webLibDir) throws InstantiationException {
        try {
            this.initUpdateFields(webInfDir, webLibDir, webClassesDir);
            this.populateLoaderWithWarManifestClassPath(webRootDir);
            this.populateLoaderWithWebClasses(webClassesDir);
            this.populateLoaderWithWebLib(webLibDir);
            this.populateLoaderWithClassPath(webRootDir);
            this.populateLoaderWithSourceDir(webRootDir);
            this.populateLoaderWithWebServicesDeploymentCache();
        }
        catch (IOException e) {
            InstantiationException ex = new InstantiationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private void initUpdateFields(File webInfDir, File webLibDir, File webClassesDir) {
        File[] files;
        if (ApplicationServer.getInstance().getCheckForUpdatesMode().equals("none")) {
            return;
        }
        this.libraryContextFile = webLibDir;
        if (this.libraryContextFile.exists()) {
            File[] files2 = this.libraryContextFile.listFiles();
            this.libraryContextContent = new FileDependency[files2.length];
            for (int i = 0; i < files2.length; ++i) {
                this.libraryContextContent[i] = new FileDependency(files2[i]);
            }
        }
        ArrayList classList = new ArrayList();
        this.findClassFiles(webClassesDir, classList);
        this.webClasses = new FileDependency[classList.size()];
        int j = 0;
        for (int i = 0; i < classList.size(); ++i) {
            File file = (File)classList.get(i);
            this.webClasses[j++] = new FileDependency(file);
        }
        this.tldContextFile = webInfDir;
        if (JspServletInstanceInfo.jspTldCacheIsUsed(this.jspTldCacheLevel) && this.tldContextFile != null && this.tldContextFile.exists() && (files = JspServletInstanceInfo.listUnjarredTldFiles(this.tldContextFile, this.jspTldCacheLevel)) != null) {
            this.tldContextContent = new FileDependency[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.tldContextContent[i] = new FileDependency(files[i]);
            }
        }
    }

    private void populateLoaderWithWarManifestClassPath(File warRootDir) throws IOException {
        if (this.config.getIncludeWarManifestClassPath()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_MANIFEST, warRootDir.getPath());
            this.classLoader.addCodeSource(warRootDir, origin);
        }
    }

    private void populateLoaderWithWebClasses(File webClassesDir) throws IOException {
        if (webClassesDir.exists()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_CLASSES, webClassesDir.getPath());
            this.classLoader.addCodeSource(webClassesDir, origin);
        }
    }

    private void populateLoaderWithWebServicesDeploymentCache() throws IOException, InstantiationException {
        if (this.generateWebServiceArtifacts()) {
            this.initVirtualDirectories(this.config.getVirtualMappings());
            HttpApplicationDescriptor descriptor = (HttpApplicationDescriptor)this.config;
            File dcFile = WrapperClassGenerator.getWebServicesDeploymentCache(descriptor.getDeploymentContext(), descriptor.getDeploymentCacheName());
            if (dcFile != null && dcFile.exists()) {
                ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_SERVICES_WRAPPERS, dcFile.getPath());
                this.classLoader.addCodeSource(dcFile, origin, OC4JProtectionPolicy.WEBSERVICE_WRAPPER_PERMISSIONS);
            }
        }
    }

    private void populateLoaderWithWebLib(File webLibDir) throws IOException {
        this.libraries = new HashMap();
        if (webLibDir.exists()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_LIB, webLibDir.getPath());
            this.classLoader.addCodeSource(webLibDir, origin);
            String[] files = webLibDir.list();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip") && !fileName.endsWith(".war")) continue;
                File file = new File(webLibDir, fileName);
                this.classLoader.addCodeSource(file, origin);
                String libraryName = "WEB-INF/lib/" + fileName;
                ContentArchiveContext context = new ContentArchiveContext(file, false);
                this.libraries.put(libraryName, context);
            }
        }
    }

    private void populateLoaderWithClassPath(File warRootDir) throws InstantiationException {
        List codebases = this.config.getCodebases();
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_CLASSPATH_ELEMENT, warRootDir.getPath());
        if (codebases != null) {
            for (int i = 0; i < codebases.size(); ++i) {
                URL url = (URL)codebases.get(i);
                try {
                    File file = new File(ClassLoaderQuery.getPath((URL)url));
                    this.classLoader.addCodeSource(file, origin);
                    continue;
                }
                catch (IOException e) {
                    InstantiationException ex = new InstantiationException("Invalid <classpath> entry: " + url);
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
    }

    private void populateLoaderWithSourceDir(File warRootDir) throws IOException {
        if (this.config.isDevelopment()) {
            File srcDir = this.getSourceDirectory(warRootDir);
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.WEB_SOURCE_ATTRIBUTE, warRootDir.getPath());
            this.classLoader.addCodeSource(srcDir, origin);
        }
    }

    private File getSourceDirectory(File warRootDir) {
        try {
            URL url = this.config.getSourceURL();
            if (url != null) {
                File srcDir = new File(ClassLoaderQuery.getPath((URL)url));
                if (srcDir.exists()) {
                    return srcDir;
                }
                this.log("source-directory path does not exist: " + srcDir);
            }
        }
        catch (IOException e) {
            this.log(e, "source-directory attribute");
        }
        File srcDir = new File(warRootDir, "WEB-INF/src");
        if (srcDir.exists()) {
            return srcDir;
        }
        return new File(warRootDir, "WEB-INF/classes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        ThreadState state = ThreadState.getInheritableCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            WebApplicationProtocol.PRE_STOP.fire(this);
            state.contextContainer = this;
            this.destroyed = true;
            if (ApplicationServer.serverExtensionProviders != null) {
                for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    try {
                        ApplicationServer.serverExtensionProviders[i].preDestroyHttpApplication((AttributeContainer)((Object)this.config), this);
                        continue;
                    }
                    catch (Throwable t) {
                        this.log("Error thrown during serverExtensionProvider preDestroyHttpApplication", t);
                    }
                }
            }
            this.replicationService.destroy();
            try {
                if (!this.config.isClustered()) {
                    this.persist();
                }
            }
            catch (Throwable t) {
                m_traceLogger.log(Level.FINE, "Error persisting application state: " + t.getClass().getName() + " (" + t.getMessage() + ")");
            }
            this.shutdownThreads();
            this.destroySessions();
            this.destroyServlets();
            this.destroyContextListeners();
            this.destroyPersistenceUnitManager();
            this.classLoader.close();
            if (ApplicationServer.serverExtensionProviders != null) {
                for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                    try {
                        ApplicationServer.serverExtensionProviders[i].postDestroyHttpApplication((AttributeContainer)((Object)this.config), this);
                        continue;
                    }
                    catch (Throwable t) {
                        this.log("Error thrown during serverExtensionProvider preDestroyHttpApplication", t);
                    }
                }
            }
            this.config.setHttpApplication(null);
            this.log(ApplicationServer.VERSION + " Stopped");
        }
        finally {
            WebApplicationProtocol.POST_STOP.fire(this);
            state.contextContainer = previousContainer;
        }
    }

    private void destroyContextListeners() {
        if (this.contextListeners != null) {
            for (int i = this.contextListeners.length - 1; i >= 0; --i) {
                try {
                    this.contextListeners[i].contextDestroyed(new ServletContextEvent((ServletContext)this));
                    continue;
                }
                catch (Throwable t) {
                    this.log("Exception thrown during contextDestroyed", t);
                }
            }
            this.contextListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySessions() {
        Map map = this.sessions;
        synchronized (map) {
            int count = this.sessions.size();
            EvermindHttpSession[] list = new EvermindHttpSession[count];
            this.sessions.values().toArray(list);
            for (int i = 0; i < count; ++i) {
                if (list[i].getInvalidated()) continue;
                list[i].invalidateLocal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyServlets() {
        List listeners;
        Iterator iterator;
        Map map = this.servletInstancesLock;
        synchronized (map) {
            iterator = this.servletInstances.values().iterator();
            while (iterator.hasNext()) {
                ServletInstanceInfo info;
                try {
                    info = (ServletInstanceInfo)iterator.next();
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (info.page != null) continue;
                try {
                    this.invokeLifecycleMethod(info.servlet, info.descriptor.getPreDestroyMethod());
                    info.destroy();
                }
                catch (Throwable t) {
                    this.log("Error in servlet '" + info.name + "' destroy()", t);
                }
                if (info.shared) {
                    this.site.server.removeSharedServlet(info.name);
                }
                info.invalidated = true;
            }
            this.servletInstances.clear();
        }
        map = this.jspPages;
        synchronized (map) {
            iterator = this.jspPages.values().iterator();
            while (iterator.hasNext()) {
                Object infoObject = iterator.next();
                if (!(infoObject instanceof JSPPage)) continue;
                JSPPage info = (JSPPage)infoObject;
                try {
                    if (info.instance == null) continue;
                    info.instance.destroy();
                }
                catch (Throwable t) {
                    this.log("Error in JSP's destroy()", t);
                }
            }
        }
        if (this.filterInstances != null) {
            Iterator iterator2 = this.filterInstances.values().iterator();
            while (iterator2.hasNext()) {
                EvermindFilterConfig filterconfig = (EvermindFilterConfig)iterator2.next();
                this.invokeLifecycleMethod(filterconfig.instance, filterconfig.descriptor.getPreDestroyMethod());
                filterconfig.instance.destroy();
            }
        }
        if (!(listeners = this.config.getListeners()).isEmpty()) {
            for (int i = 0; i < listeners.size(); ++i) {
                ListenerDescriptor listener = (ListenerDescriptor)listeners.get(i);
                try {
                    Class<?> type = Class.forName(listener.getClassName(), true, this.getClassLoader());
                    Object instance = type.newInstance();
                    this.invokeLifecycleMethod(instance, listener.getPreDestroyMethod());
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.securityFilter != null) {
            this.securityFilter.destroy();
        }
        this.securityFilter = null;
        this.filterInstances = null;
    }

    protected synchronized void shutdownThreads() {
        boolean threadsLeft;
        int maxTries = 10;
        ThreadGroup group = this.site.server.getThreadGroup();
        int count = group.activeCount();
        int tries = 0;
        Thread[] threads = new Thread[count];
        group.enumerate(threads);
        int sleepTime = this.application.getStopTimeout() / maxTries;
        do {
            ++tries;
            threadsLeft = false;
            for (int i = 0; i < threads.length; ++i) {
                EvermindHttpServletResponse response;
                EvermindHttpServletRequest request;
                block15: {
                    if (threads[i] == null || threads[i] == Thread.currentThread() || !threads[i].isAlive()) continue;
                    request = null;
                    response = null;
                    try {
                        if (((ApplicationServerThread)threads[i]).httpHandler == null) break block15;
                        request = ((ApplicationServerThread)threads[i]).httpHandler.request;
                        response = ((ApplicationServerThread)threads[i]).httpHandler.response;
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                }
                if (request == null || request.application != this) continue;
                threadsLeft = true;
                try {
                    if (request.in != null) {
                        request.in.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (tries > maxTries / 2 + 2) {
                    try {
                        threads[i].interrupt();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (tries <= maxTries) continue;
                try {
                    m_traceLogger.log(Level.FINE, "Thread named: " + threads[i].toString() + " forcefully stopped");
                    response.handleException(new Throwable("Application: " + this.name + " has been stopped forcefully."));
                    threads[i].stop();
                    threads[i] = null;
                    continue;
                }
                catch (ThreadDeath td) {
                    m_traceLogger.log(Level.FINE, td.toString());
                    continue;
                }
                catch (Throwable t) {
                    m_traceLogger.log(Level.FINE, t.toString());
                }
            }
            if (!threadsLeft) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (Throwable t) {
                // empty catch block
            }
        } while (threadsLeft);
    }

    public void setErrorPages(List errorPages) throws InstantiationException {
        if (errorPages.isEmpty()) {
            return;
        }
        Iterator iterator = errorPages.iterator();
        while (iterator.hasNext()) {
            ErrorPage errorPage = (ErrorPage)iterator.next();
            int errorCode = errorPage.getErrorCode();
            if (errorCode > 0 && errorCode < 1000) {
                if (this.errorPage == null) {
                    this.errorPage = new String[1000];
                }
                this.errorPage[errorCode] = errorPage.getLocation();
                continue;
            }
            if (errorPage.getExceptionType() == null) continue;
            if (this.exceptionPages == null) {
                this.exceptionPages = new ArrayList();
            }
            this.exceptionPages.add(errorPage);
        }
    }

    public ProtectedRegion getProtectedRegion(ByteString uri, String method) {
        int protectedRegionIndex = this.getProtectedRegionIndex(uri, method, 0);
        if (protectedRegionIndex < 0) {
            return null;
        }
        return this.protectedRegions[protectedRegionIndex];
    }

    protected int getProtectedRegionIndex(ByteString uri, String method, int protectedRegionsStartIndex) {
        if (this.protectedRegions == null) {
            return -1;
        }
        int length = this.protectedRegions.length;
        for (int i = protectedRegionsStartIndex; i < length; ++i) {
            ProtectedRegion region = this.protectedRegions[i];
            if (region.allMethods) {
                if (region.method.isEmpty()) {
                    return i;
                }
                if (!region.method.containsKey(method.toUpperCase())) continue;
                return i;
            }
            if (region.hasWildCard) {
                if (uri.startsWith(region.prefix)) {
                    if (region.suffix != null) {
                        if (!uri.endsWith(region.suffix)) continue;
                        if (region.method.isEmpty()) {
                            return i;
                        }
                        if (region.method.containsKey(method.toUpperCase())) {
                            return i;
                        }
                    }
                    if (region.method.isEmpty()) {
                        return i;
                    }
                    if (region.method.containsKey(method.toUpperCase())) {
                        return i;
                    }
                } else if (region.suffix != null && uri.endsWith(region.suffix)) {
                    if (region.method.isEmpty()) {
                        return i;
                    }
                    if (region.method.containsKey(method.toUpperCase())) {
                        return i;
                    }
                }
            }
            if (region.hasWildCard) continue;
            boolean match = true;
            match = region.prefix.equals(uri);
            if (match) {
                if (region.method.isEmpty()) {
                    return i;
                }
                if (!region.method.containsKey(method.toUpperCase())) continue;
                return i;
            }
            match = region.prefix.equals(uri.substring(0, uri.lastIndexOf('/')));
            if (region.suffix == null || !match || !uri.endsWith(region.suffix)) continue;
            if (region.method.isEmpty()) {
                return i;
            }
            if (!region.method.containsKey(method.toUpperCase())) continue;
            return i;
        }
        return -1;
    }

    public static PasswordAuthentication getAuthentication(String username, String password, EvermindHttpServletRequest request) {
        if (username == null) {
            return null;
        }
        char[] passwordChars = null;
        passwordChars = password != null ? password.toCharArray() : new char[]{};
        request.getSession(true);
        return new PasswordAuthentication(username, passwordChars);
    }

    private boolean checkAuthenticationAndAuthorize(EvermindHttpServletRequest request, EvermindHttpServletResponse response, ByteString requestURI) throws IOException, ServletException {
        if (this.protectedRegions == null) {
            return true;
        }
        if (!request.isDispatcherChainEmpty()) {
            return true;
        }
        int length = this.protectedRegions.length;
        int currentRegionIndex = 0;
        currentRegionIndex = this.getProtectedRegionIndex(requestURI, request.method, currentRegionIndex);
        ProtectedRegion region = null;
        if (currentRegionIndex > -1) {
            region = this.protectedRegions[currentRegionIndex];
        }
        if (region == null) {
            return true;
        }
        int reason = 2;
        User user = request.getUserPrincipalInternal();
        while (currentRegionIndex < length) {
            SecurityConstraint constraint = region.constraint;
            reason = this.getAuthenticationReason(user, reason, constraint);
            if (region.role == null && constraint.hasAuthorizationConstraint()) {
                HashSet roles = new HashSet();
                List roleNames = constraint.getRoleNames();
                for (int y = 0; y < roleNames.size(); ++y) {
                    String roleName = (String)roleNames.get(y);
                    if (roleName.equals("*")) {
                        List allRoles = ((SecurityRoleContainer)((Object)this.config)).getSecurityRoles();
                        Iterator i = allRoles.iterator();
                        while (i.hasNext()) {
                            Object o = i.next();
                            if (roles.contains(o)) {
                                roles.remove(o);
                            }
                            roles.add(o);
                        }
                        break;
                    }
                    SecurityRole role = this.config.getSecurityRole(roleName);
                    if (role == null) {
                        response.sendError(403, "Error initializing security, security-role not found: " + roleNames.get(y));
                        return false;
                    }
                    roles.add(role);
                }
                region.role = new RuntimeSecurityRole(this.userManager, roles);
            }
            if (region.requiresSSL && !request.isSecure()) {
                response.sendError(403, "SSL (https) required for access");
                return false;
            }
            if (this.allowAccess(region, user, request)) {
                return true;
            }
            if ((currentRegionIndex = this.getProtectedRegionIndex(requestURI, request.method, currentRegionIndex + 1)) <= -1) break;
            region = this.protectedRegions[currentRegionIndex];
        }
        response.isLoginOrErrorPage = true;
        if (this.authenticator instanceof FormHttpAuthenticator && (((FormHttpAuthenticator)this.authenticator).loginPage.equals(requestURI) || ((FormHttpAuthenticator)this.authenticator).errorPage.equals(requestURI))) {
            return true;
        }
        this.authenticator.reject(request, response, reason);
        return false;
    }

    private int getAuthenticationReason(User user, int reason, SecurityConstraint constraint) {
        ApplicationServer appServer = this.site.server.getApplicationServer();
        User anonUser = appServer.getAnonymousUser();
        if (anonUser != null && anonUser.equals(user)) {
            reason = 1;
        }
        if (!constraint.hasRoles()) {
            reason = 3;
        }
        return reason;
    }

    private boolean getJaccAuthorization(EvermindHttpServletRequest request) {
        int transportLevel = 0;
        if (request.isSecure()) {
            transportLevel = 1;
        }
        ThreadState thread = ThreadState.getInheritableCurrentState();
        JaccWrapper jaccWrapper = thread.getJaccWrapper(this.config.getConfigId());
        return jaccWrapper.authorizeWeb(request.getRequestURI(), request.getContextPath(), request.getMethod(), transportLevel, request.getUserPrincipalInternal());
    }

    private boolean allowAccess(ProtectedRegion region, User user, EvermindHttpServletRequest request) {
        boolean retVal = false;
        retVal = region.role == null ? true : (JaccWrapper.isJaccEnabled() ? this.getJaccAuthorization(request) : region.role.impliesUser(user, request));
        return retVal;
    }

    protected static EvermindHttpServletRequest getRequestFromThread() {
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().applicationThread;
        EvermindHttpServletRequest request = thread == null ? null : (thread.httpHandler == null ? null : thread.httpHandler.request);
        return request;
    }

    protected static EvermindHttpServletResponse getResponseFromThread() {
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().applicationThread;
        EvermindHttpServletResponse response = thread == null ? null : (thread.httpHandler == null ? null : thread.httpHandler.response);
        return response;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public JSPPage getJSPPageCore(ByteString path) {
        Object pageObject = this.jspPages.get(path);
        while (pageObject == COMPILING_JSP) {
            try {
                this.jspPages.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
            pageObject = this.jspPages.get(path);
        }
        return (JSPPage)pageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSPPage getJSP(ByteString servletPath) throws JSPCompilationException, IOException, ServletException {
        HashMap hashMap;
        JSPPage page = null;
        long currentTime = HttpDateFormat.currentTimeLong;
        boolean changed = false;
        String servletPathString = null;
        File cacheFile = null;
        HashMap hashMap2 = this.jspPages;
        synchronized (hashMap2) {
            page = this.getJSPPageCore(servletPath);
            if (page != null && page.lastModifiedCheck < currentTime) {
                changed = !page.isUpToDate();
                page.lastModifiedCheck = currentTime + this.config.getLastModifiedCheckInterval();
                page.lastUsed = currentTime;
            }
            if (page == null || changed) {
                if (this.flushAllJSP && page != null && (page.beans != null || this.flushAllJSPAtPageUpdate)) {
                    this.flushAllJSP();
                }
                if (page != null && (page.flushBeans() || this.tagLibraryStorage != null && this.tagLibraryStorage.isUpdated())) {
                    try {
                        this.reset();
                    }
                    catch (InstantiationException e) {
                        this.log("Error updating application: " + e.getMessage());
                    }
                }
                page = null;
                servletPathString = servletPath.toString();
                File file = cacheFile = this.jspCacheFile == null ? null : new File(this.jspCacheFile.getPath() + servletPathString.replace('/', File.separatorChar) + ".jspCache");
                if (cacheFile != null && cacheFile.exists()) {
                    try {
                        FileInputStream fileIn = new FileInputStream(cacheFile);
                        try {
                            HttpApplicationInputStream in = new HttpApplicationInputStream((InputStream)fileIn, this);
                            if (ApplicationServer.VERSION.equals(in.readUTF())) {
                                page = (JSPPage)in.readObject();
                                page.application = this;
                                if (!page.isUpToDate()) {
                                    page = null;
                                }
                            }
                        }
                        finally {
                            fileIn.close();
                        }
                    }
                    catch (Throwable t) {
                        page = null;
                    }
                }
            }
            if (page == null) {
                this.jspPages.put(servletPath.clone(), COMPILING_JSP);
            }
        }
        try {
            if (page == null && servletPathString != null) {
                page = JSPPage.compile(this, servletPathString, this.config.getJSPDescriptor(servletPathString));
                page.lastUsed = HttpDateFormat.currentTimeMillis();
                if (cacheFile != null) {
                    try {
                        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                        EJBOutputStream out = new EJBOutputStream(byteOut);
                        out.writeUTF(ApplicationServer.VERSION);
                        out.writeObject(page);
                        out.close();
                        IOUtils.makePath(cacheFile);
                        IOUtils.writeContent(cacheFile, byteOut.toByteArray());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (servletPathString == null) {
                servletPathString = servletPath.toString();
            }
            ServletDescriptor descriptor = this.config.getJSPDescriptorByPath(servletPathString);
            if (page.instance == null) {
                page.getInstance(this);
                page.instance.init((ServletConfig)new EvermindServletConfig(this, descriptor == null ? null : descriptor.getInitParameters(), (ByteString)servletPath.clone()));
                page.classData = null;
                page.tagLibraryNames = null;
            }
            if (descriptor != null) {
                ServletInstanceInfo info = new ServletInstanceInfo(this);
                info.descriptor = descriptor;
                info.servlet = page.instance;
                info.name = this.application.getServer().byteStringCache.getByteString(descriptor.getName());
                info.page = page;
                info.file = page.file;
                info.autoReload = true;
                this.servletInstances.put(info.name, info);
                info.runAsRoleName = descriptor.getRunAsRoleName();
            }
            HashMap hashMap3 = this.jspPages;
            synchronized (hashMap3) {
                this.jspPages.put(this.application.getServer().byteStringCache.getByteString(servletPath.data, servletPath.offset, servletPath.length), page);
            }
            Object var15_16 = null;
            hashMap = this.jspPages;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            HashMap hashMap4 = this.jspPages;
            synchronized (hashMap4) {
                if (this.jspPages.get(servletPath) == COMPILING_JSP) {
                    this.jspPages.remove(servletPath);
                }
                this.jspPages.notifyAll();
            }
            throw throwable;
        }
        synchronized (hashMap) {
            if (this.jspPages.get(servletPath) == COMPILING_JSP) {
                this.jspPages.remove(servletPath);
            }
            this.jspPages.notifyAll();
        }
        return page;
    }

    public void serviceJSP(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ByteString servletPath;
        EvermindHttpServletRequest evermindRequest;
        EvermindHttpServletRequest evermindHttpServletRequest = evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : null;
        if (evermindRequest != null) {
            servletPath = evermindRequest.getDispatcherServletPathByteString();
            if (servletPath == null) {
                servletPath = evermindRequest.servletPath;
            }
        } else {
            String included = (String)request.getAttribute("javax.servlet.include.servlet_path");
            servletPath = included != null ? new ByteString(included) : new ByteString(((HttpServletRequest)request).getServletPath());
        }
        try {
            JSPPage page;
            try {
                page = this.getJSP(servletPath);
            }
            catch (IOException e) {
                if (response instanceof HttpServletResponse) {
                    ((HttpServletResponse)response).sendError(404);
                }
                return;
            }
            if (evermindRequest != null ? evermindRequest.queryString != null && evermindRequest.queryString.indexOf(JSP_PRECOMPILE_BYTESTING) >= 0 : ((HttpServletRequest)request).getQueryString() != null && ((HttpServletRequest)request).getQueryString().indexOf("jsp_precompile=") >= 0) {
                String value = request.getParameter("jsp_precompile");
                if (!(value == null || value.equals("true") || value.equals("false") || value.equals("\"true\"") || value.equals("\"false\""))) {
                    if (response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendError(500, "jsp_precompile parameter can only contain the value \"true\" or \"false\"");
                    }
                } else if ("true".equals(value) || "\"true\"".equals(value)) {
                    response.setContentType("text/html");
                    ServletOutputStream out = response.getOutputStream();
                    out.println("<html><head><title>Precompilation succeeded</title></head><body><h1>Precompilation succeeded.</h1></body></html>");
                } else {
                    page.instance.service(request, response);
                }
            } else {
                page.instance.service(request, response);
            }
        }
        catch (JSPFileNotFoundException e) {
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).sendError(404);
            }
        }
        catch (JSPCompilationException e) {
            try {
                String exceptionString = e.getMessage();
                exceptionString = MarkupUtils.encode(exceptionString);
                if (response instanceof HttpServletResponse) {
                    String pagePath = ((HttpServletRequest)request).getRequestURI();
                    int lineNumber = -1;
                    if (e.getPosition() >= 0 && e.getCompilation() != null) {
                        JSPStaticInclude include = e.getCompilation().getMappedStaticInclude().getInclude(e.getPosition());
                        pagePath = include.path.toString();
                        lineNumber = include.getLineNumber(e.getPosition());
                    }
                    ((HttpServletResponse)response).sendError(500, "Error parsing JSP page " + EvermindHttpServletResponse.escapeHTML(pagePath) + (lineNumber >= 1 ? " line " + lineNumber : "") + "<BR><PRE>" + exceptionString + "</PRE>");
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAllJSP() {
        HashMap hashMap = this.jspPages;
        synchronized (hashMap) {
            this.jspPages.clear();
        }
    }

    void checkSessionTimeouts() {
        this.replicationService.checkSessionTimeouts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _checkSessionTimeouts() {
        long currentTime = HttpDateFormat.currentTimeLong;
        ThreadState state = ThreadState.getInheritableCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            state.contextContainer = this;
            Map map = this.sessions;
            synchronized (map) {
                EvermindHttpSession session;
                Iterator<Object> iterator = this.sessions.values().iterator();
                while (iterator.hasNext()) {
                    session = (EvermindHttpSession)iterator.next();
                    if (!session.isTimedOut(currentTime)) continue;
                    this.invalidateSessions.add(session);
                }
                if (!this.invalidateSessions.isEmpty()) {
                    iterator = this.invalidateSessions.iterator();
                    while (iterator.hasNext()) {
                        session = (EvermindHttpSession)iterator.next();
                        if (session.getInvalidated()) continue;
                        this.sessions.remove(session.id);
                        this.sessionAsyncInvalidateHandler.addSession(session);
                    }
                    this.invalidateSessions.clear();
                }
            }
        }
        finally {
            state.contextContainer = previousContainer;
        }
    }

    public boolean checkActivity(long maxInactivityTime) {
        if (maxInactivityTime > 0L) {
            if (this.used) {
                this.used = false;
                this.lastUsed = HttpDateFormat.currentTimeLong;
            } else if (HttpDateFormat.currentTimeLong - this.lastUsed > maxInactivityTime) {
                return false;
            }
        }
        return true;
    }

    public Context getEnvironmentContext() throws NamingException {
        if (this.componentContext == null) {
            try {
                List mailSessions = null;
                if (this.application != null && this.application.getConfig() != null) {
                    mailSessions = this.application.getConfig().getAllMailSessions();
                }
                this.componentContext = J2EEContext.create(this.config, new ApplicationResourceFinder(this.application), this.application.getContext(), mailSessions);
                if (this.getPersistenceUnitManager() != null) {
                    this.getPersistenceUnitManager().bindPersistenceReferences(this.config, (J2EEContext)this.componentContext);
                }
            }
            catch (InstantiationException e) {
                throw new NamingException("Error instantiating web-app JNDI-context: " + e.getMessage());
            }
        }
        return this.componentContext;
    }

    public HttpApplicationConfig getConfig() {
        return this.config;
    }

    public void persist() throws IOException {
        if (this.sessions.size() == 0) {
            return;
        }
        if (this.config.getPersistenceURL() != null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                this.writeState(byteOut);
                File file = new File(this.config.getPersistenceURL().getFile());
                IOUtils.makePath(file);
                IOUtils.writeContent(file, byteOut.toByteArray());
            }
            catch (Throwable t) {
                this.log("Error persisting state", t);
            }
        }
    }

    public void restore() throws IOException, ClassNotFoundException {
        this.sessions.clear();
        try {
            if (this.config.getPersistenceURL() != null) {
                InputStream in = this.config.getPersistenceURL().openStream();
                this.readState(in);
                in.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public TagLibraryArchive getTagLibContext(String requestURI, String relativeURI) throws InstantiationException {
        List shortPaths = this.config.getTagLibraries();
        for (int i = 0; i < shortPaths.size(); ++i) {
            TagLibraryUse use = (TagLibraryUse)shortPaths.get(i);
            if (!use.getURI().equals(relativeURI)) continue;
            if (use.getLocation() == null || (relativeURI = use.getLocation()).startsWith("/")) break;
            relativeURI = "/" + relativeURI;
            break;
        }
        String url = null;
        boolean isLocal = false;
        try {
            if (relativeURI.indexOf(":/") < 0) {
                isLocal = true;
                String urlString = relativeURI;
                if (!urlString.startsWith("/")) {
                    urlString = requestURI.substring(0, requestURI.lastIndexOf(47) + 1) + urlString;
                }
                if (!(urlString.endsWith("/") || urlString.endsWith(".jar") || urlString.endsWith(".war") || urlString.endsWith(".zip") || urlString.endsWith(".ear") || urlString.endsWith(".tld"))) {
                    urlString = urlString + "/";
                }
                if ((urlString = this.getRealPath(urlString)) != null) {
                    url = new File(urlString).toURL().toExternalForm();
                }
            } else {
                url = new URL(relativeURI).toExternalForm();
            }
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Error loading taglib at " + relativeURI + ", invalid URL: " + e.getMessage());
        }
        if (isLocal) {
            if (this.tagLibraryStorage == null) {
                this.tagLibraryStorage = new TagLibraryStorage(this.getClassLoader(), this.libraries, this.application);
            }
            return this.tagLibraryStorage.getTagLibContext(relativeURI, this.config.getContext(), url, this.config.isDevelopment() ? this : null);
        }
        return this.site.server.getTagLibContext(url, this.config.isDevelopment() ? this : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getSessionIDs() {
        Map map = this.sessions;
        synchronized (map) {
            String[][] response = new String[this.sessions.size()][];
            int i = 0;
            Iterator iterator = this.sessions.values().iterator();
            while (iterator.hasNext()) {
                EvermindHttpSession session = (EvermindHttpSession)iterator.next();
                response[i] = new String[2];
                response[i][0] = session.getId();
                response[i][1] = session.user == null ? null : session.user.getName();
                ++i;
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSessionRuntimeInfo getSessionByID(String id) {
        Map map = this.sessions;
        synchronized (map) {
            EvermindHttpSession session = (EvermindHttpSession)this.sessions.get(new ByteString(id));
            if (session != null) {
                return session.getRuntimeInfo();
            }
            return null;
        }
    }

    public void flushTagLibrary(String url) {
        if (this.tagLibraryStorage == null) {
            return;
        }
        this.tagLibraryStorage.flush(url);
    }

    public synchronized boolean isUserInRole(User user, String roleName, AddressContainer addressContainer) {
        RuntimeSecurityRole role;
        ApplicationServerThread currThread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
        if (currThread.servletInfo != null) {
            ServletConfig servletConfig = currThread.servletInfo.config;
            ServletDescriptor servletDesc = this.config.getServletDescriptor(servletConfig.getServletName(), false);
            List roleRefs = null;
            if (servletDesc != null && (roleRefs = servletDesc.getSecurityRoleReferences()) != null) {
                for (int i = 0; i < roleRefs.size(); ++i) {
                    SecurityRoleReference roleRef = (SecurityRoleReference)roleRefs.get(i);
                    if (!roleRef.getName().equalsIgnoreCase(roleName)) continue;
                    roleName = roleRef.getLink();
                }
            }
        }
        if (this.roles == null) {
            this.roles = new HashMap();
        }
        if ((role = (RuntimeSecurityRole)this.roles.get(roleName)) != null) {
            return role.impliesUser(user, addressContainer);
        }
        SecurityRole securityRole = this.config.getSecurityRole(roleName);
        if (securityRole == null) {
            return false;
        }
        HashSet<SecurityRole> roleSet = new HashSet<SecurityRole>();
        roleSet.add(securityRole);
        role = new RuntimeSecurityRole(this.userManager, roleSet);
        this.roles.put(roleName, role);
        return role.impliesUser(user, addressContainer);
    }

    public Application getApplication() {
        return this.application;
    }

    public synchronized void addRestartHook(HttpSite site, String path) {
        if (this.restartHookList == null) {
            this.restartHookList = new ArrayList();
        }
        this.restartHookList.add(site);
        this.restartHookList.add(path);
    }

    protected void fireRestartHooks() {
        if (this.restartHookList == null) {
            return;
        }
        while (!this.restartHookList.isEmpty()) {
            this.application.getServer().getThreadPool().launch(new HttpApplicationRestarter(this, (HttpSite)this.restartHookList.get(0), new ByteString(this.restartHookList.get(1).toString())));
            this.restartHookList.remove(0);
            this.restartHookList.remove(0);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ByteString getContextPathByteString() {
        return this.application.getServer().byteStringCache.getByteString(this.contextPath);
    }

    protected boolean isClustered() {
        return this.config.isClustered();
    }

    public boolean isShared() {
        return this.shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutJSPs() {
        if (this.config.getJSPTimeout() > 0) {
            long acceptableTime = HttpDateFormat.currentTimeMillis() + (long)(this.config.getJSPTimeout() * 1000);
            HashMap hashMap = this.jspPages;
            synchronized (hashMap) {
                Iterator iterator = this.jspPages.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object pageObject = entry.getValue();
                    if (!(pageObject instanceof JSPPage)) continue;
                    JSPPage page = (JSPPage)entry.getValue();
                    if (page.lastUsed > 0L && page.lastUsed < acceptableTime) {
                        iterator.remove();
                        if (page.instance == null) continue;
                        page.instance.destroy();
                        page.instance = null;
                        continue;
                    }
                    if (page.lastUsed != 0L && page.lastUsed <= HttpDateFormat.currentTimeLong) continue;
                    page.lastUsed = HttpDateFormat.currentTimeLong;
                }
            }
        }
    }

    public File getClassFile(Class type, boolean source) {
        String resourceName = type.getName().replace('.', '/');
        resourceName = resourceName + (source ? ".java" : ".class");
        return ClassLoaderQuery.getResourceAsFile((PolicyClassLoader)this.classLoader, (boolean)false, (String)resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jspPageNameEncode(String string, JSPPage overridingPage) {
        if (string.indexOf("__jspPage") < 0) {
            return string;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer();
        StringTokenizer lineTokenizer = new StringTokenizer(string, "\r\n" + lineSeparator);
        while (lineTokenizer.hasMoreElements()) {
            String line = lineTokenizer.nextToken();
            if (string.indexOf("__jspPage") >= 0) {
                JSPPage page = null;
                String path = null;
                int lineNumber = -1;
                StringTokenizer tokenizer = new StringTokenizer(line, ":() .-/\\");
                boolean firstToken = true;
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    if (Character.isDigit(token.charAt(0)) && lineNumber < 0) {
                        try {
                            lineNumber = Integer.parseInt(token);
                            if (firstToken && overridingPage != null) {
                                path = overridingPage.requestURI;
                                page = overridingPage;
                            }
                        }
                        catch (Throwable t) {}
                    } else if (token.indexOf("__jspPage") >= 0) {
                        if (overridingPage != null && token.equals(overridingPage.pageClassName)) {
                            path = overridingPage.requestURI;
                            page = overridingPage;
                        } else {
                            HashMap hashMap = this.jspPages;
                            synchronized (hashMap) {
                                Iterator iterator = this.jspPages.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    Object testPageObject = entry.getValue();
                                    if (!(testPageObject instanceof JSPPage)) continue;
                                    JSPPage testPage = (JSPPage)entry.getValue();
                                    if (!testPage.pageClassName.equals(token)) continue;
                                    path = entry.getKey().toString();
                                    page = testPage;
                                }
                            }
                        }
                    }
                    firstToken = false;
                }
                if (page != null) {
                    int jspLine;
                    if (lineNumber > 0 && (jspLine = page.getJSPLine(lineNumber)) > 0) {
                        line = line + " (JSP page line " + jspLine + ")";
                    }
                    line = StringUtils.replace(line, page.pageClassName, path);
                }
            }
            output.append(line);
            output.append(lineSeparator);
        }
        return output.toString();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void hasChanged(List componentsToRefresh) {
        if (this.isLibUpdated() || this.isTldUpdated() || this.isWebClassesUpdated() || this.isDescriptorsUpdated()) {
            this.invalidateApplication = true;
        }
        if (this.isUserManagerUpdated()) {
            this.userManagerUpdated = true;
        }
        if (this.invalidateApplication || this.userManagerUpdated) {
            componentsToRefresh.add(this);
            return;
        }
    }

    public void refresh() {
        if (this.userManagerUpdated) {
            try {
                this.userManager.update();
                if (!this.invalidateApplication) {
                    this.initAccessController();
                }
            }
            catch (InstantiationException e) {
                this.log("Unable to refresh the user manager for web application: " + this.name);
            }
        }
        if (this.invalidateApplication) {
            if (this.descriptorUpdated) {
                this.application.updateWebApplicationConfigs((HttpApplicationDescriptor)this.config);
                try {
                    ((XMLConfig)((Object)this.config)).initLastModifieds();
                }
                catch (InstantiationException ie) {
                    this.log("Unable to update time stamp for web application: " + this.name + "'s descriptors");
                }
            }
            this.site.getServer().invalidateHttpApplications(new HttpApplicationReference(this.application.getName(), this.name));
        }
        this.userManagerUpdated = false;
        this.descriptorUpdated = false;
        this.invalidateApplication = false;
    }

    private boolean isUserManagerUpdated() {
        if (this.userManager != null && this.userManager.isUpdated()) {
            this.userManagerUpdated = true;
            return true;
        }
        return false;
    }

    private boolean isDescriptorsUpdated() {
        HttpApplicationDescriptor descriptor = (HttpApplicationDescriptor)this.config;
        if (descriptor.isUpdated()) {
            this.descriptorUpdated = true;
            return true;
        }
        return false;
    }

    private boolean isWebClassesUpdated() {
        for (int i = 0; i < this.webClasses.length; ++i) {
            if (this.webClasses[i].file.lastModified() == this.webClasses[i].lastModified) continue;
            return true;
        }
        return false;
    }

    private void findClassFiles(File webClassesDir, ArrayList classList) {
        File[] files = webClassesDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(webClassesDir, files[i].getName());
            if (f.isDirectory()) {
                this.findClassFiles(f, classList);
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            classList.add(files[i]);
        }
    }

    private boolean isLibUpdated() {
        if (this.libraryContextCheckCount++ < 5) {
            return false;
        }
        this.libraryContextCheckCount = 0;
        if (this.requestDispatcherCache != null) {
            RequestDispatcherCache cache;
            for (int i = 0; i < 10 && (cache = this.requestDispatcherCache[i]) != null; ++i) {
                if (cache.hits <= 0) continue;
                --cache.hits;
            }
        }
        if (this.libraryContextFile != null) {
            if (this.libraryContextContent == null) {
                return this.libraryContextFile.exists();
            }
            if (!this.libraryContextFile.exists()) {
                return true;
            }
            File[] files = this.libraryContextFile.listFiles();
            if (files != null && files.length != this.libraryContextContent.length) {
                return true;
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (this.libraryContextContent == null || this.libraryContextContent[i] == null) {
                        return true;
                    }
                    if (!files[i].equals(this.libraryContextContent[i].file)) {
                        return true;
                    }
                    if (files[i].lastModified() == this.libraryContextContent[i].lastModified) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTldUpdated() {
        if (this.jspTldCacheLevel > 1) {
            return false;
        }
        if (this.tldContextCheckCount++ < 5) {
            return false;
        }
        this.tldContextCheckCount = 0;
        if (this.tldContextFile != null) {
            if (this.tldContextContent == null) {
                return this.tldContextFile.exists();
            }
            if (!this.tldContextFile.exists()) {
                return true;
            }
            File[] files = JspServletInstanceInfo.listUnjarredTldFiles(this.tldContextFile, this.jspTldCacheLevel);
            if (files != null && files.length != this.tldContextContent.length) {
                return true;
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (this.tldContextContent == null || this.tldContextContent[i] == null) {
                        return true;
                    }
                    if (!files[i].equals(this.tldContextContent[i].file)) {
                        return true;
                    }
                    if (files[i].lastModified() == this.tldContextContent[i].lastModified) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionAttribute(String id, String name, Object value) {
        HttpSession session;
        HttpApplication httpApplication = this;
        synchronized (httpApplication) {
            session = (HttpSession)this.sessions.get(id);
        }
        if (session != null) {
            session.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSessions(Collection ids) {
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            HttpSession session;
            HttpApplication httpApplication = this;
            synchronized (httpApplication) {
                session = (HttpSession)this.sessions.get(iterator.next());
            }
            if (session == null) continue;
            session.invalidate();
        }
    }

    public synchronized EvermindFilterConfig getFilterConfig(FilterDescriptor descriptor) throws InstantiationException, ServletException {
        EvermindFilterConfig config;
        if (this.filterInstances == null) {
            this.filterInstances = new HashMap();
        }
        if ((config = (EvermindFilterConfig)this.filterInstances.get(descriptor.getName())) != null) {
            return config;
        }
        config = new EvermindFilterConfig(this, descriptor.hasInitParameters() ? descriptor.getInitParameters() : null, descriptor.getName(), descriptor);
        try {
            Filter filter;
            Class<?> type = Class.forName(descriptor.getClassName(), true, this.getClassLoader());
            config.instance = filter = (Filter)type.newInstance();
            if (this.development) {
                config.file = this.getClassFile(type, false);
                config.sourceFile = this.getClassFile(type, true);
                if (config.file != null) {
                    config.lastModified = config.file.lastModified();
                }
                if (config.sourceFile != null) {
                    config.sourceLastModified = config.sourceFile.lastModified();
                }
                config.lastModifiedCheck = HttpDateFormat.currentTimeLong + 2000L;
            }
            this.injectResource(filter);
            boolean inv = this.invokeLifecycleMethod(filter, descriptor.getPostConstructMethod());
            if (!inv) {
                throw new ServletException("@PostConstruct method invocation failed. Filter will NOT be put into servive.");
            }
            filter.init((FilterConfig)config);
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Error loading filter '" + descriptor.getDisplayName() + "', filter-class '" + descriptor.getClassName() + "' could not be instantiated due to access problems: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Error loading filter '" + descriptor.getDisplayName() + "', filter-class '" + descriptor.getClassName() + "' not found");
        }
        catch (ClassCastException e) {
            throw new InstantiationException("Specified filter-class for filter '" + descriptor.getDisplayName() + "' does not implement javax.servlet.Filter: " + descriptor.getClassName());
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Unable to instantiate filter class '" + descriptor.getClassName() + "': " + e.getMessage());
        }
        this.filterInstances.put(descriptor.getName(), config);
        return config;
    }

    public EvermindFilterConfig getFilterConfig(FilterDescriptor[] applied, int appliedCount) throws InstantiationException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readState(InputStream basicIn) throws IOException, ClassNotFoundException {
        if (HTTPProperties.getHttpClusterDebug()) {
            m_traceLogger.log(Level.FINE, "HttpApplication.readState()");
        }
        Map sessions = this.sessions;
        int version = IOUtils.readCompressedInt(basicIn);
        if (version != 1) {
            throw new IOException("Incompatible serialization format, the most common reasons for this is either due to a corrupt persistence file or due to a server software upgrade, if it's due to an upgrade then it is natural and will only happen once per major upgrade");
        }
        PolicyClassLoader stateLoader = this.classLoader;
        EJBInputStream in = new EJBInputStream(basicIn, (ClassLoader)stateLoader);
        in.setContext(this.application.getContext());
        in.setHttpApplication(this);
        Map map = sessions;
        synchronized (map) {
            int count = IOUtils.readCompressedInt(basicIn);
            if (HTTPProperties.getHttpClusterDebug()) {
                m_traceLogger.log(Level.FINE, "Restoring " + count + " sessions...");
            }
            for (int i = 0; i < count; ++i) {
                try {
                    EvermindHttpSession session = this.replicationService.read(in);
                    if (HTTPProperties.getHttpClusterDebug()) {
                        m_traceLogger.log(Level.FINE, "Imported session '" + session.id + "'");
                    }
                    sessions.put(session.id, session);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    if (HTTPProperties.getHttpClusterDebug()) {
                        m_traceLogger.log(Level.FINE, "Class not found while importing session:" + e, e);
                    }
                    this.application.log("Caught exception while importing session:" + e);
                    continue;
                }
                catch (IOException e) {
                    if (HTTPProperties.getHttpClusterDebug()) {
                        m_traceLogger.log(Level.FINE, "Caught exception while importing session:" + e, e);
                    }
                    this.application.log("Caught exception while importing session:" + e);
                    throw e;
                }
            }
            if (HTTPProperties.getHttpClusterDebug()) {
                m_traceLogger.log(Level.FINE, "End of Session stream");
            }
            if (in.readBoolean()) {
                Map map2 = this.attributes;
                synchronized (map2) {
                    this.readEntries(in, this.attributes);
                }
            }
        }
        in.close();
    }

    public static void writeEntries(ObjectOutputStream out, int entryCount, Object[] entries) throws IOException {
        for (int i = 0; i < entryCount; i += 2) {
            HttpApplication.writeEntry(out, (String)entries[i], entries[i + 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(OutputStream basicOut) throws IOException {
        if (HTTPProperties.getHttpClusterDebug()) {
            m_traceLogger.log(Level.FINE, "Persisting state");
        }
        IOUtils.writeCompressedInt(basicOut, 1);
        Map sessions = this.sessions;
        EJBOutputStream out = new EJBOutputStream(basicOut);
        Map map = sessions;
        synchronized (map) {
            int count = sessions.size();
            if (HTTPProperties.getHttpClusterDebug()) {
                m_traceLogger.log(Level.FINE, "Storing " + count + " sessions...");
            }
            IOUtils.writeCompressedInt(basicOut, count);
            Iterator iterator = sessions.values().iterator();
            while (iterator.hasNext()) {
                EvermindHttpSession session = (EvermindHttpSession)iterator.next();
                session.write(out);
                if (!HTTPProperties.getHttpClusterDebug()) continue;
                m_traceLogger.log(Level.FINE, "Wrote session '" + session.id + "'");
            }
            if (this.config.getReplicateServletContext()) {
                out.writeBoolean(true);
                HttpApplication.writeEntries(out, this.attributes);
            } else {
                out.writeBoolean(false);
            }
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEntries(ObjectOutputStream out, Map map) throws IOException {
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                HttpApplication.writeEntry(out, (String)key, value);
            }
            out.write(3);
        }
    }

    public static void writeEntry(ObjectOutputStream out, String name, Object value) throws IOException {
        if (value instanceof Serializable || value instanceof byte[] || value instanceof Remote) {
            out.write(1);
            out.writeUTF(name);
            IOUtils.writeSimpleObject(out, value);
        }
    }

    public void readEntries(ObjectInputStream in, Map map) throws IOException {
        block5: while (true) {
            switch (in.read()) {
                case 1: {
                    String name = in.readUTF();
                    try {
                        map.put(name, IOUtils.readSimpleObject(in));
                    }
                    catch (ClassNotFoundException e) {
                        this.application.log("Error deserializing attribute", e);
                    }
                    continue block5;
                }
            }
            break;
        }
    }

    public String getClasspath() {
        return this.getClassPath();
    }

    public String getClassPath() {
        if (this.classPathCache == null) {
            this.classPathCache = ClassLoaderQuery.getClassPath((PolicyClassLoader)this.classLoader);
        }
        return this.classPathCache;
    }

    public String toString() {
        return (this.config == null ? "uninitialized" : this.config.getName()) + " web-app";
    }

    public Context getAssemblyContext() {
        return this.config.getContext();
    }

    public String getDefaultCharSet() {
        return this.defaultCharSet;
    }

    public File getJSPCacheFile() {
        return this.jspCacheFile;
    }

    public LinkedCompiler getCompiler() throws InstantiationException {
        return this.site.server.getApplicationServer().getCompiler();
    }

    public URL getArchiveURL() {
        return this.config.getURL();
    }

    public String getServletContextName() {
        return this.config.getDisplayNameOnly();
    }

    public String getName() {
        return this.application.getConfig().getName();
    }

    public ServletMapping[] getServletMappings() {
        return this.servletMappings;
    }

    public PhaseEventIntf getResolveServletMetric() {
        if (this.resolveServletPhase == null) {
            try {
                this.resolveServletPhase = ApplicationServer.phaseEventFactory().create(this.getNoun(), "resolveServlet", "oc4j_context");
                this.resolveServletPhase.deriveMetric(511);
            }
            catch (Exception e) {
                this.getApplication().log("Unable to create phase sensor", e);
            }
        }
        return this.resolveServletPhase;
    }

    public NounIntf getNoun() {
        if (this.noun == null) {
            NounIntf parent = this.getWebNoun();
            try {
                this.noun = ApplicationServer.nounFactory().create(parent, this.getWebAppName(), "oc4j_context");
                this.sessionActivationPhase = ApplicationServer.phaseEventFactory().create(this.noun, "sessionActivation", "oc4j_context");
                this.sessionActivationPhase.deriveMetric(511);
            }
            catch (Throwable t) {
                this.log("*** failed to create context noun", t);
            }
        }
        return this.noun;
    }

    public NounIntf getWebNoun() {
        if (this.webNoun == null) {
            NounIntf parent = this.application.getApplicationNoun();
            try {
                this.webNoun = ApplicationServer.nounFactory().create(parent, "WEBs", "oc4j_web_module");
            }
            catch (Throwable t) {
                this.log("*** failed to create WEBs noun", t);
            }
        }
        return this.webNoun;
    }

    public NounIntf getServletsNoun() {
        if (this.servletsNoun == null) {
            NounIntf parent = this.getNoun();
            try {
                this.servletsNoun = ApplicationServer.nounFactory().create(parent, "SERVLETs", "");
            }
            catch (Throwable t) {
                this.log("*** failed to create WEBs noun", t);
            }
        }
        return this.servletsNoun;
    }

    public PhaseEventIntf getParseRequestMetric() {
        if (this.parseRequestPhase == null) {
            try {
                this.parseRequestPhase = ApplicationServer.phaseEventFactory().create(this.getWebNoun(), "parseRequest", "service_metric");
                this.parseRequestPhase.deriveMetric(511);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.parseRequestPhase;
    }

    public PhaseEventIntf getResolveContextMetric() {
        if (this.resolveContextPhase == null) {
            try {
                this.resolveContextPhase = ApplicationServer.phaseEventFactory().create(this.getWebNoun(), "resolveContext", "service_metric");
                this.resolveContextPhase.deriveMetric(511);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.resolveContextPhase;
    }

    public PhaseEventIntf getProcessRequestMetric() {
        if (this.processRequestPhase == null) {
            try {
                this.processRequestPhase = ApplicationServer.phaseEventFactory().create(this.getWebNoun(), "processRequest", "service_metric");
                this.processRequestPhase.deriveMetric(511);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.processRequestPhase;
    }

    public PhaseEventIntf getContextProcessRequestMetric() {
        if (this.contextProcessRequestPhase == null) {
            try {
                this.contextProcessRequestPhase = ApplicationServer.phaseEventFactory().create(this.getNoun(), "processRequest", "oc4j_context");
                this.contextProcessRequestPhase.deriveMetric(511);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.contextProcessRequestPhase;
    }

    public Set getResourcePaths(String path) {
        HashSet<String> set;
        block20: {
            File dir;
            String realPath;
            boolean wildcard;
            block19: {
                if (path == null || path.length() == 0) {
                    return null;
                }
                if (!path.startsWith("/")) {
                    throw new IllegalArgumentException("Partial path must start with a /");
                }
                set = null;
                wildcard = false;
                if (path.charAt(path.length() - 1) == '*') {
                    wildcard = true;
                    path = path.substring(0, path.length() - 1);
                }
                if ((realPath = this.getRealPath(path)) == null) {
                    return Collections.EMPTY_SET;
                }
                realPath = realPath.replace(File.separatorChar, '/');
                if (wildcard) {
                    path = path + "*";
                    realPath = realPath + "*";
                }
                File file = dir = !wildcard ? new File(realPath) : null;
                if (dir == null || !path.endsWith("/") && !dir.isDirectory()) break block19;
                File[] files = dir.listFiles();
                if (files == null) break block20;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (files.length > 0) {
                    set = new HashSet<String>();
                }
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        set.add(path + files[i].getName() + "/");
                        continue;
                    }
                    set.add(path + files[i].getName());
                }
                break block20;
            }
            if (wildcard) {
                File[] files;
                int idx = realPath.lastIndexOf("/");
                String dirPath = realPath.substring(0, idx + 1);
                String partialFileName = realPath.substring(idx + 1);
                if (partialFileName.endsWith("*")) {
                    partialFileName = partialFileName.substring(0, partialFileName.length() - 1);
                }
                if ((dir = new File(dirPath)).exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                    int slashOccurence = 0;
                    int pathLength = path.length();
                    int x = 0;
                    while (x < pathLength && (idx = path.indexOf("/", x)) >= 0) {
                        ++slashOccurence;
                        x = idx + 1;
                    }
                    if (slashOccurence > 0) {
                        idx = 0;
                        x = dirPath.length() - 1;
                        while (slashOccurence > 0 && (idx = dirPath.lastIndexOf("/", x)) >= 0) {
                            x = idx - 1;
                            --slashOccurence;
                        }
                        if (idx > 0) {
                            dirPath = dirPath.substring(idx);
                        }
                    }
                    String fileName = null;
                    for (int i = 0; i < files.length; ++i) {
                        fileName = files[i].getName();
                        if (!fileName.startsWith(partialFileName)) continue;
                        if (set == null) {
                            set = new HashSet();
                        }
                        if (files[i].isDirectory()) {
                            set.add(dirPath + fileName + "/");
                            continue;
                        }
                        set.add(dirPath + fileName);
                    }
                }
            }
        }
        return set;
    }

    public Map getAttributes() {
        return null;
    }

    private String getWebAppName() {
        return this.getConfig().getName();
    }

    private List getTldListenerDescriptors(List tldListeners) {
        int i;
        ArrayList<ListenerDescriptor> tldListenerClasses = new ArrayList<ListenerDescriptor>();
        for (i = 0; i < tldListeners.size(); ++i) {
            tldListenerClasses.add(new ListenerDescriptor((String)tldListeners.get(i)));
        }
        if (this.jspTldListenerDescriptors == null) {
            this.jspTldListenerDescriptors = new ArrayList();
            for (i = 0; i < tldListeners.size(); ++i) {
                this.jspTldListenerDescriptors.add(new ListenerDescriptor((String)tldListeners.get(i)));
            }
        }
        return tldListenerClasses;
    }

    public static String collapseParentDirs(String location) {
        int pos = 0;
        while (pos < location.length()) {
            if (location.charAt(pos) == '/') {
                if (pos > 0 && location.charAt(pos - 1) == '/') {
                    location = location.substring(0, pos - 1) + location.substring(pos, location.length());
                    continue;
                }
                if (pos > 1 && location.charAt(pos - 1) == '.' && location.charAt(pos - 2) == '/') {
                    location = location.substring(0, pos - 2) + location.substring(pos, location.length());
                    --pos;
                    continue;
                }
                if (pos > 3 && location.charAt(pos - 1) == '.' && location.charAt(pos - 2) == '.' && location.charAt(pos - 3) == '/') {
                    int prevSegmentStart;
                    for (prevSegmentStart = pos - 4; prevSegmentStart > 0 && location.charAt(prevSegmentStart) != '/'; --prevSegmentStart) {
                    }
                    if (pos - prevSegmentStart == 6 && location.charAt(prevSegmentStart + 1) == '.' && location.charAt(prevSegmentStart + 2) == '.') {
                        ++pos;
                        continue;
                    }
                    location = location.substring(0, prevSegmentStart) + location.substring(pos, location.length());
                    pos = prevSegmentStart;
                    continue;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
        return location;
    }

    SessionReplicationService getSessionService() {
        return this.replicationService;
    }

    private final void addServletMBean(ServletCallBackIf callBackIf, String name) {
        oracle.oc4j.admin.management.mbeans.Servlet.addServletMBean(callBackIf, name, this.application.getName(), this.config.getName());
    }

    private final void removeServletMBean(String name) {
        oracle.oc4j.admin.management.mbeans.Servlet.removeServletMBean(name, this.application.getName(), this.config.getName());
    }

    public void setLastModifiedCheckExpires(long interval) {
        this.lastModifiedCheckExpires = interval;
    }

    public void setDirectoryBrowsing(boolean allow) {
        this.directoryBrowsingAllowed = allow;
    }

    public void setResponseBufferSize(int size) {
        this.responseBufferSize = size;
    }

    public void setDefaultDocuments(List defaultDocuments) {
        this.defaultDocument = StringUtils.toByteString(defaultDocuments);
    }

    public synchronized void componentStart() throws InstantiationException {
        if (this.httpApplicationState == 0 || this.httpApplicationState == 1) {
            return;
        }
        this.initClassLoader();
        this.initDynamic(this.config);
        this.setComponentState(1);
    }

    public void componentStop(List appSubComponentList) {
        if (this.httpApplicationState == 3 || this.httpApplicationState == 2) {
            return;
        }
        if (this.getHttpReqCount() == 0) {
            this.stopCleanUp(appSubComponentList);
        } else {
            this.setComponentState(2);
        }
    }

    public int getComponentState() {
        return this.httpApplicationState;
    }

    public synchronized void setComponentState(int state) {
        this.httpApplicationState = state;
    }

    public void incrementReqCount() {
        this.httpReqCount.increment();
    }

    public void decrementReqCount() {
        this.httpReqCount.decrement();
    }

    public int getHttpReqCount() {
        return this.httpReqCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCleanUp(List appSubComponentList) {
        if (this.httpApplicationState == 3) {
            return;
        }
        this.destroy();
        this.setComponentState(3);
        List list = appSubComponentList;
        synchronized (list) {
            Iterator itr = appSubComponentList.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (!(obj instanceof HttpApplication) || !((HttpApplication)obj).equals(this)) continue;
                itr.remove();
            }
            appSubComponentList.notifyAll();
        }
    }

    private boolean generateWebServiceArtifacts() throws InstantiationException {
        boolean thereIsWebService = false;
        HttpApplicationDescriptor descriptor = (HttpApplicationDescriptor)this.config;
        if (descriptor.isSynthetic()) {
            return false;
        }
        if (descriptor.getWebServicesDescriptor() != null || !descriptor.getServiceReferences().isEmpty()) {
            WrapperClassGenerator.generateWebServiceArts(this.getApplication(), this, Notifier.getNotifier());
            thereIsWebService = true;
        }
        return thereIsWebService;
    }

    public PhaseEventIntf getSessionActivationMetric() {
        if (this.sessionActivationPhase == null) {
            this.sessionActivationPhase = ApplicationServer.phaseEventFactory().create(this.getNoun(), "sessionActivation", "oc4j_context");
            this.sessionActivationPhase.deriveMetric(511);
        }
        return this.sessionActivationPhase;
    }

    public void initStatisticSensors() {
        this.getParseRequestMetric();
        this.getResolveContextMetric();
        this.getProcessRequestMetric();
        this.getContextProcessRequestMetric();
        this.getResolveServletMetric();
        this.getSessionActivationMetric();
    }

    private int getJspTldCacheLevel(String jspCacheTlds) {
        if ("on".equalsIgnoreCase(jspCacheTlds) || "true".equalsIgnoreCase(jspCacheTlds)) {
            return 0;
        }
        if (jspCacheTlds == null || "standard".equalsIgnoreCase(jspCacheTlds)) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushJGroupSessions() {
        Map map = this.sessions;
        synchronized (map) {
            int count = this.sessions.size();
            JGroupHttpSession[] list = new JGroupHttpSession[count];
            this.sessions.values().toArray(list);
            for (int i = 0; i < count; ++i) {
                if (list[i].getInvalidated()) continue;
                list[i].flush("Interrupted onShutdown/JVM termination");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDBSessions() {
        Map map = this.sessions;
        synchronized (map) {
            int count = this.sessions.size();
            PersistenceHttpSession[] list = new PersistenceHttpSession[count];
            this.sessions.values().toArray(list);
            for (int i = 0; i < count; ++i) {
                if (list[i].getInvalidated()) continue;
                list[i].flush("Interrupted onShutdown/JVM termination");
            }
        }
    }

    public PersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    protected void destroyPersistenceUnitManager() {
        if (this.getPersistenceUnitManager() != null) {
            this.getPersistenceUnitManager().destroy();
            this.setPersistenceUnitManager(null);
        }
    }

    public void parseMetaData() throws InstantiationException {
        if (!this.processAnnotations() || this.getHttpApplicationDescriptor().getMetadataParsed()) {
            return;
        }
        WARAnnotationParser wap = new WARAnnotationParser(this);
        wap.parseAnnotations(this.getAnnotationClassLoader());
        this.getHttpApplicationDescriptor().setMetadataParsed(true);
    }

    private boolean isJDK50() {
        try {
            Class.class.getMethod(JDK50_MARKER_METHOD, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isWarFull() {
        if (this.getConfig() != null) {
            return ((HttpApplicationDescriptor)this.getConfig()).isWarFull();
        }
        return true;
    }

    public boolean processAnnotations() {
        return this.m_processAnnotations;
    }

    public PolicyClassLoader getAnnotationClassLoader() {
        return this.classLoader;
    }

    public J2EEContextConfigDelegate getConfigDelegate() {
        return ((HttpApplicationDescriptor)this.config).getConfigDelegate();
    }

    private void injectResource(Object target) throws RuntimeException {
        try {
            J2EEContextConfigDelegate ctxConfig = ((HttpApplicationDescriptor)this.config).getConfigDelegate();
            if (ctxConfig != null) {
                WARDependencyManager mgr = new WARDependencyManager(ctxConfig, target.getClass(), (ClassLoader)this.getAnnotationClassLoader());
                mgr.initialize();
                mgr.resolveDependencies(new InitialContext(), target);
            }
        }
        catch (Exception e) {
            m_traceLogger.log(Level.FINE, "Unable to inject resource: " + e.getMessage(), e);
            throw (RuntimeException)new RuntimeException("Unable to inject resource to " + target).initCause(e);
        }
    }

    private void injectListenerResources() {
        int i;
        if (!this.processAnnotations()) {
            return;
        }
        ServletContextListener listener = null;
        if (this.contextListeners != null) {
            for (i = 0; i < this.contextListeners.length; ++i) {
                listener = this.contextListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
        if (this.contextAttributeListeners != null) {
            for (i = 0; i < this.contextAttributeListeners.length; ++i) {
                listener = this.contextAttributeListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
        if (this.sessionListeners != null) {
            for (i = 0; i < this.sessionListeners.length; ++i) {
                listener = this.sessionListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
        if (this.sessionAttributeListeners != null) {
            for (i = 0; i < this.sessionAttributeListeners.length; ++i) {
                listener = this.sessionAttributeListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
        if (this.requestListeners != null) {
            for (i = 0; i < this.requestListeners.length; ++i) {
                listener = this.requestListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
        if (this.requestAttributeListeners != null) {
            for (i = 0; i < this.requestAttributeListeners.length; ++i) {
                listener = this.requestAttributeListeners[i];
                this.injectListenerResourcesHelper(listener);
            }
        }
    }

    private void injectListenerResourcesHelper(Object listener) {
        this.injectResource(listener);
        ListenerDescriptor descriptor = ((HttpApplicationDescriptor)this.config).getListenerDescriptor(listener.getClass());
        if (descriptor == null) {
            descriptor = this.getJspTldListenerDescriptor(listener.getClass());
        }
        if (descriptor != null) {
            this.invokeLifecycleMethod(listener, descriptor.getPostConstructMethod());
        }
    }

    private boolean invokeLifecycleMethod(Object obj, Method method) {
        if (method == null) {
            return true;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return this.invokeMethod(obj, method);
    }

    private boolean invokeMethod(Object obj, Method method) {
        try {
            if (method != null) {
                method.invoke(obj, null);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private ListenerDescriptor getJspTldListenerDescriptor(Class cls) {
        if (this.jspTldListenerDescriptors != null) {
            Iterator listeners = this.jspTldListenerDescriptors.iterator();
            while (listeners.hasNext()) {
                ListenerDescriptor listenerDesc = (ListenerDescriptor)listeners.next();
                if (!listenerDesc.getClassName().equals(cls.getName())) continue;
                return listenerDesc;
            }
        }
        return null;
    }

    public List getJspTldListenerDescriptors() {
        return this.jspTldListenerDescriptors;
    }

    private HttpApplicationDescriptor getHttpApplicationDescriptor() {
        return (HttpApplicationDescriptor)this.config;
    }

    private synchronized void initLifecycleConfig() throws InstantiationException {
        Enumeration<Object> keys;
        PolicyClassLoader loader = this.getAnnotationClassLoader();
        String clsName = null;
        String methodName = null;
        Class<?> cls = null;
        Method method = null;
        Properties props = this.getHttpApplicationDescriptor().getPreDestroyConfig();
        if (props != null && !props.isEmpty()) {
            keys = props.keys();
            while (keys.hasMoreElements()) {
                clsName = (String)keys.nextElement();
                methodName = props.getProperty(clsName);
                try {
                    cls = loader.loadClass(clsName);
                    method = com.evermind.server.deployment.ClassUtils.getMethod(cls, methodName, null);
                }
                catch (Exception e) {
                    throw (InstantiationException)new InstantiationException("Unable to initialize <pre-destory> method :" + clsName + " " + methodName).initCause(e);
                }
                if (method == null) {
                    throw new InstantiationException("Unable to initialize <pre-destroy> method :" + clsName + " " + methodName);
                }
                WARAnnotationParser.setPreDestroyMethod(this.getHttpApplicationDescriptor(), method, cls);
            }
        }
        if ((props = this.getHttpApplicationDescriptor().getPostConstructConfig()) != null && !props.isEmpty()) {
            keys = props.keys();
            while (keys.hasMoreElements()) {
                clsName = (String)keys.nextElement();
                methodName = props.getProperty(clsName);
                try {
                    cls = loader.loadClass(clsName);
                    method = com.evermind.server.deployment.ClassUtils.getMethod(cls, methodName, null);
                }
                catch (Exception e) {
                    throw (InstantiationException)new InstantiationException("Unable to initialize <post-construct> method :" + clsName + " " + methodName).initCause(e);
                }
                if (method == null) {
                    throw new InstantiationException("Unable to initialize <post-construct> method :" + clsName + " " + methodName);
                }
                WARAnnotationParser.setPostConstructMethod(this.getHttpApplicationDescriptor(), method, cls);
            }
        }
    }

    static {
        disallowAlias = WINDOWS = File.separatorChar == '\\';
        COMPILING_JSP = new Object();
        jspextn = new ByteString(".jsp");
        jspxextn = new ByteString(".jspx");
        SPECIFIC_END_HOLDER = new ByteString("");
        SLASH_BYTESTRING = new ByteString("/");
        JSP_PRECOMPILE_BYTESTING = new ByteString("jsp_precompile");
        EMPTY_BYTESTRING = new ByteString("");
        SECURE_COOKIE_ATTRIBUTE = "; secure".getBytes();
        HTTPONLY_COOKIE_ATTRIBUTE = "; HttpOnly".getBytes();
        m_overrideCookiePath = HTTPProperties.getOc4jCookieOverridePath();
        NULL_FILE = new File("");
        m_traceLogger = TraceLogger.getLogger(HttpApplication.class);
        PRECONDITION_FAILED_MESSAGE = "<HTML><HEAD><TITLE>304 Not Modified</TITLE></HEAD><BODY><H1>412 Precondition Failed</H1></BODY></HTML>".getBytes();
        base64CharTable = Base64Utils.getCharTable();
    }

    static class MultipartContent {
        private File file;
        private List ranges = null;
        private String contentType;
        private int fileLength;
        private List headers = null;
        private byte[] lastBoundary;
        private int contentLength;
        private String boundary;
        private static final String CRLF = "\r\n";
        private static final int MAXIMUM_BUF_SIZE = 102400;
        private static final Random random = new Random();

        public MultipartContent(File file, List ranges, String contentType, int fileLength) {
            this.file = file;
            this.ranges = ranges;
            this.contentType = contentType;
            this.fileLength = fileLength;
            this.boundary = Integer.toHexString(random.nextInt()) + Integer.toHexString(random.nextInt());
        }

        public String getBoundary() {
            return this.boundary;
        }

        public String getBoundaryHeader() {
            return "multipart/byteranges; boundary=" + this.boundary;
        }

        public int getContentLength() {
            if (this.headers != null) {
                throw new IllegalStateException("headers are already generated.");
            }
            this.generateHeaders();
            return this.contentLength;
        }

        private void generateHeaders() {
            this.headers = new ArrayList();
            Iterator it = this.ranges.iterator();
            while (it.hasNext()) {
                Range r = (Range)it.next();
                int start = r.getStart();
                int end = r.getEnd();
                String headerString = "\r\n--" + this.boundary + CRLF + "Content-Type: " + this.contentType + CRLF + "Content-Range: bytes " + start + '-' + end + '/' + this.fileLength + CRLF + CRLF;
                byte[] headerStringBytes = headerString.getBytes();
                this.headers.add(headerStringBytes);
                int headerLength = headerStringBytes.length;
                this.contentLength += headerLength + this.getLength(start, end);
            }
            this.lastBoundary = ("\r\n--" + this.boundary + "--" + CRLF).getBytes();
            this.contentLength += this.lastBoundary.length;
        }

        private int getLength(int start, int end) {
            return end - start + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream out) throws IOException {
            if (this.headers == null) {
                this.generateHeaders();
            }
            byte[] buf = new byte[102400];
            int privEnd = -1;
            FileInputStream fileIn = new FileInputStream(this.file);
            try {
                for (int pos = 0; pos < this.ranges.size(); ++pos) {
                    Range r = (Range)this.ranges.get(pos);
                    int start = r.getStart();
                    int end = r.getEnd();
                    int length = this.getLength(start, end);
                    if (privEnd >= start) {
                        fileIn.close();
                        fileIn = new FileInputStream(this.file);
                        if (start > 0) {
                            fileIn.skip(start);
                        }
                    } else {
                        int skipbytes = start - privEnd - 1;
                        if (skipbytes > 0) {
                            fileIn.skip(skipbytes);
                        }
                    }
                    privEnd = end;
                    out.write((byte[])this.headers.get(pos));
                    while (length > 102400) {
                        fileIn.read(buf);
                        out.write(buf);
                        length -= 102400;
                    }
                    fileIn.read(buf, 0, length);
                    out.write(buf, 0, length);
                }
                out.write(this.lastBoundary);
                out.flush();
            }
            finally {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
        }
    }

    static class Range {
        private int start;
        private int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getEnd() {
            return this.end;
        }
    }

    protected class LocalSessionService
    implements SessionReplicationService {
        protected LocalSessionService() {
        }

        public void invalidateSession(ByteString id) {
        }

        public void updateContextRMIValue(String name) {
        }

        public void sendContextValueUpdate(String name, Serializable value) {
        }

        public EvermindHttpSession createSession(HttpApplication app, ByteString id, int timeout, byte[] addr) {
            EvermindHttpSession session = new EvermindHttpSession(app, id, id.data, timeout);
            session.ip = HttpApplication.getSessionIp(addr);
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvermindHttpSession getExistingSession(ByteString name) {
            Map sessionMap;
            Map map = sessionMap = HttpApplication.this.sessions;
            synchronized (map) {
                return (EvermindHttpSession)sessionMap.get(name);
            }
        }

        public boolean isReplicateServletContext() {
            return false;
        }

        public void setReplicateServletContext(boolean replicateServletContext) {
        }

        public EvermindHttpSession read(EJBInputStream in) throws IOException, ClassNotFoundException {
            return EvermindHttpSession.read(in, HttpApplication.this);
        }

        public void setSessionLastAccessedTime(ByteString id, long lastAccessedTime) {
        }

        public void checkSessionTimeouts() {
            HttpApplication.this._checkSessionTimeouts();
        }

        public void destroy() {
        }
    }

    class ServletInstancesCollectionModificationListener
    implements CollectionModificationListener {
        ServletInstancesCollectionModificationListener() {
        }

        public final void notifyRemove(CollectionModificationEvent event) {
            String name = event.getKey().toString();
            HttpApplication.this.removeServletMBean(name);
        }

        public final void notifyAdd(CollectionModificationEvent event) {
            ServletDescriptor descriptor;
            String name = event.getKey().toString();
            Object value = event.getValue();
            HttpApplicationDescriptor httpDescriptor = (HttpApplicationDescriptor)HttpApplication.this.config;
            if (httpDescriptor.isSynthetic()) {
                return;
            }
            if (value instanceof ServletInstanceInfo && (descriptor = ((ServletInstanceInfo)value).descriptor) instanceof ServletCallBackIf) {
                HttpApplication.this.addServletMBean(descriptor, name);
            }
        }
    }

    private static class FileQuickStats {
        public boolean isDirectory;
        public boolean exists;
        public long lastModified;
    }
}

