/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindBodyContent;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindJSPWriter;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.JSPTagHttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import oracle.oc4j.security.OC4JRuntimePermission;
import oracle.oc4j.security.OC4JSecurity;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.VariableResolverImpl;

public class EvermindPageContext
extends PageContext {
    private static final int APPLICATION_HASH = "javax.servlet.jsp.jspApplication".hashCode();
    private static final int PAGE_HASH = "javax.servlet.jsp.jspPage".hashCode();
    private static final int CONFIG_HASH = "javax.servlet.jsp.jspConfig".hashCode();
    private static final int REQUEST_HASH = "javax.servlet.jsp.jspRequest".hashCode();
    private static final int RESPONSE_HASH = "javax.servlet.jsp.jspResponse".hashCode();
    private static final int EXCEPTION_HASH = "javax.servlet.jsp.jspException".hashCode();
    private static final int OUT_HASH = "javax.servlet.jsp.jspOut".hashCode();
    private static final int PAGECONTEXT_HASH = "javax.servlet.jsp.jspPageContext".hashCode();
    private static final int SESSION_HASH = "javax.servlet.jsp.jspSession".hashCode();
    private static final int MIN_LENGTH;
    private static final int MAX_LENGTH;
    private static OC4JRuntimePermission sideChannelPermission;
    private String charSet;
    private String lastCharSet;
    private HashMap attributes;
    private ServletContext context;
    private boolean needsSession;
    private EvermindJSPWriter out;
    EvermindHttpServletRequest evermindRequest;
    EvermindHttpServletResponse evermindResponse;
    HttpServletRequest request;
    HttpSession session;
    HttpServletResponse response;
    private Servlet servlet;
    private String errorPageURL;
    private EvermindBodyContent[] writers;
    private int writersDepth;
    protected boolean printNullStr = false;

    private Object getPredefinedAttribute(String name) {
        int nameLength = name.length();
        if (nameLength < MIN_LENGTH || nameLength > MAX_LENGTH) {
            return null;
        }
        int nameHash = name.hashCode();
        if (nameHash == APPLICATION_HASH && name.equals("javax.servlet.jsp.jspApplication")) {
            return this.context;
        }
        if (nameHash == PAGE_HASH && name.equals("javax.servlet.jsp.jspPage")) {
            return this.servlet;
        }
        if (nameHash == CONFIG_HASH && name.equals("javax.servlet.jsp.jspConfig")) {
            return this.getServletConfig();
        }
        if (nameHash == REQUEST_HASH && name.equals("javax.servlet.jsp.jspRequest")) {
            return this.request;
        }
        if (nameHash == RESPONSE_HASH && name.equals("javax.servlet.jsp.jspResponse")) {
            return this.response;
        }
        if (nameHash == EXCEPTION_HASH && name.equals("javax.servlet.jsp.jspException")) {
            return this.getException();
        }
        if (nameHash == OUT_HASH && name.equals("javax.servlet.jsp.jspOut")) {
            return this.getOut();
        }
        if (nameHash == PAGECONTEXT_HASH && name.equals("javax.servlet.jsp.jspPageContext")) {
            return this;
        }
        if (nameHash == SESSION_HASH && name.equals("javax.servlet.jsp.jspSession")) {
            return this.session;
        }
        return null;
    }

    public Object findAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (name == "") {
            return null;
        }
        Object value = this.getPredefinedAttribute(name);
        if (value != null) {
            return value;
        }
        value = this.getAttribute(name);
        if (value != null) {
            return value;
        }
        value = this.request.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (this.session != null && (value = this.session.getAttribute(name)) != null) {
            return value;
        }
        return this.context.getAttribute(name);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        if (request instanceof EvermindHttpServletRequest) {
            this.evermindRequest = (EvermindHttpServletRequest)request;
            this.request = this.evermindRequest;
        } else {
            this.request = (HttpServletRequest)request;
            this.evermindRequest = null;
        }
        if (response instanceof EvermindHttpServletResponse) {
            this.evermindResponse = (EvermindHttpServletResponse)response;
            this.response = this.evermindResponse;
        } else {
            this.response = (HttpServletResponse)response;
            this.evermindResponse = null;
        }
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.context = servlet.getServletConfig().getServletContext();
        boolean isISO8859Convert = true;
        if (this.context instanceof HttpApplication) {
            this.printNullStr = ((HttpApplication)this.context).jspPrintNull;
            isISO8859Convert = ((HttpApplication)this.context).iso8859Convert;
        }
        if (this.out == null) {
            this.out = new EvermindJSPWriter(this, bufferSize, autoFlush, this.printNullStr, isISO8859Convert);
        } else {
            this.out.initialize(bufferSize, autoFlush, this.printNullStr, isISO8859Convert);
        }
        if (needsSession) {
            this.session = this.request.getSession();
        }
    }

    private void setCharSetFromResponse() {
        this.charSet = this.evermindResponse != null ? this.evermindResponse.getCharacterEncoding() : EvermindHttpServletResponse.getThreadResponse().getCharacterEncoding();
        if (this.lastCharSet == null || !this.lastCharSet.equals(this.charSet)) {
            this.out.setCharSet(this.charSet);
            this.lastCharSet = this.charSet;
        }
    }

    public void forward(String path) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        if (!path.startsWith("/")) {
            String included = (String)this.request.getAttribute("javax.servlet.include.request_uri");
            String requestURI = included != null ? included : this.request.getRequestURI();
            String contextPath = this.request.getContextPath();
            path = requestURI.substring(contextPath.length(), requestURI.lastIndexOf(47) + 1).concat(path);
        }
        if ((dispatcher = this.context.getRequestDispatcher(path)) == null) {
            throw new IllegalArgumentException("Resource " + path + " not found");
        }
        if (this.writersDepth <= 0) {
            try {
                this.out.clear();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
        } else {
            this.writers[this.writersDepth - 1].clear();
        }
        while (this.response instanceof JSPTagHttpServletResponse) {
            this.response = (HttpServletResponse)((JSPTagHttpServletResponse)this.response).getResponse();
        }
        dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public EvermindHttpServletResponse getEvermindResponse() {
        if (this.evermindResponse != null) {
            return this.evermindResponse;
        }
        return EvermindHttpServletResponse.getThreadResponse();
    }

    public void include(String path) throws IOException, ServletException {
        this.include(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(String path, boolean flush) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        if (flush && this.writersDepth <= 0) {
            this.out.flush();
        }
        if (!path.startsWith("/")) {
            String included = (String)this.request.getAttribute("javax.servlet.include.request_uri");
            String requestURI = included != null ? included : this.request.getRequestURI();
            String contextPath = this.request.getContextPath();
            path = requestURI.substring(contextPath.length(), requestURI.lastIndexOf(47) + 1).concat(path);
        }
        if ((dispatcher = this.context.getRequestDispatcher(path)) == null) {
            throw new IllegalArgumentException("Resource " + path + " not found");
        }
        JSPTagHttpServletResponse l_response = new JSPTagHttpServletResponse(this.response, (JspWriter)(this.writersDepth > 0 ? this.writers[this.writersDepth - 1] : this.out));
        try {
            dispatcher.include((ServletRequest)this.request, (ServletResponse)l_response);
            Object var7_6 = null;
            if (l_response.writer != null) {
                l_response.writer.flush();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (l_response.writer != null) {
                l_response.writer.flush();
            }
            throw throwable;
        }
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                if (this.attributes == null) {
                    return Collections.enumeration(Collections.EMPTY_LIST);
                }
                return Collections.enumeration(this.attributes.keySet());
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("page is not participating in session");
                }
                return Collections.enumeration(Arrays.asList(this.session.getValueNames()));
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid Scope");
    }

    public Exception getException() {
        try {
            return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public JspWriter getOut() {
        if (this.writersDepth > 0) {
            return this.writers[this.writersDepth - 1];
        }
        return this.out;
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        int scope = this.getAttributesScope(name);
        if (scope != 0) {
            this.removeAttribute(name, scope);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        switch (scope) {
            case 1: {
                if (this.attributes == null) {
                    return;
                }
                this.attributes.remove(name);
                return;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("page is not participating in session");
                }
                this.session.removeValue(name);
                return;
            }
            case 2: {
                this.request.setAttribute(name, null);
                return;
            }
            case 4: {
                this.context.removeAttribute(name);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Scope");
    }

    public int getAttributesScope(String name) {
        if (this.attributes != null && this.attributes.containsKey(name)) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    private boolean contains(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Enumeration enumeration, String name) {
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (name == "") {
            return null;
        }
        Object value = this.getPredefinedAttribute(name);
        if (value != null) {
            return value;
        }
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (name == "") {
            return null;
        }
        switch (scope) {
            case 1: {
                return this.getAttribute(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("page is not participating in session");
                }
                return this.session.getValue(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid Scope");
    }

    public void setAttribute(String name, Object attribute) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (attribute == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, attribute);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        switch (scope) {
            case 1: {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(name, value);
                return;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("page is not participating in session");
                }
                this.session.putValue(name, value);
                return;
            }
            case 2: {
                this.request.setAttribute(name, value);
                return;
            }
            case 4: {
                this.context.setAttribute(name, value);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Scope");
    }

    public void release() {
        this.attributes = null;
        this.request = null;
        this.response = null;
        this.session = null;
        this.writersDepth = 0;
        this.context = null;
        this.evermindRequest = null;
        this.evermindResponse = null;
        this.servlet = null;
        this.errorPageURL = null;
        this.lastCharSet = null;
        this.charSet = null;
        this.out.reset();
        if (this.writers != null) {
            for (int i = 0; i < this.writers.length; ++i) {
                if (this.writers[i] == null) continue;
                this.writers[i].reset();
            }
        }
    }

    public void handlePageException(Exception e) throws IOException, ServletException {
        this.handlePageThrowable(e);
    }

    public void handlePageException(Throwable e) throws IOException, ServletException {
        this.handlePageThrowable(e);
    }

    public void handlePageThrowable(Throwable e) throws IOException, ServletException {
        this.out.clearBuffer();
        if (e == null) {
            throw new NullPointerException();
        }
        if (e instanceof HttpIOException) {
            throw (IOException)e;
        }
        if (this.errorPageURL != null && this.errorPageURL != "") {
            RequestDispatcher dispatcher;
            if (!this.errorPageURL.startsWith("/")) {
                String requestURI = this.request.getServletPath();
                this.errorPageURL = requestURI.substring(0, requestURI.lastIndexOf(47) + 1) + this.errorPageURL;
            }
            if ((dispatcher = this.context.getRequestDispatcher(this.errorPageURL)) != null) {
                try {
                    this.request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                    if (e instanceof IOException) {
                        this.request.setAttribute("javax.servlet.error.exception", (Object)((IOException)e));
                    } else if (e instanceof ServletException) {
                        this.request.setAttribute("javax.servlet.error.exception", (Object)((ServletException)e));
                    } else {
                        this.request.setAttribute("javax.servlet.error.exception", (Object)e);
                    }
                    this.request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                    if (e.getMessage() != null) {
                        this.request.setAttribute("javax.servlet.error.message", (Object)e.getMessage());
                    }
                    this.request.setAttribute("javax.servlet.error.request_uri", (Object)this.request.getRequestURI());
                    this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                    this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.servlet.getServletConfig().getServletName());
                    try {
                        dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
                    }
                    catch (IllegalStateException ex) {
                        dispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
                    }
                    this.request.removeAttribute("javax.servlet.error.status_code");
                    this.request.removeAttribute("javax.servlet.error.request_uri");
                    this.request.removeAttribute("javax.servlet.error.servlet_name");
                    this.request.removeAttribute("javax.servlet.error.message");
                    this.request.removeAttribute("javax.servlet.error.exception");
                    this.request.removeAttribute("javax.servlet.error.exception_type");
                    return;
                }
                catch (Exception newException) {
                    e = newException;
                }
            }
        } else {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new ServletException(e);
        }
        EvermindHttpServletRequest evermindRequest = this.request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)this.request : EvermindHttpServletRequest.getThreadRequest();
        EvermindHttpServletResponse evermindResponse = this.response instanceof EvermindHttpServletResponse ? (EvermindHttpServletResponse)this.response : EvermindHttpServletResponse.getThreadResponse();
        evermindResponse.handleException(e, evermindRequest);
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        if (this.writers == null) {
            this.writers = new EvermindBodyContent[4];
        }
        if (this.writersDepth >= this.writers.length) {
            EvermindBodyContent[] newWriters = new EvermindBodyContent[this.writers.length * 2];
            System.arraycopy(this.writers, 0, newWriters, 0, this.writers.length);
            this.writers = newWriters;
        }
        if (this.writers[this.writersDepth] == null) {
            this.writers[this.writersDepth] = new EvermindBodyContent();
        } else {
            this.writers[this.writersDepth].clearBody();
        }
        if (this.writersDepth == 0) {
            this.writers[this.writersDepth].setEnclosingWriter(this.out);
        } else {
            this.writers[this.writersDepth].setEnclosingWriter((JspWriter)this.writers[this.writersDepth - 1]);
        }
        this.setCharSetFromResponse();
        this.writers[this.writersDepth].setCharacterEncoding(this.out.getCharSet());
        this.writers[this.writersDepth].setWriter(writer);
        this.writers[this.writersDepth].setJspPrintNull(this.printNullStr);
        return this.writers[this.writersDepth++];
    }

    public JspWriter popBody() {
        if (--this.writersDepth < 1) {
            this.writersDepth = 0;
            return this.out;
        }
        return this.writers[this.writersDepth - 1];
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        ExpressionEvaluatorImpl expressionEvaluator = new ExpressionEvaluatorImpl();
        return expressionEvaluator;
    }

    public VariableResolver getVariableResolver() {
        VariableResolverImpl variableResolver = new VariableResolverImpl((PageContext)this);
        return variableResolver;
    }

    static {
        ArrayList<Integer> constants = new ArrayList<Integer>();
        constants.add(new Integer("javax.servlet.jsp.jspApplication".length()));
        constants.add(new Integer("javax.servlet.jsp.jspPage".length()));
        constants.add(new Integer("javax.servlet.jsp.jspConfig".length()));
        constants.add(new Integer("javax.servlet.jsp.jspRequest".length()));
        constants.add(new Integer("javax.servlet.jsp.jspResponse".length()));
        constants.add(new Integer("javax.servlet.jsp.jspException".length()));
        constants.add(new Integer("javax.servlet.jsp.jspOut".length()));
        constants.add(new Integer("javax.servlet.jsp.jspPageContext".length()));
        constants.add(new Integer("javax.servlet.jsp.jspSession".length()));
        Collections.sort(constants);
        MIN_LENGTH = (Integer)constants.get(0);
        MAX_LENGTH = (Integer)constants.get(constants.size() - 1);
        sideChannelPermission = OC4JSecurity.getRuntimePermission("sidechannel.com.evermind.server.http.EvermindPageContext");
    }
}

