/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.util.ConfigUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.j2ee.util.TraceLogger;

public class CGIServlet
extends HttpServlet {
    public static final String CGI_SPECIFICATION = "CGI/1.1";
    private ServletContext context;
    private String interpreter;
    private String root;
    private String[] environment;
    private boolean commaSeparateMultipleValues = false;
    private boolean debug;
    private boolean not_1_3;
    private static Logger m_traceLogger = TraceLogger.getLogger(CGIServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        this.interpreter = config.getInitParameter("interpreter");
        this.root = config.getInitParameter("root");
        this.commaSeparateMultipleValues = "true".equalsIgnoreCase(config.getInitParameter("commaSeparateMultipleValues"));
        this.debug = "true".equalsIgnoreCase(config.getInitParameter("debug"));
        String environment = config.getInitParameter("environment");
        if (environment != null) {
            ArrayList<String> environmentList = new ArrayList<String>();
            StringTokenizer environmentTokenizer = new StringTokenizer(environment, ",");
            while (environmentTokenizer.hasMoreTokens()) {
                environmentList.add(environmentTokenizer.nextToken());
            }
            this.environment = environmentList.toArray(new String[environmentList.size()]);
        }
        if (this.root != null && this.context.getRealPath("/") != null) {
            try {
                this.root = new File(ConfigUtils.getURL(new File(this.context.getRealPath("/")).toURL(), this.root).getFile()).getAbsolutePath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int i;
        Process process;
        boolean isDirectoryRequest;
        String authType;
        String remoteUser;
        String realPath;
        String contextPath;
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        if ((contextPath = request.getContextPath()) != null && contextPath.length() > 0) {
            requestURI = requestURI.substring(contextPath.length());
        }
        if ((realPath = this.context.getRealPath(requestURI)) == null) {
            response.sendError(404);
            return;
        }
        ArrayList<String> environmentList = new ArrayList<String>();
        String userAgent = request.getHeader("User-Agent");
        String queryString = request.getQueryString();
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        try {
            EvermindHttpServletRequest evermindRequest = (EvermindHttpServletRequest)request;
            remoteUser = request.getRemoteUser();
            authType = request.getAuthType();
        }
        catch (ClassCastException e) {
            remoteUser = request.getRemoteUser();
            authType = request.getAuthType();
        }
        String requestAccept = request.getHeader("Accept");
        String requestMethod = request.getMethod();
        String requestContentType = request.getContentType();
        Enumeration headerNames = request.getHeaderNames();
        String pathTranslated = null;
        String cgiPathTranslated = null;
        boolean found = false;
        boolean bl = isDirectoryRequest = pathInfo != null;
        if (!isDirectoryRequest) {
            pathTranslated = request.getRealPath(request.getServletPath());
        } else {
            int pos;
            String initialServletPath = servletPath = pathInfo;
            int previousPos = 0;
            int index = servletPath.length();
            while ((pos = servletPath.lastIndexOf(47, index)) >= 0) {
                pathTranslated = this.getRealPath(request, servletPath);
                File file = new File(pathTranslated);
                if (file.exists() && !file.isDirectory()) {
                    found = true;
                    if (servletPath != initialServletPath) {
                        if (initialServletPath.length() > previousPos) {
                            pathInfo = initialServletPath.substring(previousPos);
                            cgiPathTranslated = request.getRealPath(pathInfo);
                            break;
                        }
                        pathInfo = null;
                        cgiPathTranslated = null;
                        break;
                    }
                    pathInfo = null;
                    break;
                }
                servletPath = servletPath.substring(0, pos);
                index = pos + 1;
                previousPos = pos;
            }
            if (!found) {
                pathTranslated = this.getRealPath(request, servletPath);
                pathInfo = null;
            }
        }
        if (pathTranslated == null) {
            response.setContentType("text/html");
            ServletOutputStream out = response.getOutputStream();
            out.println("<html><head><title>CGI error</title></head><body><h1>CGI Error</h1>CGI cannot be run from within a WAR file - it requires standalone files.</body></html>");
            out.close();
            return;
        }
        if (!new File(pathTranslated).exists() || new File(pathTranslated).isDirectory()) {
            response.sendError(404);
            return;
        }
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Content-Type")) continue;
            environmentList.add("HTTP_" + name.replace('-', '_').toUpperCase() + '=' + request.getHeader(name));
        }
        if (cgiPathTranslated == null && pathInfo != null && pathInfo.length() > 0) {
            cgiPathTranslated = pathTranslated;
        }
        if (requestContentType != null) {
            environmentList.add("CONTENT_TYPE=".concat(requestContentType));
        }
        if (queryString != null) {
            environmentList.add("QUERY_STRING=".concat(queryString));
        }
        if (remoteUser != null) {
            environmentList.add("REMOTE_USER=".concat(remoteUser));
        }
        if (pathInfo != null) {
            environmentList.add("PATH_INFO=".concat(pathInfo));
        }
        if (cgiPathTranslated != null) {
            environmentList.add("PATH_TRANSLATED=".concat(cgiPathTranslated));
        }
        if (isDirectoryRequest) {
            servletPath = request.getServletPath().concat(servletPath);
        }
        environmentList.add("SERVER_SOFTWARE=".concat(this.context.getServerInfo()));
        environmentList.add("SERVER_NAME=".concat(request.getServerName()));
        environmentList.add("SERVER_PORT=".concat(String.valueOf(request.getServerPort())));
        environmentList.add("SERVER_PROTOCOL=".concat(request.getProtocol()));
        environmentList.add("GATEWAY_INTERFACE=CGI/1.1");
        environmentList.add("DOCUMENT_ROOT=".concat(this.context.getRealPath("")));
        environmentList.add("REQUEST_METHOD=".concat(requestMethod));
        environmentList.add("REMOTE_HOST=".concat(request.getRemoteHost()));
        environmentList.add("REMOTE_ADDR=".concat(request.getRemoteAddr()));
        environmentList.add("SCRIPT_NAME=".concat(servletPath));
        environmentList.add("SCRIPT_FILENAME=".concat(pathInfo == null ? realPath : realPath.substring(0, realPath.length() - pathInfo.length())));
        environmentList.add("REQUEST_URI=".concat(queryString == null ? requestURI : requestURI + '?' + queryString));
        int requestContentLength = request.getContentLength();
        if (requestContentLength > 0) {
            environmentList.add("CONTENT_LENGTH=".concat(String.valueOf(requestContentLength)));
        }
        try {
            String[] stringArray;
            String[] environmentArray = new String[environmentList.size() + (this.environment == null ? 0 : this.environment.length)];
            environmentList.toArray(environmentArray);
            if (this.environment != null) {
                System.arraycopy(this.environment, 0, environmentArray, environmentList.size(), this.environment.length);
            }
            String directory = pathTranslated.substring(0, pathTranslated.lastIndexOf(File.separatorChar));
            if (this.interpreter == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = pathTranslated;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.interpreter;
                stringArray = stringArray3;
                stringArray3[1] = pathTranslated;
            }
            process = this.launch(stringArray, environmentArray, directory);
        }
        catch (Exception e) {
            if (this.interpreter == null) {
                response.sendError(500, "Unable to execute the file (" + e.getClass().getName() + ": " + e.getMessage() + ")");
            } else {
                response.sendError(500, "Could not find/launch the interpreter, searched for \"" + this.interpreter + '\"');
            }
            return;
        }
        InputStream processIn = process.getInputStream();
        InputStream processErr = process.getErrorStream();
        OutputStream processOut = process.getOutputStream();
        byte[] buffer = new byte[1024];
        if (requestMethod.equals("POST") || requestMethod.equals("PUT")) {
            int length;
            if (this.debug) {
                m_traceLogger.log(Level.FINE, "Post content:");
            }
            try {
                if (((EvermindHttpServletRequest)request).getImmutableParameters() != null) {
                    if (this.debug) {
                        m_traceLogger.log(Level.FINE, new String(((EvermindHttpServletRequest)request).getPostParams(this.commaSeparateMultipleValues)));
                    }
                    processOut.write(((EvermindHttpServletRequest)request).getPostParams(this.commaSeparateMultipleValues));
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ServletInputStream servletIn = request.getInputStream();
            while ((length = servletIn.read(buffer)) != -1) {
                if (this.debug) {
                    m_traceLogger.log(Level.FINE, new String(buffer, 0, length));
                }
                processOut.write(buffer, 0, length);
            }
        }
        processOut.close();
        int length = 0;
        response.setContentType("text/html");
        String redirectLocation = null;
        int lineNumber = 0;
        while ((i = processIn.read()) != -1) {
            if (i == 13) continue;
            if (i == 10) {
                if (length == 0) break;
                String line = new String(buffer, 0, length);
                length = 0;
                int colonPos = line.indexOf(58);
                if (colonPos < 0) {
                    if (lineNumber != 0 || line.length() <= 9 || !line.substring(0, 5).equalsIgnoreCase("http/")) continue;
                    this.parseStatus(response, line.substring(9));
                    continue;
                }
                String name = line.substring(0, colonPos).trim();
                String value = line.substring(colonPos + 1, line.length()).trim();
                if (name.equalsIgnoreCase("Content-Type")) {
                    response.setContentType(value);
                } else if (name.equalsIgnoreCase("Content-Length")) {
                    response.setContentLength(Integer.parseInt(value));
                } else if (name.equalsIgnoreCase("Location")) {
                    redirectLocation = value;
                } else if (name.equalsIgnoreCase("Status")) {
                    this.parseStatus(response, value);
                } else {
                    response.addHeader(name, value);
                }
                ++lineNumber;
                continue;
            }
            if (length >= 1024) continue;
            buffer[length++] = (byte)i;
        }
        if (redirectLocation != null) {
            response.sendRedirect(redirectLocation);
            processIn.close();
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        boolean errorOccured = false;
        while ((length = processIn.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        while ((length = processErr.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    private String getRealPath(HttpServletRequest request, String path) {
        if (request.getPathInfo() != null) {
            if (this.root == null) {
                return request.getRealPath(request.getServletPath() + path);
            }
            return this.root + path.replace('/', File.separatorChar);
        }
        return request.getRealPath(path);
    }

    public void parseStatus(HttpServletResponse response, String string) {
        String message;
        int endOfNumber;
        if (string.indexOf(32) >= 0) {
            endOfNumber = string.indexOf(32);
            message = string.substring(endOfNumber + 1);
        } else {
            endOfNumber = string.length();
            message = null;
        }
        int status = 200;
        try {
            String numberString = endOfNumber == string.length() ? string : string.substring(0, endOfNumber);
            status = Integer.parseInt(numberString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        response.setStatus(status, message);
    }

    private Process launch(String[] arguments, String[] environment, String workingDirectory) throws IOException {
        if (!this.not_1_3) {
            try {
                return this.launchWithWorkingDirectory(arguments, environment, workingDirectory);
            }
            catch (NoSuchMethodException e) {
                this.not_1_3 = true;
            }
            catch (Error e) {
                this.not_1_3 = true;
            }
        }
        return Runtime.getRuntime().exec(arguments, environment);
    }

    private Process launchWithWorkingDirectory(String[] arguments, String[] environment, String workingDirectory) throws IOException, NoSuchMethodException {
        return Runtime.getRuntime().exec(arguments, environment, new File(workingDirectory));
    }
}

