/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.HttpAuthenticator;
import com.evermind.util.Base64Utils;
import java.io.IOException;
import java.net.PasswordAuthentication;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicHttpAuthenticator
implements HttpAuthenticator {
    protected String realm = "Unknown";

    public String getAuthType() {
        return "Basic";
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public PasswordAuthentication getAuthentication(HttpServletRequest request) {
        String authorization = request.getHeader("AUTHORIZATION");
        if (authorization == null) {
            return null;
        }
        int separatorIndex = authorization.indexOf(32);
        if (separatorIndex > 0 && authorization.substring(0, separatorIndex).equalsIgnoreCase("Basic")) {
            byte[] data;
            try {
                data = Base64Utils.decode(authorization.substring(separatorIndex + 1, authorization.length()).toCharArray());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 58) continue;
                String username = new String(data, 0, i);
                char[] password = new char[data.length - ++i];
                for (int x = 0; x < data.length - i; ++x) {
                    password[x] = (char)data[i + x];
                }
                return new PasswordAuthentication(username, password);
            }
        }
        return null;
    }

    public void reject(HttpServletRequest request, HttpServletResponse response, int reason) throws IOException {
        if (reason == 1) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + '\"');
            response.sendError(401);
        } else {
            response.sendError(403);
        }
    }
}

