/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.session.persistence;

import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBInternalInputStream;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.ejb.session.persistence.InternalEJBSessionInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class InternalEJBSessionObject
implements InternalEJBSessionInterface {
    private static Logger m_logger = EJBTraceLogger.getLogger(InternalEJBSessionObject.class);
    protected long id;
    private long lastAccessed;
    private long creationTime;
    private int maxInactiveTime = 60000;
    private StatefulSessionEJBObject sfsbObj;
    private StatefulSessionEJBHome sfsbHome;
    private String user;
    private EJBContainer container;
    private byte[] sfsbBytes;
    private String location;
    private long checksum;
    public boolean passivate = false;

    public InternalEJBSessionObject() {
    }

    public InternalEJBSessionObject(long id) {
        this.id = id;
    }

    public InternalEJBSessionObject(long id, long creationTime) {
        this.id = id;
        this.creationTime = creationTime;
        this.lastAccessed = creationTime;
    }

    public void dropped() {
        if (this.sfsbObj == null) {
            return;
        }
        this.sfsbHome.remove(this.sfsbObj.OC4J_getId());
        this.sfsbObj = null;
    }

    public void setEJBObject(StatefulSessionEJBObject object) throws InterruptedException, NamingException {
        this.sfsbObj = object;
        this.checksum = this.sfsbObj.OC4J_getChecksum();
        this.location = ((ExposableBeanDescriptor)this.sfsbObj.getBeanDescriptor()).getQualifiedLocation();
        this.id = this.sfsbObj.OC4J_getId();
        this.sfsbHome = (StatefulSessionEJBHome)this.container.getApplication().getContext().lookup(this.location);
    }

    public void unmarshall() throws NamingException {
        if (this.container == null) {
            throw new IllegalStateException("must set container");
        }
        if (this.location == null) {
            throw new IllegalStateException("must set location");
        }
        Object object = this.container.getApplication().getContext().lookup(this.location);
        if (!(object instanceof StatefulSessionEJBHome)) {
            if (m_logger.isLoggable(Level.INFO)) {
                m_logger.info("unmarshalling, object at " + this.location + " not StatefulSessionEJBHome");
            }
            return;
        }
        StatefulSessionEJBHome home = (StatefulSessionEJBHome)object;
        if (this.sfsbBytes == null) {
            throw new IllegalStateException("nothing to unmarshall");
        }
        try {
            EJBInternalInputStream in = new EJBInternalInputStream((InputStream)new ByteArrayInputStream(this.sfsbBytes), home);
            in.readSession(home, this.id, this.checksum);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getBytes() {
        return this.sfsbBytes;
    }

    public synchronized void flush() {
        try {
            this.setBytes(InternalEJBSessionObject.extractBytes(this.sfsbObj, this.passivate));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBytes(byte[] bytes) {
        this.sfsbBytes = bytes;
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    protected boolean shouldReap(long currentTime) {
        return false;
    }

    protected void reaped() {
    }

    public void interrupt() {
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public String getUserName() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getUserName();
        }
        return this.user;
    }

    public long getCreationTime() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getCreationTime();
        }
        return this.creationTime;
    }

    public String getLocation() {
        return this.location;
    }

    public long getSFSBId() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getId();
        }
        return this.id;
    }

    public long getChecksum() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getChecksum();
        }
        return this.checksum;
    }

    protected static byte[] extractBytes(StatefulSessionEJBObject sfsbObj, boolean passivate) throws Exception {
        if (sfsbObj == null) {
            return new byte[0];
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        EJBInternalOutputStream ejbOut = new EJBInternalOutputStream(o);
        ejbOut.writeUTF(sfsbObj.OC4J_getUserName());
        ejbOut.writeLong(sfsbObj.OC4J_getCreationTime());
        ejbOut.writeLong(sfsbObj.OC4J_getLastAccessedTime());
        ejbOut.sessionContext = sfsbObj.getContext();
        ejbOut.writeObject(sfsbObj.getContext().attributes);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "ClusteredEJBService is attempting Session Migration at End Of Call for Stateful Session Bean" + sfsbObj.getObject());
        }
        ejbOut.writeObject(passivate ? sfsbObj.passivate() : sfsbObj.getObject());
        ejbOut.writeObject(sfsbObj.getContext().getUserInterceptorInstances());
        ejbOut.close();
        return o.toByteArray();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPassivate(boolean passivate) {
        this.passivate = passivate;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }
}

