/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.LocalStatefulSessionEJBHome;
import com.evermind.server.ejb.RemoteStatefulSessionEJBHome;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.proxy.ProxyGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class StatefulHomeProxyGenerator
extends ProxyGenerator {
    private SessionBeanDescriptor sd;
    private Class wrapperClass;

    public StatefulHomeProxyGenerator(SessionBeanDescriptor sd, boolean local) {
        Class clazz = local ? LocalStatefulSessionEJBHome.class : RemoteStatefulSessionEJBHome.class;
        super(clazz, local ? sd.getLocalHome() : sd.getRemoteHome());
        this.sd = sd;
        this.wrapperClass = local ? sd.getLocalWrapper() : sd.getRemoteWrapper();
        this.setHome(true);
        this.setRemote(!local);
        this.setCopyByValue(sd.isCopyByValue());
        if (this.isRemote() && sd.getGenerateIIOP()) {
            this.setCorba(true);
        }
    }

    protected String generateProxyClassName() {
        return EJBUtils.getProxyName(this.sd, this.isRemote(), this.isHome());
    }

    protected void afterGenerateMethods(ClassVisitor cw) {
        this.generateNewCreate(cw);
        this.generateCreateWrapperInstance(cw);
    }

    private void generateNewCreate(ClassVisitor cw) {
        String wrapperName = Type.getInternalName((Class)this.wrapperClass);
        CodeVisitor mv = cw.visitMethod(33, "newCreate", "(Lcom/evermind/server/ejb/AbstractEJBContext;)Lcom/evermind/server/ejb/AbstractEJBObject;", null, null);
        mv.visitTypeInsn(187, wrapperName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "com/evermind/server/ejb/StatefulSessionContext");
        mv.visitMethodInsn(183, wrapperName, "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;)V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }

    private void generateCreateWrapperInstance(ClassVisitor cw) {
        String wrapperName = Type.getInternalName((Class)this.wrapperClass);
        CodeVisitor mv = cw.visitMethod(1, "getWrapperInstance", "(Lcom/evermind/server/ejb/StatefulSessionContext;JJLjava/lang/String;)Lcom/evermind/server/ejb/StatefulSessionEJBObject;", null, null);
        mv.visitTypeInsn(187, wrapperName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(22, 2);
        mv.visitVarInsn(22, 4);
        mv.visitVarInsn(25, 6);
        mv.visitMethodInsn(183, wrapperName, "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;JJLjava/lang/String;)V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }
}

