/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.security.User;
import com.evermind.server.RoleUser;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBPrivileged;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;

public class RunAsInterceptor
implements Interceptor {
    private RoleUser runAsUser;

    private RunAsInterceptor(RoleUser runAsUser) {
        this.runAsUser = runAsUser;
    }

    public static Interceptor getInstance(BeanDescriptor descriptor) {
        RoleUser user = descriptor.getRunAsUser();
        if (user != null) {
            return new RunAsInterceptor(user);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext ctx) throws Exception {
        RunAsHelper helper = new RunAsHelper(ctx.getCurrentThreadState(), this.runAsUser, ctx.getTarget());
        helper.setRunAsUser();
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            helper.resetRunAsUser();
        }
    }

    public static class RunAsHelper {
        private User previousUser;
        private boolean previousShieldedUser;
        private ThreadState thread;
        private RoleUser runAsUser;
        private Object target;

        public RunAsHelper(ThreadState thread, RoleUser runAsUser, Object target) {
            this.thread = thread;
            this.runAsUser = runAsUser;
            this.target = target;
        }

        public void setRunAsUser() {
            this.previousUser = EJBPrivileged.getUser(this.thread);
            this.previousShieldedUser = this.thread.shieldedUser;
            this.thread.user = this.getRunAsUser(this.previousUser, this.target);
            this.thread.shieldedUser = true;
        }

        public void resetRunAsUser() {
            this.thread.user = this.previousUser;
            this.thread.shieldedUser = this.previousShieldedUser;
        }

        protected User getRunAsUser(User user, Object wrapContext) {
            if (this.runAsUser.getShieldedUser() == user) {
                return this.runAsUser;
            }
            return new RoleUser(this.runAsUser.getRole(), user, wrapContext);
        }
    }
}

