/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.system.AbstractTxInterceptor;
import com.evermind.server.ejb.interceptor.system.TxLifecycleCallback;

public abstract class AbstractTxRetryInterceptor
extends AbstractTxInterceptor {
    protected int getMaxRetryCount(InvocationContext ctx) {
        return ctx.getMethodState().getBeanDescriptor().getMaxTxRetries();
    }

    protected boolean checkTxRetry(InvocationContext ctx, Exception e, boolean committed) throws Exception {
        boolean retry = false;
        if (e != null && !EJBUtils.isApplicationException(e)) {
            retry = true;
            TxLifecycleCallback callback = ctx.getTxLifecycleCallback();
            if (callback != null) {
                retry = callback.OC4J_transactionRetry(ctx, e);
            }
        }
        return retry;
    }

    protected void retryWait(InvocationContext ctx) throws Exception {
        long waitTime = ctx.getMethodState().getBeanDescriptor().getTxRetryWait();
        if (waitTime > 0L) {
            Thread.sleep(waitTime);
        }
    }
}

