/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.joinpoint;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.joinpoint.AbstractEJBJoinPointImpl;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBJoinPointImpl
extends AbstractEJBJoinPointImpl {
    private static Logger m_logger = EJBTraceLogger.getLogger(EJBJoinPointImpl.class);
    private Method method;

    public EJBJoinPointImpl(Method method) {
        this.setMethod(method);
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.finest("Invoking method " + this.getMethod());
            }
            return this.method.invoke(ctx.getTarget(), ctx.getParametersOrNull());
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Error invoking " + this.getMethod(), cause);
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw EJBUtils.createEJBException(new Exception(cause));
        }
    }

    public Method getMethod() {
        return this.method;
    }

    private void setMethod(Method method) {
        this.method = method;
    }
}

