/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.InitMethod;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.interceptor.EntityCreateMethodState;
import com.evermind.server.ejb.interceptor.MethodState;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MethodStateFactory {
    private MethodStateFactory() {
    }

    public static MethodState createMethodState(BeanDescriptor beanDescriptor, Method method, boolean isLocal, boolean isHome) {
        Class[] paramTypes;
        String methodName = method.getName();
        if (MethodStateFactory.shouldIgnore(beanDescriptor, isLocal, isHome, method, methodName, paramTypes = method.getParameterTypes())) {
            return null;
        }
        byte methodType = 1;
        Method beanMethod = null;
        String beanMethodName = null;
        if (MethodStateFactory.isCreateMethod(isHome, methodName)) {
            methodType = beanDescriptor.isTopLinkCMP() ? (byte)19 : 6;
            if (beanDescriptor.isStateful()) {
                SessionBeanDescriptor sessionDesc = (SessionBeanDescriptor)beanDescriptor;
                if (beanDescriptor.getEJBPackage().getCompatibility() < 3) {
                    beanMethodName = "ejbC" + methodName.substring(1);
                } else if (isLocal && sessionDesc.isAdaptedLocalHome() || !isLocal & sessionDesc.isAdaptedRemoteHome()) {
                    ArrayList methodList = sessionDesc.getInitMethod(method);
                    if (methodList != null && methodList.size() != 0) {
                        InitMethod initMethod = (InitMethod)methodList.get(0);
                        beanMethodName = initMethod.getMethodDescriptor().getName();
                    } else {
                        beanMethodName = "ejbC" + methodName.substring(1);
                    }
                } else {
                    beanMethod = beanDescriptor.getLifecycleManager().getPostConstructMethod();
                }
            } else if (methodName.equals("create") && paramTypes.length == 0) {
                beanMethod = beanDescriptor.getLifecycleManager().getPostConstructMethod();
            } else {
                beanMethodName = "ejbC" + methodName.substring(1);
            }
        } else if (MethodStateFactory.isFinderMethod(beanDescriptor, isHome, methodName)) {
            methodType = 3;
            if (!((EntityBeanDescriptor)beanDescriptor).isContainerManaged()) {
                beanMethodName = "ejbF" + methodName.substring(1);
            }
        } else if (MethodStateFactory.isRemoveMethod(beanDescriptor, isHome, methodName, paramTypes)) {
            methodType = beanDescriptor.isTopLinkCMP() ? (byte)18 : 8;
            beanMethod = beanDescriptor.getLifecycleManager().getPreDestroyMethod();
        } else if (isHome) {
            if (beanDescriptor.isSession()) {
                throw EJBUtils.createEJBException("SessionBean home interfaces cannot have arbitrarymethods defined on them: " + method);
            }
            methodType = 2;
            beanMethodName = "ejbHome" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        } else {
            beanMethodName = methodName;
        }
        if (beanMethodName != null && beanMethod == null) {
            try {
                beanMethod = beanDescriptor.getEJBClass().getMethod(beanMethodName, paramTypes);
            }
            catch (Exception e) {
                throw EJBUtils.createEJBException(e);
            }
        }
        if (methodType == 19) {
            return new EntityCreateMethodState(beanDescriptor, methodType, method, beanMethod, isLocal);
        }
        return new MethodState(beanDescriptor, methodType, method, beanMethod, isLocal, isHome);
    }

    private static boolean isCreateMethod(boolean isHome, String methodName) {
        return isHome && methodName.startsWith("create");
    }

    private static boolean isFinderMethod(BeanDescriptor beanDescriptor, boolean isHome, String methodName) {
        return isHome && methodName.startsWith("find") && beanDescriptor.isEntity();
    }

    private static boolean isRemoveMethod(BeanDescriptor beanDescriptor, boolean isHome, String methodName, Class[] paramTypes) {
        return methodName.equals("remove") && !isHome && paramTypes.length == 0 || MethodStateFactory.isHomeRemoveMethod(beanDescriptor, isHome, methodName, paramTypes);
    }

    private static boolean shouldIgnore(BeanDescriptor beanDescriptor, boolean isLocal, boolean isHome, Method method, String methodName, Class[] paramTypes) {
        return Modifier.isStatic(method.getModifiers()) || methodName.equals("<clinit>") || MethodStateFactory.isHomeRemoveMethod(beanDescriptor, isHome, methodName, paramTypes) && !beanDescriptor.isEntity() || MethodStateFactory.isGetHomeHandleMethod(isLocal, isHome, methodName, paramTypes) || MethodStateFactory.isGetEJBMetaDataMethod(isLocal, isHome, methodName, paramTypes) || MethodStateFactory.isGetPrimaryKeyMethod(isHome, methodName, paramTypes) || MethodStateFactory.isGetEJBHomeMethod(isLocal, isHome, methodName, paramTypes) || MethodStateFactory.isGetEJBLocalHomeMethod(isLocal, isHome, methodName, paramTypes) || MethodStateFactory.isGetHandleMethod(isLocal, isHome, methodName, paramTypes) || MethodStateFactory.isIsIdenticalMethod(isLocal, isHome, methodName, paramTypes);
    }

    private static boolean isHomeRemoveMethod(BeanDescriptor beanDescriptor, boolean isHome, String methodName, Class[] paramTypes) {
        return isHome && methodName.equals("remove") && paramTypes.length == 1 && (paramTypes[0].getName().equals("java.lang.Object") || paramTypes[0].getName().equals("javax.ejb.Handle"));
    }

    private static boolean isGetHomeHandleMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return isHome && !isLocal && methodName.equals("getHomeHandle") && paramTypes.length == 0;
    }

    private static boolean isGetEJBMetaDataMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return isHome && !isLocal && methodName.equals("getEJBMetaData") && paramTypes.length == 0;
    }

    private static boolean isGetPrimaryKeyMethod(boolean isHome, String methodName, Class[] paramTypes) {
        return !isHome && methodName.equals("getPrimaryKey") && paramTypes.length == 0;
    }

    private static boolean isGetEJBHomeMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return !isHome && !isLocal && methodName.equals("getEJBHome") && paramTypes.length == 0;
    }

    private static boolean isGetEJBLocalHomeMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return !isHome && isLocal && methodName.equals("getEJBLocalHome") && paramTypes.length == 0;
    }

    private static boolean isGetHandleMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return !isHome && !isLocal && methodName.equals("getHandle") && paramTypes.length == 0;
    }

    private static boolean isIsIdenticalMethod(boolean isLocal, boolean isHome, String methodName, Class[] paramTypes) {
        return !isHome && methodName.equals("isIdentical") && paramTypes.length == 1 && (!isLocal && paramTypes[0].getName().equals("javax.ejb.EJBObject") || isLocal && paramTypes[0].getName().equals("javax.ejb.EJBLocalObject"));
    }
}

