/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.QueryMethodDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ClassUtils;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.jacc.EJBMethodPermission;
import oracle.dms.instrument.NounIntf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodDescriptor
extends AbstractDescribable
implements XMLizable {
    public static final int METHOD_UNKNOWN = 0;
    public static final int METHOD_REMOTE = 1;
    public static final int METHOD_HOME = 2;
    public static final int METHOD_LOCAL = 3;
    public static final int METHOD_LOCALHOME = 4;
    public static final int METHOD_SERVICEENDPOINT = 5;
    private String beanName;
    private int methodOrigin = 0;
    private String[] params;
    protected NounIntf methodNoun = null;

    public MethodDescriptor(String beanName) {
        this.beanName = beanName;
        this.setName("*");
    }

    public MethodDescriptor(String beanName, Method method, int methodOrigin) {
        this.beanName = beanName;
        this.setName(method.getName());
        this.methodOrigin = methodOrigin;
        Class<?>[] types = method.getParameterTypes();
        this.params = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.params[i] = ClassUtils.getSourceNotation(types[i], 0);
        }
    }

    public MethodDescriptor(Node parent) throws InstantiationException {
        this.parseEjbJarXml(parent);
        if (this.beanName == null && !(this instanceof QueryMethodDescriptor)) {
            throw new InvalidEJBAssemblyException("method tag with missing ejb-name tag", "22.5");
        }
    }

    protected void parseEjbJarXml(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("ejb-name")) {
                this.beanName = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("method-intf")) {
                this.setMethodOrigin(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("method-name")) {
                String methodName = XMLUtils.getStringValue(node);
                if (methodName.compareTo("*") != 0 && methodName.indexOf(42) >= 0) {
                    throw new InvalidEJBAssemblyException("Invalid method name: " + methodName, "22.5");
                }
                this.setName(methodName);
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("method-params")) {
                this.parseMethodParams(node);
                continue;
            }
            throw new InvalidEJBAssemblyException("Unknown method subtag: " + name, "22.5");
        }
    }

    public void setMethodOrigin(String name) throws InstantiationException {
        if (name.equals("Home")) {
            this.methodOrigin = 2;
        } else if (name.equals("Remote")) {
            this.methodOrigin = 1;
        } else if (name.equals("Local")) {
            this.methodOrigin = 3;
        } else if (name.equals("LocalHome")) {
            this.methodOrigin = 4;
        } else if (name.equals("ServiceEndpoint")) {
            this.methodOrigin = 5;
        } else {
            throw new InvalidEJBAssemblyException("Illegal method-intf value: '" + name + "', legal values are 'Remote', 'Home', 'Local' and 'LocalHome'", "22.5");
        }
    }

    public MethodDescriptor(String beanName, String name) {
        this.beanName = beanName;
        this.setName(name);
    }

    protected NounIntf getMethodNoun(NounIntf beanNoun) {
        return this.methodNoun != null ? this.methodNoun : (this.methodNoun = MethodDescriptor.getTheMethodNoun(beanNoun, this.createFullMethodName()));
    }

    protected String createFullMethodName() {
        StringBuffer sb = new StringBuffer(this.getName() + "(");
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.params[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static NounIntf getTheMethodNoun(NounIntf beanNoun, String fullMethodName) {
        return ApplicationServer.nounFactory().create(beanNoun, fullMethodName, "oc4j_ejb_method");
    }

    protected void parseMethodParams(Node parent) throws InstantiationException {
        ArrayList<String> params = new ArrayList<String>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name) || !name.equals("method-param")) continue;
            String className = XMLUtils.getStringValue(node);
            try {
                MethodDescriptor.verifyClassName(className);
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Invalid method-param value, bad classname: " + e.getMessage());
            }
            params.add(className);
        }
        this.params = params.toArray(new String[params.size()]);
    }

    public static void verifyClassName(String className) throws InstantiationException {
        int length = className.length();
        if (length == 0) {
            throw new InstantiationException("cannot be empty");
        }
        char first = className.charAt(0);
        if (length <= 9) {
            switch (first) {
                case 'B': {
                    if (length != 4 || !className.equals("Byte")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                    break;
                }
                case 'C': {
                    if (length != 9 || !className.equals("Character")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                    break;
                }
                case 'D': {
                    if (length != 6 || !className.equals("Double")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                    break;
                }
                case 'I': {
                    if (length != 7 || !className.equals("Integer")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                    break;
                }
                case 'L': {
                    if (length != 4 || !className.equals("Long")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                    break;
                }
                case 'S': {
                    if (length == 5 && className.equals("Short")) {
                        MethodDescriptor.signalMistakenCoreClassname(className);
                    }
                    if (length != 6 || !className.equals("String")) break;
                    MethodDescriptor.signalMistakenCoreClassname(className);
                }
            }
        }
        if (!Character.isJavaIdentifierStart(first)) {
            throw new InstantiationException("not a legal name: '" + className + "'");
        }
    }

    private static void signalMistakenCoreClassname(String className) throws InstantiationException {
        throw new InstantiationException("must be fully qualified, ie 'java.lang." + className + "' instead of '" + className + "'");
    }

    public int implies(MethodDescriptor method) {
        if (this.beanName != null && method.beanName != null && !this.beanName.equals(method.beanName)) {
            return 0;
        }
        if (this.methodOrigin != 0 && method.methodOrigin != 0 && this.methodOrigin != method.methodOrigin) {
            return 0;
        }
        if (!(this.getName().equals("*") || method.getName().equals("*") || method.getName().equals(this.getName()))) {
            return 0;
        }
        if (this.params == null || method.params == null) {
            return this.getScope();
        }
        if (this.params.length != method.params.length) {
            return 0;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(method.params[i])) continue;
            return 0;
        }
        return this.getScope();
    }

    public int implies(String beanName, Method method, int methodOrigin) {
        if (this.beanName != null && !this.beanName.equals(beanName)) {
            return 0;
        }
        if (methodOrigin != 0 && this.methodOrigin != 0 && methodOrigin != this.methodOrigin) {
            return 0;
        }
        if (!this.getName().equals("*") && !method.getName().equals(this.getName())) {
            return 0;
        }
        if (this.params == null) {
            return this.getScope();
        }
        Class<?>[] types = method.getParameterTypes();
        if (this.params.length != types.length) {
            return 0;
        }
        for (int i = 0; i < types.length; ++i) {
            if (ClassUtils.getSourceNotation(types[i], 0).equals(this.params[i])) continue;
            return 0;
        }
        return this.getScope();
    }

    public int getScope() {
        int level = 1;
        if (this.beanName != null) {
            level += 8;
        }
        if (this.methodOrigin != 0) {
            level += 4;
        }
        if (!this.getName().equals("*")) {
            level += 2;
        }
        if (this.params != null) {
            ++level;
        }
        return level;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        String tagName = this instanceof QueryMethodDescriptor ? "query-method" : "method";
        out.println(indention + "<" + tagName + ">");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.beanName != null) {
            out.println(indention + "\t<ejb-name>" + XMLUtils.encode(this.getBeanName()) + "</ejb-name>");
        }
        if (this.methodOrigin != 0) {
            out.println(indention + "\t<method-intf>" + MethodDescriptor.getMethodOriginName(this.methodOrigin) + "</method-intf>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<method-name>" + XMLUtils.encode(this.getName()) + "</method-name>");
        } else {
            out.println(indention + "\t<method-name>*</method-name>");
        }
        if (this.params != null) {
            out.println(indention + "\t<method-params>");
            XMLUtils.writeStrings(Arrays.asList(this.params), "method-param", out, indention + "\t\t");
            out.println(indention + "\t</method-params>");
        }
        out.println(indention + "</" + tagName + ">");
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)otherObject;
        return false;
    }

    public void setParameterNames(String[] names) {
        this.params = names;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setType(int type) {
        this.methodOrigin = type;
    }

    public int getType() {
        return this.methodOrigin;
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public String toString() {
        String s = null;
        for (int i = 0; this.params != null && i < this.params.length; ++i) {
            s = i == 0 ? this.params[i] : s + ", " + this.params[i];
        }
        return this.beanName + "." + this.getName() + "(" + s + ")";
    }

    public static String getMethodOriginName(int type) {
        switch (type) {
            case 1: {
                return "Remote";
            }
            case 2: {
                return "Home";
            }
            case 3: {
                return "Local";
            }
            case 4: {
                return "LocalHome";
            }
            case 5: {
                return "ServiceEndpoint";
            }
        }
        return "Unknown";
    }

    public EJBMethodPermission toEJBMethodPermission() {
        return new EJBMethodPermission(this.beanName, this.getName(), MethodDescriptor.getMethodOriginName(this.methodOrigin), this.params);
    }
}

