/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.ActivationConfig;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDrivenBeanDescriptorXMLFactory
extends BeanDescriptorXMLFactory {
    private static MessageDrivenBeanDescriptorXMLFactory instance = new MessageDrivenBeanDescriptorXMLFactory();

    private MessageDrivenBeanDescriptorXMLFactory() {
    }

    public static MessageDrivenBeanDescriptorXMLFactory getInstance() {
        return instance;
    }

    protected boolean parseEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        boolean ejb30;
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        String name = node.getNodeName();
        String value = XMLUtils.getStringValue(node);
        boolean bl = ejb30 = descriptor.getEJBPackage().getCompatibility() >= 3;
        if (name.equals("transaction-type")) {
            this.parseTransactionType(desc, value);
        } else {
            if (ejb30 && name.equals("callback-listener")) {
                throw new InstantiationException("<callback-listener> has been removed from the spec and is unsupported.  Please place your callbacks on an interceptor class and use <interceptor> and <interceptor-binding> instead.");
            }
            if (!ejb30 || !descriptor.getBeanInterceptor().parseCallbackMethod(desc, name, node)) {
                if (ejb30 && name.equals("timeout-method")) {
                    String methodName = XMLUtils.getSubnodeValue(node, "method-name");
                    if (methodName == null) {
                        throw new InvalidEJBAssemblyException("Missing <method-name> from <timeout-method>");
                    }
                    descriptor.setTimeoutMethodName(methodName);
                } else if (name.equals("message-selector")) {
                    descriptor.setMessageSelector(value);
                } else if (name.equals("acknowledge-mode")) {
                    descriptor.setAcknowledgeMode(this.parseAcknowledgeMode(value));
                } else if (name.equals("message-driven-destination")) {
                    this.parseMessageDrivenDestination(descriptor, node);
                } else if (name.equals("messaging-type")) {
                    descriptor.setMessagingType(value);
                } else if (name.equals("message-destination-type")) {
                    descriptor.setDestinationType(value);
                } else if (name.equals("message-destination-link")) {
                    descriptor.setDestinationLink(value);
                } else if (name.equals("activation-config")) {
                    this.parseActivationConfig(descriptor, node);
                } else {
                    return super.parseEJBJarXMLNode(descriptor, node);
                }
            }
        }
        return true;
    }

    private int parseAcknowledgeMode(String mode) throws InstantiationException {
        if (mode.equalsIgnoreCase("Auto-acknowledge")) {
            return 1;
        }
        if (mode.equalsIgnoreCase("Dups-ok-acknowledge")) {
            return 3;
        }
        throw new InvalidEJBAssemblyException("Illegal acknowledge mode: " + mode + " (legal values are 'Auto-acknowledge' and 'Dups-ok-acknowledge')", "22.5");
    }

    private String getAcknowledgeModeString(int mode) {
        if (mode == 1) {
            return "Auto-acknowledge";
        }
        if (mode == 3) {
            return "Dups-ok-acknowledge";
        }
        throw new RuntimeException("Unknow acknowledge-mode: " + mode);
    }

    private void parseMessageDrivenDestination(MessageDrivenBeanDescriptor descriptor, Node node) throws InstantiationException {
        descriptor.setDestinationType(XMLUtils.getSubnodeValue(node, "destination-type"));
        String durableString = XMLUtils.getSubnodeValue(node, "subscription-durability");
        if (durableString != null) {
            if (durableString.equalsIgnoreCase("Durable")) {
                descriptor.setDurable(true);
            } else if (durableString.equalsIgnoreCase("NonDurable")) {
                descriptor.setDurable(false);
            } else {
                throw new InvalidEJBAssemblyException("Illegal subscription-durability value: " + durableString + ", legal values are Durable and NonDurable", "22.5");
            }
        }
    }

    private void parseActivationConfig(MessageDrivenBeanDescriptor descriptor, Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("activation-config-property")) {
                    ActivationConfig config = new ActivationConfig(node, "activation-config-property");
                    descriptor.addActivationConfigProperty(config);
                    descriptor.addOracleActivationConfig(new ActivationConfig(config.getName(), config.getDescription(), config.getStringValue(), "config-property"));
                    continue;
                }
                throw new InstantiationException("Unknown activation-config subtag: " + name);
            }
        }
    }

    protected boolean parseOracleEJBJarXMLAttribute(BeanDescriptor desc, String name, String value) throws InstantiationException {
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        if (name.equals("max-instances")) {
            descriptor.setMaxInstances(XMLUtils.parseInt("max-instances", value));
        } else if (name.equals("min-instances")) {
            descriptor.setMinInstances(XMLUtils.parseInt("min-instances", value));
        } else if (!name.equals("location")) {
            if (name.equals("cache-timeout")) {
                descriptor.setCacheTimeout(this.parseNeverStringOrInt("cache-timeout", value));
            } else if (name.equals("destination-location")) {
                descriptor.setDestinationLocation(value);
            } else if (name.equals("connection-factory-location")) {
                descriptor.setConnectionFactoryLocation(value);
            } else if (name.equals("subscription-name")) {
                descriptor.setSubscriptionName(value);
            } else if (name.equals("res-user")) {
                descriptor.setResUser(value);
            } else if (name.equals("res-password")) {
                descriptor.setResPassword(value);
            } else if (name.equals("listener-threads")) {
                descriptor.setListenerThreads(XMLUtils.parseInt("listener-threads", value));
            } else if (name.equals("dequeue-retry-count")) {
                descriptor.setDequeueRetryCount(XMLUtils.parseInt("dequeue-retry-count", value));
            } else if (name.equals("dequeue-retry-interval")) {
                descriptor.setDequeueRetryInterval(XMLUtils.parseInt("dequeue-retry-interval", value));
            } else if (name.equals("transaction-timeout")) {
                descriptor.setTransactionTimeout(XMLUtils.parseInt("transaction-timeout", value));
            } else if (!name.equals("wrapper-class")) {
                if (name.equals("resource-adapter")) {
                    descriptor.setResourceAdapter(value);
                } else if (name.equals("enabled")) {
                    descriptor.setEnabled(XMLUtils.parseBoolean("enabled", value));
                } else if (name.equals("max-delivery-count")) {
                    descriptor.setMaxDeliveryCount(XMLUtils.parseInt("max-delivery-count", value));
                } else if (descriptor.getEJBPackage().getCompatibility() >= 3 && name.equals("interceptor-type")) {
                    descriptor.setInterceptorType(value);
                } else {
                    return super.parseOracleEJBJarXMLAttribute(descriptor, name, value);
                }
            }
        }
        return true;
    }

    protected boolean parseOracleEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        String name = node.getNodeName();
        if (name.equals("config-property")) {
            ActivationConfig oracleConfigFromXML = new ActivationConfig(node, "config-property");
            ActivationConfig oracleConfigExisting = descriptor.findOracleActivationConfig(oracleConfigFromXML);
            if (oracleConfigExisting != null && oracleConfigFromXML.getStringValue() != null) {
                oracleConfigExisting.setStringValue(oracleConfigFromXML.getStringValue());
                return true;
            }
        } else {
            return super.parseOracleEJBJarXMLNode(descriptor, node);
        }
        descriptor.addOracleActivationConfig(new ActivationConfig(node, "config-property"));
        return true;
    }

    public void writeOracleEJBJarXML(BeanDescriptor desc, PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "message-driven-deployment" + this.getOracleEJBJarXMLAttributes(desc) + ">");
        super.writeOracleEJBJarXML(desc, out, indentation);
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        List configs = descriptor.getOracleActivationConfigs();
        Iterator i = configs.iterator();
        while (i.hasNext()) {
            ((ActivationConfig)i.next()).writeOrionXML(out, indentation);
        }
        out.println(indentation + "</" + "message-driven-deployment" + ">");
    }

    public void writeEJBJarXML(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "message-driven" + ">");
        super.writeEJBJarXML(descriptor, out, indentation);
        out.println(indentation + "</" + "message-driven" + ">");
    }

    protected String getOracleEJBJarXMLAttributes(BeanDescriptor desc) {
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        StringBuffer attributes = new StringBuffer();
        this.appendAttribute("name", descriptor.getName(), attributes);
        this.appendAttribute("destination-location", descriptor.getDestinationLocation(), attributes);
        this.appendAttribute("connection-factory-location", descriptor.getConnectionFactoryLocation(), attributes);
        this.appendAttribute("subscription-name", descriptor.getSubscriptionName(), attributes);
        if (descriptor.getResUser() != null && descriptor.getResPassword() != null) {
            this.appendAttribute("res-user", descriptor.getResUser(), attributes);
            this.appendAttribute("res-password", descriptor.getResPassword(), attributes);
        }
        if (descriptor.getListenerThreads() != 1) {
            this.appendAttribute("listener-threads", String.valueOf(descriptor.getListenerThreads()), attributes);
        }
        if (descriptor.getDequeueRetryCount() != 0) {
            this.appendAttribute("dequeue-retry-count", String.valueOf(descriptor.getDequeueRetryCount()), attributes);
        }
        if (descriptor.getDequeueRetryInterval() != 60) {
            this.appendAttribute("dequeue-retry-interval", String.valueOf(descriptor.getDequeueRetryInterval()), attributes);
        }
        if (descriptor.getTransactionTimeout() != 86400) {
            this.appendAttribute("transaction-timeout", String.valueOf(descriptor.getTransactionTimeout()), attributes);
        }
        if (descriptor.getMaxInstances() != 0) {
            this.appendAttribute("max-instances", String.valueOf(descriptor.getMaxInstances()), attributes);
        }
        if (descriptor.getMinInstances() != 0) {
            this.appendAttribute("min-instances", String.valueOf(descriptor.getMinInstances()), attributes);
        }
        if (descriptor.getCacheTimeout() != 60) {
            this.appendAttribute("pool-cache-timeout", this.getIntAsStringOrNever(descriptor.getCacheTimeout()), attributes);
        }
        this.appendAttribute("resource-adapter", descriptor.getResourceAdapter(), attributes);
        if (!descriptor.isEnabled()) {
            this.appendAttribute("enabled", "false", attributes);
        }
        if (descriptor.getMaxDeliveryCount() != 5) {
            this.appendAttribute("max-delivery-count", String.valueOf(descriptor.getMaxDeliveryCount()), attributes);
        }
        if (descriptor.getInterceptorType() != "default") {
            this.appendAttribute("interceptor-type", descriptor.getInterceptorType(), attributes);
        }
        return attributes.toString();
    }

    protected void writeBeanSpecificEJBJarXMLTags(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        MessageDrivenBeanDescriptor mdbDescriptor = (MessageDrivenBeanDescriptor)descriptor;
        this.writeTag("ejb-class", mdbDescriptor.getEJBClassName(), out, indentation);
        this.writeTag("messaging-type", mdbDescriptor.getMessagingType(), out, indentation);
        this.writeTag("transaction-type", this.getTransactionTypeString(mdbDescriptor.getTransactionType()), out, indentation);
        if (descriptor.getEJBPackage().getCompatibility() >= 2) {
            this.writeTag("message-destination-type", mdbDescriptor.getDestinationType(), out, indentation);
            this.writeTag("message-destination-link", mdbDescriptor.getDestinationLink(), out, indentation);
            XMLUtils.writeAll(mdbDescriptor.getActivationConfigs(), out, indentation + "\t");
        } else {
            this.writeTag("message-selector", mdbDescriptor.getMessageSelector(), out, indentation);
            this.writeTag("acknowledge-mode", this.getAcknowledgeModeString(mdbDescriptor.getAcknowledgeMode()), out, indentation);
            out.println(indentation + "\t<" + "message-driven-destination" + ">");
            this.writeTag("destination-type", mdbDescriptor.getDestinationType(), out, indentation + "\t");
            this.writeTag("subscription-durability", mdbDescriptor.isDurable() ? "Durable" : "NonDurable", out, indentation + "\t");
            out.println(indentation + "\t</" + "message-driven-destination" + ">");
        }
    }

    protected void validateBeanTypeOverridden(BeanDescriptor descriptor, Node rootNode, boolean isEjbJar) throws InstantiationException {
        if (isEjbJar && !rootNode.getNodeName().equals("message-driven") || !isEjbJar && !rootNode.getNodeName().equals("message-driven-deployment")) {
            this.failOnBeanTypeMismatch(descriptor, rootNode.getNodeName(), isEjbJar);
        }
    }
}

