/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.deployment.SecurityIdentity;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.ejb.deployment.IorConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BeanDescriptorXMLFactory {
    protected BeanDescriptorXMLFactory() {
    }

    public final void parseEJBJarXML(BeanDescriptor descriptor, Node rootNode) throws InstantiationException {
        this.validateBeanTypeOverridden(descriptor, rootNode, true);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (XMLUtils.isCommentOrID(node.getNodeName()) || this.parseEJBJarXMLNode(descriptor, node)) continue;
            throw new InvalidEJBAssemblyException("Unknown <" + rootNode.getNodeName() + "> subtag: " + node.getNodeName(), "22.5");
        }
    }

    protected abstract void validateBeanTypeOverridden(BeanDescriptor var1, Node var2, boolean var3) throws InstantiationException;

    protected void failOnBeanTypeMismatch(BeanDescriptor desc, String beanType, boolean isEjbJar) throws InstantiationException {
        String ddXml = isEjbJar ? "ejb-jar.xml" : "orion-ejb-jar.xml";
        EJBDeploymentMessages.warningBeanTypeMismatch(desc, ddXml, beanType);
    }

    protected boolean parseEJBJarXMLNode(BeanDescriptor descriptor, Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (descriptor.getConfigDelegate().parseNode(node)) {
            return true;
        }
        String value = XMLUtils.getStringValue(node);
        if (name.equals("description")) {
            descriptor.setDescription(value);
        } else if (name.equals("display-name")) {
            descriptor.setDisplayName(value);
        } else if (name.equals("small-icon")) {
            descriptor.setSmallIcon(value);
        } else if (name.equals("large-icon")) {
            descriptor.setLargeIcon(value);
        } else if (name.equals("ejb-name")) {
            descriptor.setName(value);
        } else if (name.equals("ejb-class")) {
            descriptor.setEJBClassName(value);
        } else if (name.equals("security-identity")) {
            descriptor.setSecurityIdentity(new SecurityIdentity(node));
        } else if (name.equals("security-role-ref")) {
            descriptor.addSecurityRoleReference(new SecurityRoleReference(node));
        } else if (name.equals("mapped-name") && value.length() > 0) {
            EJBDeploymentMessages.warningIgnoredTag("<entity> or <session> or <message-driven>", "mapped-name");
        } else {
            return false;
        }
        return true;
    }

    protected void parseTransactionType(BeanDescriptor desc, String mode) throws InstantiationException {
        int txType = -1;
        if (mode.equalsIgnoreCase("Bean")) {
            txType = 1;
        } else if (mode.equalsIgnoreCase("Container")) {
            txType = 0;
        } else {
            throw new InvalidEJBAssemblyException("Unknown transaction-type: " + mode + " (must be either Bean or Container)", "17.3.6");
        }
        if (desc.getTransactionType() == -1) {
            desc.setTransactionType(txType);
        } else if (desc.getTransactionType() != txType) {
            EJBDeploymentMessages.warningTxTypeMismatch(desc, mode);
        }
    }

    protected String getTransactionTypeString(int mode) {
        if (mode == 1) {
            return "Bean";
        }
        if (mode == 0) {
            return "Container";
        }
        throw new RuntimeException("Unknown transaction-type: " + mode);
    }

    public final void parseOracleEJBJarXML(BeanDescriptor descriptor, Node rootNode) throws InstantiationException {
        this.validateBeanTypeOverridden(descriptor, rootNode, false);
        NamedNodeMap attributes = rootNode.getAttributes();
        for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (this.parseOracleEJBJarXMLAttribute(descriptor, attribute.getNodeName(), attribute.getNodeValue())) continue;
            throw new InvalidEJBAssemblyException("Unknown <" + rootNode.getNodeName() + "> attribute: " + attribute.getNodeName(), "22.5");
        }
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (XMLUtils.isCommentOrID(node.getNodeName()) || this.parseOracleEJBJarXMLNode(descriptor, node)) continue;
            throw new InvalidEJBAssemblyException("Unknown <" + rootNode.getNodeName() + "> subtag: " + node.getNodeName(), "22.5");
        }
    }

    protected boolean parseOracleEJBJarXMLAttribute(BeanDescriptor descriptor, String name, String value) throws InstantiationException {
        if (!name.equals("name")) {
            if (name.equals("max-tx-retries")) {
                descriptor.setMaxTxRetries(XMLUtils.parseInt("max-tx-retries", value));
            } else if (name.equals("tx-retry-wait")) {
                descriptor.setTxRetryWait(XMLUtils.parseInt("tx-retry-wait", value));
            } else if (name.equals("max-instances")) {
                descriptor.setMaxInstances(XMLUtils.parseInt("max-instances", value));
            } else if (name.equals("min-instances")) {
                descriptor.setMinInstances(XMLUtils.parseInt("min-instances", value));
            } else if (name.equals("pool-cache-timeout")) {
                descriptor.setCacheTimeout(this.parseNeverStringOrInt("pool-cache-timeout", value));
            } else if (name.equals("copy-by-value")) {
                descriptor.setCopyByValue(XMLUtils.parseBoolean("copy-by-value", value));
            } else if (name.equals("call-timeout")) {
                descriptor.setCallTimeout(XMLUtils.parseLong("call-timeout", value));
            } else {
                return false;
            }
        }
        return true;
    }

    protected int parseNeverStringOrInt(String tagName, String value) throws InstantiationException {
        if (value.equalsIgnoreCase("never")) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InstantiationException("Illegal " + tagName + " value: '" + value + "', must be numeric or 'never'");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseOracleEJBJarXMLNode(BeanDescriptor descriptor, Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("ejb-ref-mapping")) {
            EJBReference eJBReference;
            String referenceName = XMLUtils.getNodeAttribute(node, "name");
            if (referenceName == null || (eJBReference = descriptor.getEJBReference(referenceName)) == null) return true;
            eJBReference.parseOrionXML(node);
            return true;
        } else if (name.equals("service-ref-mapping")) {
            String referenceName = XMLUtils.getNodeAttribute(node, "name");
            if (referenceName == null) throw new InstantiationException("service-ref-mapping with missing name attribute");
            ServiceReferenceDescriptor serviceReferenceDescriptor = descriptor.getServiceReference(referenceName);
            if (serviceReferenceDescriptor == null) return true;
            serviceReferenceDescriptor.parseOrionXML(node);
            return true;
        } else if (name.equals("resource-ref-mapping")) {
            void var5_14;
            String resName = XMLUtils.getNodeAttribute(node, "name");
            if (resName == null) throw new InstantiationException("resource-ref-mapping with missing name attribute");
            ResourceReference resourceReference = descriptor.getResourceReference(resName);
            if (resourceReference == null) {
                ResourceEnvironmentReference resourceEnvironmentReference = descriptor.getResourceEnvironmentReference(resName);
            }
            if (var5_14 == null) return true;
            var5_14.parseOrionXML(node);
            return true;
        } else if (name.equals("resource-env-ref-mapping")) {
            String resName = XMLUtils.getNodeAttribute(node, "name");
            if (resName == null) throw new InstantiationException("resource-env-ref-mapping with missing name attribute");
            ResourceEnvironmentReference resourceEnvironmentReference = descriptor.getResourceEnvironmentReference(resName);
            if (resourceEnvironmentReference == null) return true;
            resourceEnvironmentReference.parseOrionXML(node);
            return true;
        } else if (name.equals("message-destination-ref-mapping")) {
            String resName = XMLUtils.getNodeAttribute(node, "name");
            if (resName == null) throw new InstantiationException("message-destination-ref-mapping with missing name attribute");
            DestinationReference destinationReference = descriptor.getDestinationReference(resName);
            if (destinationReference == null) return true;
            destinationReference.parseOrionXML(node);
            return true;
        } else if (name.equals("env-entry-mapping")) {
            EnvironmentEntry environmentEntry;
            String entryName = XMLUtils.getNodeAttribute(node, "name");
            if (entryName == null || (environmentEntry = descriptor.getEnvironmentEntry(entryName)) == null) return true;
            environmentEntry.parseOrionXML(node);
            return true;
        } else {
            if (!name.equals("ior-security-config")) return false;
            descriptor.getIorConfigurations().add(IorConfig.parse(node));
        }
        return true;
    }

    public void writeEJBJarXML(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        EntityBeanDescriptor entityDescriptor;
        this.writeTag("description", descriptor.getDescription(), out, indentation);
        this.writeTag("display-name", descriptor.getDisplayName(), out, indentation);
        this.writeTag("small-icon", descriptor.getSmallIcon(), out, indentation);
        this.writeTag("large-icon", descriptor.getLargeIcon(), out, indentation);
        this.writeTag("ejb-name", descriptor.getName(), out, indentation);
        this.writeBeanSpecificEJBJarXMLTags(descriptor, out, indentation);
        if (descriptor.getEJBPackage().getCompatibility() >= 3 && descriptor.getBeanInterceptor() != null) {
            descriptor.getBeanInterceptor().writeXML(out, indentation);
        }
        XMLUtils.writeAll(descriptor.getEnvironmentEntries(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getEJBReferences(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getResourceReferences(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getResourceEnvironmentReferences(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getSecurityRoleReferences(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getPersistenceUnitReferences(), out, indentation + "\t");
        XMLUtils.writeAll(descriptor.getPersistenceContextReferences(), out, indentation + "\t");
        if (descriptor.getSecurityIdentity() != null) {
            descriptor.getSecurityIdentity().writeXML(out, indentation + "\t");
        }
        if (descriptor.isEntity() && (entityDescriptor = (EntityBeanDescriptor)descriptor).getQueries() != null) {
            XMLUtils.writeAll(entityDescriptor.getQueries(), out, indentation + "\t");
        }
    }

    public void writeOracleEJBJarXML(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        String indent = indentation + "\t";
        Iterator i = descriptor.getEnvironmentEntries().iterator();
        while (i.hasNext()) {
            EnvironmentEntry entry = (EnvironmentEntry)i.next();
            if (!entry.hasRuntimeValue()) continue;
            entry.writeOrionXML(out, indent);
        }
        i = descriptor.getEJBReferences().iterator();
        while (i.hasNext()) {
            ((EJBReference)i.next()).writeOrionXML(out, indent);
        }
        i = descriptor.getServiceReferences().iterator();
        while (i.hasNext()) {
            ((ServiceReferenceDescriptor)i.next()).writeOrionXML(out, indent);
        }
        i = descriptor.getIorConfigurations().iterator();
        while (i.hasNext()) {
            ((IorConfig)i.next()).writeXml(out, indent);
        }
        i = descriptor.getResourceReferences().iterator();
        while (i.hasNext()) {
            ((ResourceReference)i.next()).writeOrionXML(out, indent);
        }
        i = descriptor.getResourceEnvironmentReferences().iterator();
        while (i.hasNext()) {
            ((ResourceEnvironmentReference)i.next()).writeOrionXML(out, indent);
        }
        i = descriptor.getDestinationReferences().iterator();
        while (i.hasNext()) {
            ((DestinationReference)i.next()).writeOrionXML(out, indent);
        }
    }

    protected String getOracleEJBJarXMLAttributes(BeanDescriptor descriptor) {
        StringBuffer attributes = new StringBuffer();
        this.appendAttribute("name", descriptor.getName(), attributes);
        if (descriptor.getMaxTxRetries() != 0) {
            this.appendAttribute("max-tx-retries", String.valueOf(descriptor.getMaxTxRetries()), attributes);
        }
        if (descriptor.getTxRetryWait() != 0L) {
            this.appendAttribute("tx-retry-wait", String.valueOf(descriptor.getTxRetryWait()), attributes);
        }
        if (!descriptor.isCopyByValue()) {
            this.appendAttribute("copy-by-value", String.valueOf(descriptor.isCopyByValue()), attributes);
        }
        if (descriptor.getMaxInstances() != 0) {
            this.appendAttribute("max-instances", String.valueOf(descriptor.getMaxInstances()), attributes);
        }
        if (descriptor.getMinInstances() != 0) {
            this.appendAttribute("min-instances", String.valueOf(descriptor.getMinInstances()), attributes);
        }
        if (descriptor.getCacheTimeout() != 60) {
            this.appendAttribute("pool-cache-timeout", this.getIntAsStringOrNever(descriptor.getCacheTimeout()), attributes);
        }
        if (descriptor.getCallTimeout() != 90000L) {
            this.appendAttribute("call-timeout", String.valueOf(descriptor.getCallTimeout()), attributes);
        }
        return attributes.toString();
    }

    protected String getIntAsStringOrNever(int timeout) {
        if (timeout < 0) {
            return "never";
        }
        return String.valueOf(timeout);
    }

    protected void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }

    protected void appendAttribute(String attributeName, String attributeValue, StringBuffer out) {
        if (attributeValue != null) {
            out.append(" ");
            out.append(attributeName);
            out.append("=\"");
            out.append(attributeValue);
            out.append("\"");
        }
    }

    protected abstract void writeBeanSpecificEJBJarXMLTags(BeanDescriptor var1, PrintWriter var2, String var3) throws IOException;
}

