/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ejb.cache.IntQuickMap;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AlternateHashTable {
    private int _numberOfBuckets;
    private Bucket[] _buckets;
    private IntQuickMap _alternateToPrimary;
    private static Logger m_logger = EJBTraceLogger.getLogger(AlternateHashTable.class);

    public AlternateHashTable(int initialCapacity) {
        this._numberOfBuckets = initialCapacity;
        this.init();
    }

    public abstract Object cloneValue(Object var1, boolean var2);

    public abstract Object copyValue(Object var1, Object var2, boolean var3);

    public abstract boolean isKeyEqual(Object var1, Object var2);

    public abstract int keyHashCode(Object var1);

    public abstract int altKeyHashCode(Object var1);

    public abstract boolean hasExpired(BucketEntry var1, Bucket var2, int var3);

    public abstract void updateAccess(BucketEntry var1, Bucket var2);

    public abstract long getTime();

    private void init() {
        this._buckets = new Bucket[this._numberOfBuckets];
        this._alternateToPrimary = new IntQuickMap(this._numberOfBuckets);
        for (int i = 0; i < this._numberOfBuckets; ++i) {
            this._buckets[i] = new Bucket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, boolean alternate) {
        Bucket b;
        Object result = null;
        Bucket bucket = b = this.getBucket(key, alternate);
        synchronized (bucket) {
            BucketEntry currNode = b.head;
            while (currNode != null) {
                if (this.isKeyEqual(currNode.key, key)) {
                    this.updateAccess(currNode, b);
                    result = currNode.value;
                    break;
                }
                currNode = currNode.next;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClone(Object key, boolean alternate) {
        Bucket b;
        Object result = null;
        Bucket bucket = b = this.getBucket(key, alternate);
        synchronized (bucket) {
            BucketEntry currNode = b.head;
            while (currNode != null) {
                if (this.isKeyEqual(currNode.key, key)) {
                    this.updateAccess(currNode, b);
                    result = this.cloneValue(currNode.value, false);
                    break;
                }
                currNode = currNode.next;
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "+ number of instance in cache " + key + " " + this._buckets.length + " ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClone(Object key, Object dest, boolean alternate) {
        Bucket b;
        Object result = null;
        Bucket bucket = b = this.getBucket(key, alternate);
        synchronized (bucket) {
            BucketEntry currNode = b.head;
            while (currNode != null) {
                if (this.isKeyEqual(currNode.key, key)) {
                    this.updateAccess(currNode, b);
                    result = this.copyValue(currNode.value, dest, false);
                    break;
                }
                currNode = currNode.next;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object altKey, Object value) {
        if (value == null) {
            throw new NullPointerException("value is Null !!!");
        }
        int hashkey = this.keyHashCode(key);
        Bucket b = this.getBucket(hashkey, false);
        Object lastValue = null;
        Bucket bucket = b;
        synchronized (bucket) {
            BucketEntry currNode = b.head;
            while (currNode != null) {
                if (this.isKeyEqual(currNode.key, key)) {
                    lastValue = currNode.value;
                    this.updateAccess(currNode, b);
                    currNode.value = this.copyValue(value, lastValue, true);
                    break;
                }
                currNode = currNode.next;
            }
            if (currNode == null) {
                currNode = new BucketEntry(hashkey, key, altKey, value, b.head);
                if (altKey != null) {
                    this.setAlternateToPrimary(hashkey, this.altKeyHashCode(altKey));
                }
                ++b.entries;
                this.updateAccess(currNode, b);
                b.head = currNode;
            }
        }
        return lastValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putClone(Object key, Object altKey, Object value) {
        if (value == null) {
            throw new NullPointerException("value is Null !!!");
        }
        int hashkey = this.keyHashCode(key);
        Bucket b = this.getBucket(hashkey, false);
        Object lastValue = null;
        Bucket bucket = b;
        synchronized (bucket) {
            BucketEntry currNode = b.head;
            while (currNode != null) {
                if (this.isKeyEqual(currNode.key, key)) {
                    lastValue = currNode.value;
                    this.updateAccess(currNode, b);
                    currNode.value = this.copyValue(value, lastValue, true);
                    break;
                }
                currNode = currNode.next;
            }
            if (currNode == null) {
                currNode = new BucketEntry(hashkey, key, altKey, this.cloneValue(value, false), b.head);
                if (altKey != null) {
                    this.setAlternateToPrimary(hashkey, this.altKeyHashCode(altKey));
                }
                ++b.entries;
                this.updateAccess(currNode, b);
                b.head = currNode;
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "+ number of instance in cache " + key + " " + this._buckets.length + " ");
        }
        return lastValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key, boolean alternate) {
        Bucket b;
        Object result = null;
        Bucket bucket = b = this.getBucket(key, alternate);
        synchronized (bucket) {
            BucketEntry c = b.head;
            BucketEntry p = null;
            while (c != null) {
                if (this.isKeyEqual(c.key, key)) {
                    this.updateAccess(c, b);
                    result = c.value;
                    if (p == null) {
                        b.head = c.next;
                    } else {
                        p.next = c.next;
                    }
                    if (c.altKey != null) {
                        this.removeAlternateHash(this.altKeyHashCode(c.altKey));
                    }
                    --b.entries;
                    break;
                }
                p = c;
                c = c.next;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int cleanUp(int ttl) {
        int removed = 0;
        long maxAccess = 0L;
        Bucket b = null;
        try {
            for (int i = 0; i < this._numberOfBuckets; ++i) {
                Bucket bucket = b = this._buckets[i];
                synchronized (bucket) {
                    BucketEntry c = b.head;
                    BucketEntry p = null;
                    maxAccess = b.access;
                    while (c != null) {
                        if (this.hasExpired(c, b, ttl)) {
                            if (p == null) {
                                b.head = c.next;
                            } else {
                                p.next = c.next;
                            }
                            if (c.altKey != null) {
                                this.removeAlternateHash(this.altKeyHashCode(c.altKey));
                            }
                            --b.entries;
                            ++removed;
                            c = c.next;
                            continue;
                        }
                        if (c.access > maxAccess) {
                            maxAccess = c.access;
                        }
                        p = c;
                        c = c.next;
                    }
                    b.access = maxAccess;
                    continue;
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("WARNING Cache.cleanUp " + ttl + " error= " + e.getMessage());
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this._numberOfBuckets; ++i) {
            Bucket bucket = this._buckets[i];
            synchronized (bucket) {
                this._buckets[i].head = null;
                continue;
            }
        }
        this._alternateToPrimary.clear();
    }

    public synchronized boolean containsKey(Object key, boolean alternate) {
        Object obj = this.get(key, alternate);
        return obj != null;
    }

    private final Bucket getBucket(Object key, boolean alternate) {
        int hashkey = alternate ? this.altKeyHashCode(key) : this.keyHashCode(key);
        return this.getBucket(hashkey, alternate);
    }

    protected final Bucket getBucket(int hashkey, boolean alternate) {
        if (alternate) {
            hashkey = this.getPrimaryHash(hashkey);
        }
        if (hashkey < 0) {
            hashkey = -hashkey;
        }
        return this._buckets[hashkey % this._numberOfBuckets];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPrimaryHash(int alternate) {
        IntQuickMap intQuickMap = this._alternateToPrimary;
        synchronized (intQuickMap) {
            return this._alternateToPrimary.get(alternate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setAlternateToPrimary(int primary, int alternate) {
        IntQuickMap intQuickMap = this._alternateToPrimary;
        synchronized (intQuickMap) {
            return this._alternateToPrimary.put(alternate, primary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAlternateHash(int alternate) {
        IntQuickMap intQuickMap = this._alternateToPrimary;
        synchronized (intQuickMap) {
            return this._alternateToPrimary.remove(alternate);
        }
    }

    public long size() {
        long numberOfObjects = 0L;
        Bucket b = null;
        for (int i = 0; i < this._numberOfBuckets; ++i) {
            b = this._buckets[i];
            numberOfObjects += (long)b.entries;
        }
        return numberOfObjects;
    }

    protected final class Bucket {
        public BucketEntry head = null;
        public int entries = 0;
        public long access = 0L;

        protected Bucket() {
        }
    }

    protected final class BucketEntry {
        public int hash;
        public Object key;
        public Object altKey;
        public Object value;
        public BucketEntry next = null;
        public long access = 0L;

        public BucketEntry(Object key, Object altKey, Object value, BucketEntry next) {
            this.hash = AlternateHashTable.this.keyHashCode(key);
            this.key = key;
            this.altKey = altKey;
            this.value = value;
            this.next = next;
            this.access = AlternateHashTable.this.getTime();
        }

        public BucketEntry(int hash, Object key, Object altKey, Object value, BucketEntry next) {
            this.hash = hash;
            this.key = key;
            this.altKey = altKey;
            this.value = value;
            this.next = next;
            this.access = AlternateHashTable.this.getTime();
        }
    }
}

