/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.io.IOUtils;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.CMRCollectionField;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.EJBOutputStream;
import com.evermind.server.ejb.EJBThreadContext;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.ORCollection;
import com.evermind.server.ejb.ORSet;
import com.evermind.server.ejb.deployment.ApplicationException;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.CollectionEnumeration;
import com.evermind.util.EJBProperties;
import com.oracle.naming.J2EEContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.rmi.CORBA.Stub;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassPreprocessor;
import oracle.classloader.util.ClassPreprocessorSequence;
import oracle.j2ee.ejb.TimeoutExpiredException;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.transport.TransportManager;

public class EJBUtils {
    static Logger m_logger = EJBTraceLogger.getLogger(EJBUtils.class);
    private static final String JDK50_MARKER_METHOD = "getDeclaredAnnotations";
    private static Boolean isJdk50;
    private static SecureRandom randomGenerator;
    private static Method parseApplicationExceptionAnnotationMethod;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$javax$jms$ConnectionFactory;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$TopicConnectionFactory;
    static /* synthetic */ Class class$javax$resource$cci$ConnectionFactory;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$com$evermind$server$ejb$StatelessSessionEJBObject;

    public static Integer getInteger(ResultSet set, int index) throws SQLException {
        int value = set.getInt(index);
        if (set.wasNull()) {
            return null;
        }
        return new Integer(value);
    }

    public static Float getFloat(ResultSet set, int index) throws SQLException {
        float value = set.getFloat(index);
        if (set.wasNull()) {
            return null;
        }
        return new Float(value);
    }

    public static Long getLong(ResultSet set, int index) throws SQLException {
        long value = set.getLong(index);
        if (set.wasNull()) {
            return null;
        }
        return new Long(value);
    }

    public static Double getDouble(ResultSet set, int index) throws SQLException {
        double value = set.getDouble(index);
        if (set.wasNull()) {
            return null;
        }
        return new Double(value);
    }

    public static Byte getByte(ResultSet set, int index) throws SQLException {
        byte value = set.getByte(index);
        if (set.wasNull()) {
            return null;
        }
        return new Byte(value);
    }

    public static Character getCharacter(ResultSet set, int index) throws SQLException {
        String value = set.getString(index);
        if (set.wasNull() || value == null || value.length() < 1) {
            return null;
        }
        return new Character(value.charAt(0));
    }

    public static Short getShort(ResultSet set, int index) throws SQLException {
        short value = set.getShort(index);
        if (set.wasNull()) {
            return null;
        }
        return new Short(value);
    }

    public static Boolean getBoolean(ResultSet set, int index) throws SQLException {
        boolean value = set.getBoolean(index);
        if (set.wasNull()) {
            return null;
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Integer getInteger(ResultSet set, String index) throws SQLException {
        int value = set.getInt(index);
        if (set.wasNull()) {
            return null;
        }
        return new Integer(value);
    }

    public static Float getFloat(ResultSet set, String index) throws SQLException {
        float value = set.getFloat(index);
        if (set.wasNull()) {
            return null;
        }
        return new Float(value);
    }

    public static Long getLong(ResultSet set, String index) throws SQLException {
        long value = set.getLong(index);
        if (set.wasNull()) {
            return null;
        }
        return new Long(value);
    }

    public static Double getDouble(ResultSet set, String index) throws SQLException {
        double value = set.getDouble(index);
        if (set.wasNull()) {
            return null;
        }
        return new Double(value);
    }

    public static Byte getByte(ResultSet set, String index) throws SQLException {
        byte value = set.getByte(index);
        if (set.wasNull()) {
            return null;
        }
        return new Byte(value);
    }

    public static Character getCharacter(ResultSet set, String index) throws SQLException {
        String value = set.getString(index);
        if (set.wasNull() || value == null || value.length() < 1) {
            return null;
        }
        return new Character(value.charAt(0));
    }

    public static Short getShort(ResultSet set, String index) throws SQLException {
        short value = set.getShort(index);
        if (set.wasNull()) {
            return null;
        }
        return new Short(value);
    }

    public static Boolean getBoolean(ResultSet set, String index) throws SQLException {
        boolean value = set.getBoolean(index);
        if (set.wasNull()) {
            return null;
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static char getChar(ResultSet set, String index) throws SQLException {
        String string = set.getString(index);
        if (string == null || string.length() < 1) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public static char getChar(ResultSet set, int index) throws SQLException {
        String string = set.getString(index);
        if (string == null || string.length() < 1) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public static void setChar(PreparedStatement statement, int index, char value) throws SQLException {
        char[] array = new char[]{value};
        statement.setString(index, new String(array));
    }

    public static String toString(Throwable t) {
        CharArrayWriter charWriter = new CharArrayWriter();
        PrintWriter writer = new PrintWriter((Writer)charWriter, true);
        t.printStackTrace(writer);
        writer.flush();
        return new String(charWriter.toCharArray());
    }

    public static EJBException getLocalUserException(Throwable throwable, boolean userTransaction) {
        if (userTransaction) {
            while (throwable instanceof EJBException && ((EJBException)throwable).getCausedByException() != null) {
                throwable = ((EJBException)throwable).getCausedByException();
            }
            if (throwable instanceof TransactionRolledbackLocalException) {
                return (TransactionRolledbackLocalException)throwable;
            }
            return (EJBException)new TransactionRolledbackLocalException(throwable.toString(), throwable instanceof Exception ? (Exception)throwable : null).initCause(throwable);
        }
        if (throwable instanceof EJBException) {
            return (EJBException)throwable;
        }
        return (EJBException)new EJBException(throwable.toString(), throwable instanceof Exception ? (Exception)throwable : null).initCause(throwable);
    }

    public static RemoteException getUserException(Throwable throwable, boolean userTransaction) {
        while (throwable instanceof EJBException && ((EJBException)throwable).getCausedByException() != null) {
            throwable = ((EJBException)throwable).getCausedByException();
        }
        if (userTransaction) {
            if (throwable instanceof TransactionRolledbackException) {
                return (TransactionRolledbackException)throwable;
            }
            TransactionRolledbackException re = new TransactionRolledbackException(throwable.getMessage());
            re.detail = throwable;
            return re;
        }
        if (throwable instanceof RemoteException) {
            return (RemoteException)throwable;
        }
        return new OracleRemoteException(throwable.toString(), throwable);
    }

    public static EJBException createEJBException(Exception cause) {
        return EJBUtils.createEJBException(cause.getMessage(), cause);
    }

    public static EJBException createEJBException(String message, Exception cause) {
        return (EJBException)new EJBException(message, cause).initCause((Throwable)cause);
    }

    public static EJBException createEJBException(String message) {
        return new EJBException(message);
    }

    public static XAException createXAException(String message, Throwable cause) {
        XAException e = new XAException(message);
        e.errorCode = -3;
        e.initCause(cause);
        return e;
    }

    public static XAException createXAException(Throwable cause) {
        return EJBUtils.createXAException(cause.toString(), cause);
    }

    public static byte[] getContent(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.getContent(in);
    }

    public static char[] getContent(Reader in) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.getContent(in);
    }

    public static final Object cloneObject(final Object object, final AbstractEJBHome home) throws RemoteException {
        if (object == null || object instanceof EJBObject || object instanceof EJBLocalObject || object instanceof EJBHome || object instanceof EJBLocalHome || ThreadState.getCurrentState().getCurrentInvocation() != null) {
            return object;
        }
        if (!OC4JSecurity.isSecurityOn()) {
            return EJBUtils.unprivileged_cloneObject(object, home);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws RemoteException {
                return EJBUtils.unprivileged_cloneObject(object, home);
            }
        };
        try {
            return OC4JSecurity.doPrivileged(action);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object unprivileged_cloneObject(Object object, AbstractEJBHome home) throws RemoteException {
        block21: {
            Class<?> cls;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                cls = object.getClass();
                                                if (!cls.isPrimitive() && cls != Handle.class) break block12;
                                                Object object2 = object;
                                                return object2;
                                            }
                                            if (!cls.isArray()) break block13;
                                            Object object3 = TransportManager.getInstance().cloneArray(object, home);
                                            return object3;
                                        }
                                        if (cls != J2EEContext.class) break block14;
                                        Object object4 = object;
                                        return object4;
                                    }
                                    if (cls != ORSet.class) break block15;
                                    HashSet hashSet = new HashSet((Set)object);
                                    return hashSet;
                                }
                                if (cls != ORCollection.class) break block16;
                                ArrayList arrayList = new ArrayList((Collection)object);
                                return arrayList;
                            }
                            if (!EJBProperties.getOracleArrayListDeepCopy() || cls != ArrayList.class) break block17;
                            Object object5 = EJBUtils.cloneArrayList((ArrayList)object, home);
                            return object5;
                        }
                        if (cls != CollectionEnumeration.class) break block18;
                        CollectionEnumeration collectionEnumeration = EJBUtils.cloneCollectionEnumeration(cls, (CollectionEnumeration)object, home);
                        return collectionEnumeration;
                    }
                    if (!EJBProperties.getOracleVectorDeepCopy() || cls != Vector.class) break block19;
                    Object object6 = EJBUtils.cloneVector((Vector)object, home);
                    return object6;
                }
                if (cls != HashSet.class) break block20;
                Object object7 = EJBUtils.cloneHashSet((HashSet)object, home);
                return object7;
            }
            if (cls != HashMap.class) break block21;
            Object object8 = EJBUtils.cloneHashMap((HashMap)object, home);
            return object8;
        }
        Object object9 = EJBUtils.cloneSerialize(object, home);
        return object9;
    }

    private static final Object cloneSerialize(Object object, AbstractEJBHome home) throws OracleRemoteException {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(128);
            EJBOutputStream out = new EJBOutputStream(byteOut);
            out.writeObject(object);
            out.close();
            byte[] data = byteOut.toByteArray();
            EJBInputStream in = new EJBInputStream((InputStream)new ByteArrayInputStream(data), home);
            Object response = in.readObject();
            return response;
        }
        catch (IOException e) {
            throw new OracleRemoteException("Error (de-)serializing object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new OracleRemoteException("Error (de-)serializing object, class not found: " + e.getMessage(), e);
        }
    }

    public static final Object cloneOneObjectInstance(Object instance, AbstractEJBHome home) throws RemoteException {
        if (instance == null || instance instanceof EJBObject || instance instanceof EJBHome || instance instanceof EJBLocalObject || instance instanceof EJBLocalHome || instance.getClass().isPrimitive()) {
            return instance;
        }
        return EJBUtils.cloneObject(instance, home);
    }

    public static final Object cloneArray(Object list, Class cls, AbstractEJBHome home) throws RemoteException {
        Object retData = null;
        Class<?> componentType = cls.getComponentType();
        if (componentType.isPrimitive()) {
            int size = 0;
            if (componentType == Boolean.TYPE) {
                size = ((boolean[])list).length;
                retData = new boolean[size];
            } else if (componentType == Character.TYPE) {
                size = ((char[])list).length;
                retData = new char[size];
            } else if (componentType == Byte.TYPE) {
                size = ((byte[])list).length;
                retData = new byte[size];
            } else if (componentType == Short.TYPE) {
                size = ((short[])list).length;
                retData = new short[size];
            } else if (componentType == Integer.TYPE) {
                size = ((int[])list).length;
                retData = new int[size];
            } else if (componentType == Long.TYPE) {
                size = ((long[])list).length;
                retData = new long[size];
            } else if (componentType == Float.TYPE) {
                size = ((float[])list).length;
                retData = new float[size];
            } else if (componentType == Double.TYPE) {
                size = ((double[])list).length;
                retData = new double[size];
            } else {
                return EJBUtils.cloneSerialize(list, home);
            }
            System.arraycopy(list, 0, retData, 0, size);
        } else {
            retData = !EJBUtils.isIIOPStubArray(list) ? EJBUtils.cloneSerialize(list, home) : list;
        }
        return retData;
    }

    private static boolean isIIOPStubArray(Object list) {
        return ((Object[])list).length > 0 && ((Object[])list)[0] instanceof Stub;
    }

    private static final Object cloneHashMap(HashMap oldMap, AbstractEJBHome home) throws RemoteException {
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(oldMap.size());
        Iterator iterator = oldMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = EJBUtils.cloneOneObjectInstance(entry.getKey(), home);
            Object value = EJBUtils.cloneOneObjectInstance(entry.getValue(), home);
            newMap.put(key, value);
        }
        return newMap;
    }

    private static final Object cloneHashSet(HashSet oldSet, AbstractEJBHome home) throws RemoteException {
        HashSet<Object> newSet = new HashSet<Object>(oldSet.size());
        Iterator iterator = oldSet.iterator();
        while (iterator.hasNext()) {
            Object instance = iterator.next();
            newSet.add(EJBUtils.cloneOneObjectInstance(instance, home));
        }
        return newSet;
    }

    private static final Object cloneVector(Vector oldSet, AbstractEJBHome home) throws RemoteException {
        Vector<Object> newVector = new Vector<Object>(oldSet.size());
        Iterator iterator = oldSet.iterator();
        while (iterator.hasNext()) {
            Object instance = iterator.next();
            if (instance == oldSet) {
                newVector.add(instance);
                continue;
            }
            newVector.add(EJBUtils.cloneOneObjectInstance(instance, home));
        }
        return newVector;
    }

    private static final CollectionEnumeration cloneCollectionEnumeration(Class cls, CollectionEnumeration enum5, AbstractEJBHome home) throws RemoteException {
        ArrayList<Object> newList = new ArrayList<Object>(enum5.size());
        while (enum5.hasMoreElements()) {
            Object instance = enum5.nextElement();
            if (instance instanceof EJBObject || instance instanceof EJBHome) {
                newList.add(instance);
                continue;
            }
            newList.add(EJBUtils.cloneObject(instance, home));
        }
        return new CollectionEnumeration(newList);
    }

    private static final Object cloneArrayList(ArrayList oldList, AbstractEJBHome home) throws RemoteException {
        int oldListSize = oldList.size();
        ArrayList<Object> newList = new ArrayList<Object>(oldListSize);
        for (int i = 0; i < oldListSize; ++i) {
            Object instance = oldList.get(i);
            newList.add(EJBUtils.cloneOneObjectInstance(instance, home));
        }
        return newList;
    }

    public static Object cloneLocalObject(Object object, AbstractEJBHome home) {
        try {
            return EJBUtils.cloneObject(object, home);
        }
        catch (RemoteException e) {
            if (e.getCause() instanceof Exception) {
                throw new EJBException(e.getMessage(), (Exception)e.getCause());
            }
            throw new EJBException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyManyToManyAdd(EntityEJBObject holder, Object container, AbstractEJBObject instance) {
        ThreadState state = ThreadState.getCurrentState();
        boolean inCall = holder.startCallLocal(state, 90000L, true);
        Transaction tx = null;
        try {
            tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (tx != null) {
            ((ApplicationServerTransactionSynchronization)tx).registerBeanUnchecked(holder);
            holder.transaction = (ApplicationServerTransaction)tx;
        }
        try {
            if (container == null) {
                return;
            }
            if (container instanceof CMRCollectionField) {
                ((CMRCollectionField)container).add(instance, false, false);
            } else if (container instanceof Collection) {
                ((Collection)container).add(instance);
            }
        }
        finally {
            holder.endCallLocal(inCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyManyToManyRemove(EntityEJBObject other, Object container, Object instance) {
        ThreadState state = ThreadState.getCurrentState();
        boolean inCall = other.startCallLocal(state, 90000L, true);
        Transaction tx = null;
        try {
            tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        try {
            if (tx != null) {
                ((ApplicationServerTransactionSynchronization)tx).registerBeanUnchecked(other);
                other.transaction = (ApplicationServerTransaction)tx;
            }
            if (container == null) {
                return;
            }
            if (container instanceof CMRCollectionField) {
                ((CMRCollectionField)container).remove(instance, false, true);
            } else if (container instanceof Collection) {
                ((Collection)container).remove(instance);
            }
        }
        finally {
            other.endCallLocal(inCall);
        }
    }

    public static void deleteOR(Collection collection, boolean cascadeDelete) throws RemoveException {
        if (collection == null) {
            return;
        }
        if (cascadeDelete) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (!(current instanceof AbstractEJBObject)) continue;
                try {
                    ((EntityEJBObject)current).__removeIfAlive();
                }
                catch (RemoteException e) {
                    throw (RemoveException)new RemoveException("Remote error: " + e.getMessage()).initCause((Throwable)e);
                }
            }
        }
        if (collection instanceof CMRCollectionField) {
            ((CMRCollectionField)((Object)collection)).clear(false);
        } else {
            collection.clear();
        }
    }

    public static Exception makeException(Throwable throwable) {
        if (throwable == null) {
            String msg = "No Exception - originate from:";
            Exception ex2 = new Exception(msg);
            msg = msg + ex2.fillInStackTrace();
            RemoteException ex = new RemoteException(msg, ex2);
            return ex;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        String msg = throwable.getMessage();
        if (msg == null) {
            msg = "";
        }
        RemoteException ex = new RemoteException(msg, throwable);
        return ex;
    }

    public static void throwTransactionRequiredLocalException() {
        throw new TransactionRequiredLocalException();
    }

    public static void confirmAlive(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof EntityEJBObject)) {
            return;
        }
        ((EntityEJBObject)object).__confirmAlive();
    }

    public static void throwNullORCollectionSet() {
        throw new IllegalArgumentException("Illegal attempt to set a collection OR field to null, see the EJB 2.0 specification chapter 10.3.8");
    }

    public static void removeAll(Collection collection, Object value) {
        while (collection.remove(value)) {
        }
    }

    public static void throwGetPrimaryKeyInEJBCreateException() {
        throw new IllegalStateException("Can not call getPrimaryKey() inside ejbCreate(...) methods, the entity does not have an identity yet, see the EJB 2.0 specification chapter 10.5.4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRandomInt() {
        SecureRandom secureRandom = randomGenerator;
        synchronized (secureRandom) {
            return randomGenerator.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getRandomLong() {
        SecureRandom secureRandom = randomGenerator;
        synchronized (secureRandom) {
            return randomGenerator.nextLong();
        }
    }

    public static byte[] blobToByteArray(ResultSet set, int index) throws SQLException {
        return EJBUtils.blobToByteArray((Blob)set.getObject(index));
    }

    public static byte[] blobToByteArray(ResultSet set, String columnName) throws SQLException {
        return EJBUtils.blobToByteArray((Blob)set.getObject(columnName));
    }

    public static byte[] blobToByteArray(Blob anObject) throws SQLException {
        if (anObject == null) {
            return null;
        }
        int length = anObject.length() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)anObject.length();
        return anObject.getBytes(1L, length);
    }

    public static String clobToString(ResultSet set, int index) throws SQLException {
        return EJBUtils.clobToString((Clob)set.getObject(index));
    }

    public static String clobToString(ResultSet set, String columnName) throws SQLException {
        return EJBUtils.clobToString((Clob)set.getObject(columnName));
    }

    public static String clobToString(Clob anObject) throws SQLException {
        if (anObject == null) {
            return null;
        }
        int length = anObject.length() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)anObject.length();
        return anObject.getSubString(1L, length);
    }

    public static char[] clobToCharArray(ResultSet set, int index) throws SQLException {
        String _string = EJBUtils.clobToString((Clob)set.getObject(index));
        return _string == null ? null : _string.toCharArray();
    }

    public static char[] clobToCharArray(ResultSet set, String columnName) throws SQLException {
        String _string = EJBUtils.clobToString((Clob)set.getObject(columnName));
        return _string == null ? null : _string.toCharArray();
    }

    public static Collection getAllInterfaces(Class cls) {
        HashSet c = new HashSet();
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            c.add(interfaces[i]);
            c.addAll(EJBUtils.getAllInterfaces(interfaces[i]));
        }
        Class superClass = cls.getSuperclass();
        if (superClass != null) {
            c.addAll(EJBUtils.getAllInterfaces(superClass));
        }
        return c;
    }

    public static Collection getImplementedBusinessInterfaces(Class cls) {
        Collection c = EJBUtils.getAllInterfaces(cls);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String className = ((Class)i.next()).getName();
            if (!className.equals("java.io.Serializable") && !className.equals("java.io.Externalizable") && !className.equals("java.rmi.Remote") && !className.startsWith("javax.ejb")) continue;
            i.remove();
        }
        return c;
    }

    public static Collection getMethodsWithUniqueSingatureForInterface(Class interf) {
        HashSet<String> methods = new HashSet<String>();
        Collection c = EJBUtils.getImplementedBusinessInterfaces(interf);
        c.add(interf);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Class cls = (Class)i.next();
            Method[] m = cls.getDeclaredMethods();
            for (int index = 0; index < m.length; ++index) {
                methods.add(EJBUtils.getUniqueMethodSignature(m[index]));
            }
        }
        return methods;
    }

    public static boolean isApplicationException(Throwable e) {
        return !(e instanceof RuntimeException) && !(e instanceof RemoteException) && !(e instanceof Error);
    }

    public static ApplicationException getApplicationException(Throwable e, EJBPackage ejbPackage) {
        ApplicationException ae = null;
        if (ejbPackage.getCompatibility() >= 3 && (ae = ejbPackage.getApplicationException(e)) == null && parseApplicationExceptionAnnotationMethod != null) {
            try {
                ae = (ApplicationException)parseApplicationExceptionAnnotationMethod.invoke(null, ejbPackage, e.getClass());
            }
            catch (Throwable t) {
                m_logger.log(Level.WARNING, "Unexpected exception invoking BeanDescriptorAnnotationParser.parseApplicationExceptionAnnotation(EJBPackage, Class): ", t);
            }
        }
        if (ae == null && EJBUtils.isApplicationException(e)) {
            ae = new ApplicationException(e.getClass().getName(), false);
            if (ejbPackage.getCompatibility() >= 3) {
                ejbPackage.addApplicationException(ae);
            }
        }
        return ae;
    }

    public static EJBException unwrapSystemException(EJBException e) {
        while (e.getCausedByException() != null && e.getCausedByException() instanceof EJBException) {
            e = (EJBException)((Object)e.getCausedByException());
        }
        return e;
    }

    public static boolean isRecoverableSystemException(Throwable e) {
        return e instanceof TimeoutExpiredException;
    }

    public static boolean isOrionCmpForced() {
        return EJBProperties.getOc4jEjbPmName() != null && EJBProperties.getOc4jEjbPmName().equalsIgnoreCase("orion");
    }

    public static boolean isJdk50() {
        if (isJdk50 == null) {
            isJdk50 = Boolean.FALSE;
            try {
                Class.class.getMethod(JDK50_MARKER_METHOD, null);
                isJdk50 = Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isJdk50;
    }

    public static Class getSingleBussinessInterface(Class cls) {
        Collection c = EJBUtils.getImplementedBusinessInterfaces(cls);
        if (c.size() == 1) {
            return (Class)c.toArray()[0];
        }
        return null;
    }

    public static EJBContext getEJBContext() {
        EJBThreadContext tc = ThreadState.getCurrentState().getEJBThreadContext();
        if (tc != null) {
            return tc.context;
        }
        return null;
    }

    public static void setClassPreprocessor(PolicyClassLoader loader, ClassPreprocessor processor) {
        if (loader.getPreprocessor() == null) {
            loader.setPreprocessor(processor);
        } else {
            loader.setPreprocessor((ClassPreprocessor)new ClassPreprocessorSequence(new ClassPreprocessor[]{loader.getPreprocessor(), processor}, 2));
        }
    }

    public static boolean classContainsStatefulFields(Class clazz) {
        while (!clazz.getName().equals("java.lang.Object")) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> fieldType;
                if ((class$javax$sql$DataSource == null ? EJBUtils.class$("javax.sql.DataSource") : class$javax$sql$DataSource).isAssignableFrom(fieldType = fields[i].getType()) || (class$javax$jms$ConnectionFactory == null ? EJBUtils.class$("javax.jms.ConnectionFactory") : class$javax$jms$ConnectionFactory).isAssignableFrom(fieldType) || (class$javax$jms$QueueConnectionFactory == null ? EJBUtils.class$("javax.jms.QueueConnectionFactory") : class$javax$jms$QueueConnectionFactory).isAssignableFrom(fieldType) || (class$javax$jms$TopicConnectionFactory == null ? EJBUtils.class$("javax.jms.TopicConnectionFactory") : class$javax$jms$TopicConnectionFactory).isAssignableFrom(fieldType) || (class$javax$resource$cci$ConnectionFactory == null ? EJBUtils.class$("javax.resource.cci.ConnectionFactory") : class$javax$resource$cci$ConnectionFactory).isAssignableFrom(fieldType) || (class$javax$mail$Session == null ? EJBUtils.class$("javax.mail.Session") : class$javax$mail$Session).isAssignableFrom(fieldType) || (class$java$net$URL == null ? EJBUtils.class$("java.net.URL") : class$java$net$URL).isAssignableFrom(fieldType) || (class$javax$ejb$EJBHome == null ? EJBUtils.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(fieldType) || (class$com$evermind$server$ejb$StatelessSessionEJBObject == null ? EJBUtils.class$("com.evermind.server.ejb.StatelessSessionEJBObject") : class$com$evermind$server$ejb$StatelessSessionEJBObject).isAssignableFrom(fieldType) || Modifier.isStatic(fields[i].getModifiers())) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static String getUniqueMethodSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getName());
        buffer.append("(");
        Class<?>[] args = method.getParameterTypes();
        for (int index = 0; index < args.length; ++index) {
            buffer.append(args[index].getName());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static boolean isCMT() {
        AbstractEJBContext ejbCtx = (AbstractEJBContext)EJBUtils.getEJBContext();
        return ejbCtx == null ? false : ejbCtx.getBeanDescriptor().getTransactionType() == 0;
    }

    public static void checkCMT() {
        if (EJBUtils.isCMT()) {
            EJBRuntimeMessages.warningCMTUserTransaction(EJBUtils.getEJBContext());
        }
    }

    public static InterceptorDescriptor buildInterceptorClassDescriptor(String interceptorClassName, ClassLoader tempLoader, Object parser) throws InstantiationException {
        Method buildInterceptorClassDescriptorMethod = null;
        Class<?> interceptorClass = null;
        try {
            interceptorClass = tempLoader.loadClass(interceptorClassName);
            Class<?> annotationParserClass = tempLoader.loadClass("com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser");
            buildInterceptorClassDescriptorMethod = annotationParserClass.getMethod("buildInterceptorClassDescriptor", Class.class, Object.class);
            return (InterceptorDescriptor)buildInterceptorClassDescriptorMethod.invoke(null, interceptorClass, parser);
        }
        catch (IllegalArgumentException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalAccessException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw EJBUtils.createEJBException((Exception)e.getCause());
            }
            throw EJBUtils.createEJBException(e);
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException(e);
        }
    }

    public static InterceptorDescriptor buildInterceptorClassDescriptor(String interceptorClassName, ClassLoader tempLoader) throws InstantiationException {
        Method buildInterceptorClassDescriptorMethod = null;
        Class<?> interceptorClass = null;
        try {
            interceptorClass = tempLoader.loadClass(interceptorClassName);
            Class<?> annotationParserClass = tempLoader.loadClass("com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser");
            buildInterceptorClassDescriptorMethod = annotationParserClass.getMethod("buildInterceptorClassDescriptor", Class.class);
            return (InterceptorDescriptor)buildInterceptorClassDescriptorMethod.invoke(null, interceptorClass);
        }
        catch (IllegalArgumentException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalAccessException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw EJBUtils.createEJBException((Exception)e.getCause());
            }
            throw EJBUtils.createEJBException(e);
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException(e);
        }
    }

    public static String buildProxyId(BeanDescriptor descriptor) {
        return Integer.toString(Math.abs(descriptor.getPackage().getName().hashCode()), 26);
    }

    public static String buildSafeClassName(String name) {
        StringBuffer buf = new StringBuffer();
        char c = name.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            c = '_';
        }
        buf.append(c);
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String getProxyName(BeanDescriptor bd, boolean remote, boolean home) {
        StringBuffer buf = new StringBuffer();
        buf.append(EJBUtils.buildSafeClassName(bd.getName()));
        buf.append('_');
        buf.append(remote ? "Remote" : "Local");
        if (home) {
            buf.append("Home");
        }
        buf.append("Proxy_");
        buf.append(EJBUtils.buildProxyId(bd));
        return buf.toString();
    }

    static {
        randomGenerator = new SecureRandom();
        parseApplicationExceptionAnnotationMethod = null;
        try {
            if (EJBUtils.isJdk50()) {
                Class<?> annotationParserClass = Class.forName("com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser");
                parseApplicationExceptionAnnotationMethod = annotationParserClass.getMethod("parseApplicationExceptionAnnotation", EJBPackage.class, Class.class);
            }
        }
        catch (Throwable t) {
            m_logger.log(Level.WARNING, "Unexpected exception accessing BeanDescriptorAnnotationParser.parseApplicationExceptionAnnotation(EJBPackage, Class): ", t);
        }
    }
}

