/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.TransactionManagerAccess;
import com.evermind.server.ejb.EJBTransactionContext;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTransactionMessages;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.oc4j.rmi.OracleRemoteException;

public class EJBTransactionManager {
    private Map activeTransactions = new HashMap();
    private static TransactionManagerAccess m_tmAccess = new TransactionManagerAccess();
    private static EJBTransactionManager ejbTransactionManager = null;

    public static EJBTransactionManager getInstance() {
        if (ejbTransactionManager == null) {
            ejbTransactionManager = new EJBTransactionManager();
        }
        return ejbTransactionManager;
    }

    private EJBTransactionManager() {
    }

    public void begin(BeanDescriptor desc, boolean isLocal) throws Exception {
        int timeout = 0;
        if (desc.isSession()) {
            timeout = ((SessionBeanDescriptor)desc).getTransactionTimeout();
        }
        if (isLocal) {
            this.beginLocal(timeout);
        } else {
            this.beginRemote(timeout);
        }
    }

    public void beginLocal() {
        this.beginLocal(0);
    }

    public void beginRemote() throws RemoteException {
        this.beginRemote(0);
    }

    protected void beginLocal(int timeout) {
        try {
            this.begin(timeout);
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException("Error creating transaction", e);
        }
    }

    protected void beginRemote(int timeout) throws RemoteException {
        try {
            this.begin(timeout);
        }
        catch (Exception e) {
            throw new OracleRemoteException("Error creating transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin(int timeout) throws SystemException, NotSupportedException {
        if (timeout > 0) {
            int originalTimeout = ((ApplicationServerTransactionManager)EJBTransactionManager.getTransactionManager()).getTransactionTimeout();
            try {
                EJBTransactionManager.getTransactionManager().setTransactionTimeout(timeout);
                EJBTransactionManager.getTransactionManager().begin();
            }
            finally {
                EJBTransactionManager.getTransactionManager().setTransactionTimeout(originalTimeout);
            }
        } else {
            EJBTransactionManager.getTransactionManager().begin();
        }
    }

    public boolean end(boolean local) throws Exception {
        try {
            if (EJBTransactionManager.getTransactionManager().getStatus() == 1) {
                int rollbackCause = ((ApplicationServerTransaction)EJBTransactionManager.getTransaction()).getTxRollbackCause();
                if (rollbackCause == 201 || rollbackCause == 204) {
                    EJBTransactionManager.getTransactionManager().commit();
                    return true;
                }
                EJBTransactionManager.getTransactionManager().rollback();
                return false;
            }
            EJBTransactionManager.getTransactionManager().commit();
            return true;
        }
        catch (Exception e) {
            String message = "An exception occurred during transaction completion: ";
            if (local) {
                throw EJBUtils.createEJBException(message, e);
            }
            throw new OracleRemoteException(message, e);
        }
    }

    public Transaction suspendLocal() {
        try {
            return this.suspend();
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException("Error suspending transaction", e);
        }
    }

    public Transaction suspendRemote() throws RemoteException {
        try {
            return this.suspend();
        }
        catch (Exception e) {
            throw new OracleRemoteException("Error suspending transaction", e);
        }
    }

    public Transaction suspend() throws SystemException {
        return EJBTransactionManager.getTransactionManager().suspend();
    }

    public void resumeLocal(Transaction suspendedTx) {
        try {
            this.resume(suspendedTx);
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException("Error resuming transaction", e);
        }
    }

    public void resumeRemote(Transaction suspendedTx) throws Exception {
        try {
            this.resume(suspendedTx);
        }
        catch (Exception e) {
            throw new OracleRemoteException("Error resuming transaction", e);
        }
    }

    public void resume(Transaction suspendedTx) throws SystemException, InvalidTransactionException {
        if (suspendedTx != null) {
            EJBTransactionManager.getTransactionManager().resume(suspendedTx);
        }
    }

    public void setContainerRollbackOnly() {
        try {
            Transaction tx = EJBTransactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Cannot call setRollbackOnly() current thread is NOT associated with a transaction");
            }
            tx.setRollbackOnly();
        }
        catch (SystemException se) {
            EJBTransactionMessages.warningTransactionForRollback((Exception)((Object)se));
        }
    }

    public EJBTransactionContext getOrCreateEJBTransactionContext() throws SystemException, RollbackException {
        Transaction tx;
        EJBTransactionContext txContext = this.getEJBTransactionContext();
        if (txContext == null && (tx = EJBTransactionManager.getTransaction()) != null) {
            txContext = this.createTransactionContext(tx);
        }
        return txContext;
    }

    private EJBTransactionContext getEJBTransactionContext() {
        Transaction tx = EJBTransactionManager.getTransaction();
        if (tx == null) {
            return null;
        }
        return (EJBTransactionContext)this.activeTransactions.get(tx);
    }

    private EJBTransactionContext createTransactionContext(Transaction currentTx) throws SystemException, RollbackException {
        final EJBTransactionContext txContext = new EJBTransactionContext(currentTx);
        if (currentTx != null) {
            currentTx.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    EJBTransactionManager.this.releaseTransactionContext(txContext);
                }
            });
            this.activeTransactions.put(currentTx, txContext);
        }
        return txContext;
    }

    private void releaseTransactionContext(EJBTransactionContext txContext) {
        this.activeTransactions.remove(txContext.getTransaction());
    }

    public static TransactionManager getTransactionManager() {
        return m_tmAccess.getTransactionManager();
    }

    public static Transaction getTransaction() {
        try {
            return EJBTransactionManager.getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            return null;
        }
    }
}

