/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.reflect.Proxy;
import com.evermind.security.User;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EntityBeanReferenceHolder;
import com.evermind.server.ejb.EntityHandle;
import com.evermind.server.ejb.InitialContextHolder;
import com.evermind.server.ejb.LocalContextHolder;
import com.evermind.server.ejb.SessionBeanReferenceHolder;
import com.evermind.server.ejb.SessionContainer;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.ejb.persistence.EntityManagerHolder;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.rmi.SingletonHolder;
import com.evermind.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.HomeHandle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBInputStream
extends ClassLoaderObjectInputStream {
    protected AbstractEJBHome home;
    protected Context context;
    public StatefulSessionContext sessionContext;
    private HttpApplication httpApp;
    private static Logger m_logger = EJBTraceLogger.getLogger(EJBInputStream.class);

    public EJBInputStream(InputStream in, AbstractEJBHome home) throws IOException {
        super(in, home == null ? Thread.currentThread().getContextClassLoader() : home.getClassLoader());
        this.home = home;
        this.context = home == null ? null : home.container.getApplication().getContext();
        this.enableResolveObject(true);
    }

    public EJBInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in, loader);
        this.enableResolveObject(true);
    }

    public Object resolveObject(Object object) throws IOException {
        try {
            if (object instanceof EntityBeanReferenceHolder) {
                EntityBeanReferenceHolder holder = (EntityBeanReferenceHolder)object;
                return EntityHandle.getEJBObject(holder.homePath, holder.primaryKey, this.getInitialContext());
            }
            if (object instanceof SessionBeanReferenceHolder) {
                SessionBeanReferenceHolder holder = (SessionBeanReferenceHolder)object;
                SessionContainer shome = (SessionContainer)this.getInitialContext().lookup(holder.path);
                if (holder.remoteEnvironment != null) {
                    InitialContext ictx = new InitialContext(holder.remoteEnvironment);
                    SessionContainer dummyHome = (SessionContainer)ictx.lookup(holder.path);
                    if (dummyHome instanceof Proxy) {
                        return dummyHome.getRemoteSession(holder.id, holder.checksum);
                    }
                    return dummyHome.getSession(holder.id, holder.checksum);
                }
                return shome.getSession(holder.id, holder.checksum);
            }
            if (object instanceof HomeHandle) {
                return ((HomeHandle)object).getEJBHome();
            }
            if (object instanceof LocalContextHolder) {
                return this.getLocalContext();
            }
            if (object instanceof InitialContextHolder) {
                if (InitialContextHolder.initialContext == null) {
                    InitialContextHolder.initialContext = new InitialContext();
                }
                return InitialContextHolder.initialContext;
            }
            if (object instanceof EntityManagerHolder) {
                PersistenceUnitManager pm = this.home.getEJBPackage().getPersistenceUnitManager();
                PersistenceUnit pu = pm.getPersistenceUnit(((EntityManagerHolder)object).getName());
                return pu.getEntityManagerProxy(((EntityManagerHolder)object).getProperties());
            }
            if (object instanceof SingletonHolder) {
                String name = ((SingletonHolder)object).getName();
                if ("UserTransaction".equals(name)) {
                    if (this.home != null) {
                        return this.home.container.getApplication().getServer().getTransactionManager();
                    }
                    return this.getInitialContext().lookup("java:comp/UserTransaction");
                }
                if ("EntityManager".equals(name)) {
                    if (this.home != null) {
                        return this.home.getEJBPackage().getEntityManagerDeployer().getEntityManagerFactory().getEntityManager();
                    }
                    return this.getInitialContext().lookup("java:comp/ejb/EntityManager");
                }
                if ("sessionEJBObject".equals(name)) {
                    if (this.sessionContext == null) {
                        return null;
                    }
                    return this.sessionContext.remoteWrapper;
                }
                if ("sessionContext".equals(name)) {
                    return this.sessionContext;
                }
                if (name.startsWith("session:")) {
                    boolean local = (name = name.substring("session:".length())).startsWith("local:");
                    if (local) {
                        name = name.substring(6);
                    }
                    if (local) {
                        throw new IOException("Local stateless session reference cannot be de-serialized in location:" + name);
                    }
                    Object lookup = this.getInitialContext().lookup(name);
                    if (lookup instanceof StatelessSessionEJBHome) {
                        return ((StatelessSessionEJBHome)lookup).getSingletonInstance();
                    }
                    try {
                        return lookup.getClass().getMethod("create", ClassUtils.CLASS_NOARGS).invoke(lookup, new Object[0]);
                    }
                    catch (Throwable t) {
                        IOException ie = new IOException("Error resolving stateless session: " + name);
                        ie.initCause(t);
                        throw ie;
                    }
                }
                if (name.startsWith("contextObject:")) {
                    String location = name.substring("contextObject:".length());
                    Context context = this.home == null || this.home.container == null ? this.getInitialContext() : this.home.container.getApplication().getContext();
                    return context.lookup(location);
                }
            }
            return object;
        }
        catch (NamingException e) {
            IOException ie = new IOException("NamingException: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public Context getLocalContext() {
        return this.home.getEnvironmentContext();
    }

    public Context getInitialContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        return this.context;
    }

    public void readSession(StatefulSessionEJBHome home, long id, long checksum) throws IOException, ClassNotFoundException, Exception {
        this.readSession(home, id, checksum, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSession(StatefulSessionEJBHome home, long id, long checksum, boolean restoreSessions) throws IOException, ClassNotFoundException, Exception {
        String username = this.readUTF();
        User user = this.home.getApplication().getUserManager().getUser(username);
        StatefulSessionEJBObject wrapper = home.getEJBObject(id);
        boolean wrapperFound = false;
        StatefulSessionContext context = null;
        if (wrapper != null && wrapper.OC4J_getChecksum() == checksum) {
            wrapperFound = true;
            long startTime = System.currentTimeMillis();
            while (wrapper.isInCall()) {
                if ((System.currentTimeMillis() - startTime) / 1000L <= 60L) continue;
                throw new RuntimeException("Cannot proceed with readSession because the object is being used");
            }
            context = wrapper.context;
        }
        boolean maxInstancesIncremented = false;
        if (!wrapperFound) {
            if (!restoreSessions) {
                home.checkMaxInstancesCount();
                maxInstancesIncremented = true;
            }
            context = new StatefulSessionContext();
            context.remoteHome = home;
            wrapper = home.getWrapperInstance(context, id, checksum, user == null ? "" : user.getName());
        }
        try {
            StatefulSessionEJBObject statefulSessionEJBObject = wrapper;
            synchronized (statefulSessionEJBObject) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "EJBInputStream reading wrapper=" + wrapper.getClass().getName());
                }
                wrapper.creationTime = this.readLong();
                wrapper.lastAccessedTime = this.readLong();
                if (wrapperFound) {
                    wrapper.context = context;
                    wrapper.OC4J_setUserName(user.getName());
                }
                if (!restoreSessions || wrapperFound) {
                    try {
                        this.sessionContext = context;
                        context.attributes = (Hashtable)this.readObject();
                        context.object = this.readObject();
                        context.setUserInterceptorInstances((Object[])this.readObject());
                    }
                    finally {
                        this.sessionContext = null;
                    }
                    wrapper.setObject(context.object);
                }
                if (!wrapperFound) {
                    if (!restoreSessions) {
                        home.getBeanDescriptor().getLifecycleManager().postActivate(context.object, context);
                    } else {
                        wrapper.passivated = true;
                    }
                    home.addInstance(wrapper);
                }
            }
        }
        catch (Exception e) {
            if (maxInstancesIncremented && !wrapperFound) {
                Object object = home.getBeanDescriptor().__poolLock;
                synchronized (object) {
                    --home.getBeanDescriptor().__activeInstancesCount;
                }
            }
            home.OC4J_log("readSession() removing bean due to error:" + e.getMessage(), e);
            throw e;
        }
        if (!restoreSessions && wrapperFound && wrapper.OC4J_isPassivated()) {
            wrapper.passivateBean(false, false);
        }
    }

    public void setContext(Context c) {
        this.context = c;
    }

    public void setHttpApplication(HttpApplication httpApp) {
        this.httpApp = httpApp;
    }

    public HttpApplication getHttpApplication() {
        return this.httpApp;
    }
}

