/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.Flag;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.logging.EJBDatabaseMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import oracle.jdbc.OraclePreparedStatement;

public class DataSourceConnection {
    public static final int ISOLATION_DEFAULT = -7;
    private DataSourceConnectionContainer container;
    private ApplicationServerTransaction transaction;
    private Connection connection;
    private boolean closed;
    int oldLevel;
    boolean resetIsolation = false;
    protected Throwable stackTrace;
    private StatementBatch m_batch;
    private static Logger m_logger = EJBTraceLogger.getLogger(DataSourceConnection.class);

    public DataSourceConnection(DataSourceConnectionContainer container, ApplicationServerTransaction transaction) throws SQLException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): begin");
        }
        try {
            block15: {
                try {
                    if (m_logger.isLoggable(Level.FINE)) {
                        this.stackTrace = new Throwable("DataSourceConnection created");
                    }
                    this.container = container;
                    this.m_batch = container.isOracleDatabase() ? new OracleStatementBatch() : new StatementBatch();
                    this.transaction = transaction;
                    this.connection = container.source.getConnection();
                    if (this.connection == null) {
                        throw new InternalError("Cold not create a connection");
                    }
                    if (transaction == null || !container.getIsolationSet()) break block15;
                    int level = container.getIsolationLevel();
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor---Setting the transaction isolation level on the connection " + this.connection + ", to level " + level);
                    }
                    this.oldLevel = this.connection.getTransactionIsolation();
                    if (level == this.oldLevel) break block15;
                    this.connection.setTransactionIsolation(level);
                    this.resetIsolation = true;
                }
                catch (SQLException e) {
                    block17: {
                        try {
                            this.close(true);
                        }
                        catch (Throwable t) {
                            if (container.server == null) break block17;
                            container.server.log("Error closing connection after SQLException", t);
                        }
                    }
                    throw e;
                }
                catch (Error e) {
                    try {
                        this.close(true);
                    }
                    catch (Throwable t) {
                        this.container.server.log("Error closing connection after " + e.getClass(), t);
                    }
                    throw e;
                }
            }
            Object var6_6 = null;
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---transaction = " + transaction);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---connection = " + this.connection);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---this.resetIsolation = " + this.resetIsolation);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---this.closed = " + this.closed);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---transaction = " + transaction);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---connection = " + this.connection);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---this.resetIsolation = " + this.resetIsolation);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end---this.closed = " + this.closed);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Constructor(container, transaction): end");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close(boolean rollback) {
        block27: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): begin");
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): begin---rollback = " + rollback);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): begin---this.connection = " + this.connection);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): begin---this.resetIsolation = " + this.resetIsolation);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): begin---this.closed = " + this.closed);
            }
            if (this.closed) {
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---Already closed");
                return;
            }
            this.closed = true;
            this.flushStatements();
            if (rollback) {
                try {
                    if (ApplicationServer.getInstance().getTransactionManager().getTransaction() == null) {
                        if (this.connection != null && !this.connection.isClosed()) {
                            this.connection.rollback();
                        }
                    } else {
                        EJBTransactionManager.getInstance().setContainerRollbackOnly();
                    }
                }
                catch (SystemException systemException) {
                    this.container.server.log("Error during getTransaction call", systemException);
                }
            }
            Object var4_4 = null;
            try {
                if (this.resetIsolation) {
                    this.connection.setTransactionIsolation(this.oldLevel);
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Throwable t) {
                this.container.server.log("Error closing DataSource connection", t);
            }
            this.container = null;
            this.connection = null;
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---connection = " + this.connection);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.resetIsolation = " + this.resetIsolation);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.closed = " + this.closed);
                m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end");
            }
            break block27;
            {
                catch (SQLException e) {
                    this.container.server.log("Error rolling back DataSource connection", e);
                    Object var4_5 = null;
                    try {
                        if (this.resetIsolation) {
                            this.connection.setTransactionIsolation(this.oldLevel);
                        }
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (Throwable t) {
                        this.container.server.log("Error closing DataSource connection", t);
                    }
                    this.container = null;
                    this.connection = null;
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---connection = " + this.connection);
                        m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.resetIsolation = " + this.resetIsolation);
                        m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.closed = " + this.closed);
                        m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (this.resetIsolation) {
                        this.connection.setTransactionIsolation(this.oldLevel);
                    }
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Throwable t) {
                    this.container.server.log("Error closing DataSource connection", t);
                }
                this.container = null;
                this.connection = null;
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---connection = " + this.connection);
                    m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.resetIsolation = " + this.resetIsolation);
                    m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end---this.closed = " + this.closed);
                    m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "close(rollback): end");
                }
                throw throwable;
            }
        }
    }

    protected Set getBatchedStatements() {
        return this.m_batch.getBatchedStatements();
    }

    public void flushStatements() {
        this.m_batch.flushStatements();
    }

    public void sendBatchStatements() throws SQLException {
        this.m_batch.sendBatchStatements();
    }

    public PreparedStatement getCustomStatement(String syntax) throws SQLException {
        return this.getCustomStatement(new Flag(false), syntax);
    }

    public PreparedStatement getCustomStatement(String syntax, int executeBatchSize, boolean delayUntilCommit) throws SQLException {
        return this.getCustomStatement(new Flag(false), syntax, executeBatchSize, delayUntilCommit);
    }

    public PreparedStatement getCustomStatement(Flag isCached, String syntax) throws SQLException {
        return this.connection.prepareStatement(syntax);
    }

    public PreparedStatement getCustomStatement(Flag isCached, String syntax, int executeBatchSize, boolean delayUntilCommit) throws SQLException {
        PreparedStatement stmt = this.getCustomStatement(isCached, syntax);
        this.m_batch.batchStatement(stmt, isCached, syntax, executeBatchSize, delayUntilCommit);
        return stmt;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    public void release() {
        this.close(false);
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null || this.closed;
    }

    public String toString() {
        return "[DataSourceConnection " + this.connection + "]";
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void finalize() {
        if (!this.closed) {
            EJBDatabaseMessages.warningUnclosedConnection(this.getConnection());
            if (this.stackTrace != null) {
                this.stackTrace.printStackTrace();
            }
        }
    }

    public void setIsolationModeIfAny() throws SQLException {
        if (this.transaction != null && this.container.getIsolationSet()) {
            int level = this.container.getIsolationLevel();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "Setting the transaction isolation level on the connection " + this.connection + ", to level " + level);
            }
            this.oldLevel = this.connection.getTransactionIsolation();
            if (level != this.oldLevel) {
                this.connection.setTransactionIsolation(level);
                this.resetIsolation = true;
            }
        }
    }

    class OracleStatementBatch
    extends StatementBatch {
        OracleStatementBatch() {
        }

        public void sendBatchStatements() throws SQLException {
            int bch = 0;
            Iterator iterator = this.getBatchedStatements().iterator();
            while (iterator.hasNext()) {
                OraclePreparedStatement preparedStatement = (OraclePreparedStatement)iterator.next();
                bch += preparedStatement.sendBatch();
                if (!m_logger.isLoggable(Level.FINE)) continue;
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "sendBatchStatements -- sendBatch " + preparedStatement + " " + bch);
            }
            if (bch > 0 && m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "sendBatchStatements -- ttl = " + bch);
            }
            this.getBatchedStatements().clear();
        }

        public void batchStatement(PreparedStatement stmt, Flag isCached, String syntax, int executeBatchSize, boolean delayUntilCommit) throws SQLException {
            if (executeBatchSize > 1) {
                OraclePreparedStatement oracleStmt = (OraclePreparedStatement)stmt;
                oracleStmt.setExecuteBatch(executeBatchSize);
                if (!delayUntilCommit) {
                    this.getBatchedStatements().add(stmt);
                }
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "batchStatement -- setExecuteBatch " + stmt + "=" + syntax + " bs=" + executeBatchSize);
                }
            }
        }
    }

    class StatementBatch {
        private Set m_batchedStatements = new HashSet();

        StatementBatch() {
        }

        protected Set getBatchedStatements() {
            return this.m_batchedStatements;
        }

        public void flushStatements() {
            Iterator iterator = this.m_batchedStatements.iterator();
            while (iterator.hasNext()) {
                PreparedStatement preparedStatement = (PreparedStatement)iterator.next();
                try {
                    preparedStatement.clearBatch();
                }
                catch (SQLException e) {
                    EJBDatabaseMessages.warningClearBatchOnStatement(e);
                }
            }
            this.m_batchedStatements.clear();
        }

        public void sendBatchStatements() throws SQLException {
            int bch = 0;
            Iterator iterator = this.m_batchedStatements.iterator();
            while (iterator.hasNext()) {
                PreparedStatement preparedStatement = (PreparedStatement)iterator.next();
                int[] ret = preparedStatement.executeBatch();
                ++bch;
                if (!m_logger.isLoggable(Level.FINE)) continue;
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "sendBatchStatements -- executeBatch " + preparedStatement + ":" + ret);
            }
            if (bch > 0) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "sendBatchStatements -- ttl = " + bch);
            }
            this.m_batchedStatements.clear();
        }

        public void batchStatement(PreparedStatement stmt, Flag isCached, String syntax, int executeBatchSize, boolean delayUntilCommit) throws SQLException {
            if (executeBatchSize > 1) {
                stmt.addBatch();
                this.m_batchedStatements.add(stmt);
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnection." + "batchStatement -- addBatch " + stmt + "=" + syntax + " bs=" + executeBatchSize);
                }
            }
            isCached.set(false);
        }
    }
}

