/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.security.UserManager;
import com.evermind.server.deployment.UserManagerConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UserManagerConfigList {
    public static final int NO_COMPAT = 0;
    public static final int COMPAT_9_0_3 = 1;
    public static final int COMPAT_9_0_4 = 2;
    private List configs;
    private List filtered;
    private UserManagerConfig genericUserManager;
    private int compat;
    private UserManager parent;

    public UserManagerConfigList(int compat) {
        this.compat = compat;
        this.configs = new LinkedList();
    }

    public boolean isEmpty() {
        return this.configs.isEmpty();
    }

    public void add(UserManagerConfig userManagerConfig) {
        this.configs.add(userManagerConfig);
        this.configChanged();
    }

    void configChanged() {
        if (this.genericUserManager != null) {
            this.filtered = this.filter(this.compat, this.configs);
            UserManager underlying = this.chain(this.parent, this.filtered);
            this.genericUserManager.setUnderlying(underlying);
        }
    }

    public void setParent(UserManager newParent) {
        UserManager oldParent = this.parent;
        this.parent = newParent;
        if (oldParent != newParent) {
            this.configChanged();
        }
    }

    public UserManager getUserManager() {
        boolean firstTime;
        boolean bl = firstTime = this.genericUserManager == null;
        if (firstTime) {
            this.genericUserManager = this.genericUserManager = new UserManagerConfig.Generic();
            this.configChanged();
        }
        return this.genericUserManager;
    }

    UserManager chain(UserManager parent, List configList) {
        UserManager previous = parent;
        Iterator configs = configList.iterator();
        while (configs.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)configs.next();
            userManagerConfig.setParent(previous);
            previous = userManagerConfig;
        }
        return previous;
    }

    private List filter(int compat, List list) {
        List result;
        switch (compat) {
            case 2: {
                result = this.filter904(list);
                break;
            }
            case 1: {
                result = list;
                break;
            }
            default: {
                result = list;
            }
        }
        return result;
    }

    private List filter903(List list) {
        throw new RuntimeException("NYI");
    }

    private List filter904(List list) {
        boolean hasPrincipals = false;
        boolean hasJazn = false;
        boolean hasCustom = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig member = (UserManagerConfig)iterator.next();
            switch (member.kind()) {
                case 1: {
                    hasJazn = true;
                    break;
                }
                case 2: {
                    hasPrincipals = true;
                    break;
                }
                case 3: {
                    hasCustom = true;
                }
            }
        }
        int selected = hasCustom ? 3 : (hasJazn ? 1 : (hasPrincipals ? 2 : -1));
        LinkedList<UserManagerConfig> result = new LinkedList<UserManagerConfig>();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            UserManagerConfig member = (UserManagerConfig)iterator2.next();
            if (member.kind() != selected) continue;
            result.add(member);
        }
        return result;
    }

    public void validate() throws InstantiationException {
        this.getUserManager();
        Iterator iterator = this.filtered.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)iterator.next();
            userManagerConfig.ultimate();
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)iterator.next();
            userManagerConfig.writeXML(out, indention);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)iterator.next();
            userManagerConfig.setClassLoader(loader);
        }
    }

    public void start() {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)iterator.next();
            userManagerConfig.start();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        boolean firstTime = true;
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            UserManagerConfig userManagerConfig = (UserManagerConfig)iterator.next();
            if (!firstTime) {
                buf.append(", ");
            }
            firstTime = false;
            buf.append(userManagerConfig.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

