/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDestination
extends AbstractDescribable
implements XMLizable {
    protected String location;
    protected String type;
    protected String icon;

    public MessageDestination(String name) throws InstantiationException {
        super(name);
    }

    public MessageDestination(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("message-destination-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("display-name")) {
                    this.setDisplayName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (nodeName.equals("icon")) {
                    this.icon = XMLUtils.getStringValue(node);
                    continue;
                }
                throw new InstantiationException("Unknown message-destination tag: " + nodeName);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("message-destination tag with missing message-destination-name subtag");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.firePropertyChangeEvent("location", this.location, location);
    }

    public void writeXML(PrintWriter out, String indentation) {
        out.println(indentation + "<message-destination>");
        if (this.getName() != null) {
            out.println(indentation + indentation + "<message-destination-name>" + XMLUtils.encode(this.getName()) + "</message-destination-name>");
        }
        if (this.getDescription() != null) {
            out.println(indentation + indentation + "<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getDisplayNameOnly() != null) {
            out.println(indentation + indentation + "<display-name>" + XMLUtils.encode(this.getDisplayNameOnly()) + "</display-name>");
        }
        if (this.icon != null) {
            out.println(indentation + indentation + "<icon>" + XMLUtils.encode(this.icon) + "</icon>");
        }
        out.println(indentation + "</message-destination>");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (!XMLUtils.isCommentOrID(nodeName)) continue;
            }
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + "<message-destination-mapping name=\"" + XMLUtils.encode(this.getName()) + "\"");
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        out.println(" />");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.firePropertyChangeEvent("type", this.type, type);
    }
}

