/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.MessageListener;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.j2ee.connector.logging.JCADeploymentMessages;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InboundResourceAdapter
extends AbstractDescribable
implements XMLizable {
    protected Map m_messageListeners;

    public InboundResourceAdapter(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("messageadapter")) {
                    this.parseMessageAdapter(node);
                    continue;
                }
                throw new InstantiationException("Unknown inbound-resourceadapter subtag: " + nodeName);
            }
        }
    }

    protected void parseMessageAdapter(Node parent) throws InstantiationException {
        if (parent == null) {
            return;
        }
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("messagelistener")) {
                    this.addMessageListener(new MessageListener(node));
                    continue;
                }
                throw new InstantiationException("Unknown 'messageadapter' subtag: " + nodeName);
            }
        }
        if (this.m_messageListeners == null) {
            throw new InstantiationException("Missing 'messagelistener' subtag in messageadapter tag");
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        if (this.m_messageListeners == null) {
            this.m_messageListeners = new HashMap();
        }
        if (this.getMessageListenerTypes().contains(messageListener.getMessageListenerType())) {
            JCADeploymentMessages.warningDuplicateMsgLsnrType();
        } else {
            this.m_messageListeners.put(messageListener.getMessageListenerType(), messageListener);
        }
    }

    public MessageListener getMessageListener(String listenerClass) {
        return (MessageListener)this.m_messageListeners.get(listenerClass);
    }

    public Set getMessageListenerTypes() {
        return this.m_messageListeners.keySet();
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<inbound-resourceadapter>");
        if (this.m_messageListeners != null) {
            out.println(indention + "\t<messageadapter>");
            XMLUtils.writeAll(this.m_messageListeners.values(), out, indention + "\t\t");
            out.println(indention + "\t</messageadapter>");
        }
        out.println(indention + "</inbound-resourceadapter>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
    }
}

