/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector;

import com.evermind.server.connector.ConnectionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.Transaction;

public class ConnectionSharingPool {
    private HashMap m_txnPool;

    public ConnectionSharingPool() {
        this.initPool();
    }

    public int getSize() {
        return this.m_txnPool.size();
    }

    private void initPool() {
        this.m_txnPool = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Transaction txn, ConnectionContext connCtx) {
        if (connCtx == null || txn == null) {
            return false;
        }
        ArrayList<ConnectionContext> listForTxn = null;
        Cloneable cloneable = this.m_txnPool;
        synchronized (cloneable) {
            listForTxn = (ArrayList<ConnectionContext>)this.m_txnPool.get(txn);
            if (listForTxn == null) {
                listForTxn = new ArrayList<ConnectionContext>();
                this.m_txnPool.put(txn, listForTxn);
                listForTxn.add(connCtx);
                return true;
            }
        }
        if (listForTxn != null) {
            cloneable = listForTxn;
            synchronized (cloneable) {
                if (listForTxn.contains(connCtx)) {
                    return false;
                }
                listForTxn.add(connCtx);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionContext get(Subject subject, ConnectionRequestInfo cxRequestInfo, Transaction txn, ManagedConnection preferredMC) {
        ConnectionContext match = null;
        if (txn != null) {
            List txnList = null;
            Object object = this.m_txnPool;
            synchronized (object) {
                txnList = (List)this.m_txnPool.get(txn);
            }
            if (txnList != null) {
                object = txnList;
                synchronized (object) {
                    match = this.findMatchFromList(txnList, subject, cxRequestInfo, preferredMC);
                }
            }
        }
        return match;
    }

    private ConnectionContext findMatchFromList(List shareableList, Subject subject, ConnectionRequestInfo cxRequestInfo, ManagedConnection preferredMC) {
        ConnectionContext match = null;
        ConnectionContext bestMatch = null;
        Iterator iter = shareableList.iterator();
        while (iter.hasNext() && bestMatch == null) {
            ConnectionContext connCtx = (ConnectionContext)iter.next();
            if (!connCtx.matchCredentials(subject, cxRequestInfo)) continue;
            if (connCtx.getManagedConnection() == preferredMC) {
                bestMatch = connCtx;
                continue;
            }
            match = connCtx;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transactionEnded(Transaction txn) {
        HashMap hashMap = this.m_txnPool;
        synchronized (hashMap) {
            this.m_txnPool.remove(txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ConnectionContext connectionContext) {
        if (connectionContext == null || !connectionContext.isAssociatedWithTransaction()) {
            return false;
        }
        Transaction txn = connectionContext.getXaTransaction();
        if (txn != null) {
            HashMap hashMap = this.m_txnPool;
            synchronized (hashMap) {
                List txnList = (List)this.m_txnPool.get(txn);
                if (txnList != null) {
                    txnList.remove(connectionContext);
                    if (txnList.isEmpty()) {
                        this.m_txnPool.remove(txn);
                    }
                }
            }
        }
        return true;
    }

    void destroy() {
        this.initPool();
    }
}

