/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.administration;

import com.evermind.server.Application;
import com.evermind.server.administration.ResourceFinder;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.ResourceInfo;
import com.evermind.server.deployment.ResourceProvider;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.BeanBinding;
import com.evermind.server.ejb.deployment.EJBReference;
import com.oracle.naming.J2EEContext;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import oracle.j2ee.connector.OracleConnectionManager;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;

public class ApplicationResourceFinder
implements ResourceFinder {
    public static final String LOCATION_TYPE_DATASOURCE = "javax.sql.DataSource";
    Application m_application;

    public ApplicationResourceFinder(Application application) {
        this.m_application = application;
    }

    public String getLocation(String name, String typeName) throws InstantiationException {
        Application current;
        Class<?> typeClass = null;
        for (current = this.m_application; current != null; current = current.getParent()) {
            ResourceProvider[] resourceProviders = current.getResourceProviders();
            if (resourceProviders == null) continue;
            for (int i = 0; i < resourceProviders.length; ++i) {
                ResourceInfo resource;
                ResourceProvider provider = resourceProviders[i];
                if (!provider.getHandledTypes().contains(typeName) || (resource = provider.getDefaultResource(typeName)) == null) continue;
                return "java:comp/resource/" + provider.getName() + "/" + resource.getName();
            }
        }
        try {
            Object instance = this.m_application.getContext().lookup(name);
            if (typeClass == null) {
                typeClass = Class.forName(typeName, true, (ClassLoader)this.m_application.getBeansClassLoader());
            }
            if (typeClass.isAssignableFrom(instance.getClass())) {
                return name;
            }
        }
        catch (NamingException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        current = this.m_application;
        if (typeName.equals(LOCATION_TYPE_DATASOURCE)) {
            throw new InstantiationException("No location specified for resource-ref " + name);
        }
        if (typeName.equals("javax.sql.XADataSource")) {
            throw new InstantiationException("No location specified for resource-ref " + name);
        }
        if (typeName.equals("javax.sql.ConnectionPoolDataSource")) {
            throw new InstantiationException("No location specified for resource-ref " + name);
        }
        if (typeName.equals("javax.jms.ConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultConnectionFactoryLocation(false);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.QueueConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultQueueConnectionFactoryLocation(false);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.TopicConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultTopicConnectionFactoryLocation(false);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.XAConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultConnectionFactoryLocation(true);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.XAQueueConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultQueueConnectionFactoryLocation(true);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.XATopicConnectionFactory")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                return this.m_application.getServer().getJMSServer().getDefaultTopicConnectionFactoryLocation(true);
            }
            throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
        }
        if (typeName.equals("javax.jms.Queue")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                String queue = this.m_application.getServer().getJMSServer().getDefaultQueueLocation();
                if (queue != null) {
                    return queue;
                }
            } else {
                throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
            }
            throw new InstantiationException("No location set for Queue resource " + name);
        }
        if (typeName.equals("javax.jms.Topic")) {
            if (this.m_application != null && this.m_application.getServer().getJMSServer() != null) {
                String topic = this.m_application.getServer().getJMSServer().getDefaultTopicLocation();
                if (topic != null) {
                    return topic;
                }
            } else {
                throw new InstantiationException("Unable to link resource " + name + ", no JMS server running");
            }
            throw new InstantiationException("No location set for Topic resource " + name);
        }
        if (typeName.equals("javax.mail.Session")) {
            List infos;
            Application intermediate;
            MailSessionInfo defaultSession = null;
            for (intermediate = this.m_application; defaultSession == null && intermediate != null; intermediate = intermediate.getParent()) {
                defaultSession = intermediate.getConfig().getDefaultMailSession(false);
            }
            if (defaultSession != null && defaultSession.getLocation() != null) {
                return defaultSession.getLocation();
            }
            for (intermediate = this.m_application; intermediate != null; intermediate = intermediate.getParent()) {
                infos = intermediate.getConfig().getMailSessions();
                if (infos == null || infos.isEmpty()) continue;
                return ((MailSessionInfo)infos.get(0)).getLocation();
            }
            if (defaultSession == null) {
                defaultSession = this.m_application.getServer().getConfig().getDefaultApplicationConfig().getDefaultMailSession(true);
            }
            if (defaultSession != null && defaultSession.getLocation() != null) {
                return defaultSession.getLocation();
            }
            infos = this.m_application.getServer().getConfig().getDefaultApplicationConfig().getMailSessions();
            if (infos != null && !infos.isEmpty()) {
                return ((MailSessionInfo)infos.get(0)).getLocation();
            }
            throw new InstantiationException("No location set for javax.mail.Session resource " + name);
        }
        if (typeName.equals("javax.resource.cci.ConnectionFactory")) {
            return name;
        }
        throw new InstantiationException("Unknown resource type: " + typeName);
    }

    public String getLocation(EJBReference reference) throws InstantiationException {
        this.m_application.getEJBContainer().resolveReference(reference);
        return reference.getLocation();
    }

    public Object getEjbBinding(EJBReference reference) throws InstantiationException {
        Reference ref = null;
        String location = this.getLocation(reference);
        if (!reference.isEndpoint() && reference.getHome() == null) {
            ref = BeanBinding.createBinding(location, reference);
        } else {
            Class clazz = reference.isLocal() ? EJBLocalHome.class : EJBHome.class;
            ref = BeanBinding.createHomeBinding(clazz, location, reference);
        }
        return ref;
    }

    public Map getLocations(Map bindings) throws InstantiationException {
        Iterator iterator = bindings.entrySet().iterator();
        HashMap locations = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            locations.put(entry.getKey(), this.getLocation(entry.getKey().toString(), entry.getValue().toString()));
        }
        return locations;
    }

    public Set getLocations(String typeName) throws InstantiationException {
        Application current;
        HashSet<String> response = new HashSet<String>();
        for (current = this.m_application; current != null; current = current.getParent()) {
            ResourceProvider[] resourceProviders = current.getResourceProviders();
            if (resourceProviders == null) continue;
            for (int i = 0; i < resourceProviders.length; ++i) {
                Set resources;
                ResourceProvider provider = resourceProviders[i];
                if (!provider.getHandledTypes().contains(typeName) || (resources = provider.getResources(typeName)) == null) continue;
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    ResourceInfo info = (ResourceInfo)iterator.next();
                    response.add("java:comp/resource/" + provider.getName() + "/" + info.getName());
                }
            }
        }
        if (typeName.equals(LOCATION_TYPE_DATASOURCE)) {
            for (current = this.m_application; current != null; current = current.getParent()) {
                Iterator iter = current.getNativeDataSourceConfigs().values().iterator();
                while (iter.hasNext()) {
                    NativeDataSourceConfig ndsConfig = (NativeDataSourceConfig)iter.next();
                    response.add(ndsConfig.getJndiName());
                }
                iter = current.getManagedDataSourceConfigs().values().iterator();
                while (iter.hasNext()) {
                    ManagedDataSourceConfig ndsConfig = (ManagedDataSourceConfig)iter.next();
                    response.add(ndsConfig.getJndiName());
                }
                if (current.getConfig().getSeeParentDataSources()) {
                    continue;
                }
                break;
            }
        } else if (typeName.equals("javax.jms.ConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(ConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.QueueConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(QueueConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.TopicConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(TopicConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.XAConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(XAConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.XAQueueConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(XAQueueConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.XATopicConnectionFactory")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(XATopicConnectionFactory.class));
            }
        } else if (typeName.equals("javax.jms.Queue")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(Queue.class));
            }
        } else if (typeName.equals("javax.jms.Topic")) {
            if (this.m_application.getServer().getJMSServer() != null) {
                response.addAll(this.m_application.getServer().getJMSServer().getImplementations(Topic.class));
            }
        } else if (typeName.equals("javax.mail.Session")) {
            for (current = this.m_application; current != null; current = current.getParent()) {
                Iterator iterator = current.getConfig().getMailSessions().iterator();
                while (iterator.hasNext()) {
                    MailSessionInfo info = (MailSessionInfo)iterator.next();
                    if (info.getLocation() == null) continue;
                    response.add(info.getLocation());
                }
            }
        } else {
            throw new InstantiationException("Unknown resource type: " + typeName);
        }
        return response;
    }

    public EJBHome getEJBHome(String name, String home, String remote, String type, String link, boolean local) throws RemoteException, InstantiationException {
        EJBReference reference = new EJBReference(name, local, false);
        reference.setHomeName(home);
        reference.setRemoteName(remote);
        reference.setType(type);
        reference.setEJBLink(link);
        EJBHome ejbHome = null;
        try {
            ejbHome = (EJBHome)this.m_application.getContext().lookup(this.getLocation(reference));
        }
        catch (NamingException namingException) {
            throw new InstantiationException("Error resolving EJB reference, exception = " + namingException.getMessage());
        }
        return ejbHome;
    }

    public Object getJCAConnectionResource(Context root, String location, ResourceReference reference) throws InstantiationException {
        Object jcaValue = null;
        Application application = this.m_application;
        while (jcaValue == null && application != null) {
            jcaValue = ApplicationConnectionManager.getOracleConnectionManager(application.getName() + "/" + "_jcaOracleConnectionManager/" + (location == null ? reference.getName() : location));
            if (jcaValue != null) continue;
            application = application.getParent();
        }
        if (jcaValue instanceof OracleConnectionManager) {
            OracleConnectionManager ocm = (OracleConnectionManager)((OracleConnectionManager)jcaValue).clone();
            ocm.setConnectionsShareable(reference.isShareable());
            if (root instanceof J2EEContext) {
                ocm.setBoundJNDILocation(root, reference);
            }
            ocm.setContainerAuthentication(reference.getContainerAuthentication());
            return ocm.getBindObject();
        }
        return null;
    }
}

