/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.compiler.CompilerFactory;
import com.evermind.net.NetUtils;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThreadPoolConfig;
import com.evermind.server.ApplicationServerUser;
import com.evermind.server.OC4JServer;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.WorkManagerThreadPoolConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.server.http.XMLHttpApplicationConfigContext;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.server.jms.XMLJMSServerConfig;
import com.evermind.server.rmi.RMIServerConfig;
import com.evermind.server.rmi.XMLRMIServerConfig;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.CharString;
import com.evermind.util.ClassDescriptor;
import com.evermind.util.ConfigUtils;
import com.evermind.util.ConsoleObfuscator;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.as.j2ee.transaction.TransactionManagerConfiguration;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.PathElement;
import oracle.classloader.util.VersionNumber;
import oracle.core.ojdl.logging.LoggingConfigurationException;
import oracle.core.ojdl.logging.config.ServerLoggingConfiguration;
import oracle.j2ee.jms.oc4j.v1.JMSServerConfig;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.admin.config.HttpServerConfig;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.loader.config.ConfigurationConsumer;
import oracle.oc4j.loader.config.xml.CodeSourceElement;
import oracle.oc4j.loader.config.xml.ImportSharedLibraryElement;
import oracle.oc4j.loader.config.xml.SharedLibraryElement;
import oracle.oc4j.security.SecurityUtil;
import oracle.security.jazn.realm.DeactivatableUser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLApplicationServerConfig
extends XMLServerConfig
implements ApplicationServerConfig,
HttpServerConfig {
    private String globalWebAppSettingsPath;
    private HttpApplicationConfigContext globalWebAppSettingsConfig;
    private long taskManagerGranularity = -1L;
    private Map databaseSchemas;
    private int recoveryProcedure = 1;
    private String autoDeploymentDirectoryPath;
    private String deploymentContextPath;
    private long nodeID;
    private int clusterPort;
    private static final boolean SFSB_ENABLE_PASSIVATION = true;
    private boolean sfsbEnablePassivation = true;
    private String applicationDirectory;
    private String connectorDirectory;
    private XMLHttpSiteConfig defaultSiteConfig;
    private String defaultSiteConfigPath;
    private EnterpriseArchive defaultApplicationConfig;
    private ApplicationConfigReference defaultApplicationConfigReference;
    private EnterpriseArchive systemApplicationConfig;
    private ApplicationConfigReference systemApplicationConfigReference;
    private List applicationConfigReferences;
    private Map compilerSettings;
    private String sharedLibrariesDirectory;
    private List siteConfigPaths;
    private List siteConfigs;
    private int defaultSiteIndex = -1;
    private List failureApplicationConfigReferences = new ArrayList();
    private List failureSiteConfigPaths = new ArrayList();
    private int failureDefaultSiteIndex = -1;
    private boolean secure;
    private boolean localhostIsAdmin = ServerProperties.getRunningInIAS();
    private List initLibraryPaths;
    private List sharedLibraries;
    private String maxHttpConnectionsRedirectURL;
    private int httpSocketBacklog = 30;
    private int maxHttpConnections = 1000000;
    private int maxHttpConnectionQueueTimeout = 10;
    private String jmsServerPath;
    private boolean jmsServerActive;
    private XMLJMSServerConfig jmsServerConfig;
    private oracle.j2ee.jms.oc4j.v1.XMLJMSServerConfig jmsServerConfig2;
    private String rmiServerPath;
    private boolean rmiServerActive;
    private XMLRMIServerConfig rmiServerConfig;
    private String javacachePath;
    private String J2EELoggingConfigurationPath;
    private boolean autoUnpackEnterpriseArchives;
    private String checkForUpdates;
    private ApplicationServerThreadPoolConfig _applicationServerThreadPoolConfig = new ApplicationServerThreadPoolConfig();
    private WorkManagerThreadPoolConfig _workManagerThreadPoolConfig = new WorkManagerThreadPoolConfig();
    private String transactionManagerXMLPath;
    private String sepPath = null;
    private boolean globalJNDIEnabled = false;
    private boolean environmentNamingURLFactoryEnabled = false;
    private String m_metricCollectorClassName;
    private HashMap m_metricCollectorParams;
    protected SSLConfig sslConfig;
    private String propPath = null;
    private static Logger m_logger = TraceLogger.getLogger(XMLApplicationServerConfig.class);

    protected void reset() {
        super.reset();
        this.globalWebAppSettingsPath = null;
        this.globalWebAppSettingsConfig = null;
        this.autoDeploymentDirectoryPath = null;
        this.secure = false;
        this.localhostIsAdmin = ServerProperties.getRunningInIAS();
        this.defaultSiteConfig = null;
        this.defaultSiteConfigPath = null;
        this.defaultSiteIndex = -1;
        this.defaultApplicationConfigReference = null;
        this.siteConfigPaths = null;
        this.siteConfigs = null;
        this.initLibraryPaths = null;
        this.sharedLibraries = null;
        this.maxHttpConnectionsRedirectURL = null;
        this.maxHttpConnections = 1000000;
        this.maxHttpConnectionQueueTimeout = 10;
        this.httpSocketBacklog = 30;
        this.jmsServerPath = null;
        this.jmsServerActive = false;
        this.jmsServerConfig = null;
        this.jmsServerConfig2 = null;
        if (!this.useNewJMSServer()) {
            XMLJMSServerConfig.removeAllJMSResourceMBeans();
        }
        this.autoUnpackEnterpriseArchives = false;
        this.rmiServerPath = null;
        this.javacachePath = null;
        this.J2EELoggingConfigurationPath = null;
        this.sepPath = null;
        this.rmiServerActive = false;
        this.rmiServerConfig = null;
        this.sslConfig = null;
        this._applicationServerThreadPoolConfig = new ApplicationServerThreadPoolConfig();
        this._workManagerThreadPoolConfig = new WorkManagerThreadPoolConfig();
    }

    public XMLApplicationServerConfig() {
        super((XMLServerConfig)null);
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        block31: {
            if (name.equals("deployment-directory")) {
                this.deploymentContextPath = value;
            } else if (name.equals("localhostIsAdmin")) {
                this.localhostIsAdmin = "true".equalsIgnoreCase(value);
            } else if (name.equals("secure")) {
                this.secure = "true".equalsIgnoreCase(value);
            } else if (name.equals("application-directory")) {
                this.applicationDirectory = value;
            } else if (name.equals("check-for-updates")) {
                this.checkForUpdates = value;
            } else if (name.equals("connector-directory")) {
                this.connectorDirectory = value;
            } else if (name.equals("application-auto-deploy-directory")) {
                this.autoDeploymentDirectoryPath = value;
            } else if (name.equals("recovery-procedure")) {
                this.recoveryProcedure = XMLApplicationServerConfig.getRecoveryProcedure(value);
            } else if (name.equals("auto-unpack-applications")) {
                this.autoUnpackEnterpriseArchives = "true".equalsIgnoreCase(value);
            } else if (name.equals("shared-libraries-directory")) {
                this.sharedLibrariesDirectory = value;
            } else {
                if (name.equals("taskmanager-granularity")) {
                    try {
                        this.taskManagerGranularity = Long.parseLong(value);
                    }
                    catch (Exception e) {
                        throw new InstantiationException("Illegal taskmanager-granularity value (not a valid long): '" + value + "'");
                    }
                }
                if (name.equals("default-host")) {
                    try {
                        if (value.equalsIgnoreCase("[ALL]")) {
                            this.setAddress(NetUtils.ZERO_ADDRESS);
                            break block31;
                        }
                        InetAddress address = InetAddress.getByName(value);
                        this.setAddress(address);
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else if (name.equalsIgnoreCase("global-jndi-lookup-enabled")) {
                    this.globalJNDIEnabled = "true".equals(value);
                }
            }
        }
        if (name.equalsIgnoreCase("environment-naming-url-factory-enabled")) {
            this.environmentNamingURLFactoryEnabled = "true".equals(value);
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    String getXmlConfiguredCheckForUpdateValue() {
        return this.checkForUpdates;
    }

    void setXmlConfiguredCheckForUpdateValue(String value) {
        this.checkForUpdates = value;
    }

    private void initJ2eeLogging() {
        if (ApplicationServer.getInstance() != null) {
            if (ServerProperties.getApplicationServerDebug()) {
                Logger.getAnonymousLogger().log(Level.FINEST, "Application server instance is not null. Not invoking the j2ee-logging code");
            }
            return;
        }
        try {
            String j2eeLoggingConfigurationPath = this.getJ2EELoggingConfigurationPath();
            if (j2eeLoggingConfigurationPath != null) {
                ServerLoggingConfiguration.readConfiguration((String)j2eeLoggingConfigurationPath);
            }
        }
        catch (LoggingConfigurationException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Unable to read logging configuration", e);
        }
    }

    protected void postInit() throws InstantiationException {
        super.postInit();
        this.initJ2eeLogging();
        if (this.compilerSettings == null || !"jcomp".equals(this.compilerSettings.get("executable"))) {
            this.autoUnpackEnterpriseArchives = true;
        }
        this.InitSystemApplication();
        this.postInitDefaultApplication();
        this.postInitApplications();
        this.postInitSiteConfigs();
    }

    private void InitSystemApplication() throws InstantiationException {
        URL deploymentURL;
        String systemApplicationPath = "system-application.xml";
        URL systemConfigFile = null;
        try {
            systemConfigFile = ConfigUtils.getURL(this.getURL(), "system-application.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.systemApplicationConfigReference == null) {
            this.systemApplicationConfigReference = new ApplicationConfigReference(systemConfigFile, ApplicationServer.getSystemApplicationName());
        }
        if ((deploymentURL = this.systemApplicationConfigReference.getDeploymentDescriptorURL()) == null && this.deploymentContextPath != null && !"[none]".equalsIgnoreCase(this.systemApplicationConfigReference.deploymentDirectoryPath)) {
            try {
                deploymentURL = ConfigUtils.getURL(this.getURL(), this.deploymentContextPath + "/" + this.systemApplicationConfigReference.getName());
            }
            catch (IOException e) {
                InstantiationException ie = new InstantiationException("malformed deployment URL");
                ie.initCause(e);
                throw ie;
            }
        }
        try {
            this.systemApplicationConfig = new EnterpriseArchive(this.systemApplicationConfigReference.getName(), this.systemApplicationConfigReference.getURL(), deploymentURL, this, null, true, null);
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Error instantiating system application");
            ie.initCause(e);
            throw ie;
        }
    }

    public synchronized void addHttpSite(String path, HttpSiteConfig config) {
        if (this.siteConfigPaths == null) {
            this.siteConfigPaths = new ArrayList();
        }
        if (this.siteConfigs == null) {
            this.siteConfigs = new ArrayList();
        }
        this.siteConfigPaths.add(path);
        this.siteConfigs.add(config);
    }

    public HttpServerConfig getHttpServerConfig() {
        return this;
    }

    public synchronized JMSServerConfig getJMSServerConfig() throws InstantiationException {
        if (this.jmsServerPath == null || !this.jmsServerActive) {
            return null;
        }
        if (!this.useNewJMSServer()) {
            if (this.jmsServerConfig != null) {
                return this.jmsServerConfig;
            }
        } else if (this.jmsServerConfig2 != null) {
            return this.jmsServerConfig2;
        }
        try {
            XMLJMSServerConfig config = null;
            oracle.j2ee.jms.oc4j.v1.XMLJMSServerConfig config2 = null;
            if (!this.useNewJMSServer()) {
                config = new XMLJMSServerConfig(this);
            } else {
                config2 = new oracle.j2ee.jms.oc4j.v1.XMLJMSServerConfig(this);
            }
            URL url = ConfigUtils.getURL(this.getURL(), this.jmsServerPath);
            try {
                if (!this.useNewJMSServer()) {
                    XMLJMSServerConfig.removeAllJMSResourceMBeans();
                    config.init(url);
                } else {
                    config2.init(url);
                }
            }
            catch (InstantiationException e) {
                InstantiationException ie = new InstantiationException("Error parsing jms-server config at " + url + ": " + e.getMessage());
                ie.initCause(e);
                throw ie;
            }
            if (!this.useNewJMSServer()) {
                this.jmsServerConfig = config;
                return config;
            }
            this.jmsServerConfig2 = config2;
            return config2;
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + this.jmsServerPath);
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Could not read JMS config file: " + this.jmsServerPath + (e.getMessage() == null ? "" : ": " + e.getMessage()));
            ie.initCause(e);
            throw ie;
        }
    }

    public synchronized List getCanonicalInitLibraryPaths() {
        try {
            return FileUtils.getCanonicalPaths((String)this.getDirectoryURLString(), (List)this.initLibraryPaths);
        }
        catch (MalformedURLException e) {
            ClassLoadLogger.logException((String)"Unable to add <init-library>.", (Throwable)e, (boolean)false);
            return Collections.EMPTY_LIST;
        }
    }

    public synchronized List getSharedLibraries() {
        if (this.sharedLibraries == null) {
            return Collections.EMPTY_LIST;
        }
        return this.sharedLibraries;
    }

    public synchronized void setSharedLibraries(List sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public synchronized void removeSharedLibrary(String libraryName, String libraryVersion) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                if (!lib.getName().equals(libraryName) || !lib.getVersion().equals(libraryVersion)) continue;
                this.sharedLibraries.remove(i);
            }
        }
    }

    public synchronized void addSharedLibrary(String libraryName, String libraryVersion, String parentName, String parentVersion) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        SharedLibraryElement shLib = null;
        if (this.sharedLibraries != null) {
            for (int lib = 0; lib < this.sharedLibraries.size(); ++lib) {
                shLib = (SharedLibraryElement)this.sharedLibraries.get(lib);
                if (!shLib.getName().equals(libraryName) || !shLib.getVersion().equals(libraryVersion)) continue;
                throw new InstantiationException("Shared Library already exists");
            }
        } else {
            this.sharedLibraries = new ArrayList();
        }
        shLib = new SharedLibraryElement(libraryName, libraryVersion, parentName, parentVersion);
        this.sharedLibraries.add(shLib);
    }

    public void modifySharedLibrary(String libraryName, String libraryVersion, Boolean libraryCompatible, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws InstantiationException {
        int i;
        int i2;
        if (!this.checkSharedLibraryExists(libraryName, libraryVersion)) {
            throw new InstantiationException("Specified shared library '" + libraryName + " ver. " + libraryVersion + "' does not exist");
        }
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library is not modifiable");
        }
        if (addCodeSources == null) {
            addCodeSources = new String[]{};
        }
        if (removeCodeSources == null) {
            removeCodeSources = new String[]{};
        }
        if (addImports == null) {
            addImports = new ImportSharedLibrary[]{};
        }
        if (removeImports == null) {
            removeImports = new String[]{};
        }
        if (addCodeSources.length == 0 && removeCodeSources.length == 0 && addImports.length == 0 && removeImports.length == 0 && libraryCompatible == null) {
            return;
        }
        SharedLibraryElement originalLibrary = this.getSharedLibrary(libraryName, libraryVersion);
        boolean instantiated = originalLibrary.isInstantiated();
        List codeSources = originalLibrary.getCodeSources();
        LinkedList<CodeSourceElement> modCodeSources = new LinkedList<CodeSourceElement>();
        modCodeSources.addAll(codeSources);
        CodeSourceElement codeSource = null;
        for (int i3 = 0; i3 < removeCodeSources.length; ++i3) {
            String rcs = removeCodeSources[i3];
            if (rcs == null || rcs.length() == 0) {
                throw new IllegalArgumentException("Illegal empty code source path specified for removal");
            }
            codeSource = new CodeSourceElement(rcs);
            if (modCodeSources.remove(codeSource)) continue;
            throw new InstantiationException("Specified code source to be removed '" + rcs + "' does not exist");
        }
        List imports = originalLibrary.getImports();
        LinkedList<ImportSharedLibraryElement> modImports = new LinkedList<ImportSharedLibraryElement>();
        modImports.addAll(imports);
        ImportSharedLibraryElement importLib = null;
        for (i2 = 0; i2 < removeImports.length; ++i2) {
            String ri = removeImports[i2];
            if (ri == null || ri.length() == 0) {
                throw new IllegalArgumentException("Illegal empty import name specified for removal");
            }
            boolean found = false;
            for (int j = 0; j < modImports.size(); ++j) {
                importLib = (ImportSharedLibraryElement)modImports.get(j);
                if (!importLib.getName().equals(removeImports[i2])) continue;
                found = true;
                modImports.remove(j);
                break;
            }
            if (found) continue;
            throw new InstantiationException("Specified shared library import to be removed '" + removeImports[i2] + "' does not exist");
        }
        for (i2 = 0; i2 < addCodeSources.length; ++i2) {
            String acs = addCodeSources[i2];
            if (acs == null || acs.length() == 0) {
                throw new IllegalArgumentException("Illegal empty code source path specified to be added");
            }
            codeSource = new CodeSourceElement(addCodeSources[i2]);
            if (modCodeSources.contains(codeSource)) {
                throw new InstantiationException("Specified code source to be added '" + addCodeSources[i2] + "' already exists");
            }
            modCodeSources.add(codeSource);
        }
        for (i2 = 0; i2 < addImports.length; ++i2) {
            ImportSharedLibrary isl = addImports[i2];
            if (isl == null || isl.getName() == null || isl.getName().length() == 0) {
                throw new IllegalArgumentException("Illegal empty code source path specified for removal");
            }
            for (int j = 0; j < modImports.size(); ++j) {
                importLib = (ImportSharedLibraryElement)modImports.get(j);
                if (!importLib.getName().equals(isl.getName())) continue;
                throw new InstantiationException("Specified shared library import to be added '" + importLib.getName() + "' already exists");
            }
            modImports.add(new ImportSharedLibraryElement(addImports[i2].getName(), addImports[i2].getMinVersion(), addImports[i2].getMaxVersion()));
        }
        if (modCodeSources.size() == 0 && modImports.size() == 0) {
            throw new InstantiationException("Shared libraries must have at least one valid code source or import");
        }
        String timeStr = Long.toString(System.currentTimeMillis());
        String unique = "." + timeStr.substring(timeStr.length() - 8);
        SharedLibraryElement modLibrary = new SharedLibraryElement(libraryName, libraryVersion + unique, originalLibrary.getParentName(), originalLibrary.getParentVersion());
        if (libraryCompatible == null) {
            modLibrary.setLibraryCompatible(originalLibrary.isLibraryCompatible());
        } else {
            modLibrary.setLibraryCompatible(libraryCompatible);
        }
        File sharedLibDir = null;
        try {
            sharedLibDir = new File(this.getSharedLibrariesDirectory());
        }
        catch (IOException ioe) {
            InstantiationException ie = new InstantiationException("Error instantiating modified shared library");
            ie.initCause(ioe);
            throw ie;
        }
        String configPath = this.getURL().getPath();
        File serverConfigDir = new File(configPath).getParentFile();
        File originalLibDir = originalLibrary.isLibraryCompatible() ? serverConfigDir : new File(sharedLibDir, libraryName + File.separatorChar + libraryVersion);
        Iterator it = modCodeSources.iterator();
        while (it.hasNext()) {
            codeSource = (CodeSourceElement)it.next();
            File csFile = new File(codeSource.getPath());
            if (!csFile.isAbsolute()) {
                csFile = new File(originalLibDir, codeSource.getPath());
                codeSource = new CodeSourceElement(csFile.getAbsolutePath());
            }
            modLibrary.addCodeSource(codeSource);
        }
        it = modImports.iterator();
        while (it.hasNext()) {
            modLibrary.addImport((ImportSharedLibraryElement)it.next());
        }
        PolicyClassLoader lib = ConfigurationConsumer.createSharedLibrary(modLibrary, sharedLibDir, serverConfigDir, false, configPath);
        originalLibrary.setLibraryCompatible(modLibrary.isLibraryCompatible());
        for (int i4 = 0; i4 < removeCodeSources.length; ++i4) {
            originalLibrary.removeCodeSource(removeCodeSources[i4]);
        }
        LinkedList<ImportSharedLibraryElement> importsRemoved = new LinkedList<ImportSharedLibraryElement>();
        for (i = 0; i < removeImports.length; ++i) {
            Iterator it2 = originalLibrary.getImports().iterator();
            while (it2.hasNext()) {
                ImportSharedLibraryElement elem = (ImportSharedLibraryElement)it2.next();
                if (!elem.getName().equals(removeImports[i])) continue;
                importsRemoved.add(elem);
                break;
            }
            originalLibrary.removeImport(removeImports[i]);
        }
        for (i = 0; i < addCodeSources.length; ++i) {
            originalLibrary.addCodeSource(new CodeSourceElement(addCodeSources[i]));
        }
        for (i = 0; i < addImports.length; ++i) {
            String name = addImports[i].getName();
            String min = addImports[i].getMinVersion();
            String max = addImports[i].getMaxVersion();
            originalLibrary.addImport(new ImportSharedLibraryElement(name, min, max));
        }
        try {
            this.store();
            originalLibrary.setInstantiated(false);
        }
        catch (IOException ioe) {
            int i5;
            for (i5 = 0; i5 < addCodeSources.length; ++i5) {
                originalLibrary.removeCodeSource(addCodeSources[i5]);
            }
            for (i5 = 0; i5 < removeCodeSources.length; ++i5) {
                originalLibrary.addCodeSource(new CodeSourceElement(removeCodeSources[i5]));
            }
            for (i5 = 0; i5 < addImports.length; ++i5) {
                originalLibrary.removeImport(addImports[i5].getName());
            }
            Iterator it3 = importsRemoved.iterator();
            while (it3.hasNext()) {
                originalLibrary.addImport((ImportSharedLibraryElement)it3.next());
            }
            originalLibrary.setInstantiated(instantiated);
            InstantiationException ie = new InstantiationException("Error persisting shared library config");
            ie.initCause(ioe);
            throw ie;
        }
    }

    public synchronized boolean checkSharedLibraryExists(String libraryName, String libraryVersion) {
        if (libraryName == null || libraryName.length() == 0) {
            throw new IllegalArgumentException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new IllegalArgumentException("Illegal libraryVersion value (null)");
        }
        if (this.getSharedLibrary(libraryName, libraryVersion) != null) {
            return true;
        }
        PolicyClassLoader[] bootList = ClassLoaderQuery.getSystemSharedLoaders((boolean)true);
        for (int i = 0; i < bootList.length; ++i) {
            if (!bootList[i].getName().equals(libraryName) || !bootList[i].getVersionNumber().equals((Object)new VersionNumber(libraryVersion))) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean checkSharedLibraryExists(String libraryName) {
        if (libraryName == null || libraryName.length() == 0) {
            throw new IllegalArgumentException("Illegal libraryName value (null)");
        }
        if (this.getSharedLibrary(libraryName) != null) {
            return true;
        }
        PolicyClassLoader[] bootList = ClassLoaderQuery.getSystemSharedLoaders((boolean)true);
        for (int i = 0; i < bootList.length; ++i) {
            if (!bootList[i].getName().equals(libraryName)) continue;
            return true;
        }
        return false;
    }

    private SharedLibraryElement getSharedLibrary(String name, String version) {
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                if (!lib.getName().equals(name) || !lib.getVersion().equals(version)) continue;
                return lib;
            }
        }
        return null;
    }

    public SharedLibraryElement getSharedLibrary(String name) {
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                if (!lib.getName().equals(name)) continue;
                return lib;
            }
        }
        return null;
    }

    public synchronized void removeSharedLibraryCodeSource(String libraryName, String libraryVersion, String path) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        if (path == null || path.length() == 0) {
            throw new InstantiationException("Illegal path value (null)");
        }
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                if (!lib.getName().equals(libraryName) || !lib.getVersion().equals(libraryVersion)) continue;
                lib.removeCodeSource(path);
                return;
            }
        }
    }

    public synchronized void addSharedLibraryCodeSource(String libraryName, String libraryVersion, String path) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        if (path == null || path.length() == 0) {
            throw new InstantiationException("Illegal path value (null)");
        }
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                CodeSourceElement codeSource = null;
                if (!lib.getName().equals(libraryName) || !lib.getVersion().equals(libraryVersion)) continue;
                List codeSources = lib.getCodeSources();
                for (int cs = 0; cs < codeSources.size(); ++cs) {
                    codeSource = (CodeSourceElement)codeSources.get(cs);
                    if (!codeSource.getPath().equals(path)) continue;
                    throw new InstantiationException("Code Source already exists");
                }
                codeSource = new CodeSourceElement(path);
                lib.addCodeSource(codeSource);
                return;
            }
        }
        throw new InstantiationException("Shared Library does not exist");
    }

    public synchronized void removeSharedLibraryImport(String libraryName, String libraryVersion, String name) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        if (name == null || name.length() == 0) {
            throw new InstantiationException("Illegal name value (null)");
        }
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                if (!lib.getName().equals(libraryName) || !lib.getVersion().equals(libraryVersion)) continue;
                lib.removeImport(name);
                return;
            }
        }
    }

    public synchronized void addSharedLibraryImport(String libraryName, String libraryVersion, String name, String minVersion, String maxVersion) throws InstantiationException {
        if (libraryName == null || libraryName.length() == 0) {
            throw new InstantiationException("Illegal libraryName value (null)");
        }
        if (libraryVersion == null || libraryVersion.length() == 0) {
            throw new InstantiationException("Illegal libraryVersion value (null)");
        }
        if (name == null || name.length() == 0) {
            throw new InstantiationException("Illegal name value (null)");
        }
        if (this.sharedLibraries != null) {
            for (int i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement lib = (SharedLibraryElement)this.sharedLibraries.get(i);
                ImportSharedLibraryElement importSharedLibrary = null;
                if (!lib.getName().equals(libraryName) || !lib.getVersion().equals(libraryVersion)) continue;
                List imports = lib.getImports();
                for (int imprt = 0; imprt < imports.size(); ++imprt) {
                    importSharedLibrary = (ImportSharedLibraryElement)imports.get(imprt);
                    if (!importSharedLibrary.getName().equals(name)) continue;
                    throw new InstantiationException("Import Shared Library already exists");
                }
                importSharedLibrary = new ImportSharedLibraryElement(name, minVersion, maxVersion);
                lib.addImport(importSharedLibrary);
                return;
            }
        }
        throw new InstantiationException("Shared Library does not exist");
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.startsWith("#")) {
            return;
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                if (!ApplicationServer.serverExtensionProviders[i].parseApplicationServerMainNode(this, node)) continue;
                return;
            }
        }
        if (name.equals("data-sources")) {
            throw new InstantiationException("<data-sources> tag not allowed in server.xml, move your <data-sources> tag to config/application.xml - the global application config for equivelent behaviour");
        }
        if (name.equals("compiler")) {
            this.parseCompiler(node);
        } else if (name.equals("java-compiler")) {
            this.parseJavaCompiler(node);
        } else if (name.equals("web-site")) {
            this.parseWebSite(node);
        } else if (name.equals("transaction-config")) {
            System.err.println("transaction-config of server.xml is discontinued - transaction-timeout attribute must be set in transaction-manager-config file");
        } else if (name.equals("global-site-config")) {
            this.defaultSiteConfigPath = XMLUtils.getNodeAttribute(node, "path");
        } else if (name.equals("global-web-app-config")) {
            this.globalWebAppSettingsPath = XMLUtils.getNodeAttribute(node, "path");
        } else if (name.equals("global-application")) {
            this.defaultApplicationConfigReference = new ApplicationConfigReference(node, this.getURL(), true);
        } else if (name.equals("application")) {
            this.addApplicationConfigReference(new ApplicationConfigReference(node, this.getURL(), false));
        } else if (name.equals("jms-config")) {
            this.parseJMSServerConfig(node);
        } else if (name.equals("rmi-config")) {
            this.parseRMIServerConfig(node);
        } else if (name.equals("transaction-manager-config")) {
            this.parseTransactionManagerConfig(node);
        } else if (name.equals("javacache-config")) {
            this.javacachePath = XMLUtils.getNodeAttribute(node, "path");
        } else if (name.equals("j2ee-logging-config")) {
            this.J2EELoggingConfigurationPath = XMLUtils.getNodeAttribute(node, "path");
        } else if (name.equals("sep-config")) {
            this.parseSepConfig(node);
        } else if (name.equals("cluster")) {
            this.parseCluster(node);
        } else if (name.equals("sfsb-config")) {
            this.parseSFSB(node);
        } else if (name.equals("global-thread-pool")) {
            this.parseThreadPool(node);
        } else if (name.equals("work-manager-thread-pool")) {
            this.parseWorkManagerThreadPool(node);
        } else if (name.equals("thread-pool")) {
            this.parseNewFormatThreadPool(node);
        } else if (name.equals("custom-thread-pool")) {
            this.parseCustomThreadPool(node);
        } else if (name.equals("metric-collector")) {
            this.parseMetricCollector(node);
        } else if (name.equals("max-http-connections")) {
            this.parseHttpConnection(node);
        } else if (name.equals("init-library")) {
            this.parseInitLibrary(node);
        } else {
            if (name.equals("library")) {
                throw new InstantiationException("Illegal tag, 'library': The library tag has moved from config/server.xml to config/application.xml, please update your configuration manually or reinstall.");
            }
            if (name.equals("shared-library")) {
                this.parseSharedLibrary(node);
            } else {
                if (name.equals("principals")) {
                    throw new InstantiationException("Illegal tag, 'principals': The principals link tag has moved from config/server.xml to config/application.xml, please update your configuration manually or reinstall.");
                }
                if (name.equals("ssl-config")) {
                    this.sslConfig = new SSLConfig(node, this.getURL());
                } else {
                    super.parseDeploymentMainNode(node);
                }
            }
        }
    }

    protected XMLHttpSiteConfig parseHttpSiteConfig(String path, XMLServerConfig parent) throws InstantiationException {
        try {
            URL url = ConfigUtils.getURL(this.getURL(), path);
            XMLHttpSiteConfig config = new XMLHttpSiteConfig(parent, this);
            try {
                config.init(url);
            }
            catch (InstantiationException e) {
                InstantiationException ie = new InstantiationException("Error initializing web-site at " + path + ": " + e.getMessage());
                ie.initCause(e);
                throw ie;
            }
            return config;
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + path);
        }
        catch (IOException e) {
            throw new InstantiationException("Could not read web-site config file: " + path);
        }
    }

    private void parseCompiler(Node parent) {
        String executable = XMLUtils.getNodeAttribute(parent, "executable");
        String classpath = XMLUtils.getNodeAttribute(parent, "classpath");
        if (executable != null) {
            this.addCompilerSetting("executable", executable);
        }
        if (classpath != null) {
            this.addCompilerSetting("classpath", classpath);
        }
    }

    private void parseJavaCompiler(Node parent) throws InstantiationException {
        CompilerFactory cs = CompilerFactory.instance();
        cs.setName(XMLUtils.getNodeAttribute(parent, "name"));
        cs.setInProcess(XMLUtils.getNodeAttribute(parent, "in-process"));
        cs.setDir(XMLUtils.getNodeAttribute(parent, "bindir"));
        cs.setExt(XMLUtils.getNodeAttribute(parent, "extdirs"));
        cs.setEncoding(XMLUtils.getNodeAttribute(parent, "encoding"));
        cs.setDebug(XMLUtils.getNodeAttribute(parent, "debug"));
        cs.setOptions(XMLUtils.getNodeAttribute(parent, "options"));
        if (cs.getName() == null) {
            throw new InstantiationException("'name' attribute not specified in 'java-compiler' element");
        }
        if (cs.isInProcess()) {
            if (cs.getDir() != null && !cs.isJavac()) {
                m_logger.warning("'bindir' attribute ignored for in process " + cs.getName() + " compiler. Make sure it is in your classpath.");
            }
        } else if (cs.getDir() == null && !cs.isJavac()) {
            throw new InstantiationException("'bindir' attribute not specified for out of process compiler '" + cs.getName() + "'");
        }
    }

    private void parseWebSite(Node parent) throws InstantiationException {
        if (this.siteConfigPaths == null) {
            this.siteConfigPaths = new ArrayList();
        }
        this.siteConfigPaths.add(XMLUtils.getNodeAttribute(parent, "path"));
        if ("true".equals(XMLUtils.getNodeAttribute(parent, "default"))) {
            if (this.defaultSiteIndex != -1) {
                throw new InstantiationException("Only one web-site can set default attribute to true");
            }
            this.defaultSiteIndex = this.siteConfigPaths.size() - 1;
        }
    }

    protected void parseMetricCollector(Node parent) {
        this.m_metricCollectorClassName = null;
        this.m_metricCollectorParams = null;
        String classname = XMLUtils.getNodeAttribute(parent, "classname");
        if (classname == null) {
            return;
        }
        this.m_metricCollectorClassName = classname;
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        this.m_metricCollectorParams = new HashMap();
        for (int i = 0; i < list.getLength(); ++i) {
            Node param = list.item(i);
            String nodeName = param.getNodeName();
            if (!nodeName.equals("init-param")) continue;
            NodeList nameValueList = param.getChildNodes();
            String name = null;
            String value = null;
            for (int nv = 0; nv < nameValueList.getLength(); ++nv) {
                Node nameOrValueNode = nameValueList.item(nv);
                String nameOrValue = nameOrValueNode.getNodeName();
                if (nameOrValue.equals("param-name")) {
                    name = XMLUtils.getStringValue(nameOrValueNode);
                    continue;
                }
                if (!nameOrValue.equals("param-value")) continue;
                value = XMLUtils.getStringValue(nameOrValueNode);
            }
            if (name == null) continue;
            this.m_metricCollectorParams.put(name, value);
        }
    }

    private void parseThreadPool(Node parent) throws InstantiationException {
        try {
            this._applicationServerThreadPoolConfig.read(parent);
        }
        catch (DOMException e) {
            throw new InstantiationException("Parse global-thread-pool error: " + e.getMessage());
        }
    }

    private void parseCustomThreadPool(Node parent) throws InstantiationException {
        try {
            this._applicationServerThreadPoolConfig.readCustomThreadPool(parent);
        }
        catch (DOMException e) {
            throw new InstantiationException("Parse global-thread-pool error: " + e.getMessage());
        }
    }

    private void parseNewFormatThreadPool(Node parent) throws InstantiationException {
        if (XMLUtils.getNodeAttribute(parent, "name").equals("jca")) {
            this.parseWorkManagerThreadPool(parent);
            return;
        }
        try {
            this._applicationServerThreadPoolConfig.readNewFormat(parent);
        }
        catch (DOMException e) {
            throw new InstantiationException("Parse global-thread-pool error: " + e.getMessage());
        }
    }

    private void parseWorkManagerThreadPool(Node parent) throws InstantiationException {
        try {
            this._workManagerThreadPoolConfig.read(parent);
            this._workManagerThreadPoolConfig.validateMinPoolSize();
        }
        catch (DOMException e) {
            throw new InstantiationException("Parse work-manager-pool error: " + e.getMessage());
        }
    }

    private void parseHttpConnection(Node node) {
        try {
            this.maxHttpConnections = Integer.parseInt(XMLUtils.getNodeAttribute(node, "value"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.maxHttpConnectionsRedirectURL = XMLUtils.getStringValue(node);
        try {
            this.httpSocketBacklog = Integer.parseInt(XMLUtils.getNodeAttribute(node, "socket-backlog"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.maxHttpConnectionQueueTimeout = Integer.parseInt(XMLUtils.getNodeAttribute(node, "max-connections-queue-timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseCluster(Node parent) throws InstantiationException {
        String idString;
        if (!OC4JServer.getOPMNEnabled() && (idString = XMLUtils.getNodeAttribute(parent, "id")) != null) {
            try {
                this.nodeID = Long.parseLong(idString);
                OC4JServer.setNodeId(this.nodeID);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Invalid cluster id: " + e.getMessage());
            }
        }
        this.nodeID = OC4JServer.getNodeId();
        String portString = XMLUtils.getNodeAttribute(parent, "port");
        if (portString != null) {
            try {
                this.clusterPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Invalid cluster port: " + e.getMessage());
            }
        }
    }

    private void parseSFSB(Node parent) {
        String enablePassivationString = XMLUtils.getNodeAttribute(parent, "enable-passivation");
        if (enablePassivationString != null && ("true".equalsIgnoreCase(enablePassivationString) || "false".equalsIgnoreCase(enablePassivationString))) {
            this.sfsbEnablePassivation = "true".equalsIgnoreCase(enablePassivationString);
        }
    }

    private void parseInitLibrary(Node node) {
        if (this.initLibraryPaths == null) {
            this.initLibraryPaths = new ArrayList();
        }
        StringTokenizer tokenizer = new StringTokenizer(XMLUtils.getNodeAttribute(node, "path"), ";\n\r\t");
        while (tokenizer.hasMoreElements()) {
            String pathToken = (String)tokenizer.nextElement();
            this.initLibraryPaths.add(new PathElement(pathToken, true));
        }
    }

    private void parseSharedLibrary(Node node) throws InstantiationException {
        try {
            if (this.sharedLibraries == null) {
                this.sharedLibraries = new ArrayList();
            }
            SharedLibraryElement shLib = new SharedLibraryElement();
            shLib.read(node);
            this.removeSharedLibrary(shLib.getName(), shLib.getVersion());
            this.sharedLibraries.add(shLib);
        }
        catch (DOMException domEx) {
            throw new InstantiationException("Error parsing shared-library tag: " + domEx.getMessage());
        }
    }

    public String getMetricCollectorClassName() {
        return this.m_metricCollectorClassName;
    }

    public Map getMetricCollectorParams() {
        return this.m_metricCollectorParams;
    }

    private synchronized void addCompilerSetting(String name, String value) {
        if (this.compilerSettings == null) {
            this.compilerSettings = new HashMap();
        }
        this.compilerSettings.put(name, value);
    }

    private void parseJMSServerConfig(Node node) {
        this.jmsServerPath = XMLUtils.getNodeAttribute(node, "path");
        this.jmsServerActive = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "active"));
    }

    private void parseRMIServerConfig(Node node) {
        this.rmiServerPath = XMLUtils.getNodeAttribute(node, "path");
        this.rmiServerActive = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "active"));
    }

    private void parseTransactionManagerConfig(Node node) {
        this.transactionManagerXMLPath = XMLUtils.getNodeAttribute(node, "path");
    }

    private void parseSepConfig(Node node) {
        this.sepPath = XMLUtils.getNodeAttribute(node, "path");
    }

    public synchronized int getConnectionLimit() {
        return this.maxHttpConnections;
    }

    public int getSocketBacklog() {
        return this.httpSocketBacklog;
    }

    public int getConnectionLimitWaitTimeout() {
        return this.maxHttpConnectionQueueTimeout;
    }

    public synchronized String getConnectionLimitRedirectURL() {
        return this.maxHttpConnectionsRedirectURL;
    }

    public synchronized List getSiteConfigs() {
        if (this.siteConfigs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.siteConfigs;
    }

    public String getJavacachePath() {
        try {
            URL url = ConfigUtils.getURL(this.getURL(), this.javacachePath);
            return url.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getJ2EELoggingConfigurationPath() {
        try {
            URL url = ConfigUtils.getURL(this.getURL(), this.J2EELoggingConfigurationPath);
            return url.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void update() throws InstantiationException {
        this.globalWebAppSettingsConfig = null;
        this.siteConfigPaths = new ArrayList();
        this.siteConfigs = new ArrayList();
        this.applicationConfigReferences = null;
        this.jmsServerConfig = null;
        this.jmsServerConfig2 = null;
        this.failureSiteConfigPaths = new ArrayList();
        this.failureApplicationConfigReferences = new ArrayList();
        this.defaultSiteIndex = -1;
        if (!this.useNewJMSServer()) {
            XMLJMSServerConfig.removeAllJMSResourceMBeans();
        }
        this.defaultSiteConfig = null;
        this.defaultSiteIndex = -1;
        if (this.startupClasses != null) {
            this.startupClasses.clear();
        }
        if (this.shutdownClasses != null) {
            this.shutdownClasses.clear();
        }
        super.update();
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("application-server")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not an application-server file as expected");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        ClassDescriptor cd;
        int i;
        String indention = "";
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        out.print(indention + "<application-server " + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/application-server-10_1.xsd\" " + "");
        if (this.secure) {
            out.println(" secure=\"true\"");
        }
        if (this.localhostIsAdmin) {
            out.println(" localhostIsAdmin=\"" + this.localhostIsAdmin + "\"");
        }
        if (this.applicationDirectory != null) {
            out.println(" application-directory=\"" + XMLUtils.encode(this.applicationDirectory) + "\"");
        }
        if (this.checkForUpdates != null) {
            out.println(" check-for-updates=\"" + this.checkForUpdates + "\"");
        }
        if (this.autoDeploymentDirectoryPath != null) {
            out.println(" application-auto-deploy-directory=\"" + this.autoDeploymentDirectoryPath + "\"");
        }
        if (this.deploymentContextPath != null) {
            out.println(" deployment-directory=\"" + XMLUtils.encode(this.deploymentContextPath) + "\"");
        }
        if (this.connectorDirectory != null) {
            out.println(" connector-directory=\"" + XMLUtils.encode(this.connectorDirectory) + "\"");
        }
        if (!this.getAddress().equals(NetUtils.ZERO_ADDRESS)) {
            out.println(" default-host=\"" + this.getAddress().getHostName() + "\"");
        }
        if (this.recoveryProcedure != 1) {
            out.println(" recovery-procedure=\"" + XMLApplicationServerConfig.getRecoveryProcedureName(this.recoveryProcedure) + "\"");
        }
        if (this.sharedLibrariesDirectory != null) {
            out.println(" shared-libraries-directory=\"" + XMLUtils.encode(this.sharedLibrariesDirectory) + "\"");
        }
        if (this.getTaskManagerInterval() > 0L) {
            out.println(" taskmanager-interval=\"" + this.getTaskManagerInterval() + "\"");
        }
        if (this.getTaskManagerGranularity() > 0L) {
            out.println(" taskmanager-granularity=\"" + this.getTaskManagerGranularity() + "\"");
        }
        if (this.getGlobalJNDILookupEnabled()) {
            out.println(" global-jndi-lookup-enabled=\"" + this.getGlobalJNDILookupEnabled() + "\"");
        }
        if (this.getEnvironmentNamingURLFactoryEnabled()) {
            out.println(" environment-naming-url-factory-enabled=\"" + this.getEnvironmentNamingURLFactoryEnabled() + "\"");
        }
        out.println(" schema-major-version=\"10\" schema-minor-version=\"0\" >");
        if (this.sharedLibraries != null) {
            for (i = 0; i < this.sharedLibraries.size(); ++i) {
                SharedLibraryElement shLib = (SharedLibraryElement)this.sharedLibraries.get(i);
                shLib.write(out, indention + "\t");
            }
        }
        if (this.rmiServerPath != null) {
            out.print(indention + "\t<rmi-config");
            if (!this.rmiServerActive) {
                out.print(" active=\"false\"");
            }
            out.println(" path=\"" + XMLUtils.encode(this.rmiServerPath) + "\" />");
        }
        if (this.sepPath != null) {
            out.print(indention + "\t<sep-config");
            out.println(" path=\"" + XMLUtils.encode(this.sepPath) + "\" />");
        }
        if (this.jmsServerPath != null) {
            out.print(indention + "\t<jms-config");
            if (!this.jmsServerActive) {
                out.print(" active=\"false\"");
            }
            out.println(" path=\"" + XMLUtils.encode(this.jmsServerPath) + "\" />");
        }
        if (this.javacachePath != null) {
            out.print(indention + "\t<javacache-config");
            out.println(" path=\"" + XMLUtils.encode(this.javacachePath) + "\" />");
        }
        if (this.J2EELoggingConfigurationPath != null) {
            out.print(indention + "\t<j2ee-logging-config");
            out.println(" path=\"" + XMLUtils.encode(this.J2EELoggingConfigurationPath) + "\" />");
        }
        if (this.logConfig != null) {
            this.logConfig.write(out, indention + "\t");
        }
        if (CompilerFactory.instance().isConfigured()) {
            out.print(indention + "\t<java-compiler");
            out.print(" name=\"" + XMLUtils.encode(CompilerFactory.instance().getName()) + "\"");
            if (CompilerFactory.instance().isInProcess()) {
                out.print(" in-process=\"true\"");
            } else {
                out.print(" in-process=\"false\"");
            }
            if (CompilerFactory.instance().getEncoding() != null) {
                out.print(" encoding=\"" + XMLUtils.encode(CompilerFactory.instance().getEncoding()) + "\"");
            }
            if (CompilerFactory.instance().getOptions() != null && !CompilerFactory.instance().isOptionsDefault()) {
                out.print(" options=\"" + XMLUtils.encode(CompilerFactory.instance().getOptions()) + "\"");
            }
            if (CompilerFactory.instance().getDir() != null) {
                out.print(" bindir=\"" + XMLUtils.encode(CompilerFactory.instance().getDir()) + "\"");
            }
            if (CompilerFactory.instance().getExt() != null) {
                out.print(" extdirs=\"" + XMLUtils.encode(CompilerFactory.instance().getExt()) + "\"");
            }
            CompilerFactory.instance();
            if (CompilerFactory.isDebug()) {
                out.print(" debug=\"true\"");
            }
            out.println(" />");
        }
        if (this.defaultApplicationConfigReference != null) {
            this.defaultApplicationConfigReference.writeXML(out, indention + "\t");
        }
        if (this.applicationConfigReferences != null) {
            XMLUtils.writeAll(this.applicationConfigReferences, out, indention + "\t");
        }
        if (this.globalWebAppSettingsPath != null) {
            out.println(indention + "\t<global-web-app-config path=\"" + this.globalWebAppSettingsPath + "\" />");
        }
        if (this.transactionManagerXMLPath != null) {
            out.println("\t<transaction-manager-config path=\"" + this.transactionManagerXMLPath + "\" />");
        }
        if (this.maxHttpConnections != 1000000 || this.maxHttpConnectionsRedirectURL != null || this.httpSocketBacklog != 30) {
            out.print(indention + "\t<max-http-connections ");
            if (this.maxHttpConnections != 1000000) {
                out.print(" value=\"" + this.maxHttpConnections + "\"");
            }
            if (this.maxHttpConnectionQueueTimeout != 10) {
                out.print(" max-connections-queue-timeout=\"" + this.maxHttpConnectionQueueTimeout + "\"");
            }
            if (this.httpSocketBacklog >= 0 && this.httpSocketBacklog != 30) {
                out.print(" socket-backlog=\"" + this.httpSocketBacklog + "\"");
            }
            if (this.maxHttpConnectionsRedirectURL != null) {
                out.println(">" + this.maxHttpConnectionsRedirectURL + "</max-http-connections>");
            } else {
                out.println(" />");
            }
        }
        if (this.defaultSiteConfigPath != null) {
            out.println(indention + "\t<global-site-config>" + XMLUtils.encode(this.defaultSiteConfigPath) + "</global-site-config>");
        }
        if (this.siteConfigPaths != null) {
            for (i = 0; i < this.siteConfigPaths.size(); ++i) {
                if (i == this.defaultSiteIndex) {
                    out.println(indention + "\t<web-site default=\"true\" path=\"" + XMLUtils.encode((String)this.siteConfigPaths.get(i)) + "\" />");
                    continue;
                }
                out.println(indention + "\t<web-site path=\"" + XMLUtils.encode((String)this.siteConfigPaths.get(i)) + "\" />");
            }
        }
        if (this.compilerSettings != null) {
            out.print(indention + "\t<compiler");
            if (this.compilerSettings.get("executable") != null) {
                out.print(" executable=\"" + XMLUtils.encode(this.compilerSettings.get("executable").toString()) + "\"");
            }
            if (this.compilerSettings.get("classpath") != null) {
                out.print(" classpath=\"" + XMLUtils.encode(this.compilerSettings.get("classpath").toString()) + "\"");
            }
            out.println(" />");
        }
        this._applicationServerThreadPoolConfig.write(out, indention + "\t");
        this._workManagerThreadPoolConfig.write(out, indention + "\t");
        if (this.m_metricCollectorClassName != null) {
            out.print(indention + "\t<metric-collector classname=\"" + this.m_metricCollectorClassName + "\"");
            if (this.m_metricCollectorParams == null || this.m_metricCollectorParams.isEmpty()) {
                out.println("/>");
            } else {
                out.println(">");
                Iterator i2 = this.m_metricCollectorParams.entrySet().iterator();
                while (i2.hasNext()) {
                    Map.Entry entry = i2.next();
                    out.println(indention + "\t  <init-param>");
                    out.println(indention + "\t    <param-name>");
                    out.println(indention + "\t      " + entry.getKey());
                    out.println(indention + "\t    </param-name>");
                    out.println(indention + "\t    <param-value>");
                    out.println(indention + "\t      " + entry.getValue());
                    out.println(indention + "\t    </param-value>");
                    out.println(indention + "\t  </init-param>");
                }
                out.println(indention + "\t</metric-collector>");
            }
        }
        if (this.nodeID != 0L || this.clusterPort != 0) {
            out.print(indention + "\t<cluster ");
            if (this.nodeID != 0L) {
                out.print(" id=\"" + this.nodeID + "\"");
            }
            if (this.clusterPort != 0) {
                out.print(" port=\"" + this.clusterPort + "\"");
            }
            out.println(" />");
        }
        if (!this.sfsbEnablePassivation) {
            out.print(indention + "\t<sfsb-config");
            out.print(" enable-passivation=\"" + this.sfsbEnablePassivation + "\"");
            out.println(" />");
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i3 = 0; i3 < ApplicationServer.serverExtensionProviders.length; ++i3) {
                ApplicationServer.serverExtensionProviders[i3].writeApplicationServerMainNodes(this, out, indention + "\t");
            }
        }
        if (this.initLibraryPaths != null) {
            for (int i4 = 0; i4 < this.initLibraryPaths.size(); ++i4) {
                PathElement elem = (PathElement)this.initLibraryPaths.get(i4);
                out.println(indention + "\t<init-library path=\"" + XMLUtils.encode(elem.getPathName()) + "\" />");
            }
        }
        if (this.startupClasses != null && !this.startupClasses.isEmpty()) {
            out.println(indention + "\t<startup-classes>");
            Iterator iter = this.startupClasses.iterator();
            while (iter.hasNext()) {
                cd = (ClassDescriptor)iter.next();
                cd.writeXML(out, indention + "\t\t", true);
            }
            out.println(indention + "\t</startup-classes>");
        }
        if (this.shutdownClasses != null && !this.shutdownClasses.isEmpty()) {
            out.println(indention + "\t<shutdown-classes>");
            Iterator iter = this.shutdownClasses.iterator();
            while (iter.hasNext()) {
                cd = (ClassDescriptor)iter.next();
                cd.writeXML(out, indention + "\t\t", false);
            }
            out.println(indention + "\t</shutdown-classes>");
        }
        if (null != this.sslConfig) {
            this.sslConfig.writeXML(out, indention);
        }
        out.println(indention + "</application-server>");
    }

    public boolean isUpdated() {
        if (this.defaultSiteConfig != null && this.defaultSiteConfig.isUpdated()) {
            return true;
        }
        return super.isUpdated();
    }

    public synchronized RMIServerConfig getRMIServerConfig() throws InstantiationException {
        if (this.rmiServerConfig != null) {
            return this.rmiServerConfig;
        }
        if (this.rmiServerPath != null && this.rmiServerActive) {
            try {
                URL url = ConfigUtils.getURL(this.getURL(), this.rmiServerPath);
                XMLRMIServerConfig config = new XMLRMIServerConfig(this);
                try {
                    config.init(url);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Error parsing rmi-server config at " + url + ": " + e.getMessage());
                }
                this.rmiServerConfig = config;
            }
            catch (MalformedURLException e) {
                throw new InstantiationException("Invalid URL: " + this.rmiServerPath);
            }
            catch (IOException e) {
                throw new InstantiationException("Could not read RMI config file: " + this.rmiServerPath + (e.getMessage() == null ? "" : ": " + e.getMessage()));
            }
        }
        return this.rmiServerConfig;
    }

    public synchronized Map getCompilerSettings() {
        return this.compilerSettings;
    }

    public synchronized boolean isSecure() {
        return this.secure;
    }

    public synchronized boolean isLocalhostIsAdmin() {
        return this.localhostIsAdmin;
    }

    public synchronized long getTaskManagerGranularity() {
        return this.taskManagerGranularity;
    }

    public synchronized ApplicationConfig getDefaultApplicationConfig() throws InstantiationException {
        return this.defaultApplicationConfig;
    }

    public synchronized ApplicationConfigReference getSystemApplicationConfigReference() throws InstantiationException {
        return this.systemApplicationConfigReference;
    }

    public synchronized ApplicationConfig getSystemApplicationConfig() throws InstantiationException {
        return this.systemApplicationConfig;
    }

    public synchronized ApplicationConfigReference getDefaultApplicationConfigReference() throws InstantiationException {
        return this.defaultApplicationConfigReference;
    }

    public synchronized List getApplicationConfigs() throws InstantiationException {
        if (this.applicationConfigReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.applicationConfigReferences;
    }

    public ApplicationConfig getApplicationConfig(String appName) throws InstantiationException {
        ApplicationConfigReference reference = this.getApplicationConfigReference(appName);
        return this.parseApplicationConfigReference(reference);
    }

    private ApplicationConfig parseApplicationConfigReference(ApplicationConfigReference reference) throws InstantiationException {
        try {
            String parentName = reference.getParentName();
            ApplicationConfig parentConfig = null;
            parentConfig = reference.getName().equals(this.systemApplicationConfigReference.getName()) ? null : (parentName != null && parentName.equals(this.systemApplicationConfigReference.getName()) ? this.systemApplicationConfig : (parentName == null || parentName.equals(this.defaultApplicationConfigReference.getName()) ? this.defaultApplicationConfig : this.parseApplicationConfigReference(this.getApplicationConfigReference(parentName))));
            URL deploymentURL = reference.getDeploymentDescriptorURL();
            if (deploymentURL == null && this.deploymentContextPath != null && !"[none]".equalsIgnoreCase(reference.deploymentDirectoryPath)) {
                deploymentURL = ConfigUtils.getURL(this.getURL(), this.deploymentContextPath + "/" + reference.getName());
            }
            Map extraParams = null;
            return new EnterpriseArchive(reference.getName(), reference.getURL(), deploymentURL, this, parentConfig, this.autoUnpackEnterpriseArchives, extraParams);
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Unable to get ApplicationConfig for " + reference.getName() + " : " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public synchronized HttpApplicationConfigContext getDefaultHttpApplicationConfig() throws InstantiationException {
        if (this.globalWebAppSettingsConfig == null) {
            if (this.globalWebAppSettingsPath == null) {
                return null;
            }
            this.globalWebAppSettingsConfig = new XMLHttpApplicationConfigContext(this.defaultApplicationConfig, "global web-app", this.getURL(), this.globalWebAppSettingsPath, null, null, this.getDefaultApplicationConfig().getUserManager(), -1L, true, false, false, null);
        }
        return this.globalWebAppSettingsConfig;
    }

    public synchronized void addApplicationConfigReference(ApplicationConfigReference reference) {
        if (this.applicationConfigReferences == null) {
            this.applicationConfigReferences = new ArrayList();
        } else {
            for (int i = 0; i < this.applicationConfigReferences.size(); ++i) {
                ApplicationConfigReference other = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
                if (!other.getName().equals(reference.getName())) continue;
                this.applicationConfigReferences.remove(i);
                System.err.println("WARNING: application \"" + other.getName() + "\" is defined twice in server.xml, " + other.getURL().getPath() + " and " + reference.getURL().getPath());
            }
        }
        this.applicationConfigReferences.add(reference);
    }

    public ApplicationConfigReference getApplicationConfigReference(String appName) throws InstantiationException {
        if (appName == null || appName.equals(this.defaultApplicationConfigReference.getName())) {
            return this.defaultApplicationConfigReference;
        }
        if (this.applicationConfigReferences == null) {
            return null;
        }
        for (int i = 0; i < this.applicationConfigReferences.size(); ++i) {
            ApplicationConfigReference reference = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
            if (!reference.getName().equals(appName)) continue;
            return reference;
        }
        return null;
    }

    public synchronized long getNodeID() {
        if (this.nodeID == 0L) {
            this.nodeID = OC4JServer.getNodeId();
        }
        return this.nodeID;
    }

    public synchronized void setNodeID(long nodeID) {
        this.nodeID = nodeID;
    }

    public int getClusterPort() {
        return this.clusterPort;
    }

    public synchronized boolean getSFSBEnablePassivation() {
        return this.sfsbEnablePassivation;
    }

    public synchronized void removeApplication(String name) {
        if (this.applicationConfigReferences != null) {
            for (int i = 0; i < this.applicationConfigReferences.size(); ++i) {
                ApplicationConfigReference reference = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
                if (!reference.getName().equals(name)) continue;
                this.applicationConfigReferences.remove(i);
            }
        }
    }

    public synchronized DatabaseSchema getDatabaseSchema(String path) throws InstantiationException {
        DatabaseSchema schema;
        if (this.databaseSchemas == null) {
            this.databaseSchemas = new HashMap();
        }
        if ((schema = (DatabaseSchema)this.databaseSchemas.get(path)) != null) {
            return schema;
        }
        throw new InstantiationException("Error finding database-schema at: " + path);
    }

    public synchronized void flushGlobalWebAppConfig() {
        this.globalWebAppSettingsConfig = null;
    }

    public String getSharedLibrariesDirectory() throws IOException {
        return new File(ConfigUtils.getURL(this.getURL(), this.sharedLibrariesDirectory == null ? "../shared-lib" : this.sharedLibrariesDirectory).getFile()).getAbsolutePath();
    }

    public synchronized void removeSite(HttpSiteConfig config) {
        for (int i = 0; i < this.siteConfigs.size(); ++i) {
            if (!this.siteConfigs.get(i).equals(config)) continue;
            this.siteConfigPaths.remove(i);
            this.siteConfigs.remove(i);
        }
    }

    public String getApplicationDirectory() throws IOException {
        return new File(ConfigUtils.getURL(this.getURL(), this.applicationDirectory == null ? "../applications" : this.applicationDirectory).getFile()).getAbsolutePath();
    }

    public String getApplicationDirectoryString() {
        return this.applicationDirectory == null ? "../applications" : this.applicationDirectory;
    }

    public String getDeploymentDirectory() throws IOException {
        return new File(ConfigUtils.getURL(this.getURL(), this.deploymentContextPath == null ? "../application-deployments" : this.deploymentContextPath).getFile()).getAbsolutePath();
    }

    public String getAutoDeployApplicationDirectory() throws IOException {
        if (this.autoDeploymentDirectoryPath != null) {
            return new File(ConfigUtils.getURL(this.getURL(), this.autoDeploymentDirectoryPath).getFile()).getAbsolutePath();
        }
        return null;
    }

    public String getConnectorDirectory() throws IOException {
        return new File(ConfigUtils.getURL(this.getURL(), this.connectorDirectory == null ? "../connectors" : this.connectorDirectory).getFile()).getAbsolutePath();
    }

    public synchronized boolean getAutoStartApplications() {
        return true;
    }

    public int getRecoveryProcedure() {
        return this.recoveryProcedure;
    }

    private static int getRecoveryProcedure(String procedure) throws InstantiationException {
        if (procedure.equalsIgnoreCase("automatic")) {
            return 1;
        }
        if (procedure.equalsIgnoreCase("prompt")) {
            return 2;
        }
        if (procedure.equalsIgnoreCase("ignore")) {
            return 3;
        }
        throw new InstantiationException("Unknown recovery-procedure: " + procedure);
    }

    private static String getRecoveryProcedureName(int type) {
        switch (type) {
            case 1: {
                return "automatic";
            }
            case 2: {
                return "prompt";
            }
            case 3: {
                return "ignore";
            }
        }
        throw new IllegalArgumentException("Illegal recovery-procedure: " + type);
    }

    public TransactionManagerConfiguration getTransactionManagerConfiguration() throws InstantiationException {
        if (this.transactionManagerXMLPath == null) {
            InstantiationException ie = new InstantiationException("Could not read transaction manager configuration from " + this.getURL() + " transaction-manager-config file not specified in server.xml");
            throw ie;
        }
        if (!new File(this.getURL().getFile()).exists()) {
            InstantiationException ie = new InstantiationException("Could not read transaction manager configuration from " + this.getURL() + " transaction-manager-config file specified in server.xml does not exist");
            throw ie;
        }
        try {
            TransactionManagerConfiguration tmConfig = new TransactionManagerConfiguration(ConfigUtils.getURL(this.getURL(), this.transactionManagerXMLPath));
            return tmConfig;
        }
        catch (MalformedURLException e) {
            InstantiationException ie = new InstantiationException("Could not read transaction manager configuration " + this.getURL());
            ie.initCause(e);
            throw ie;
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Could not read transaction manager configuration " + this.getURL());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            InstantiationException ie = new InstantiationException("Could not read transaction manager configuration " + this.getURL());
            ie.initCause(e);
            throw ie;
        }
    }

    public boolean getGlobalJNDILookupEnabled() {
        return this.globalJNDIEnabled;
    }

    public boolean getEnvironmentNamingURLFactoryEnabled() {
        return this.environmentNamingURLFactoryEnabled;
    }

    public ApplicationServerThreadPoolConfig getApplicationServerThreadPoolConfig() {
        return this._applicationServerThreadPoolConfig;
    }

    public WorkManagerThreadPoolConfig getWorkManagerThreadPoolConfig() {
        return this._workManagerThreadPoolConfig;
    }

    public String getSepConfigPath() {
        return this.sepPath;
    }

    private void postInitDefaultApplication() throws InstantiationException {
        if (this.defaultApplicationConfigReference == null) {
            throw new InstantiationException("No global-application specified in " + this);
        }
        try {
            this.defaultApplicationConfig = (EnterpriseArchive)this.parseApplicationConfigReference(this.defaultApplicationConfigReference);
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Error instantiating default application at " + e.getMessage());
        }
    }

    private boolean sortApplicationConfigReferences() throws InstantiationException {
        ApplicationConfigReference reference;
        int i;
        int appConfigRefsSize = this.applicationConfigReferences.size();
        HashMap<ApplicationConfigReference, Integer> applicationConfigRefsCounts = new HashMap<ApplicationConfigReference, Integer>(appConfigRefsSize);
        for (i = 1; i <= appConfigRefsSize; ++i) {
            reference = (ApplicationConfigReference)this.applicationConfigReferences.get(i - 1);
            if (ServerProperties.getApplicationServerDebug()) {
                m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Application " + reference.getName() + " beginning the outside for loop, checking app ref " + i + " of " + appConfigRefsSize);
            }
            if (reference.getParentName() != null) {
                if (ServerProperties.getApplicationServerDebug()) {
                    m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Application " + reference.getName() + " has a parent named " + reference.getParentName());
                }
                boolean parentFound = false;
                for (int y = 0; y < appConfigRefsSize; ++y) {
                    ApplicationConfigReference other = (ApplicationConfigReference)this.applicationConfigReferences.get(y);
                    if (ServerProperties.getApplicationServerDebug()) {
                        m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Checking if app " + other.getName() + " is app " + reference.getName() + "'s daddy");
                    }
                    if (!other.getName().equals(reference.getParentName())) continue;
                    if (ServerProperties.getApplicationServerDebug()) {
                        m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: App " + reference.getName() + " believes that " + other.getName() + " is its daddy...");
                    }
                    if (other.getName().equals(reference.getName())) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit : but application " + reference.getName() + "'s parent is itself, or there is a duplicate configuration entry for this application!  Illegal circular definition, throwing InstantiationException");
                        }
                        throw new InstantiationException("application " + reference.getName() + "'s parent is itself; illegal circular reference or duplicate configuration record");
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit : and " + other.getName() + " IS " + reference.getName() + "'s daddy!");
                    }
                    parentFound = true;
                    int j = i - 1;
                    if (y > j) {
                        int moveCount;
                        Integer count;
                        if (ServerProperties.getApplicationServerDebug()) {
                            m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: The parent " + other.getName() + " is not before the child " + reference.getName() + ".  Moving the child...");
                        }
                        if (applicationConfigRefsCounts.containsKey(reference)) {
                            count = (Integer)applicationConfigRefsCounts.get(reference);
                            moveCount = count;
                            if (ServerProperties.getApplicationServerDebug()) {
                                m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: This child " + reference.getName() + " has been moved " + count + " times before.");
                            }
                        } else {
                            moveCount = 0;
                            if (ServerProperties.getApplicationServerDebug()) {
                                m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: This child " + reference.getName() + " has never been moved before.");
                            }
                        }
                        if (moveCount == appConfigRefsSize) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                m_logger.fine("com.evermind.server.XMLApplicationServerConfig.postInit: Illegal circular definition detected, throwing InstantiationException.  Note that the circular definition may involve other children than just the exception text's listed parent and child.");
                            }
                            throw new InstantiationException("Illegal circular reference found for application " + reference.getName() + " and parent " + reference.getParentName());
                        }
                        count = new Integer(++moveCount);
                        applicationConfigRefsCounts.put(reference, count);
                        if (ServerProperties.getApplicationServerDebug()) {
                            m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: This child " + reference.getName() + " will be moved from position " + j + " to position " + y + ". The move count will be incremented to " + moveCount + ".");
                        }
                        i = 0;
                        while (y > j) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: This child " + reference.getName() + " is being moved from position " + j + " to position " + (j + 1));
                            }
                            ApplicationConfigReference next = (ApplicationConfigReference)this.applicationConfigReferences.get(j + 1);
                            this.applicationConfigReferences.set(j, next);
                            this.applicationConfigReferences.set(++j, reference);
                        }
                    } else if (ServerProperties.getApplicationServerDebug()) {
                        m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Child " + reference.getName() + " was not moved, since it was after its parent " + other.getName());
                    }
                    if (!ServerProperties.getApplicationServerDebug()) break;
                    m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Child " + reference.getName() + " was processed.  Breaking out of the inside loop.");
                    break;
                }
                if (parentFound) {
                    if (!ServerProperties.getApplicationServerDebug()) continue;
                    m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Found the parent for " + reference.getName() + ".  Starting the next loop.");
                    continue;
                }
                if (reference.getParentName().equals(this.defaultApplicationConfigReference.getName()) || reference.getParentName().equals(this.systemApplicationConfigReference.getName())) {
                    if (!ServerProperties.getApplicationServerDebug()) continue;
                    m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Found the parent for " + reference.getName() + ".  Starting the next loop.");
                    continue;
                }
                if (ServerProperties.getApplicationServerDebug()) {
                    m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit : Application " + reference.getName() + "'s parent " + reference.getParentName() + " not found!  Throwing InstantiationException");
                }
                throw new InstantiationException("application " + reference.getName() + "'s parent " + reference.getParentName() + " not found");
            }
            if (!ServerProperties.getApplicationServerDebug()) continue;
            m_logger.finest("com.evermind.server.XMLApplicationServerConfig.postInit: Application " + reference.getName() + " has completed the for loop.  The current count is " + i);
        }
        for (i = 0; i < this.applicationConfigReferences.size(); ++i) {
            reference = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
            try {
                reference.setConfig(this.parseApplicationConfigReference(reference));
                continue;
            }
            catch (InstantiationException e) {
                m_logger.severe("Error instantiating application at " + reference.getURL() + ": " + e.getMessage());
                this.applicationConfigReferences.remove(i--);
                this.failureApplicationConfigReferences.add(reference);
            }
        }
        return true;
    }

    private void postInitApplications() throws InstantiationException {
        if (this.applicationConfigReferences == null) {
            return;
        }
        try {
            this.sortApplicationConfigReferences();
        }
        catch (InstantiationException e) {
            InstantiationException ie = new InstantiationException("Error while attempting to sort application configuration references: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private void postInitSiteConfigs() throws InstantiationException {
        if (this.defaultSiteConfigPath != null) {
            this.defaultSiteConfig = this.parseHttpSiteConfig(this.defaultSiteConfigPath, this);
        }
        if (this.siteConfigPaths == null) {
            return;
        }
        this.siteConfigs = new ArrayList();
        for (int i = 0; i < this.siteConfigPaths.size(); ++i) {
            String path = (String)this.siteConfigPaths.get(i);
            try {
                XMLServerConfig parent = this.defaultSiteConfig == null ? this : this.defaultSiteConfig;
                this.siteConfigs.add(this.parseHttpSiteConfig(path, parent));
                continue;
            }
            catch (InstantiationException e) {
                if (i == this.defaultSiteIndex) {
                    this.failureDefaultSiteIndex = this.failureSiteConfigPaths.size();
                    this.defaultSiteIndex = -1;
                }
                this.siteConfigPaths.remove(i--);
                this.failureSiteConfigPaths.add(path);
                m_logger.severe(e.getMessage());
            }
        }
        this.overwriteSiteConfigPort();
    }

    public int getDefaultWebSiteIndex() {
        return this.defaultSiteIndex;
    }

    protected void overwriteSiteConfigPort() {
        ArrayList servicesList = OC4JServer.getServicesList();
        if (servicesList != null) {
            Iterator i = servicesList.iterator();
            while (i.hasNext()) {
                OC4JServiceInfo service = (OC4JServiceInfo)i.next();
                if (!service.isWebSiteService()) continue;
                Iterator sites = this.siteConfigs.iterator();
                boolean found = false;
                while (sites.hasNext()) {
                    XMLHttpSiteConfig site = (XMLHttpSiteConfig)sites.next();
                    if (service.getId() == null) {
                        try {
                            if (service.isSameProtocol(XMLHttpSiteConfig.getProtocolName(site.getProtocol()))) {
                                site.setPort(service.getPort());
                                found = true;
                                break;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!service.getId().equals(site.getShortName())) continue;
                    site.setPort(service.getPort());
                    try {
                        site.setProtocol(XMLHttpSiteConfig.getProtocol(service.getProtocol()));
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                m_logger.warning("Port assignment is ignored: web-site not found in the server " + service);
            }
        }
    }

    protected void createDMSState(String dmsStr) {
        ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "server_log", "", "Application server log file path", (Object)dmsStr);
    }

    void setPassword(PrintStream out) throws InstantiationException, IOException {
        User user = this.systemApplicationConfig.getUserManager().getAdminUser();
        if (user == null) {
            String errMsg = "OC4J administrator account is not configured correctly. Please make sure that at least one administration account is created and configured correctly.";
            throw new InstantiationException(errMsg);
        }
        boolean isJTAAdminPasswordToBeStored = this.randomizeJtaAdminPassword();
        if (user instanceof DeactivatableUser && ((DeactivatableUser)user).isDeactivated()) {
            out.print("Set OC4J administrator's password (password text will not be displayed as it is entered)\n");
            String firstPrompt = "Enter password: ";
            String secondPrompt = "Confirm password: ";
            char[] firstPwd = this.readPassword(firstPrompt);
            char[] secondPwd = this.readPassword(secondPrompt);
            if (firstPwd == null || secondPwd == null) {
                throw new InstantiationException("OC4J administrator's password is empty.");
            }
            CharString first = new CharString(firstPwd);
            CharString second = new CharString(secondPwd);
            if (!first.equals(second)) {
                throw new InstantiationException("Error: OC4J administrator password mismatches.");
            }
            user.setPassword(String.valueOf(firstPwd));
            if (user instanceof ApplicationServerUser) {
                ((ApplicationServerUser)user).setDeactivated(false);
            } else {
                ((DeactivatableUser)user).setDeactivated(false);
            }
            this.systemApplicationConfig.getUserManager().store();
            isJTAAdminPasswordToBeStored = false;
            out.println("The password for OC4J administrator \"" + user.getName() + "\" has been set.");
            out.println("The OC4J administrator \"" + user.getName() + "\" account is activated.");
        }
        if (isJTAAdminPasswordToBeStored) {
            this.systemApplicationConfig.getUserManager().store();
        }
    }

    private boolean randomizeJtaAdminPassword() {
        UserManager userManager = this.systemApplicationConfig.getUserManager();
        User user = userManager.getUser("JtaAdmin");
        if (user == null) {
            return false;
        }
        if (user.getPassword().equals("defaultJtaPassword")) {
            Logger.getAnonymousLogger().log(Level.INFO, "Updating JtaAdmin account");
            user.setPassword("" + SecurityUtil.createRandomAlphaNumPassword());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private char[] readPassword(String prompt) throws IOException {
        char[] lineBuffer;
        ConsoleObfuscator obfuscator = new ConsoleObfuscator(System.out, prompt);
        obfuscator.start();
        InputStream in = System.in;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    void var8_8;
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)var8_8;
                    continue block4;
                }
            }
            break;
        }
        obfuscator.finishObfuscate();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public void updateJ2eeLogging() {
        this.initJ2eeLogging();
    }

    public void setPropPath(String path) {
        this.propPath = path;
    }

    public String getPropPath() {
        return this.propPath;
    }

    public void store() throws IOException {
        int i;
        List origApplicationConfigReferences = null;
        List origSiteConfigPaths = null;
        if (this.failureApplicationConfigReferences.size() != 0) {
            for (i = 0; i < this.applicationConfigReferences.size(); ++i) {
                ApplicationConfigReference currentReference = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
                String currentName = currentReference.getName();
                for (int j = 0; j < this.failureApplicationConfigReferences.size(); ++j) {
                    ApplicationConfigReference currentFailureReference = (ApplicationConfigReference)this.failureApplicationConfigReferences.get(j);
                    if (!currentFailureReference.getName().equals(currentName)) continue;
                    this.failureApplicationConfigReferences.remove(j--);
                }
            }
            if (this.failureApplicationConfigReferences.size() != 0) {
                StringBuffer sb = new StringBuffer("There are some configuration failures in following application(s). Please correct the problem and restart oc4j. : ");
                for (int i2 = 0; i2 < this.failureApplicationConfigReferences.size(); ++i2) {
                    if (i2 != 0) {
                        sb.append(", ");
                    }
                    ApplicationConfigReference currentFailureReference = (ApplicationConfigReference)this.failureApplicationConfigReferences.get(i2);
                    sb.append(currentFailureReference.getName());
                }
                m_logger.severe(sb.toString());
                origApplicationConfigReferences = this.applicationConfigReferences;
                this.applicationConfigReferences = (List)((ArrayList)this.applicationConfigReferences).clone();
                this.applicationConfigReferences.addAll(this.failureApplicationConfigReferences);
            }
        }
        if (this.failureSiteConfigPaths.size() != 0) {
            for (i = 0; i < this.siteConfigPaths.size(); ++i) {
                String path = (String)this.siteConfigPaths.get(i);
                for (int j = 0; j < this.failureSiteConfigPaths.size(); ++j) {
                    String failurePath = (String)this.failureSiteConfigPaths.get(j);
                    if (!path.equals(failurePath)) continue;
                    if (this.failureDefaultSiteIndex == j) {
                        this.failureDefaultSiteIndex = -1;
                        this.defaultSiteIndex = i;
                    }
                    if (this.failureDefaultSiteIndex > j) {
                        --this.failureDefaultSiteIndex;
                    }
                    this.failureSiteConfigPaths.remove(j--);
                }
            }
            if (this.failureSiteConfigPaths.size() != 0) {
                m_logger.severe("http site configuration parsing is failed. please correct the problem and restart oc4j. ");
                origSiteConfigPaths = this.siteConfigPaths;
                this.siteConfigPaths = (List)((ArrayList)this.siteConfigPaths).clone();
                this.siteConfigPaths.addAll(this.failureSiteConfigPaths);
                if (this.failureDefaultSiteIndex >= 0) {
                    this.defaultSiteIndex = origSiteConfigPaths.size() + this.failureDefaultSiteIndex;
                }
            }
        }
        super.store();
        if (origApplicationConfigReferences != null) {
            this.applicationConfigReferences = origApplicationConfigReferences;
        }
        if (origSiteConfigPaths != null) {
            this.siteConfigPaths = origSiteConfigPaths;
            if (this.failureDefaultSiteIndex >= 0) {
                this.defaultSiteIndex = -1;
            }
        }
    }

    public boolean useNewJMSServer() {
        return oracle.j2ee.jms.oc4j.v1.XMLJMSServerConfig.useNewJMSServer();
    }

    public synchronized List getChildApplicationConfigReferences(String parentName) {
        ArrayList<ApplicationConfigReference> children = new ArrayList<ApplicationConfigReference>();
        for (int i = 0; i < this.applicationConfigReferences.size(); ++i) {
            ApplicationConfigReference reference = (ApplicationConfigReference)this.applicationConfigReferences.get(i);
            String parentRefName = reference.getParentName();
            if (parentRefName == null || !parentRefName.equals(parentName)) continue;
            children.add(reference);
        }
        return children;
    }
}

