/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.NonRecoverableIdException;
import com.evermind.util.OpmnException;
import com.evermind.util.OpmnHelper;
import com.evermind.util.ServerProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Oc4jProcessId {
    public static final String SEPARATOR = "_";
    static final String OPMN_ID_PREFIX = "OPMN_";
    static final String RMI_ID_PREFIX = "ORMI_";
    private String m_uniqueId = null;
    private String m_host = null;
    private int m_ormiPort = -1;

    private Oc4jProcessId(String host, String uniqueId, int ormiPort) {
        this.m_host = host;
        this.m_ormiPort = ormiPort;
        this.m_uniqueId = uniqueId;
    }

    public static Oc4jProcessId currentProcessId() throws UnknownHostException {
        String host = InetAddress.getLocalHost().getHostName();
        Oc4jProcessId processId = Oc4jProcessId.encodeOpmnId(host);
        if (processId == null) {
            processId = Oc4jProcessId.encodeRmiId(host);
        }
        if (processId == null) {
            processId = Oc4jProcessId.encodeGenericId(host);
        }
        return processId;
    }

    public static Oc4jProcessId recreateIdForRecovery(String uniqueId) throws NonRecoverableIdException {
        if (uniqueId == null) {
            throw new NonRecoverableIdException("Unique id is null");
        }
        if (uniqueId.startsWith(OPMN_ID_PREFIX)) {
            return Oc4jProcessId.decodeOpmnId(uniqueId);
        }
        if (uniqueId.startsWith(RMI_ID_PREFIX)) {
            return Oc4jProcessId.decodeRmiId(uniqueId);
        }
        throw new NonRecoverableIdException("Unable to recreate process id for recovery: " + uniqueId);
    }

    private static Oc4jProcessId encodeOpmnId(String host) {
        String opmnId = null;
        Oc4jProcessId oc4jProcessId = null;
        opmnId = ServerProperties.getOracleOnsIndexID();
        if (opmnId != null) {
            oc4jProcessId = new Oc4jProcessId(host, OPMN_ID_PREFIX + host + SEPARATOR + opmnId, -1);
        }
        return oc4jProcessId;
    }

    private static Oc4jProcessId encodeRmiId(String host) {
        String rmiId = null;
        Oc4jProcessId oc4jProcessId = null;
        if (ApplicationServer.instance.getRMIServer() != null) {
            int rmiPort = ApplicationServer.instance.getRMIServer().getConfig().getPort();
            rmiId = RMI_ID_PREFIX + host + SEPARATOR + rmiPort;
            oc4jProcessId = new Oc4jProcessId(host, rmiId, rmiPort);
        }
        return oc4jProcessId;
    }

    private static Oc4jProcessId encodeGenericId(String host) {
        String id = null;
        id = ApplicationServer.instance.getHttpServer() != null ? host + SEPARATOR + ApplicationServer.instance.getHttpServer().getConfig().getPort() : host;
        return new Oc4jProcessId(host, id, -1);
    }

    private static Oc4jProcessId decodeOpmnId(String id) throws NonRecoverableIdException {
        String[] tokens = id.split(SEPARATOR);
        if (tokens.length < 3) {
            throw new NonRecoverableIdException("Invalid OPMN id");
        }
        String host = tokens[1];
        int offset = OPMN_ID_PREFIX.length() + host.length() + 1;
        int port = Oc4jProcessId.getOrmiPortFromOpmn(id.substring(offset, id.length()));
        return new Oc4jProcessId(host, id, port);
    }

    private static Oc4jProcessId decodeRmiId(String id) throws NonRecoverableIdException {
        String[] tokens = id.split(SEPARATOR);
        if (tokens.length != 3) {
            throw new NonRecoverableIdException("Invalid ORMI id");
        }
        return new Oc4jProcessId(tokens[1], id, Integer.parseInt(tokens[2]));
    }

    private static int getOrmiPortFromOpmn(String opmnId) throws NonRecoverableIdException {
        try {
            return OpmnHelper.getOrmiPortForOc4jProcess(opmnId);
        }
        catch (OpmnException e) {
            throw new NonRecoverableIdException("Unable to determine ORMI port from OPMN", e);
        }
    }

    public String getUniqueId() {
        return this.m_uniqueId;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getOrmiPortForRecovery() {
        return this.m_ormiPort;
    }
}

