/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.OC4JMonitorThread;
import com.oracle.bricks.Manager;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.jgroups.ClusterMemberIpAddress;
import oracle.hooks.Extension;
import oracle.hooks.Hook;
import oracle.oc4j.hooks.ApplicationProtocol;

public class OC4JMonitorHooksExtension
implements Extension {
    private static final String[] states = new String[]{"starting", "started", "stopping", "stopped", "failed"};

    public Class[] getDependentProtocols() {
        return new Class[]{ApplicationProtocol.class};
    }

    public void activate(String[] args) {
        ApplicationProtocol.POST_INIT_APPLICATION.addHook("OC4JMonitorHookPostInitApp", new PostInitAppAction());
        ApplicationProtocol.POST_DESTROY_APPLICATION.addHook("OC4JMonitorHookPostDestroyApp", new PostDestroyAppAction());
        ApplicationProtocol.PRE_STOP_APPLICATION.addHook("OC4JMonitorHookPreStopApp", new PreStopAppAction());
        ApplicationProtocol.POST_STOP_APPLICATION.addHook("OC4JMonitorHookPostStopApp", new PostStopAppAction());
    }

    class PostStopAppAction
    implements Hook.Read1 {
        PostStopAppAction() {
        }

        public void execute(Object arg1) {
            Application app = (Application)arg1;
            OC4JMonitorThread.setAppState(app.getName(), states[app.getstate()]);
        }
    }

    class PreStopAppAction
    implements Hook.Read1 {
        PreStopAppAction() {
        }

        public void execute(Object arg1) {
            Application app = (Application)arg1;
            OC4JMonitorThread.setAppState(app.getName(), "stopping");
        }
    }

    class PostDestroyAppAction
    implements Hook.Edit2 {
        PostDestroyAppAction() {
        }

        public Object execute(Object arg1, Object arg2) {
            ApplicationConfig appConfig = (ApplicationConfig)arg1;
            Application app = (Application)arg2;
            OC4JMonitorThread.postAppDestroy(app.getName());
            return arg1;
        }
    }

    class PostInitAppAction
    implements Hook.Edit2 {
        PostInitAppAction() {
        }

        public Object execute(Object arg1, Object arg2) {
            ApplicationConfig appConfig = (ApplicationConfig)arg1;
            Application app = (Application)arg2;
            OC4JMonitorThread.resetJGroupInfo(app.getName());
            JGroupConfig jConfig = appConfig.getClusterConfig();
            if (jConfig != null && jConfig.isEnabled() && !jConfig.useDatabase()) {
                ClusterMemberIpAddress addr;
                Manager mgr = SessionManagerFactory.getManager(jConfig.getGroupName());
                if (mgr != null && mgr.isStarted() && (addr = mgr.getLocalAddress()) != null) {
                    OC4JMonitorThread.addJGroupInfo(app.getName(), jConfig.getGroupName(), addr.getAddress().getHostName(), Integer.toString(addr.getPort()), jConfig.getProtocol());
                }
            } else if (jConfig != null && jConfig.isEnabled() && jConfig.useDatabase()) {
                OC4JMonitorThread.addJGroupInfo(app.getName(), jConfig.getGroupName(), null, null, jConfig.getProtocol());
            }
            app.addORMITunnelingRoutingInfo();
            OC4JMonitorThread.setAppParent(app.getName(), app.getApplicationConfigReference().getParentName());
            OC4JMonitorThread.setAppState(app.getName(), states[app.getstate()]);
            return arg1;
        }
    }
}

