/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.deployment.InjectionTarget;
import com.evermind.server.ejb.deployment.EJBReference;
import com.oracle.naming.J2EEContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.oc4j.configuration.J2EEContextDescriptor;

public class DependencyManager {
    private J2EEContextDescriptor descriptor;
    protected Class componentClass;
    private List dependencies;

    protected void addDependency(InjectableReference ref, List targets, String jndiName) {
        this.dependencies.add(new Dependency(ref, targets, this.getLocation(ref)));
    }

    public DependencyManager(J2EEContextDescriptor descriptor, Class componentClass) {
        this.descriptor = descriptor;
        this.componentClass = componentClass;
        this.dependencies = new ArrayList();
    }

    public void initialize() throws InstantiationException {
        List targets = this.bindAllReferences();
        this.checkDuplicateTargets(targets);
    }

    protected void bindReferences(List references, List targets) throws InstantiationException {
        Iterator i = references.iterator();
        while (i.hasNext()) {
            InjectableReference ref = (InjectableReference)i.next();
            if (ref instanceof EnvironmentEntry && ((EnvironmentEntry)ref).internalGetValue() == null || !ref.hasInjectionTarget()) continue;
            ref.initializeInjection(this.componentClass);
            targets.addAll(ref.getInjectionTargets());
            this.addDependency(ref, ref.getInjectionTargets(), this.getLocation(ref));
        }
    }

    protected List bindAllReferences() throws InstantiationException {
        ArrayList targets = new ArrayList();
        this.bindReferences(this.descriptor.getEJBReferences(), targets);
        this.bindReferences(this.descriptor.getResourceReferences(), targets);
        this.bindReferences(this.descriptor.getResourceEnvironmentReferences(), targets);
        this.bindReferences(this.descriptor.getEnvironmentEntries(), targets);
        this.bindReferences(this.descriptor.getPersistenceUnitReferences(), targets);
        this.bindReferences(this.descriptor.getPersistenceContextReferences(), targets);
        this.bindReferences(this.descriptor.getServiceReferences(), targets);
        this.bindReferences(this.descriptor.getDestinationReferences(), targets);
        return targets;
    }

    protected void checkDuplicateTargets(List targets) throws InstantiationException {
        for (int i = 0; i < targets.size(); ++i) {
            InjectionTarget target1 = (InjectionTarget)targets.get(i);
            for (int j = i + 1; j < targets.size(); ++j) {
                InjectionTarget target2 = (InjectionTarget)targets.get(j);
                if (!target1.getTargetName().equals(target2.getTargetName()) || !target1.getTargetClass().equals(target2.getTargetClass())) continue;
                throw new InstantiationException("Injection of multiple references to the same target[class = " + target1.getTargetClass() + ", field/property = " + target1.getTargetName() + "]");
            }
        }
    }

    protected String getLocation(InjectableReference ref) {
        if (ref instanceof EJBReference) {
            return "java:comp/env/" + ref.getName();
        }
        String location = J2EEContext.getPredefinedReferenceLocation(ref.getReferenceClass());
        return location == null ? "java:comp/env/" + ref.getName() : location;
    }

    public void resolveDependencies(Context ctx, Object target) throws InstantiationException {
        Iterator i = this.dependencies.iterator();
        while (i.hasNext()) {
            Object ref;
            Dependency dependency = (Dependency)i.next();
            try {
                ref = ctx.lookup(dependency.jndiName);
            }
            catch (NamingException e) {
                throw (InstantiationException)new InstantiationException("Error looking up reference " + dependency.ref).initCause(e);
            }
            try {
                Iterator j = dependency.injectionTargets.iterator();
                while (j.hasNext()) {
                    ((InjectionTarget)j.next()).inject(target, ref);
                }
            }
            catch (Exception e) {
                throw (InstantiationException)new InstantiationException("Error injecting reference").initCause(e);
            }
        }
    }

    protected J2EEContextDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    private static class Dependency {
        InjectableReference ref;
        List injectionTargets;
        String jndiName;

        Dependency(InjectableReference ref, List targets, String jndiName) {
            this.ref = ref;
            this.injectionTargets = targets;
            this.jndiName = jndiName;
        }
    }
}

