/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionManagerAdmin;
import com.evermind.server.InvalidConfigurationException;
import java.util.HashMap;
import javax.management.MalformedObjectNameException;
import oracle.as.j2ee.transaction.TransactionManagerConfiguration;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.transaction.TransactionMessages;

public class ApplicationServerTransactionStats {
    public static final int RBCAUSE_UNDEFINED = 200;
    public static final int RBCAUSE_TIMEDOUT = 201;
    public static final int RBCAUSE_APP = 202;
    public static final int RBCAUSE_RESOURCE = 203;
    public static final int RBCAUSE_ADMIN = 204;
    public static final int RBCAUSE_SHUTDOWN = 205;
    public static final String ACTIVECOUNT = "ActiveCount";
    public static final String COMMITTEDCOUNT = "CommittedCount";
    public static final String ROLLEDBACKCOUNT = "RolledbackCount";
    public static final String ROLLEDBACKDUETOTIMEDOUTCOUNT = "RolledbackDueToTimedOutCount";
    public static final String ROLLEDBACKDUETOAPPCOUNT = "RolledbackDueToAppCount";
    public static final String ROLLEDBACKDUETORESOURCECOUNT = "RolledbackDueToResourceCount";
    public static final String ROLLEDBACKDUETOADMINCOUNT = "RolledbackDueToAdminCount";
    public static final String ROLLBACKEXCEPTIONCOUNT = "RollbackExceptionCount";
    public static final String HEURISTICMIXEDEXCEPTIONCOUNT = "HeuristicMixedExceptionCount";
    public static final String HEURISTICROLLBACKEXCEPTIONCOUNT = "HeuristicRollbackExceptionCount";
    public static final String SECURITYEXCEPTIONCOUNT = "SecurityExceptionCount";
    public static final String ILLEGALSTATEEXCEPTIONCOUNT = "IllegalStateExceptionCount";
    public static final String SYSTEMEXCEPTIONCOUNT = "SystemExceptionCount";
    public static final String HEURISTICCOMMITTEDCOUNT = "HeuristicCommittedCount";
    public static final String HEURISTICROLLEDBACKCOUNT = "HeuristicRolledbackCount";
    public static final String TOTALHEURISTICCOUNT = "HeuristicCount";
    public static final String[] JTA_STAT_NAMES = new String[]{"ActiveCount", "CommittedCount", "RolledbackCount", "RolledbackDueToTimedOutCount", "RolledbackDueToAppCount", "RolledbackDueToResourceCount", "RolledbackDueToAdminCount", "RollbackExceptionCount", "HeuristicMixedExceptionCount", "HeuristicRollbackExceptionCount", "SecurityExceptionCount", "IllegalStateExceptionCount", "SystemExceptionCount", "HeuristicCommittedCount", "HeuristicRolledbackCount", "HeuristicCount"};
    public static final String JTARESOURCE = "JTAResource";
    public static final String JTA_STATS = "oc4j_jta_stats";
    private boolean m_isCommitThresholdSet = false;
    private HashMap m_statInfoMap = new HashMap();
    private NounIntf m_dmsNoun;

    public ApplicationServerTransactionStats() {
        for (int i = 0; i < JTA_STAT_NAMES.length; ++i) {
            this.m_statInfoMap.put(JTA_STAT_NAMES[i], new statInfo(JTA_STAT_NAMES[i]));
        }
    }

    void updateActive(int current) {
        statInfo statInfo2 = this.getStatInfo(ACTIVECOUNT);
        statInfo2.setActiveCount(current);
        this.checkThreshold(statInfo2);
    }

    void updateCommitted(long txStartTime) {
        this.getStatInfo(COMMITTEDCOUNT).incrementCount();
        if (!this.m_isCommitThresholdSet) {
            return;
        }
        this.checkThreshold(this.getStatInfo(COMMITTEDCOUNT));
    }

    void updateRolledback(int rollbackCause) {
        statInfo statInfoRolledbackCount = this.getStatInfo(ROLLEDBACKCOUNT);
        statInfoRolledbackCount.incrementCount();
        this.checkThreshold(statInfoRolledbackCount);
        switch (rollbackCause) {
            case 201: {
                this.incrementStat(ROLLEDBACKDUETOTIMEDOUTCOUNT);
                break;
            }
            case 203: {
                this.incrementStat(ROLLEDBACKDUETORESOURCECOUNT);
                break;
            }
            case 204: {
                this.incrementStat(ROLLEDBACKDUETOADMINCOUNT);
                break;
            }
            default: {
                this.incrementStat(ROLLEDBACKDUETOAPPCOUNT);
            }
        }
    }

    void incrementStat(String statToIncrementAndCheck) {
        if (!ApplicationServer.DMS_GATE) {
            return;
        }
        statInfo statInfo2 = this.getStatInfo(statToIncrementAndCheck);
        statInfo2.incrementCount();
        if (statToIncrementAndCheck.equals(COMMITTEDCOUNT) && !this.m_isCommitThresholdSet) {
            return;
        }
        this.checkThreshold(statInfo2);
    }

    void updateHeuristics(boolean heurcommit) {
        if (heurcommit) {
            this.incrementStat(HEURISTICCOMMITTEDCOUNT);
            this.incrementStat(TOTALHEURISTICCOUNT);
            this.incrementStat(COMMITTEDCOUNT);
        } else {
            this.incrementStat(HEURISTICROLLEDBACKCOUNT);
            this.incrementStat(TOTALHEURISTICCOUNT);
            this.incrementStat(ROLLEDBACKCOUNT);
        }
    }

    void addThresholdEventsFromConfig(TransactionManagerConfiguration config) throws InvalidConfigurationException {
        String[] thresholdStatisticNames = config.getThresholdStatisticNamesFromConfig();
        if (thresholdStatisticNames == null) {
            return;
        }
        int[] thresholds = config.getThresholdsFromConfig();
        int[] repeatNotificationIntervals = config.getRepeatIntervalFromConfig();
        for (int i = 0; i < thresholdStatisticNames.length; ++i) {
            this.addThresholdEvent(thresholdStatisticNames[i], thresholds[i], repeatNotificationIntervals[i]);
        }
    }

    boolean addThresholdEvent(String thresholdStatisticName, int threshold, int repeatNotificationInterval) throws InvalidConfigurationException {
        this.validateStatName(thresholdStatisticName);
        if (threshold < 1) {
            throw new InvalidConfigurationException("Invalid threshold of " + threshold + " set for " + thresholdStatisticName + " value must be greater than 0");
        }
        if (repeatNotificationInterval < 0) {
            throw new InvalidConfigurationException("Invalid repeatNotificationInterval of " + repeatNotificationInterval + " set for " + thresholdStatisticName + " value must be greater than or equal to 0");
        }
        boolean thresholdEventExists = this.getStatInfo(thresholdStatisticName).isThresholdEventSet();
        this.getStatInfo(thresholdStatisticName).addThresholdEvent(threshold, repeatNotificationInterval);
        if (thresholdStatisticName.equals(COMMITTEDCOUNT)) {
            this.m_isCommitThresholdSet = true;
        }
        return thresholdEventExists;
    }

    private void validateStatName(String thresholdStatisticName) throws InvalidConfigurationException {
        if (this.getStatInfo(thresholdStatisticName) == null) {
            StringBuffer buf = null;
            for (int i = 0; i < JTA_STAT_NAMES.length; ++i) {
                buf.append(JTA_STAT_NAMES[i] + "\n");
            }
            throw new InvalidConfigurationException("Invalid JTA statistic " + thresholdStatisticName + " Value must provide one of the following statistics:\n" + buf);
        }
    }

    void removeThresholdEvent(String thresholdStatisticName) throws InvalidConfigurationException {
        this.validateStatName(thresholdStatisticName);
        if (!this.getStatInfo(thresholdStatisticName).isThresholdEventSet()) {
            throw new InvalidConfigurationException("No threshold events currently exists for " + thresholdStatisticName);
        }
        statInfo statInfo2 = this.getStatInfo(thresholdStatisticName);
        statInfo2.removeThresholdEvent();
        if (this.getStatInfo(COMMITTEDCOUNT).isThresholdEventSet()) {
            this.m_isCommitThresholdSet = false;
        }
    }

    private void checkThreshold(statInfo statToCheck) {
        if (statToCheck.isThresholdEventSet() && statToCheck.getCount() >= statToCheck.getThreshold()) {
            String om;
            String string = om = statToCheck.getRepeatInterval() > 1L ? " alerts will continue every " + statToCheck.getRepeatInterval() + " increments" : "";
            if (statToCheck.getAlertsSent() > 0L && (statToCheck.getCount() - statToCheck.getThreshold()) % statToCheck.getRepeatInterval() == 1L) {
                this.fireThresholdEvent(statToCheck.getStatName() + " = " + statToCheck.getCount() + " exceeded set threshold, this is alert number " + statToCheck.getAlertsSent() + 1 + ", " + om);
                statToCheck.incrementAlertsSent();
            } else {
                this.fireThresholdEvent(statToCheck.getStatName() + " = " + statToCheck.getCount() + " exceeded set threshold, this is the first alert, " + om);
                statToCheck.incrementAlertsSent();
            }
        }
    }

    private void fireThresholdEvent(String message) {
        try {
            ApplicationServerTransactionManager applicationServerTransactionManager = (ApplicationServerTransactionManager)ApplicationServer.getInstance().getTransactionManager();
            new ApplicationServerTransactionManagerAdmin(applicationServerTransactionManager).fireEvent("jtaThresholdEvent", 0L, message);
        }
        catch (MalformedObjectNameException e) {
            TransactionMessages.warning("Error getting JTAResource ObjectName");
        }
    }

    public void clearStats() {
        for (int i = 0; i < JTA_STAT_NAMES.length; ++i) {
            if (JTA_STAT_NAMES[i].equals(ACTIVECOUNT)) continue;
            this.getStatInfo(ApplicationServerTransactionStats.JTA_STAT_NAMES[i]).clearCount();
        }
    }

    public long getStatCount(String statName) {
        return this.getStatInfo(statName).getCount();
    }

    public static String jsr77ToDMSStatNameConvention(String jsr77StatName) {
        String string = jsr77StatName.replaceFirst(jsr77StatName.substring(0, 1), jsr77StatName.substring(0, 1).toLowerCase());
        return string;
    }

    private statInfo getStatInfo(String statName) {
        return (statInfo)this.m_statInfoMap.get(statName);
    }

    private class statInfo {
        private String m_statName;
        private long m_threshold;
        private long m_repeatInterval;
        private long m_alertsSent;
        private StateIntf m_dmsState;

        private statInfo(String statName) {
            this.m_statName = statName;
            if (ApplicationServer.DMS_GATE) {
                this.createDMS();
            }
        }

        private void createDMS() {
            if (ApplicationServerTransactionStats.this.m_dmsNoun == null) {
                ApplicationServerTransactionStats.this.m_dmsNoun = ApplicationServer.nounFactory().create(ApplicationServer.nounFactory().create("/oc4j"), ApplicationServerTransactionStats.JTARESOURCE, ApplicationServerTransactionStats.JTARESOURCE);
            }
            this.m_dmsState = ApplicationServer.stateFactory().create(ApplicationServerTransactionStats.this.m_dmsNoun, this.m_statName, (byte)2, ApplicationServerTransactionStats.jsr77ToDMSStatNameConvention(this.m_statName), this.m_statName);
            this.m_dmsState.deriveMetric(3);
        }

        private String getStatName() {
            return this.m_statName;
        }

        private boolean isDMS() {
            if (ApplicationServer.DMS_GATE) {
                if (ApplicationServerTransactionStats.this.m_dmsNoun == null || this.m_dmsState == null) {
                    this.createDMS();
                }
                return true;
            }
            return false;
        }

        private void incrementCount() {
            if (this.isDMS()) {
                this.m_dmsState.increment(1);
            }
        }

        private void setActiveCount(long count) {
            if (this.isDMS()) {
                this.m_dmsState.update(count);
            }
        }

        private long getCount() {
            if (this.isDMS()) {
                int metricName = 2;
                return ((Integer)this.m_dmsState.getMetric(metricName).getValue()).longValue();
            }
            return 0L;
        }

        private void clearCount() {
            if (this.isDMS() && this.m_dmsState != null) {
                this.m_dmsState.update(0);
            }
        }

        private boolean isThresholdEventSet() {
            return this.m_threshold > 0L;
        }

        private long getThreshold() {
            return this.m_threshold;
        }

        private long getRepeatInterval() {
            return this.m_repeatInterval;
        }

        private void incrementAlertsSent() {
            ++this.m_alertsSent;
        }

        private long getAlertsSent() {
            return this.m_alertsSent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addThresholdEvent(int threshold, int repeatInterval) {
            statInfo statInfo2 = this;
            synchronized (statInfo2) {
                this.m_threshold = threshold;
                this.m_repeatInterval = repeatInterval;
                this.m_alertsSent = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeThresholdEvent() {
            statInfo statInfo2 = this;
            synchronized (statInfo2) {
                this.m_threshold = 0L;
                this.m_repeatInterval = 0L;
                this.m_alertsSent = 0L;
            }
        }
    }
}

