/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.compiler.CompilerFactory;
import com.evermind.compiler.Javac;
import com.evermind.compiler.LinkedCompiler;
import com.evermind.compiler.NativeFileLinkedCompiler;
import com.evermind.io.IOUtils;
import com.evermind.io.ThreadsPrintStream;
import com.evermind.io.TimestampedPrintStream;
import com.evermind.net.NetUtils;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.server.ApplicationInitialContextFactory;
import com.evermind.server.ApplicationServerEventsListener;
import com.evermind.server.ApplicationServerLauncher;
import com.evermind.server.ApplicationServerPolicy;
import com.evermind.server.ApplicationServerSecurityManager;
import com.evermind.server.ApplicationServerShutdownHandler;
import com.evermind.server.ApplicationServerSystemProperties;
import com.evermind.server.ApplicationServerTask;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ApplicationServerThreadGroup;
import com.evermind.server.ApplicationServerThreadLocal;
import com.evermind.server.ApplicationServerThreadPool;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.CommandLineArgs;
import com.evermind.server.EventThreadChecker;
import com.evermind.server.InvalidConfigurationException;
import com.evermind.server.Lock;
import com.evermind.server.OC4JMonitorThread;
import com.evermind.server.OC4JServer;
import com.evermind.server.ObjectReferenceCleaner;
import com.evermind.server.ReentrantReadWriteLock;
import com.evermind.server.Refreshable;
import com.evermind.server.RoleUser;
import com.evermind.server.RuntimeApplicationUpdater;
import com.evermind.server.RuntimeRarUpdater;
import com.evermind.server.Server;
import com.evermind.server.ServerExtensionProvider;
import com.evermind.server.ServerMessages;
import com.evermind.server.SubordinateXAResource;
import com.evermind.server.SubordinateXAResourceImpl;
import com.evermind.server.ThreadState;
import com.evermind.server.TransactionSynchronizationRegistryImpl;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.InternalSettingsDescriptor;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.ejb.cache.EntityCacheManager;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.JspInterface;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.rmi.JGroupJndiNamespaceReplicationService;
import com.evermind.server.rmi.JndiNamespaceReplicationService;
import com.evermind.server.rmi.NullRmiServerConfig;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerConfig;
import com.evermind.server.rmi.RMIServerContext;
import com.evermind.util.AttributeContainer;
import com.evermind.util.ByteStringCache;
import com.evermind.util.ClassDescriptor;
import com.evermind.util.DBProperties;
import com.evermind.util.ErrorHandler;
import com.evermind.util.HTTPProperties;
import com.evermind.util.OC4JRuntimeProperties;
import com.evermind.util.ServerProperties;
import com.evermind.util.TaskManager;
import com.evermind.util.ThreadPool;
import com.evermind.xml.EntityResolverUtil;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.naming.J2EEContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.Security;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.resource.spi.BootstrapContext;
import javax.transaction.TransactionManager;
import oracle.as.j2ee.transaction.CoordinatorCreationException;
import oracle.as.j2ee.transaction.recovery.BottomUpQueryCOR;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransactionInfo;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.QueryProcessor;
import oracle.classloader.util.ApplicationLogManager;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadMonitor;
import oracle.classloader.util.VersionNumber;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.SensorFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.instrument.DMSConsole;
import oracle.hooks.InterruptProtocol;
import oracle.ias.container.ContainerServiceManager;
import oracle.ias.container.event.EventService;
import oracle.ias.container.scheduler.ExecutorService;
import oracle.ias.container.timer.TimerService;
import oracle.j2ee.connector.BootstrapContextImpl;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.j2ee.jms.oc4j.v1.JMSServerConfig;
import oracle.j2ee.transaction.TransactionSynchronizationRegistry;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.j2ee.util.TraceLogger;
import oracle.j2ee.util.UUID;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.admin.config.HttpServerConfig;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.OC4JDeployer;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.Uploader;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.jmx.shared.deploy.Constants;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEServerCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JVMCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEApplication;
import oracle.oc4j.admin.management.mbeans.J2EEServer;
import oracle.oc4j.admin.management.mbeans.JNDINamespace;
import oracle.oc4j.admin.management.mbeans.JNDIResource;
import oracle.oc4j.admin.management.mbeans.JTAResource;
import oracle.oc4j.admin.management.mbeans.JVM;
import oracle.oc4j.admin.management.shared.CodeSource;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.InstalledLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;
import oracle.oc4j.admin.management.util.CollectionModificationEvent;
import oracle.oc4j.admin.management.util.CollectionModificationListener;
import oracle.oc4j.admin.management.util.NotifyingMap;
import oracle.oc4j.extensions.UseDeploymentLockFile;
import oracle.oc4j.hooks.ServerProtocol;
import oracle.oc4j.loader.OC4JProtectionPolicy;
import oracle.oc4j.loader.config.ConfigurationConsumer;
import oracle.oc4j.loader.config.OC4JConfigurationPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationType;
import oracle.oc4j.loader.config.SharedLibraryType;
import oracle.oc4j.loader.config.xml.CodeSourceElement;
import oracle.oc4j.loader.config.xml.ImportSharedLibraryElement;
import oracle.oc4j.loader.config.xml.SharedLibraryElement;
import oracle.oc4j.runtime.ServerExtensionProviderSpec;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.transport.TransportManager;
import oracle.oc4j.transport.ormi.OrmiTransportManager;
import oracle.oc4j.util.ClassUtils;
import oracle.oc4j.util.FileUtils;
import oracle.security.jazn.JAZNConfig;

public class ApplicationServer
extends Server
implements CollectionModificationListener,
J2EEServerCallBackIf,
JVMCallBackIf,
Refreshable {
    private ReentrantReadWriteLock destroyRwl = new ReentrantReadWriteLock();
    public static final User NO_PERMISSIONS_USER = new RoleUser(new SecurityRole("container actions"));
    public static final boolean CTS_COMPABILITY_MODE = true;
    public static ServerExtensionProvider[] serverExtensionProviders;
    static InternalSettingsDescriptor m_internalSettings;
    public static final int FILE_POLL_INTERVAL = 1;
    static String ejbSecPropPath;
    protected static boolean embeddedMode;
    public static final boolean USE_MEMORY_JARS = true;
    public static ApplicationServerThreadLocal threadContextContainer;
    static ApplicationServer instance;
    public static final boolean ENABLE_JCACHE;
    public static final String PRODUCT_NAME = "Oracle Containers for J2EE";
    public static final String VERSION;
    public static final String MEANINGFUL_VERSION;
    public static final String INFO;
    protected static PrintStream coreOut;
    protected static Map systemPrintStreams;
    protected static ThreadsPrintStream systemOut;
    protected static ThreadsPrintStream systemErr;
    protected static ApplicationServerPolicy policy;
    private Object _globalTldCache;
    public static boolean DMS_GATE;
    public static final String DMS_SENSORS_KEY = "oracle.dms.sensors";
    public static oracle.dms.console.DMSConsole dmsConsole;
    protected static EventFactoryIntf eventFactory;
    protected static NounFactoryIntf nounFactory;
    protected static PhaseEventFactoryIntf phaseFactory;
    protected static SensorFactoryIntf sensorFactory;
    protected static StateFactoryIntf stateFactory;
    private static final String SECURITY_PROPERTY_PREFIX = "oracle.oc4j.security.property.";
    private static final int SECURITY_PROPERTY_PREFIX_LENGTH;
    private boolean secure;
    public ByteStringCache byteStringCache = new ByteStringCache();
    ApplicationServerConfig config;
    protected ApplicationServerSecurityManager securityManager;
    protected SecurityManager originalSecurityManager;
    protected int securityLayers;
    private long clusterID;
    public int clusterPort;
    private LinkedCompiler compiler;
    private Object compilerLock = new Object();
    private boolean alive = true;
    protected boolean adminBound;
    protected TaskManager taskManager = null;
    protected ThreadGroup systemThreadGroup = null;
    protected ThreadGroup requestThreadGroup = null;
    protected ThreadGroup cxThreadGroup = null;
    protected ThreadGroup rmiRequestThreadGroup = null;
    protected ThreadPool systemThreadPool = null;
    protected ThreadPool requestThreadPool = null;
    protected ThreadPool cxThreadPool = null;
    protected ThreadPool rmiRequestThreadPool = null;
    private Hashtable customThreadPools = new Hashtable();
    private Application defaultApplication;
    protected BootstrapContext bootstrapContext = null;
    private NotifyingMap applications = new NotifyingMap();
    public int[] memoryUsage = new int[1200];
    public int memoryUsagePos;
    public int memoryUsageLength;
    private int verbosityLevel;
    private ApplicationServerTransactionManager m_tm;
    protected HttpServer httpServer;
    protected JMSServer jmsServer;
    protected oracle.j2ee.jms.oc4j.v1.JMSServer jmsServer2;
    protected RMIServer rmiServer;
    protected RMIServer localRmiServer;
    private boolean isInRMIServerShutdownStarted = false;
    private Thread shutdownHook;
    private boolean initialized;
    protected boolean executedStartupClasses = false;
    public File autoDeploymentDirectory;
    boolean enableServices = true;
    private int deploymentLayers;
    private BottomUpQueryCOR bottomUpCOR;
    private ClassLoader libraryClassLoader;
    private List sharedLibraries;
    private ArrayList componentsToRefresh;
    private String checkForUpdatesMode;
    public static final String UPDATES_VIA_ADMIN_CLIENT_REQUESTS = "adminClientOnly";
    public static final String UPDATES_VIA_ALL_MODES = "all";
    public static final String UPDATES_NONE = "none";
    private RecoveringTransactionInfo m_recoveringTransactionInfo;
    private static ApplicationServerAdministrator _admin;
    private static Application systemApplication;
    private static final String SYSTEM_APPLICATION_NAME = "system";
    private boolean ready_ = false;
    private String propPath = null;
    private static Logger m_logger;
    private Thread restartThread;
    private static boolean eventChecker;
    private static final String JVM_TERMINATE = "JVM termination";
    private final Object checkForUpdatesLock = new Object();
    private List eventsListeners = new ArrayList();

    ApplicationServer() {
    }

    ApplicationServer(boolean secure, int verbosity, ApplicationServerConfig config) throws InstantiationException {
        ServerMessages.infoStartServerInitialization();
        this.config = config;
        this.propPath = config.getPropPath();
        this.verbosityLevel = verbosity;
        this.secure = secure;
        instance = this;
        this.initThreadPools();
        ApplicationServer.initSystemStreams();
        ApplicationServer.initCoreSystemStreams();
        ApplicationServer.initProtocolHandlers();
        this.initTransportManagers();
        this.initJMX();
        this.initSecurityManager();
        this.initShutdownHandler();
        this.initJNDISettings();
        ApplicationServer.defineInitialContextFactory(ApplicationInitialContextFactory.class);
        this.applications.addCollectionModificationListener(this);
        this.initRestartHandler();
    }

    protected void launchEventThreadChecker() {
        m_logger.finest("Launching event checker thread.");
        this.systemThreadPool.launch(new EventThreadChecker(this, this.taskManager));
    }

    public static void addRunnableToThreadPool(Runnable r) {
        OC4JSecurity.assertIsSafe();
        instance.getThreadPool().launch(r);
    }

    public static long computeSerialVersionUID(String className) {
        return ClassUtils.computeSerialVersionUID(className);
    }

    public int getVerbosityLevel() {
        return this.verbosityLevel;
    }

    public long getClusterID() {
        return this.clusterID;
    }

    protected static ApplicationServer launchCommandline(String[] args) throws InstantiationException {
        File configParentDirFile;
        ApplicationServer.initProtocolHandlers();
        CommandLineArgs cmdLineConf = new CommandLineArgs(args);
        if (cmdLineConf.terminateServer()) {
            cmdLineConf.PrintErrorMessages(System.err);
            return null;
        }
        EntityResolverUtil.init(cmdLineConf.getConfigParentDir());
        ApplicationServer.setSecurityProperties();
        String configParentDir = cmdLineConf.getConfigParentDir();
        if (configParentDir != null && (configParentDirFile = new File(configParentDir)) != null && configParentDirFile.exists()) {
            JAZNConfig.setJAZNConfigSystemProperty((File)configParentDirFile);
        }
        if (cmdLineConf.isInstall()) {
            ApplicationServer.doInstall(cmdLineConf);
        } else {
            ApplicationServer.initSystemStreams();
            if (ServerProperties.getOc4jUserThreads()) {
                threadContextContainer = new ApplicationServerThreadLocal();
                threadContextContainer.set(new Object());
            }
            if (DBProperties.getNativeJDBCDebug()) {
                PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
                DriverManager.setLogWriter(w);
            }
            if (!ServerProperties.getOc4jDeveloperLazySecureRandomCreation()) {
                UUID.createSecureRandom();
            }
            if (ServerProperties.getOracleCtsUseCtsFlags()) {
                System.setProperty("oracle.jdbc.J2EE13Compliant", "true");
                System.setProperty("oracle.jms.stronglyTypedSelectors", "true");
                System.setProperty("oracle.jms.j2eeCompliant", "true");
                System.setProperty("oracle.xdkjava.compatibility.version", "9.0.3");
                System.setProperty("oracle.vector.deepCopy", "false");
            }
            eventChecker = cmdLineConf.isMonitorEventThread();
            ApplicationServerLauncher launcher = new ApplicationServerLauncher(cmdLineConf.getConfigPath(), cmdLineConf.isSecure(), cmdLineConf.getVerbosity(), eventChecker, cmdLineConf.getDefaultHost(), cmdLineConf.getClusterIDString(), cmdLineConf.getPropPath());
            ApplicationServerThread thread = new ApplicationServerThread(null, (Runnable)launcher, "OC4J Launcher", 0L);
            thread.start();
            try {
                thread.join();
                if (instance == null || startTime <= 0L) {
                    if (embeddedMode) {
                        throw new InstantiationException("Fatal error: Cannot instantiate ApplicationServerThread!");
                    }
                    System.out.println("Fatal error: server exiting");
                    m_logger.fine("OC4J server exiting with error code 1");
                    System.exit(1);
                    return null;
                }
            }
            catch (InterruptedException e) {
                m_logger.finest("Caught InterruptedException. " + e);
            }
            J2EEServer.notifyServerReady();
        }
        return instance;
    }

    public boolean enableMonitorEventChecker() {
        return eventChecker;
    }

    private static void setSecurityProperties() {
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(SECURITY_PROPERTY_PREFIX)) continue;
            String secProp = name.substring(SECURITY_PROPERTY_PREFIX_LENGTH);
            String value = System.getProperty(name);
            m_logger.finest("Setting security property: " + secProp + " to: " + value);
            Security.setProperty(secProp, value);
        }
    }

    private void initThreadPools() {
        ServerMessages.infoThreadPoolsInitializing();
        ApplicationServerThreadPool.Holder holder = ApplicationServerThreadPool.createThreadPool("SystemThreadGroup", SYSTEM_APPLICATION_NAME);
        this.systemThreadGroup = holder.group;
        this.systemThreadPool = holder.pool;
        holder = ApplicationServerThreadPool.createThreadPool("HTTPThreadGroup", "http");
        this.requestThreadGroup = holder.group;
        this.requestThreadPool = holder.pool;
        holder = ApplicationServerThreadPool.createThreadPool("RMIConnectionThreadGroup", "rmi connection");
        if (holder == null) {
            this.cxThreadPool = this.requestThreadPool;
        } else {
            this.cxThreadGroup = holder.group;
            this.cxThreadPool = holder.pool;
        }
        holder = ApplicationServerThreadPool.createThreadPool("RMIRequestThreadGroup", "rmi request");
        if (holder == null) {
            this.rmiRequestThreadPool = this.requestThreadPool;
        } else {
            this.rmiRequestThreadGroup = holder.group;
            this.rmiRequestThreadPool = holder.pool;
        }
        try {
            while (this.systemThreadGroup.getParent() instanceof ApplicationServerThreadGroup) {
                this.systemThreadGroup = this.systemThreadGroup.getParent();
                this.systemThreadPool.setThreadGroup(this.systemThreadGroup);
            }
        }
        catch (Throwable t) {
            m_logger.severe("Unable to set thread group for systemThread pool." + t);
            m_logger.throwing("ApplicationServer", "initThreadPools", t);
        }
        ServerMessages.infoDoneInitializingThreadPools();
    }

    private static void initSystemStreams() {
        if (systemOut == null) {
            System.setOut(new TimestampedPrintStream(System.out));
            System.setErr(new TimestampedPrintStream(System.err));
            systemOut = new ThreadsPrintStream(systemPrintStreams, System.out);
            systemErr = new ThreadsPrintStream(systemPrintStreams, System.err);
        }
    }

    private static void initCoreSystemStreams() {
        try {
            coreOut = System.out;
            if (systemOut == null || systemErr == null) {
                throw new NullPointerException("System.out was null!");
            }
            System.setOut(systemOut);
            System.setErr(systemErr);
        }
        catch (SecurityException e) {
            ServerMessages.warningReassigningSystemStreams(e);
            e.printStackTrace();
        }
    }

    public static void resetCoreSystemStream(PrintStream out, PrintStream err) {
        OC4JSecurity.assertIsSafe();
        if (out != null) {
            if (System.out instanceof ThreadsPrintStream) {
                ((ThreadsPrintStream)System.out).resetDefaultStream(new TimestampedPrintStream(out));
            } else {
                out = new ThreadsPrintStream(systemPrintStreams, new TimestampedPrintStream(out));
                System.setOut(out);
            }
        }
        if (err != null) {
            if (System.out instanceof ThreadsPrintStream) {
                ((ThreadsPrintStream)System.err).resetDefaultStream(new TimestampedPrintStream(err));
            } else {
                err = new ThreadsPrintStream(systemPrintStreams, new TimestampedPrintStream(err));
                System.setErr(err);
            }
        }
    }

    private static void initProtocolHandlers() {
        String protocolHandlerProperty = System.getProperty("java.protocol.handler.pkgs");
        if (protocolHandlerProperty == null) {
            protocolHandlerProperty = "com.evermind.protocol";
            System.setProperty("java.protocol.handler.pkgs", protocolHandlerProperty);
        } else if (protocolHandlerProperty.indexOf("com.evermind.protocol") < 0) {
            protocolHandlerProperty = protocolHandlerProperty + "|" + "com.evermind.protocol";
            System.setProperty("java.protocol.handler.pkgs", protocolHandlerProperty);
        }
    }

    private void initSecurityManager() {
        m_logger.finest("Initializing security manager.");
        this.originalSecurityManager = System.getSecurityManager();
        this.securityManager = new ApplicationServerSecurityManager(this.secure);
    }

    private void initShutdownHandler() {
        try {
            if (ServerProperties.getOracleSkiphooks()) {
                System.out.println("**      Skipping shutdown hooks      **\n** NOT A SUPPORTED MODE OF OPERATION **");
            } else {
                this.addShutdownHandler();
            }
        }
        catch (Throwable t) {
            ServerMessages.warningInitShutdownHandler(t);
            m_logger.throwing("ApplicationServer", "initShutdownHandler", t);
            t.printStackTrace();
        }
    }

    private void startContainerServices() throws InstantiationException {
        if (this.enableServices) {
            ServerMessages.infoContainerManagerServicesStarting();
            ContainerServiceManager csmgr = ContainerServiceManager.instance();
            EnterpriseArchive ear = (EnterpriseArchive)this.config.getDefaultApplicationConfig();
            URL persistenceDir = ear.getPersistenceURL();
            if (persistenceDir != null) {
                TimerService.instance().setTempDir(persistenceDir.getFile());
            }
            csmgr.addService(EventService.instance());
            csmgr.addService(ExecutorService.instance());
            csmgr.addService(TimerService.instance());
            csmgr.startServices();
            ServerMessages.infoContainerManagerServicesStarted();
        }
    }

    public static String getBuildNumber() {
        try {
            return new String(IOUtils.getContent(ApplicationServer.class.getClassLoader().getResource("buildnumber"))).trim();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void addShutdownHandler() {
        ApplicationServerShutdownHandler handler = new ApplicationServerShutdownHandler(this, JVM_TERMINATE);
        this.shutdownHook = new ApplicationServerThread(null, (Runnable)handler, "shutdownHookThread", 0L);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(ApplicationServerConfig config) throws InstantiationException {
        long startInitializationTime = System.currentTimeMillis();
        UseDeploymentLockFile.installIfNeeded();
        super.setConfig(config);
        try {
            ServerProtocol.PRE_SET_CONFIG.fire(this, config);
            this.config = config;
            this.startContainerServices();
            this.startJavaCache();
            if (this.taskManager != null) {
                this.taskManager.stop();
            }
            this.taskManager = new TaskManager(config.getTaskManagerGranularity(), this.systemThreadPool, this.cxThreadPool);
            this.setCheckForUpdatesMode(config);
            this.taskManager.addTask(new ApplicationServerTask(this), config.getTaskManagerInterval());
            this.initClassLoadMonitor();
            this.serverExtensionPreInit();
            this.initAutoDeployApplicationDirectory();
            this.taskManager.stop();
            this.clusterID = config.getNodeID();
            this.clusterPort = config.getClusterPort();
            if (this.secure) {
                this.addSecurityLayer();
            }
            Thread.currentThread().setContextClassLoader(this.systemThreadPool.getClassLoader());
            this.initClassLoaders();
            EnterpriseArchive ear = (EnterpriseArchive)config.getDefaultApplicationConfig();
            URL persistenceDir = ear.getPersistenceURL();
            if (persistenceDir != null) {
                CompilerFactory.instance().setTempDir(persistenceDir.getFile());
            }
            if (OC4JServer.getOPMNEnabled()) {
                InterruptProtocol.loadDynamicExtension("com.evermind.server.OC4JMonitorHooksExtension", null);
            }
            try {
                this.initializeJMS();
            }
            catch (InstantiationException iex) {
                ServerMessages.severeJmsServerStartupException(iex.getMessage());
            }
            this.initializeRMI();
            RMIServerConfig rmiConfig = config.getRMIServerConfig();
            if (this.rmiServer != null) {
                this.rmiServer.setClusterManager(new JGroupJndiNamespaceReplicationService());
            }
            this.execStartupClassesPreDeploy();
            EntityCacheManager.instance().registerCacheManagerTask(this.taskManager);
            if (LogManager.getLogManager() instanceof ApplicationLogManager) {
                ObjectReferenceCleaner.activate();
            }
            this.initializeAutoDeployedApplications();
            this.registerSystemMBeans();
            if (this.rmiServer != null) {
                this.rmiServer.ready();
            }
            if (this.localRmiServer != null) {
                this.localRmiServer.ready();
            }
            ServerMessages.infoRMIServerReady();
            this.registerTransactionManagerMBean();
            this.registerJNDINamespaceBean();
            this.initializeDeployedApplications();
            this.execStartupClassesPostDeploy();
            this.m_tm.launchRecoveryThread(this.systemThreadPool);
            this.initializeHttp();
            if (OC4JServer.getOPMNEnabled()) {
                OC4JMonitorThread.start(this);
            }
            this.serverExtensionPostInit();
            ContainerServiceManager.instance().postInit();
            this.initialized = true;
            this.taskManager.start();
            ServerMessages.infoTaskManagerStarted();
            QueryProcessor.executeStartupQueries();
            if (QueryProcessor.shouldExit()) {
                this.stop();
            }
        }
        finally {
            this.ready_ = true;
            ServerProtocol.POST_SET_CONFIG.fire(this, config);
        }
        ServerMessages.infoServerInitializationComplete();
        long endInitializationTime = System.currentTimeMillis();
        ServerMessages.infoServerStartupTime(Long.toString((endInitializationTime - startInitializationTime) / 1000L));
    }

    private void publishSubXAResource() {
        SubordinateXAResource xaResource = SubordinateXAResourceImpl.instance();
        this.rmiServer.publishSubordinateXAResource(xaResource);
        if (this.localRmiServer != null) {
            this.localRmiServer.publishSubordinateXAResource(xaResource);
        }
    }

    private void setCheckForUpdatesMode(ApplicationServerConfig config) {
        String configuredValue = ((XMLApplicationServerConfig)config).getXmlConfiguredCheckForUpdateValue();
        String systemPropertyValue = ServerProperties.getCheckForUpdates();
        this.checkForUpdatesMode = configuredValue == null && systemPropertyValue == null ? (ServerProperties.getRunningInIAS() ? UPDATES_VIA_ADMIN_CLIENT_REQUESTS : UPDATES_VIA_ALL_MODES) : (systemPropertyValue != null ? systemPropertyValue : configuredValue);
        this.checkForUpdatesMode = this.validateCheckForUpdateInput(this.checkForUpdatesMode);
    }

    public String getCheckForUpdatesMode() {
        return this.checkForUpdatesMode;
    }

    private void initJNDISettings() {
        m_logger.finest("Initializing JNDI settings.");
        RMIContext.setGlobalJNDILookupEnabled(this.config.getGlobalJNDILookupEnabled());
        J2EEContext.setupURLPackagePrefixes(this.config.getEnvironmentNamingURLFactoryEnabled());
    }

    private void initClassLoadMonitor() {
        long interval = 60000L;
        Runnable task = new Runnable(){

            public void run() {
                ClassLoadMonitor.doPeriodicMaintenance();
            }
        };
        this.taskManager.addTask(task, interval);
    }

    private void startJavaCache() {
        if (!ENABLE_JCACHE) {
            return;
        }
        ServerMessages.infoJavaCacheStarting();
        String cacheConfig = this.config.getJavacachePath();
        try {
            Class<?> cacheClass = Class.forName("oracle.ias.cache.Cache");
            if (cacheConfig != null) {
                Method cacheClose = cacheClass.getMethod("open", String.class);
                cacheClose.invoke(cacheClass, cacheConfig);
            } else {
                Method cacheClose = cacheClass.getMethod("open", new Class[0]);
                cacheClose.invoke(cacheClass, new Object[0]);
            }
            ServerMessages.infoJavaCacheStarted();
        }
        catch (ClassNotFoundException ne) {
            ServerMessages.warningJavaCacheNotAvailable(ne);
        }
        catch (Exception e) {
            ServerMessages.warningJavaCacheStartFailure(e);
        }
    }

    static void initInternalSettings(InternalSettingsDescriptor settings) throws InstantiationException {
        settings.addServerExtensionProvider("oracle.j2ee.ws.server.mgmt.runtime.InterceptorContainerExtension");
        ServerExtensionProviderSpec[] specs = settings.getServerExtensionSpecs();
        ArrayList<ServerExtensionProvider> extensions = new ArrayList<ServerExtensionProvider>();
        for (int i = 0; i < specs.length; ++i) {
            extensions.add(specs[i].getProvider());
        }
        m_internalSettings = settings;
        serverExtensionProviders = extensions.toArray(new ServerExtensionProvider[extensions.size()]);
    }

    private void serverExtensionPreInit() throws InstantiationException {
        if (m_internalSettings == null) {
            return;
        }
        ServerExtensionProviderSpec[] specs = m_internalSettings.getServerExtensionSpecs();
        for (int i = 0; i < specs.length; ++i) {
            ServerExtensionProviderSpec spec = specs[i];
            ServerMessages.infoPreInitServerExtensions(spec.getProvider().toString());
            spec.getProvider().preInitApplicationServer(new File(this.getConfig().getURL().getPath()).getParentFile(), spec.getProperties());
        }
    }

    private void serverExtensionPostInit() throws InstantiationException {
        if (m_internalSettings == null) {
            return;
        }
        ServerExtensionProviderSpec[] specs = m_internalSettings.getServerExtensionSpecs();
        for (int i = 0; i < specs.length; ++i) {
            ServerExtensionProviderSpec spec = specs[i];
            ServerMessages.infoPostInitServerExtensions(spec.getProvider().toString());
            spec.getProvider().postInitApplicationServer((AttributeContainer)((Object)this.config), this);
        }
    }

    private void initAutoDeployApplicationDirectory() {
        try {
            String directory = this.config.getAutoDeployApplicationDirectory();
            this.autoDeploymentDirectory = directory == null ? null : new File(directory);
        }
        catch (IOException e) {
            ServerMessages.warningExceptionSettingAutoDeploymentDir(e);
        }
    }

    private void initClassLoaders() throws InstantiationException {
        this.initLibraryClassLoader();
        ServerMessages.infoInitLibraryClassLoader(this.libraryClassLoader.toString());
        try {
            ServerMessages.infoInitSharedLibraryLoaders();
            this.initSharedLibraries();
        }
        catch (Exception e) {
            InstantiationException ex = new InstantiationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private void initSharedLibraries() throws Exception {
        List list = this.config.getSharedLibraries();
        String configPath = this.config.getURL().getPath();
        File sharedLibDir = new File(this.config.getSharedLibrariesDirectory());
        File severConfigDir = new File(configPath).getParentFile();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SharedLibraryType type = (SharedLibraryType)iterator.next();
            PolicyClassLoader lib = ConfigurationConsumer.createSharedLibrary(type, sharedLibDir, severConfigDir, false, configPath);
            ServerMessages.infoAddingSharedLibrary(lib.getUniqueName());
            if (this.sharedLibraries == null) {
                this.sharedLibraries = new ArrayList();
            }
            this.sharedLibraries.add(lib);
        }
    }

    public boolean instantiateSharedLibrary(String name, String version) throws InstantiationException {
        SharedLibraryType cfg = this.getSharedLibraryConfig(name, version);
        if (cfg == null) {
            throw new InstantiationException("Shared library config not found: " + name + ":" + version);
        }
        if (cfg.isInstantiated()) {
            return true;
        }
        VersionNumber vn = new VersionNumber(version);
        PolicyClassLoader existing = ClassLoaderQuery.findLoader((String)name, (VersionNumber)vn, (VersionNumber)vn);
        if (existing != null) {
            if (existing.getSubscribers().getCount() > 0) {
                return false;
            }
            existing.close();
            this.sharedLibraries.remove(existing);
        }
        try {
            String configPath = this.config.getURL().getPath();
            File sharedLibDir = new File(this.config.getSharedLibrariesDirectory());
            File severConfigDir = new File(configPath).getParentFile();
            PolicyClassLoader lib = ConfigurationConsumer.createSharedLibrary(cfg, sharedLibDir, severConfigDir, false, configPath);
            this.sharedLibraries.add(lib);
        }
        catch (IOException e) {
            throw new InstantiationException(e.getMessage());
        }
        return true;
    }

    private SharedLibraryType getSharedLibraryConfig(String name, String version) {
        Iterator iterator = this.config.getSharedLibraries().iterator();
        while (iterator.hasNext()) {
            SharedLibraryType type = (SharedLibraryType)iterator.next();
            if (!type.getName().equals(name) || !type.getVersion().equals(version)) continue;
            return type;
        }
        return null;
    }

    private void destroyClassLoaders() {
        ServerMessages.infoDestroyingClassLoaders();
        if (this.sharedLibraries != null) {
            while (this.sharedLibraries.size() > 0) {
                PolicyClassLoader lib = (PolicyClassLoader)this.sharedLibraries.remove(0);
                lib.close();
                ServerMessages.infoClosedSharedLibraryLoader(lib.getUniqueName());
            }
            this.sharedLibraries = null;
        }
        if (this.libraryClassLoader != ClassLoaderQuery.getSystemLoader() && this.libraryClassLoader instanceof PolicyClassLoader) {
            PolicyClassLoader loader = (PolicyClassLoader)this.libraryClassLoader;
            if (loader.hasChildren()) {
                ClassLoadLogger.log((Level)Level.WARNING, (String)(loader.getUniqueName() + " not closed during ApplicationServer.destroy(). Has children: "));
                PolicyClassLoader[] children = loader.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    PolicyClassLoader child = children[i];
                    System.out.println("    " + child.getUniqueName());
                }
            } else {
                loader.close();
                this.libraryClassLoader = null;
                ServerMessages.infoClosedLibraryClassLoader(loader.getUniqueName());
            }
        }
        ServerMessages.infoCompleteClassLoaderDestroy();
    }

    private void initLibraryClassLoader() {
        List canonicalInitLibraryPaths = this.config.getCanonicalInitLibraryPaths();
        if (canonicalInitLibraryPaths.size() > 0) {
            String serverConfigPath = this.config.getURL().getPath();
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.SERVER_INIT_LIBRARY_ELEMENT, serverConfigPath);
            PolicyClassLoader loader = new PolicyClassLoader("init.libraries", this.getClass().getClassLoader(), origin, OC4JConfigurationPolicy.INIT_LIBRARIES, OC4JProtectionPolicy.INIT_LIBRARY_PERMISSIONS);
            Iterator iterator = canonicalInitLibraryPaths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                try {
                    loader.addCodeSource(path, origin);
                }
                catch (IOException e) {
                    ClassLoadLogger.logException((String)("Unable to add <init-library> path \"" + path + "\"."), (Throwable)e, (boolean)false);
                }
            }
            PolicyClassLoader ours = (PolicyClassLoader)this.getClass().getClassLoader();
            PolicyClassLoader[] imports = ours.getImports();
            ConfigurationOrigin o = new ConfigurationOrigin(ConfigurationType.INHERITED_SHARED_LIBRARIES, "init-libraries");
            for (int i = 0; i < imports.length; ++i) {
                PolicyClassLoader imp = imports[i];
                if (imp.getName().equals("oc4j.internal")) continue;
                loader.importLoader(imp, origin);
            }
            this.libraryClassLoader = loader;
        } else {
            this.libraryClassLoader = ClassLoaderQuery.getSystemLoader();
        }
    }

    private void execStartupClassesPreDeploy() {
        if (!this.executedStartupClasses & ((XMLServerConfig)((Object)this.config)).startupClasses != null) {
            try {
                RMIServerContext context = this.rmiServer.getServerContext(null, true);
                Iterator it = ((XMLServerConfig)((Object)this.config)).startupClasses.iterator();
                while (it.hasNext()) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)it.next();
                    ServerMessages.infoPreDeployStartupClasses(classDescriptor.mClassName);
                    classDescriptor.executeStartupClass(context, this.getLibraryClassLoader());
                }
            }
            catch (Exception e) {
                ServerMessages.severePreDeployStartupClassesFailure(e);
                e.printStackTrace();
                this.stop();
            }
        }
    }

    private void execStartupClassesPostDeploy() {
        if (!this.executedStartupClasses & ((XMLServerConfig)((Object)this.config)).startupClasses != null) {
            this.executedStartupClasses = true;
            try {
                RMIServerContext context = this.rmiServer.getServerContext(null, true);
                Iterator it = ((XMLServerConfig)((Object)this.config)).startupClasses.iterator();
                while (it.hasNext()) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)it.next();
                    ServerMessages.infoPostDeployStartupClasses(classDescriptor.mClassName);
                    classDescriptor.executeStartupClass(context, null);
                }
            }
            catch (Exception e) {
                ServerMessages.severePostDeployStartupClassesFailure(e);
                e.printStackTrace();
                this.stop();
            }
        }
    }

    private SubordinateXAResource initServerXAResource() {
        try {
            SubordinateXAResourceImpl.initializeInstance(this.m_tm);
            this.publishSubXAResource();
        }
        catch (Exception e) {
            ServerMessages.warningServerXAResourceInitFailed(e);
            return null;
        }
        return SubordinateXAResourceImpl.instance();
    }

    void initializeTransactionManager() throws InstantiationException {
        try {
            ServerMessages.infoTransactionManagerStarting();
            this.setTM(new ApplicationServerTransactionManager(this.config.getTransactionManagerConfiguration(), this.defaultApplication.getContext(), this.getClusterID()));
            this.bottomUpCOR = new BottomUpQueryCOR(this.m_tm);
        }
        catch (CoordinatorCreationException e) {
            this.throwInstantiationException(e, "Could not create infrastructure for commit coordinator : ");
        }
        catch (InvalidConfigurationException e) {
            this.throwInstantiationException(e, "Could not create infrastructure for transaction manager events : ");
        }
        ServerMessages.infoTransactionManagerStarted();
    }

    public ApplicationContext getRootContext() {
        return systemApplication.getContext();
    }

    public void setTM(ApplicationServerTransactionManager tm) {
        this.m_tm = tm;
    }

    private final void registerTransactionManagerMBean() throws InstantiationException {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JTAResource mbean = new JTAResource(this.m_tm, "oc4j-tm");
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        catch (MBeanRegistrationException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        catch (InstanceAlreadyExistsException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        catch (InstanceNotFoundException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        catch (NotCompliantMBeanException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        catch (MBeanException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
    }

    private void throwInstantiationException(Throwable t, String message) throws InstantiationException {
        InstantiationException e = new InstantiationException(message + t);
        e.initCause(t);
        throw e;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private void registerSystemMBeans() throws InstantiationException {
        try {
            MBeanServer mbeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (!mbeanServer.isRegistered(Constants.OC4J_UPLOADER_OBJECT_NAME)) {
                Uploader uploader = new Uploader();
                mbeanServer.registerMBean(uploader, Constants.OC4J_UPLOADER_OBJECT_NAME);
            }
            if (!mbeanServer.isRegistered(Constants.OC4J_DEPLOYER_OBJECT_NAME)) {
                OC4JDeployer oc4jDeployer = new OC4JDeployer();
                mbeanServer.registerMBean(oc4jDeployer, Constants.OC4J_DEPLOYER_OBJECT_NAME);
            }
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
        ServerMessages.infoRegisterSystemMBeans();
    }

    private Map getSystemPrintStreams() {
        return systemPrintStreams;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    private void initializeAutoDeployedApplications() throws InstantiationException {
        ServerMessages.infoAppStarting(SYSTEM_APPLICATION_NAME);
        this.initializeSystemApplication();
        ServerMessages.infoAppStarted(SYSTEM_APPLICATION_NAME);
        ServerMessages.infoAppStarting("default");
        this.initializeDefaultApplication();
        ServerMessages.infoAppStarted("default");
    }

    private void initializeSystemApplication() throws InstantiationException {
        systemApplication = new Application(this, null, this.config.getSystemApplicationConfigReference());
        this.initRootApplicationContext();
        systemApplication.setConfig(this.config.getSystemApplicationConfig(), null);
    }

    private void initializeDefaultApplication() throws InstantiationException {
        this.defaultApplication = new Application(this, systemApplication, this.config.getDefaultApplicationConfigReference());
        this.defaultApplication.setConfig(this.config.getDefaultApplicationConfig(), null);
        this.rmiServer.publishServerAdministrator(this);
        if (this.localRmiServer != null) {
            this.localRmiServer.publishServerAdministrator(this);
        }
        this.initServerXAResource();
        this.m_tm.createRecoveryManager(this.m_recoveringTransactionInfo);
        this.registerJNDIMBean(this.defaultApplication);
        this.registerApplicationForJndiReplication(this.defaultApplication);
    }

    private void initializeDeployedApplications() throws InstantiationException {
        ArrayList applicationConfigs = new ArrayList(this.config.getApplicationConfigs());
        for (int i = 0; i < applicationConfigs.size(); ++i) {
            ApplicationConfigReference applicationConfigReference = (ApplicationConfigReference)applicationConfigs.get(i);
            if (!applicationConfigReference.lazyLoading && applicationConfigReference.getConfig() != null) {
                ApplicationConfig applicationConfig = applicationConfigReference.getConfig();
                if (this.applications.keySet().contains(applicationConfigReference.getName())) {
                    ServerMessages.warningDuplicateApplicationError(applicationConfigReference.getName());
                    continue;
                }
                Application parent = applicationConfigReference.getParentName() != null ? this.getApplication(applicationConfigReference.getParentName()) : this.defaultApplication;
                ServerMessages.infoAppStarting(applicationConfigReference.getName());
                Application application = new Application(this, parent, applicationConfigReference);
                try {
                    this.addApplication(applicationConfig, application, null);
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("ApplicationServer: done initializing application: " + applicationConfigReference.getName());
                    }
                }
                catch (InstantiationException e) {
                    ServerMessages.warningApplicationInitializationFailed(application.getName(), e);
                }
                ServerMessages.infoAppStarted(applicationConfigReference.getName());
                continue;
            }
            this.applications.put(applicationConfigReference.getName(), applicationConfigReference);
        }
    }

    private void initRootApplicationContext() throws InstantiationException {
        if (!this.config.useNewJMSServer()) {
            if (this.jmsServer != null) {
                this.jmsServer.bind(systemApplication.getContext());
            }
        } else if (this.jmsServer2 != null) {
            this.jmsServer2.bind(systemApplication.getContext());
        }
    }

    void setupTransactioning() throws InstantiationException {
        if (this.m_tm != null) {
            return;
        }
        this.initializeTransactionManager();
        try {
            this.m_recoveringTransactionInfo = this.m_tm.getRecoveringTransactionInfo();
        }
        catch (Store.StoreException e) {
            this.throwInstantiationException(e, "Can not recover transactions due to error in persistent store : ");
        }
        this.bootstrapContext = new BootstrapContextImpl(this.config, this.m_tm);
    }

    private final void registerJNDIMBean(Application application) throws InstantiationException {
        JNDIResource jndiResourceBean = new JNDIResource(application.getName(), application.getContext());
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        try {
            if (oc4jMBeanServer.isRegistered(jndiResourceBean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(jndiResourceBean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(jndiResourceBean), jndiResourceBean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            this.throwInstantiationException(e, "");
        }
        catch (InstanceNotFoundException e) {
            this.throwInstantiationException(e, "");
        }
        catch (MBeanRegistrationException e) {
            this.throwInstantiationException(e, "");
        }
        catch (InstanceAlreadyExistsException e) {
            this.throwInstantiationException(e, "");
        }
        catch (NotCompliantMBeanException e) {
            this.throwInstantiationException(e, "");
        }
        catch (MBeanException e) {
            this.throwInstantiationException(e, "");
        }
    }

    private void registerApplicationForJndiReplication(Application application) {
        JGroupConfig jgroupConfig;
        if (this.rmiServer.getClusterManager() != null && (jgroupConfig = application.getConfig().getClusterConfig()) != null) {
            JndiNamespaceReplicationService clusterMgr = this.rmiServer.getClusterManager();
            clusterMgr.registerApplication(jgroupConfig.getGroupName(), application);
        }
    }

    private void unRegisterApplicationForJndiReplication(Application application) {
        JGroupConfig jgroupConfig;
        if (this.rmiServer.getClusterManager() != null && (jgroupConfig = application.getConfig().getClusterConfig()) != null) {
            JndiNamespaceReplicationService clusterMgr = this.rmiServer.getClusterManager();
            clusterMgr.unRegisterApplication(jgroupConfig.getGroupName(), application);
        }
    }

    private final void unRegisterJNDIMBean(Application application) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JNDIResource jndiMBean = new JNDIResource(application.getName(), application.getContext());
        try {
            if (oc4jMBeanServer.isRegistered(jndiMBean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(jndiMBean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException e) {
            // empty catch block
        }
    }

    private final void registerJNDINamespaceBean() throws InstantiationException {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JNDINamespace jndiNamespace = new JNDINamespace();
        try {
            if (oc4jMBeanServer.isRegistered(jndiNamespace.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(jndiNamespace.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(jndiNamespace), jndiNamespace.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            this.throwInstantiationException(e, "");
        }
        catch (InstanceNotFoundException e) {
            this.throwInstantiationException(e, "");
        }
        catch (MBeanRegistrationException e) {
            this.throwInstantiationException(e, "");
        }
        catch (MBeanException e) {
            this.throwInstantiationException(e, "");
        }
        catch (InstanceAlreadyExistsException e) {
            this.throwInstantiationException(e, "");
        }
        catch (NotCompliantMBeanException e) {
            this.throwInstantiationException(e, "");
        }
    }

    public void loadApplication(String appName) throws InstantiationException {
        ApplicationConfigReference newRef = this.config.getApplicationConfigReference(appName);
        if (newRef == null) {
            throw new InstantiationException(appName + " does not exist");
        }
        ApplicationConfig newConfig = newRef.getConfig();
        boolean appLoaded = this.applications.containsKey(newRef.getName());
        if (!newRef.lazyLoading && newConfig != null) {
            Application parent = newRef.getParentName() != null ? this.getApplication(newRef.getParentName()) : this.defaultApplication;
            m_logger.log(Level.FINE, "Start loading deployed application: " + newRef.getName());
            Application newApp = new Application(this, parent, newRef);
            this.addApplication(newConfig, newApp, null);
        } else {
            if (appLoaded) {
                this.applications.remove(newRef.getName());
            }
            this.applications.put(newRef.getName(), newRef);
        }
        if (appLoaded) {
            m_logger.log(Level.FINE, "Application " + appName + " reloaded.");
        } else {
            m_logger.log(Level.FINE, "Application " + appName + " loaded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplication(ApplicationConfig applicationConfig, Application application, Notifier notifier) throws InstantiationException {
        if (applicationConfig == null) {
            throw new InstantiationException("Config was null");
        }
        if (application == null) {
            throw new InstantiationException("Application was null");
        }
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                Object previous = this.applications.put(applicationConfig.getName(), application);
                if (previous != null && previous instanceof Application) {
                    ((Application)previous).destroy("Redeployed application");
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
        application.setConfig(applicationConfig, notifier);
        this.registerJNDIMBean(application);
        this.registerApplicationForJndiReplication(application);
    }

    public ThreadPool getThreadPool() {
        return this.systemThreadPool;
    }

    public ThreadPool getConnectionThreadPool() {
        return this.cxThreadPool;
    }

    public ThreadPool getRequestThreadPool() {
        return this.requestThreadPool;
    }

    public ThreadPool getCustomThreadPool(String nm) {
        ApplicationServerThreadPool.Holder holder = (ApplicationServerThreadPool.Holder)this.customThreadPools.get(nm);
        if (holder == null) {
            holder = ApplicationServerThreadPool.createCustomThreadPool(nm);
            if (holder == null) {
                return null;
            }
            this.customThreadPools.put(nm, holder);
        }
        return holder.pool;
    }

    public ThreadPool getRMIRequestThreadPool() {
        return this.rmiRequestThreadPool;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public TransactionManager getTransactionManager() {
        return this.m_tm;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return TransactionSynchronizationRegistryImpl.getInstance();
    }

    static TransactionManager getTM() {
        return ApplicationServer.instance.m_tm;
    }

    public ClassLoader getLibraryClassLoader() {
        return this.libraryClassLoader;
    }

    public User getUser(String username) {
        return systemApplication.getUserManager().getUser(username);
    }

    public User getAdminUser() {
        try {
            return this.config.getSystemApplicationConfig().getUserManager().getAdminUser();
        }
        catch (InstantiationException e) {
            return systemApplication.getUserManager().getAdminUser();
        }
    }

    public User getAnonymousUser() {
        return systemApplication.getUserManager().getAnonymousUser();
    }

    public ThreadGroup getThreadGroup() {
        return this.systemThreadGroup;
    }

    public ThreadGroup getRequestThreadGroup() {
        return this.requestThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String reason) {
        if (!this.alive) {
            return;
        }
        ServerMessages.infoOC4JShutdownStart();
        if (reason.equals(JVM_TERMINATE)) {
            ServerMessages.infoReceivedTerminate();
            m_logger.log(Level.FINE, "OC4J server received CTRL-C");
            System.out.println("Shutting down OC4J...");
        }
        ServerProtocol.SERVER_TERMINATING.fire(this, reason);
        ServerMessages.infoRMIServerStopping();
        this.isInRMIServerShutdownStarted = true;
        if (this.rmiServer != null) {
            this.rmiServer.stop(reason);
        }
        Lock destroyLock = this.getDestroyLock().writeLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                ServerMessages.infoRMIServerStopping();
            }
            if (this.rmiServer != null) {
                this.rmiServer.stop(reason);
            }
            if (!(Thread.currentThread().getContextClassLoader() instanceof ApplicationContextClassLoader)) {
                ApplicationContextClassLoader applicationContextClassLoader = new ApplicationContextClassLoader();
                AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), applicationContextClassLoader));
            }
            if (this.taskManager != null) {
                ServerMessages.infoTaskManagerStopping();
                this.taskManager.stop();
                ServerMessages.infoTaskManagerStopped();
            }
            J2EEServer.notifyServerShutdown();
            if (m_internalSettings != null) {
                ServerExtensionProviderSpec[] specs = m_internalSettings.getServerExtensionSpecs();
                for (int i = 0; i < specs.length; ++i) {
                    try {
                        ServerExtensionProviderSpec spec = specs[i];
                        ServerMessages.infoPreDestroyServerExtensions(spec.getProvider().toString());
                        spec.getProvider().preDestroyApplicationServer(spec.getProperties(), this);
                        continue;
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                }
            }
            if (this.enableServices) {
                ServerMessages.infoContainerServiceStopping();
                ContainerServiceManager.instance().shutdown();
                ServerMessages.infoContainerServiceStopped();
            }
            if (this.m_tm != null) {
                this.m_tm.shutdownRecoverableSinglePhaseResourceReaper();
            }
            Map applicationsClone = this.applications.shallowCopy();
            Set appKeys = applicationsClone.keySet();
            Iterator apps = appKeys.iterator();
            while (apps.hasNext()) {
                String appName = (String)apps.next();
                ApplicationServer.unregisterApplicationMBean(appName);
            }
            if (this.defaultApplication != null) {
                ApplicationServer.unregisterApplicationMBean(this.defaultApplication.getName());
            }
            if (systemApplication != null) {
                ApplicationServer.unregisterApplicationMBean(systemApplication.getName());
            }
            this.shutdownConfigClasses(this.getLibraryClassLoader());
            this.alive = false;
            if (this.httpServer != null) {
                ServerMessages.infoHttpServerStartDestroy();
                this.httpServer.destroy(reason);
                this.httpServer = null;
                ServerMessages.infoHttpServerDestroyComplete();
            }
            this.destroyApplications(reason);
            if (this.rmiServer != null) {
                ServerMessages.infoRMIServerStartDestroy();
                this.rmiServer.destroy(reason);
                this.rmiServer = null;
                ServerMessages.infoRMIServerDestroyComplete();
            }
            if (this.localRmiServer != null) {
                this.localRmiServer.destroy(reason);
                this.localRmiServer = null;
            }
            if (!this.config.useNewJMSServer()) {
                if (this.jmsServer != null) {
                    ServerMessages.infoJMSServerStartDestroy();
                    this.jmsServer.destroy(reason);
                    this.jmsServer = null;
                    ServerMessages.infoJMSServerDestroyComplete();
                }
            } else if (this.jmsServer2 != null) {
                ServerMessages.infoJMSServerStartDestroy();
                this.jmsServer2.destroy(reason);
                this.jmsServer2 = null;
                ServerMessages.infoJMSServerDestroyComplete();
            }
            if (instance == this) {
                this.removeJ2EEServerMBean();
            }
            this.shutdownTransactionManager();
            ServerMessages.infoTMShutDown();
            this.shutdownWorkManager();
            if (this.shutdownHook != null) {
                if (Thread.currentThread() != this.shutdownHook) {
                    try {
                        ApplicationServer.removeShutdownHook(this.shutdownHook);
                    }
                    catch (IllegalStateException e) {
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.shutdownHook = null;
            }
            this.destroyThreadPools();
            super.destroy(reason);
            this.destroyClassLoaders();
            ServerMessages.infoIIOPServerShutdownStart();
            if (m_internalSettings != null) {
                ServerExtensionProviderSpec[] specs = m_internalSettings.getServerExtensionSpecs();
                for (int i = 0; i < specs.length; ++i) {
                    try {
                        ServerExtensionProviderSpec spec = specs[i];
                        spec.getProvider().postDestroyApplicationServer(this, spec.getProperties());
                        continue;
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                }
            }
            ServerMessages.infoIIOPServerShutdownComplete();
            this.resetStaticDataMembers();
            this.destroyBeanRef();
            this.isInRMIServerShutdownStarted = false;
            ServerMessages.infoOC4JShutdownComplete();
            this.destroyBeanRef();
            ServerMessages.infoOC4JShutdownComplete();
        }
        finally {
            destroyLock.unlock();
        }
    }

    public boolean isInRMIServerShutdownStarted() {
        return this.isInRMIServerShutdownStarted;
    }

    private void shutdownWorkManager() {
        WorkManagerImpl workManagerImpl;
        if (this.bootstrapContext != null && (workManagerImpl = (WorkManagerImpl)this.bootstrapContext.getWorkManager()) != null) {
            workManagerImpl.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyBeanRef() {
        try {
            Class<?> beanInfoManager = Class.forName("org.apache.commons.el.BeanInfoManager");
            Field mbeanhashmap = beanInfoManager.getDeclaredField("mBeanInfoManagerByClass");
            mbeanhashmap.setAccessible(true);
            Class<?> clazz = beanInfoManager;
            synchronized (clazz) {
                ((HashMap)mbeanhashmap.get(beanInfoManager)).clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void destroyThreadPools() {
        ServerMessages.infoThreadPoolDestroyStart();
        if (this.cxThreadPool == this.requestThreadPool) {
            this.cxThreadPool = null;
        } else {
            this.cxThreadPool.setThreadGroup(null);
            ServerMessages.infoThreadPoolDestroy("Connection thread pool");
            this.cxThreadPool.destroy();
        }
        if (this.rmiRequestThreadPool == this.requestThreadPool) {
            this.rmiRequestThreadPool = null;
        } else {
            this.rmiRequestThreadPool.setThreadGroup(null);
            ServerMessages.infoThreadPoolDestroy("RMI Request thread pool");
            this.rmiRequestThreadPool.destroy();
        }
        this.requestThreadPool.setThreadGroup(null);
        ServerMessages.infoThreadPoolDestroy("Request thread pool");
        this.requestThreadPool.destroy();
        this.systemThreadPool.setThreadGroup(null);
        ServerMessages.infoThreadPoolDestroy("System thread pool");
        this.systemThreadPool.destroy();
        Iterator it = this.customThreadPools.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ApplicationServerThreadPool.Holder holder = (ApplicationServerThreadPool.Holder)entry.getValue();
            holder.pool.setThreadGroup(null);
            ServerMessages.infoThreadPoolDestroy("Custom thread pool " + (String)entry.getKey());
            holder.pool.destroy();
        }
        ServerMessages.infoThreadPoolDestroyComplete();
    }

    private void resetStaticDataMembers() {
        JMXStateFactoryImpl.clearJMXStateAssociations();
        eventFactory = null;
        nounFactory = null;
        phaseFactory = null;
        sensorFactory = null;
        stateFactory = null;
        _admin = null;
        systemApplication = null;
        instance = null;
    }

    private void destroyApplications(String reason) {
        int noOfApplications = this.applications.values().size();
        Object[] applicationsCopy = this.applications.values().toArray(new Object[noOfApplications]);
        for (int i = 0; i < noOfApplications; ++i) {
            Object object = applicationsCopy[i];
            if (!(object instanceof Application)) continue;
            ServerMessages.infoApplicationStopping(((Application)object).getName());
            ((Application)object).destroy(reason);
            ServerMessages.infoApplicationStopped(((Application)object).getName());
        }
        this.applications = null;
        this.shutdownConfigClasses(null);
        if (this.defaultApplication != null) {
            ServerMessages.infoApplicationStopping("default");
            this.defaultApplication.destroy(reason);
            ServerMessages.infoApplicationStopped("default");
        }
        if (systemApplication != null) {
            ServerMessages.infoApplicationStopping(SYSTEM_APPLICATION_NAME);
            systemApplication.destroy(reason);
            ServerMessages.infoApplicationStopped(SYSTEM_APPLICATION_NAME);
        }
    }

    private void shutdownConfigClasses(ClassLoader classLoader) {
        if (this.config instanceof XMLServerConfig && ((XMLServerConfig)((Object)this.config)).shutdownClasses != null) {
            try {
                RMIServerContext context = this.rmiServer.getServerContext(null, true);
                Iterator it = ((XMLServerConfig)((Object)this.config)).shutdownClasses.iterator();
                while (it.hasNext()) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)it.next();
                    ServerMessages.infoShutdownConfiguredClasses(classDescriptor.mClassName);
                    classDescriptor.executeShutdownClass(context, classLoader);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void shutdownTransactionManager() {
        if (this.m_tm != null) {
            this.m_tm.shutdown();
            this.unregisterTransactionManagerMBean();
        }
    }

    private void unregisterTransactionManagerMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JTAResource mbean = new JTAResource(this.m_tm, "oc4j-tm");
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            // empty catch block
        }
    }

    public UserManager getUserManager() {
        return systemApplication.getUserManager();
    }

    private static void removeShutdownHook(Thread thread) {
        Runtime.getRuntime().removeShutdownHook(thread);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public ApplicationServerConfig getConfig() {
        return this.config;
    }

    private void initializeRMI() throws InstantiationException {
        ServerMessages.infoRMIServerStarting();
        RMIServerConfig rmiConfig = this.config.getRMIServerConfig();
        boolean opmn = ServerProperties.getRunningInIAS();
        if (rmiConfig != null) {
            if (this.rmiServer == null) {
                this.rmiServer = RMIServer.getInstance(this);
            }
            if (opmn && this.localRmiServer == null && !NetUtils.ZERO_ADDRESS.equals(rmiConfig.getAddress())) {
                this.localRmiServer = RMIServer.newLocalServer(this);
            }
        } else {
            if (this.rmiServer != null) {
                this.rmiServer.destroy("Restarting");
                this.rmiServer = null;
            }
            if (this.localRmiServer != null) {
                this.localRmiServer.destroy("Restarting");
                this.localRmiServer = null;
            }
        }
        if (rmiConfig != null) {
            try {
                this.rmiServer.setConfig(rmiConfig);
                if (opmn && this.localRmiServer != null) {
                    this.localRmiServer.setConfig(rmiConfig);
                }
            }
            catch (InstantiationException e) {
                ServerMessages.severeRMIServerStartupException(e);
            }
        }
        ServerMessages.infoRMIServerStarted();
    }

    private void initializeJMS() throws InstantiationException {
        ServerMessages.infoJMSServerStarting();
        JMSServerConfig jmsConfig = this.config.getJMSServerConfig();
        if (jmsConfig != null) {
            if (!this.config.useNewJMSServer() && this.jmsServer == null) {
                this.jmsServer = new JMSServer(this);
            }
            if (this.config.useNewJMSServer() && this.jmsServer2 == null) {
                this.jmsServer2 = new oracle.j2ee.jms.oc4j.v1.JMSServer(this);
            }
        } else {
            if (!this.config.useNewJMSServer() && this.jmsServer != null) {
                this.jmsServer.destroy("Restarting");
                this.jmsServer = null;
            }
            if (this.config.useNewJMSServer() && this.jmsServer2 != null) {
                this.jmsServer2.destroy("Restarting");
                this.jmsServer2 = null;
            }
        }
        if (jmsConfig != null) {
            if (!this.config.useNewJMSServer()) {
                try {
                    this.jmsServer.setConfig(jmsConfig);
                }
                catch (InstantiationException e) {
                    ServerMessages.severeJmsServerStartupException(e.getMessage());
                }
            } else {
                try {
                    this.jmsServer2.setConfig(jmsConfig);
                }
                catch (Exception e) {
                    ServerMessages.severeJmsServerStartupException(e.getMessage());
                }
            }
        }
        ServerMessages.infoJMSServerStarted();
    }

    private void initializeHttp() throws InstantiationException {
        ServerMessages.infoHttpServerStarting();
        HTTPProperties.setAjpConnectionListenerState("undefined");
        HttpServerConfig httpConfig = this.config.getHttpServerConfig();
        if (httpConfig != null) {
            if (this.httpServer == null) {
                this.httpServer = new HttpServer(this);
            }
        } else if (this.httpServer != null) {
            this.httpServer.destroy("Restarting");
            this.httpServer = null;
        }
        if (httpConfig != null) {
            try {
                this.httpServer.setConfig(httpConfig);
                if (HTTPProperties.getAjpConnectionListenerState().equals("undefined")) {
                    HTTPProperties.setAjpConnectionListenerState("down");
                }
            }
            catch (InstantiationException e) {
                ServerMessages.severeHttpStartupException(e.getMessage());
                InstantiationException ie = new InstantiationException("Unable to start HTTP-Server. default-web-site configuration may not be valid.");
                ie.initCause(e);
                throw ie;
            }
        }
        ServerMessages.infoHttpServerStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedCompiler getCompiler() throws InstantiationException {
        Object object = this.compilerLock;
        synchronized (object) {
            if (this.compiler == null) {
                if (CompilerFactory.instance().isConfigured()) {
                    this.compiler = CompilerFactory.instance().create(this.libraryClassLoader);
                } else if (this.config.getCompilerSettings() == null || this.config.getCompilerSettings().get("executable") == null) {
                    this.compiler = new Javac(this.libraryClassLoader);
                } else if (this.config.getCompilerSettings().get("executable") != null) {
                    String executable = (String)this.config.getCompilerSettings().get("executable");
                    if (executable.equals("jcomp")) {
                        try {
                            this.compiler = (LinkedCompiler)Class.forName("com.evermind.compiler.java.CommonCompilerAdapter").newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            throw new InstantiationException("jcomp not installed");
                        }
                        catch (InstantiationException e) {
                            throw new InstantiationException("failed to load jcomp: " + e);
                        }
                        catch (IllegalAccessException e) {
                            throw new InstantiationException("failed to load jcomp: " + e);
                        }
                    } else {
                        this.compiler = new NativeFileLinkedCompiler(executable, (String)this.config.getCompilerSettings().get("classpath"));
                    }
                }
            }
            this.compiler.checkIfValid();
            return this.compiler;
        }
    }

    private void activateSecurityManager() {
        System.setSecurityManager(this.securityManager);
    }

    private void restoreOriginalSecurityManager() {
        System.setSecurityManager(this.originalSecurityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityLayer() {
        ApplicationServerSecurityManager applicationServerSecurityManager = this.securityManager;
        synchronized (applicationServerSecurityManager) {
            ++this.securityLayers;
            if (System.getSecurityManager() == null) {
                this.activateSecurityManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityLayer() {
        ApplicationServerSecurityManager applicationServerSecurityManager = this.securityManager;
        synchronized (applicationServerSecurityManager) {
            if (--this.securityLayers == 0) {
                this.restoreOriginalSecurityManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplication(String name) throws InstantiationException {
        Application systemApp = systemApplication;
        if (systemApp == null) {
            return null;
        }
        if (name.equals(systemApp.getName())) {
            return systemApp;
        }
        if (this.defaultApplication != null && name.equals(this.defaultApplication.getName())) {
            return this.defaultApplication;
        }
        if (this.applications != null) {
            Object object;
            Lock destroyLock = this.getDestroyLock().readLock();
            destroyLock.lock();
            try {
                ApplicationServer applicationServer = this;
                synchronized (applicationServer) {
                    object = this.applications.get(name);
                }
            }
            finally {
                destroyLock.unlock();
            }
            if (object instanceof ApplicationConfigReference) {
                ApplicationConfigReference applicationConfigReference = (ApplicationConfigReference)object;
                ApplicationConfig applicationConfig = applicationConfigReference.getConfig();
                if (applicationConfig == null) {
                    throw new NullPointerException("application reference's config was null");
                }
                Application parent = applicationConfigReference.getParentName() != null ? this.getApplication(applicationConfigReference.getParentName()) : systemApplication;
                Application application = new Application(this, parent, applicationConfigReference);
                try {
                    this.addApplication(applicationConfig, application, null);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Error activating application " + name + ": " + e.getMessage());
                }
                return application;
            }
            return (Application)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCheckForUpdates() {
        m_logger.log(Level.FINE, "Received client request to update configuration");
        if (this.checkForUpdatesMode.equals(UPDATES_NONE)) {
            ServerMessages.infoCheckForUpdatesUsage();
            return;
        }
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            while (DefaultApplicationServerAdministrator.isIASDeploymentTransaction()) {
                try {
                    DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_.wait();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
            this.doCheckForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            if (DefaultApplicationServerAdministrator.isIASDeploymentTransaction()) {
                return;
            }
            this.doCheckForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckForUpdates() {
        Object copyOfComponentsToRefresh;
        block9: {
            copyOfComponentsToRefresh = null;
            ServerProtocol.PRE_CHECK_FOR_UPDATES.fire(this);
            if (this.deploymentLayers <= 0) break block9;
            ServerProtocol.POST_CHECK_FOR_UPDATES.fire(this, copyOfComponentsToRefresh);
            return;
        }
        try {
            Object object = this.checkForUpdatesLock;
            synchronized (object) {
                if (this.componentsToRefresh == null) {
                    this.componentsToRefresh = new ArrayList();
                }
                this.hasChanged(this.componentsToRefresh);
                m_logger.log(Level.FINEST, "Components that need to be refreshed are: " + this.componentsToRefresh);
                Iterator iterator = this.componentsToRefresh.iterator();
                while (iterator.hasNext()) {
                    Refreshable component = (Refreshable)iterator.next();
                    component.refresh();
                }
                copyOfComponentsToRefresh = this.componentsToRefresh.clone();
                if (!this.componentsToRefresh.isEmpty()) {
                    this.componentsToRefresh.clear();
                }
            }
            ServerProtocol.POST_CHECK_FOR_UPDATES.fire(this, copyOfComponentsToRefresh);
        }
        catch (Throwable throwable) {
            ServerProtocol.POST_CHECK_FOR_UPDATES.fire(this, copyOfComponentsToRefresh);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getCallerPrincipal() {
        ThreadState state = ThreadState.getCurrentState();
        User user = state.getUser();
        if (user == null) {
            try {
                if (state.contextContainer != null) {
                    try {
                        Application application = state.contextContainer.getApplication();
                        if (application != null) {
                            user = application.getUserManager().getAnonymousUser();
                        }
                    }
                    catch (NamingException namingException) {
                    }
                }
                Object var5_5 = null;
                if (user == null) {
                    user = systemApplication.getUserManager().getAnonymousUser();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (user == null) {
                    user = systemApplication.getUserManager().getAnonymousUser();
                }
                throw throwable;
            }
        }
        return user;
    }

    public Application getDefaultApplication() {
        return this.defaultApplication;
    }

    public JMSServer getJMSServer() {
        return this.jmsServer;
    }

    public oracle.j2ee.jms.oc4j.v1.JMSServer getNewJMSServer() {
        return this.jmsServer2;
    }

    public void uninstall(Application application, boolean keepWebBindings) throws DeployerException {
        this.uninstall(application, keepWebBindings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall(Application application, boolean keepWebBindings, boolean persistChange) throws DeployerException {
        List webSites;
        m_logger.log(Level.FINE, "Uninstalling application: " + application.getName() + " from the application server");
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                application.removeAppProperties();
                this.unRegisterJNDIMBean(application);
                this.unRegisterApplicationForJndiReplication(application);
                this.applications.remove(application.getName());
                this.config.removeApplication(application.getName());
                if (persistChange) {
                    try {
                        this.config.store();
                    }
                    catch (IOException e) {
                        ServerMessages.warningAppServerConfigUpdateFailed(e);
                    }
                }
                webSites = this.httpServer != null ? this.httpServer.getSites() : new ArrayList();
            }
        }
        finally {
            destroyLock.unlock();
        }
        Iterator iter = webSites.iterator();
        while (iter.hasNext()) {
            HttpSite site = (HttpSite)iter.next();
            site.unBindWebApps(application);
        }
        application.undeployCleanUp();
        application.destroy("Uninstalled");
        this.broadcastEvent(1, application.getName());
    }

    public RMIServer getRMIServer() {
        return this.rmiServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getApplicationNames() {
        NotifyingMap notifyingMap = this.applications;
        synchronized (notifyingMap) {
            return new HashSet(this.applications.keySet());
        }
    }

    public String getHomeDirectoryPath() {
        return ClassLoaderQuery.getHomeDirectory().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream pushSystemStream(PrintStream newStream) {
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                PrintStream printStream = this.getSystemPrintStreams().put(Thread.currentThread(), newStream);
                return printStream;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popSystemStream(PrintStream stream) {
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                if (stream == null) {
                    this.getSystemPrintStreams().remove(Thread.currentThread());
                } else {
                    this.getSystemPrintStreams().put(Thread.currentThread(), stream);
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public void enterDeploymentArea() {
        ++this.deploymentLayers;
    }

    public void exitDeploymentArea() {
        --this.deploymentLayers;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public static boolean isServerEnvironment() {
        return instance != null;
    }

    public static PrintStream getCoreOut() {
        return coreOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applicationExists(String name) throws InstantiationException {
        ApplicationServerConfig applicationServerConfig = this.config;
        synchronized (applicationServerConfig) {
            List configs = this.config.getApplicationConfigs();
            for (int i = 0; i < configs.size(); ++i) {
                if (!((ApplicationConfigReference)configs.get(i)).getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static int getDMSMetricsLevel() {
        int sensorLevel;
        block9: {
            sensorLevel = 5;
            String sensorString = ServerProperties.getOracleDmsSensors();
            if (sensorString != null) {
                try {
                    sensorLevel = Integer.parseInt(sensorString);
                }
                catch (Exception e) {
                    if (sensorString.equalsIgnoreCase("ALL")) {
                        sensorLevel = Integer.MAX_VALUE;
                        break block9;
                    }
                    if (sensorString.equalsIgnoreCase("NONE")) {
                        sensorLevel = 0;
                        if (!DMSConsole.setSensorWeightOff()) {
                            System.out.println("unable to set DMS level to NONE");
                        }
                        break block9;
                    }
                    if (sensorString.equalsIgnoreCase("NORMAL")) {
                        sensorLevel = 5;
                        break block9;
                    }
                    if (sensorString.equalsIgnoreCase("HEAVY")) {
                        sensorLevel = 10;
                        break block9;
                    }
                    System.out.println("oracle.dms.sensors property must be set to an integer or 'none', 'normal', 'heavy', or 'all'. ");
                    System.out.println("Setting to 'normal' by default.");
                    System.setProperty(DMS_SENSORS_KEY, String.valueOf(sensorLevel));
                }
            } else {
                System.setProperty(DMS_SENSORS_KEY, String.valueOf(sensorLevel));
            }
        }
        return sensorLevel;
    }

    public static void initConsole() throws Exception {
        if (DMS_GATE) {
            Class<?> clazz;
            String clazzname = ServerProperties.getOracleDmsConsoleDMSConsole();
            try {
                clazz = Class.forName(clazzname);
                if (clazz != null) {
                    dmsConsole = (oracle.dms.console.DMSConsole)clazz.newInstance();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (dmsConsole == null && (clazz = Class.forName("oracle.dms.instrument_stub.DMSConsole")) != null) {
                dmsConsole = (oracle.dms.console.DMSConsole)clazz.newInstance();
            }
            if (dmsConsole != null) {
                dmsConsole.init("OC4J");
            }
        }
    }

    public static EventFactoryIntf eventFactory() {
        if (!DMS_GATE) {
            return eventFactory;
        }
        if (eventFactory == null) {
            eventFactory = dmsConsole.getEventFactory();
        }
        return eventFactory;
    }

    public static NounFactoryIntf nounFactory() {
        if (!DMS_GATE) {
            return nounFactory;
        }
        if (nounFactory == null && dmsConsole != null) {
            nounFactory = dmsConsole.getNounFactory();
        }
        return nounFactory;
    }

    public static PhaseEventFactoryIntf phaseEventFactory() {
        if (!DMS_GATE) {
            return phaseFactory;
        }
        if (phaseFactory == null) {
            phaseFactory = dmsConsole.getPhaseEventFactory();
        }
        return phaseFactory;
    }

    public static StateFactoryIntf stateFactory() {
        if (!DMS_GATE) {
            return stateFactory;
        }
        if (stateFactory == null) {
            stateFactory = dmsConsole.getStateFactory();
        }
        return stateFactory;
    }

    public Map getAttributes() {
        Map attributes = super.getAttributes();
        if (attributes.isEmpty()) {
            attributes.put("threadPool", this.getThreadPool());
        }
        return attributes;
    }

    public RMIServer getLocalRmiServer() {
        return this.localRmiServer;
    }

    public static String getEjbSecPropPath() {
        return ejbSecPropPath;
    }

    public final void notifyRemove(CollectionModificationEvent event) {
        String name = (String)event.getKey();
        if (name != null) {
            ApplicationServer.unregisterApplicationMBean(name);
        }
    }

    public final void notifyAdd(CollectionModificationEvent event) {
    }

    public final void start() {
        User user = ThreadState.getCurrentState().getUser();
        InetAddress address = ThreadState.getCurrentState().getInetAddress();
        String reason = "Restart executed by " + (user == null ? "<unknown administrator>" : user.getName()) + (address == null ? "" : " from " + address.getHostAddress() + " (" + address.getHostName() + ")");
        System.out.println("Restarting... ");
        this.restartThread.setContextClassLoader((ClassLoader)ClassLoaderQuery.getMainLoader());
        this.restartThread.start();
    }

    private void initRestartHandler() {
        String reason = "Restarting";
        ApplicationServerShutdownHandler restartHandler = new ApplicationServerShutdownHandler(this, true, false, reason);
        this.restartThread = new Thread((Runnable)restartHandler, "restartThread");
    }

    public final void stop() {
        User user = ThreadState.getCurrentState().getUser();
        InetAddress address = ThreadState.getCurrentState().getInetAddress();
        String reason = "Shutdown executed by " + (user == null ? "<unknown administrator>" : user.getName()) + (address == null ? "" : " from " + address.getHostAddress() + " (" + address.getHostName() + ")");
        System.out.println("Shutting down OC4J...");
        ApplicationServerShutdownHandler stopHandler = new ApplicationServerShutdownHandler(this, false, true, reason);
        ApplicationServerThread t = new ApplicationServerThread(null, (Runnable)stopHandler, "stopThread", 0L);
        t.setPriority(10);
        t.start();
    }

    public void stop(Map params) {
        m_logger.log(Level.WARNING, "Unsuported operation stop(Map params). Defaulting to supported stop operation.");
        this.stop();
    }

    public final void startRecursive() {
        this.start();
    }

    public final long getstartTime() {
        return startTime;
    }

    public final int getstate() {
        return 1;
    }

    public final ObjectName getdefaultApplication() {
        if (this.defaultApplication == null || this.defaultApplication.getName() == null) {
            return null;
        }
        String name = this.defaultApplication.getName();
        return ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + name + ",J2EEServer=" + "standalone"));
    }

    public final ObjectName getsystemApplication() {
        if (systemApplication == null || systemApplication.getName() == null) {
            return null;
        }
        String name = systemApplication.getName();
        return ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + name + ",J2EEServer=" + "standalone"));
    }

    private final void addJ2EEServerMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        J2EEServer mbean = new J2EEServer(this);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException(e.getMessage());
        }
    }

    private final void removeJ2EEServerMBean() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            J2EEServer mbean = new J2EEServer(this);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void addJVMMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JVM mbean = new JVM(this);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeJVMMBean();
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void removeJVMMBean() {
        try {
            JVM mbean = new JVM((JVMCallBackIf)null);
            ObjectName jvmName = mbean.getObjectName();
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (oc4jMBeanServer.isRegistered(jvmName)) {
                oc4jMBeanServer.unregisterMBean(jvmName);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getRMIPort() {
        if (this.rmiServer != null && this.rmiServer.getConfig() != null) {
            return this.rmiServer.getConfig().getPort();
        }
        return 0;
    }

    public InetAddress getRmiServerAddress() throws UnknownHostException, SecurityException {
        if (this.rmiServer != null && this.rmiServer.getConfig() != null && this.rmiServer.getConfig().getAddress() != null && !NetUtils.ZERO_ADDRESS.equals(this.rmiServer.getConfig().getAddress())) {
            return this.rmiServer.getConfig().getAddress();
        }
        return InetAddress.getLocalHost();
    }

    public int getrmisPort() {
        if (this.rmiServer != null && this.rmiServer.getConfig() != null) {
            return this.rmiServer.getConfig().getSslPort();
        }
        return 0;
    }

    public boolean isReady() {
        return this.ready_;
    }

    public String getApplicationDirectory() throws IOException {
        return this.config.getApplicationDirectory();
    }

    public Object getGlobalTldCache() {
        return this._globalTldCache;
    }

    public void buildGlobalTldCache(JspInterface ojsp, int jspTldCacheLevel, String realPath) {
        VersionNumber version = new VersionNumber("1.0");
        PolicyClassLoader loader = ClassLoaderQuery.findSharedLoader((String)"global.tag.libraries", (VersionNumber)version, (VersionNumber)version);
        URL persistenceURL = this.getConfig().getURL();
        String temp = persistenceURL.getPath().substring(0, persistenceURL.getPath().lastIndexOf("/") + 1) + "../";
        try {
            String globalTagLibLocations = null;
            HttpApplicationConfigContext globalApplicationConfigContext = this.httpServer.getConfig().getDefaultHttpApplicationConfig();
            if (globalApplicationConfigContext != null) {
                globalTagLibLocations = globalApplicationConfigContext.getConfiguration().getTaglibLocations();
            }
            this._globalTldCache = ojsp.getGlobalTldCacheInstance(realPath, (ClassLoader)loader, this.getVerbosityLevel(), globalTagLibLocations, temp.replace('/', File.separatorChar), jspTldCacheLevel);
        }
        catch (Throwable t) {
            ServerMessages.warningGlobalTldCacheBuildFailure(temp, t);
        }
    }

    public static ApplicationServer getInstance() {
        OC4JSecurity.assertIsSafe();
        return instance;
    }

    private void initTransportManagers() throws InstantiationException {
        m_logger.finest("Initializing transport managers");
        try {
            RMIServerConfig rmiServerConfig = this.config.getRMIServerConfig() != null ? this.config.getRMIServerConfig() : new NullRmiServerConfig("localhost", 23791);
            TransportManager.initialize(new OrmiTransportManager(rmiServerConfig));
        }
        catch (UnknownHostException e) {
            throw new InstantiationException("Unable to initialize transport managers: " + e);
        }
    }

    private void initJMX() {
        m_logger.finest("Initializing JMX subsystem.");
        this.addJ2EEServerMBean();
        this.addJVMMBean();
    }

    private static synchronized void initSystemProperties() {
        try {
            Properties existing = System.getProperties();
            if (!(existing instanceof ApplicationServerSystemProperties)) {
                ApplicationServerSystemProperties serverProperties = new ApplicationServerSystemProperties();
                serverProperties.putAll(existing);
                System.setProperties(serverProperties);
            }
            if (ServerProperties.getApplicationServerDebug()) {
                m_logger.setLevel(Level.FINE);
            }
        }
        catch (SecurityException e) {
            m_logger.log(Level.WARNING, "Caught security exception while setting System properties." + e);
        }
    }

    private static void defineInitialContextFactory(Class initialContextFactoryClass) {
        System.setProperty("java.naming.factory.initial", initialContextFactoryClass.getName());
    }

    public void installSharedLibrary(DataSink input, String name, String version, String codeSource) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        if (version == null || version.length() == 0) {
            throw new IOException("version cannot be empty");
        }
        if (codeSource == null || codeSource.length() == 0) {
            throw new IOException("codeSource cannot be empty");
        }
        File dest = new File(new File(new File(((XMLApplicationServerConfig)this.getConfig()).getSharedLibrariesDirectory(), name), version), codeSource);
        if (!dest.exists()) {
            FileUtils.createNewFileRecursive(dest, new HashMap());
        }
        input.copyOrMoveTo(dest);
    }

    public boolean recoverBottomUp() {
        return this.bottomUpCOR.isEmpty();
    }

    public BottomUpQueryCOR getBottomUpCOR() {
        return this.bottomUpCOR;
    }

    public InstalledLibrary[] getInstalledLibraries() throws IOException {
        ArrayList<InstalledLibrary> retList = new ArrayList<InstalledLibrary>();
        InstalledLibrary[] retVal = null;
        File shLibDir = new File(((XMLApplicationServerConfig)this.getConfig()).getSharedLibrariesDirectory());
        File[] nameDirs = FileUtils.listDirectoriesOnly(shLibDir);
        if (nameDirs != null) {
            for (int n = 0; n < nameDirs.length; ++n) {
                File[] versionDirs = FileUtils.listDirectoriesOnly(nameDirs[n]);
                if (versionDirs == null) continue;
                for (int v = 0; v < versionDirs.length; ++v) {
                    CodeSource[] codeSources = null;
                    File[] codeSourceFiles = FileUtils.listFilesOnly(versionDirs[v]);
                    if (codeSourceFiles == null) {
                        codeSources = new CodeSource[]{};
                    } else {
                        codeSources = new CodeSource[codeSourceFiles.length];
                        for (int cs = 0; cs < codeSourceFiles.length; ++cs) {
                            codeSources[cs] = new CodeSource(codeSourceFiles[cs].getName());
                        }
                    }
                    InstalledLibrary lib = new InstalledLibrary(nameDirs[n].getName(), versionDirs[v].getName(), codeSources);
                    retList.add(lib);
                }
            }
        }
        retVal = retList.toArray(new InstalledLibrary[0]);
        return retVal;
    }

    public String[] getInstalledLibraryNames() throws IOException {
        File shLibDir = new File(((XMLApplicationServerConfig)this.getConfig()).getSharedLibrariesDirectory());
        File[] nameDirs = FileUtils.listDirectoriesOnly(shLibDir);
        if (nameDirs == null) {
            return new String[0];
        }
        String[] retNames = new String[nameDirs.length];
        for (int n = 0; n < nameDirs.length; ++n) {
            retNames[n] = new String(nameDirs[n].getName());
        }
        return retNames;
    }

    public String[] getInstalledLibraryVersions(String libraryName) throws IOException {
        File shLibDir = new File(((XMLApplicationServerConfig)this.getConfig()).getSharedLibrariesDirectory());
        File[] nameDirs = FileUtils.listDirectoriesOnly(shLibDir);
        if (nameDirs != null) {
            for (int n = 0; n < nameDirs.length; ++n) {
                if (!nameDirs[n].getName().equals(libraryName)) continue;
                File[] versionDirs = FileUtils.listDirectoriesOnly(nameDirs[n]);
                if (versionDirs == null) {
                    return new String[0];
                }
                String[] retVersions = new String[versionDirs.length];
                for (int v = 0; v < versionDirs.length; ++v) {
                    retVersions[v] = new String(versionDirs[v].getName());
                }
                return retVersions;
            }
        }
        return new String[0];
    }

    public String[] getInstalledLibraryCodeSources(String libraryName, String libraryVersion) throws IOException {
        File shLibDir = new File(((XMLApplicationServerConfig)this.getConfig()).getSharedLibrariesDirectory());
        File[] nameDirs = FileUtils.listDirectoriesOnly(shLibDir);
        if (nameDirs == null) {
            return new String[0];
        }
        for (int n = 0; n < nameDirs.length; ++n) {
            File[] versionDirs;
            if (!nameDirs[n].getName().equals(libraryName) || (versionDirs = FileUtils.listDirectoriesOnly(nameDirs[n])) == null) continue;
            for (int v = 0; v < versionDirs.length; ++v) {
                if (!versionDirs[v].getName().equals(libraryVersion)) continue;
                String[] retCodeSources = null;
                File[] codeSourceFiles = FileUtils.listFilesOnly(versionDirs[v]);
                if (codeSourceFiles == null) {
                    retCodeSources = new String[]{};
                } else {
                    retCodeSources = new String[codeSourceFiles.length];
                    for (int cs = 0; cs < codeSourceFiles.length; ++cs) {
                        retCodeSources[cs] = new String(codeSourceFiles[cs].getName());
                    }
                }
                return retCodeSources;
            }
        }
        return new String[0];
    }

    public SharedLibrary[] getSharedLibraries() {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] bootList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (bootList == null) {
            bootList = new PolicyClassLoader[]{};
        }
        SharedLibrary[] retList = new SharedLibrary[configList.size() + bootList.length];
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            List configCodeSources = configSharedLibrary.getCodeSources();
            CodeSource[] retCodeSources = new CodeSource[configCodeSources.size()];
            for (int codeSource = 0; codeSource < configCodeSources.size(); ++codeSource) {
                CodeSourceElement configCodeSource = (CodeSourceElement)configCodeSources.get(codeSource);
                retCodeSources[codeSource] = new CodeSource(configCodeSource.getPath());
            }
            List configImports = configSharedLibrary.getImports();
            ImportSharedLibrary[] retImports = new ImportSharedLibrary[configImports.size()];
            for (int imprt = 0; imprt < configImports.size(); ++imprt) {
                ImportSharedLibraryElement configImport = (ImportSharedLibraryElement)configImports.get(imprt);
                retImports[imprt] = new ImportSharedLibrary(configImport.getName(), configImport.getMinVersion(), configImport.getMaxVersion());
            }
            retList[lib] = new SharedLibrary(configSharedLibrary.getName(), configSharedLibrary.getVersion(), configSharedLibrary.getParentName(), configSharedLibrary.getParentVersion(), retCodeSources, retImports, true, configSharedLibrary.isInstantiated(), configSharedLibrary.isLibraryCompatible());
        }
        for (lib = 0; lib < bootList.length; ++lib) {
            SharedCodeSource[] codeSources = bootList[lib].getCodeSources(true);
            CodeSource[] retCodeSources = null;
            retCodeSources = codeSources != null ? new CodeSource[codeSources.length] : new CodeSource[]{};
            for (int codeSource = 0; codeSource < retCodeSources.length; ++codeSource) {
                retCodeSources[codeSource] = new CodeSource(codeSources[codeSource].getLocation().getPath());
            }
            PolicyClassLoader[] imports = bootList[lib].getImports();
            ImportSharedLibrary[] retImports = null;
            retImports = imports != null ? new ImportSharedLibrary[imports.length] : new ImportSharedLibrary[]{};
            for (int imprt = 0; imprt < retImports.length; ++imprt) {
                retImports[imprt] = new ImportSharedLibrary(imports[imprt].getName(), imports[imprt].getVersionNumber().toString(), imports[imprt].getVersionNumber().toString());
            }
            String parentName = null;
            String parentVersion = null;
            PolicyClassLoader parent = bootList[lib].parent();
            if (parent != null) {
                parentName = parent.getName();
                parentVersion = parent.getVersionNumber().toString();
            }
            retList[configList.size() + lib] = new SharedLibrary(bootList[lib].getName(), bootList[lib].getVersionNumber().toString(), parentName, parentVersion, retCodeSources, retImports, false, true, true);
        }
        return retList;
    }

    public void removeSharedLibrary(String libraryName, String libraryVersion) throws InstantiationException {
        VersionNumber vn = new VersionNumber(libraryVersion);
        PolicyClassLoader loader = ClassLoaderQuery.findLoader((String)libraryName, (VersionNumber)vn, (VersionNumber)vn);
        if (loader != null) {
            if (loader.isSystemLoader()) {
                throw new InstantiationException("Shared Library " + libraryName + " " + libraryVersion + " cannot be removed");
            }
            if (loader.getSubscribers().getCount() > 0) {
                throw new InstantiationException("Shared Library " + libraryName + " " + libraryVersion + " is in use");
            }
            loader.close();
        }
        this.config.removeSharedLibrary(libraryName, libraryVersion);
    }

    public void addSharedLibrary(String libraryName, String libraryVersion, String parentName, String parentVersion) throws InstantiationException {
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library already exists");
        }
        this.config.addSharedLibrary(libraryName, libraryVersion, parentName, parentVersion);
    }

    public void publishSharedLibrary(String libraryName, String libraryVersion, String parentName, String parentVersion, Boolean libraryCompatible, String[] codeSources, ImportSharedLibrary[] imports) throws InstantiationException {
        if (parentName != null && parentName.length() == 0) {
            parentName = null;
        }
        if (parentVersion != null && parentVersion.length() == 0) {
            parentVersion = null;
        }
        this.addSharedLibrary(libraryName, libraryVersion, parentName, parentVersion);
        if (libraryCompatible != null) {
            this.setSharedLibraryLibraryCompatible(libraryName, libraryVersion, libraryCompatible);
        }
        String[] interpretedCodeSources = this.interpretCodeSourcePaths(codeSources);
        try {
            int i;
            if (interpretedCodeSources != null) {
                for (i = 0; i < interpretedCodeSources.length; ++i) {
                    this.addSharedLibraryCodeSource(libraryName, libraryVersion, interpretedCodeSources[i]);
                }
            }
            if (imports != null) {
                for (i = 0; i < imports.length; ++i) {
                    this.addSharedLibraryImport(libraryName, libraryVersion, imports[i].getName(), imports[i].getMinVersion(), imports[i].getMaxVersion());
                }
            }
        }
        catch (Exception ex) {
            this.removeSharedLibrary(libraryName, libraryVersion);
            InstantiationException ie = new InstantiationException(ex.getMessage());
            ie.initCause(ex);
            throw ie;
        }
        try {
            this.instantiateSharedLibrary(libraryName, libraryVersion);
        }
        catch (Exception ex) {
            this.removeSharedLibrary(libraryName, libraryVersion);
            InstantiationException ie = new InstantiationException(ex.getMessage());
            ie.initCause(ex);
            throw ie;
        }
        try {
            this.persistConfigChange();
        }
        catch (IOException ioe) {
            this.removeSharedLibrary(libraryName, libraryVersion);
            InstantiationException ie = new InstantiationException("Error persisting shared library config");
            ie.initCause(ioe);
            throw ie;
        }
        catch (Exception ex) {
            this.removeSharedLibrary(libraryName, libraryVersion);
            InstantiationException ie = new InstantiationException("Error persisting shared library");
            ie.initCause(ex);
            throw ie;
        }
    }

    public boolean modifySharedLibrary(String libraryName, String libraryVersion, Boolean libraryCompatible, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws InstantiationException {
        String[] codeSourcePaths = this.interpretCodeSourcePaths(addCodeSources);
        this.config.modifySharedLibrary(libraryName, libraryVersion, libraryCompatible, codeSourcePaths, removeCodeSources, addImports, removeImports);
        return this.instantiateSharedLibrary(libraryName, libraryVersion);
    }

    private String[] interpretCodeSourcePaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        String[] newPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String acs = paths[i];
            if (CodeSource.isUploadedLib((String)acs)) {
                acs = CodeSource.removeUploadedMark((String)acs);
            } else if (!new File(acs).isAbsolute()) {
                String oh = OC4JRuntimeProperties.getOracleHome();
                if (!oh.endsWith(File.separator)) {
                    oh = oh + File.separator;
                }
                acs = oh + acs;
            }
            newPaths[i] = acs;
        }
        return newPaths;
    }

    public void removeSharedLibraryCodeSource(String libraryName, String libraryVersion, String path) throws InstantiationException {
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library is not modifiable");
        }
        this.config.removeSharedLibraryCodeSource(libraryName, libraryVersion, path);
    }

    public void addSharedLibraryCodeSource(String libraryName, String libraryVersion, String path) throws InstantiationException {
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library is not modifiable");
        }
        this.config.addSharedLibraryCodeSource(libraryName, libraryVersion, path);
    }

    public void removeSharedLibraryImport(String libraryName, String libraryVersion, String name) throws InstantiationException {
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library is not modifiable");
        }
        this.config.removeSharedLibraryImport(libraryName, libraryVersion, name);
    }

    public void addSharedLibraryImport(String libraryName, String libraryVersion, String name, String minVersion, String maxVersion) throws InstantiationException {
        if (ClassLoaderQuery.isSystemSharedLoader((String)libraryName, (String)libraryVersion)) {
            throw new InstantiationException("Shared Library is not modifiable");
        }
        this.config.addSharedLibraryImport(libraryName, libraryVersion, name, minVersion, maxVersion);
    }

    public String[] getSharedLibraryNames() {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] bootList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (bootList == null) {
            bootList = new PolicyClassLoader[]{};
        }
        ArrayList<String> retList = new ArrayList<String>();
        String[] retVal = null;
        for (lib = 0; lib < bootList.length; ++lib) {
            retList.add(bootList[lib].getName());
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            String name = configSharedLibrary.getName();
            if (retList.contains(name)) continue;
            retList.add(configSharedLibrary.getName());
        }
        retVal = retList.toArray(new String[0]);
        return retVal;
    }

    public String[] getSharedLibraryVersions(String libraryName) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] bootList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (bootList == null) {
            bootList = new PolicyClassLoader[]{};
        }
        ArrayList<String> retList = new ArrayList<String>();
        String[] retVal = null;
        for (lib = 0; lib < bootList.length; ++lib) {
            if (!bootList[lib].getName().equals(libraryName)) continue;
            retList.add(bootList[lib].getVersionNumber().toString());
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            String name = configSharedLibrary.getName();
            if (!name.equals(libraryName)) continue;
            retList.add(configSharedLibrary.getVersion());
        }
        retVal = retList.toArray(new String[0]);
        return retVal;
    }

    public String[] getSharedLibraryCodeSourcePaths(String libraryName, String libraryVersion) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        ArrayList<String> retList = new ArrayList<String>();
        String[] retVal = null;
        for (lib = 0; lib < systemList.length; ++lib) {
            SharedCodeSource[] codeSources;
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion) || (codeSources = systemList[lib].getCodeSources(true)) == null) continue;
            for (int codeSource = 0; codeSource < codeSources.length; ++codeSource) {
                retList.add(codeSources[codeSource].getLocation().getPath());
            }
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            List configCodeSources = configSharedLibrary.getCodeSources();
            for (int codeSource = 0; codeSource < configCodeSources.size(); ++codeSource) {
                CodeSourceElement configCodeSource = (CodeSourceElement)configCodeSources.get(codeSource);
                String path = configCodeSource.getPath();
                if (retList.contains(path)) continue;
                retList.add(path);
            }
        }
        retVal = retList.toArray(new String[0]);
        return retVal;
    }

    public String[] getSharedLibraryImportNames(String libraryName, String libraryVersion) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        ArrayList<String> retList = new ArrayList<String>();
        String[] retVal = null;
        for (lib = 0; lib < systemList.length; ++lib) {
            PolicyClassLoader[] imports;
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion) || (imports = systemList[lib].getImports()) == null) continue;
            for (int imprt = 0; imprt < imports.length; ++imprt) {
                retList.add(imports[imprt].getName());
            }
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            List configImports = configSharedLibrary.getImports();
            for (int imprt = 0; imprt < configImports.size(); ++imprt) {
                ImportSharedLibraryElement configImport = (ImportSharedLibraryElement)configImports.get(imprt);
                String name = configImport.getName();
                if (retList.contains(name)) continue;
                retList.add(name);
            }
        }
        retVal = retList.toArray(new String[0]);
        return retVal;
    }

    public String getSharedLibraryImportMinVersion(String libraryName, String libraryVersion, String importName) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        for (lib = 0; lib < systemList.length; ++lib) {
            PolicyClassLoader[] imports;
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion) || (imports = systemList[lib].getImports()) == null) continue;
            for (int imprt = 0; imprt < imports.length; ++imprt) {
                if (!imports[imprt].getName().equals(importName)) continue;
                return imports[imprt].getVersionNumber().toString();
            }
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            List configImports = configSharedLibrary.getImports();
            for (int imprt = 0; imprt < configImports.size(); ++imprt) {
                ImportSharedLibraryElement configImport = (ImportSharedLibraryElement)configImports.get(imprt);
                String name = configImport.getName();
                if (!name.equals(importName)) continue;
                return configImport.getMinVersion();
            }
        }
        return null;
    }

    public String getSharedLibraryImportMaxVersion(String libraryName, String libraryVersion, String importName) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        for (lib = 0; lib < systemList.length; ++lib) {
            PolicyClassLoader[] imports;
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion) || (imports = systemList[lib].getImports()) == null) continue;
            for (int imprt = 0; imprt < imports.length; ++imprt) {
                if (!imports[imprt].getName().equals(importName)) continue;
                return imports[imprt].getVersionNumber().toString();
            }
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            List configImports = configSharedLibrary.getImports();
            for (int imprt = 0; imprt < configImports.size(); ++imprt) {
                ImportSharedLibraryElement configImport = (ImportSharedLibraryElement)configImports.get(imprt);
                String name = configImport.getName();
                if (!name.equals(importName)) continue;
                return configImport.getMaxVersion();
            }
        }
        return null;
    }

    public boolean isSharedLibraryInstantiated(String libraryName, String libraryVersion) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        for (lib = 0; lib < systemList.length; ++lib) {
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion)) continue;
            return true;
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            return configSharedLibrary.isInstantiated();
        }
        return false;
    }

    public boolean isSharedLibraryLibraryCompatible(String libraryName, String libraryVersion) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        for (lib = 0; lib < systemList.length; ++lib) {
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion)) continue;
            return true;
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            return configSharedLibrary.isLibraryCompatible();
        }
        return false;
    }

    public void setSharedLibraryLibraryCompatible(String libraryName, String libraryVersion, boolean compatible) {
        int lib;
        List configList = this.config.getSharedLibraries();
        PolicyClassLoader[] systemList = ClassLoaderQuery.getSystemSharedLoaders((boolean)false);
        if (systemList == null) {
            systemList = new PolicyClassLoader[]{};
        }
        for (lib = 0; lib < systemList.length; ++lib) {
            if (!systemList[lib].getName().equals(libraryName) || !systemList[lib].getVersionNumber().toString().equals(libraryVersion)) continue;
            return;
        }
        for (lib = 0; lib < configList.size(); ++lib) {
            SharedLibraryElement configSharedLibrary = (SharedLibraryElement)configList.get(lib);
            if (!configSharedLibrary.getName().equals(libraryName) || !configSharedLibrary.getVersion().equals(libraryVersion)) continue;
            configSharedLibrary.setLibraryCompatible(compatible);
            return;
        }
    }

    private static void doInstall(CommandLineArgs cmdLineConf) {
        System.out.println("This option has been deprecated. \nPlease start the OC4J server to set the administrator's password. If the OC4J administrator account has already been activated, use the Application Server Control Console or the Admintool to change the password for this account.");
    }

    private static void unregisterApplicationMBean(String appName) {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            J2EEApplication mbean = new J2EEApplication(null, appName);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
                ObjectName app = mbean.getObjectName();
                String name = app.getKeyProperty("name");
                String j2eeServerName = app.getKeyProperty("J2EEServer");
                ObjectName childPattern = new ObjectName(app.getDomain() + ":J2EEApplication=" + name + ",J2EEServer=" + j2eeServerName + ",*");
                Set<ObjectName> childs = oc4jMBeanServer.queryNames(childPattern, null);
                Iterator<ObjectName> iter = childs.iterator();
                while (iter.hasNext()) {
                    try {
                        oc4jMBeanServer.unregisterMBean(iter.next());
                    }
                    catch (InstanceNotFoundException e) {}
                }
                ObjectName userMBeanPattern = new ObjectName(appName + ":*");
                Set<ObjectName> userMBeans = oc4jMBeanServer.queryNames(userMBeanPattern, null);
                iter = userMBeans.iterator();
                while (iter.hasNext()) {
                    try {
                        oc4jMBeanServer.unregisterMBean(iter.next());
                    }
                    catch (InstanceNotFoundException e) {}
                }
                J2EEServer.notifyApplicationRemoved(appName);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getApplications(ErrorHandler errorHandler) throws InstantiationException {
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                Iterator iterator = this.applications.keySet().iterator();
                HashMap<String, Object> response = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    try {
                        response.put(name, this.getApplication(name));
                    }
                    catch (InstantiationException e) {
                        if (errorHandler != null) {
                            try {
                                if (!errorHandler.handleEvent(e.getMessage(), 2)) {
                                    throw e;
                                }
                                response.put(name, e.getMessage());
                                continue;
                            }
                            catch (RemoteException re) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
                HashMap<String, Object> hashMap = response;
                return hashMap;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public String getDefaultRoutingId() {
        if (OC4JServer.getOPMNEnabled()) {
            return OC4JMonitorThread.getDefaultRoutingId();
        }
        return null;
    }

    public void setDefaultRoutingId(String rid) {
        if (OC4JServer.getOPMNEnabled()) {
            OC4JMonitorThread.setDefaultRoutingId(rid);
        }
    }

    public synchronized void purgeApplicationEntry(Application application) {
        if (application != null && this.applications != null) {
            String name = application.getName();
            this.applications.remove(name);
        }
    }

    public void hasChanged(List componentsToRefresh) {
        if (this.config.isUpdated()) {
            componentsToRefresh.add(this);
            return;
        }
        if (!this.config.useNewJMSServer()) {
            this.jmsServer.hasChanged(componentsToRefresh);
        } else {
            this.jmsServer2.hasChanged(componentsToRefresh);
        }
        this.httpServer.hasChanged(componentsToRefresh);
        this.defaultApplication.hasChanged(componentsToRefresh);
        if (componentsToRefresh.contains(this.defaultApplication)) {
            return;
        }
        ArrayList applicationsList = null;
        boolean obtainedValidApplicationsList = false;
        while (!obtainedValidApplicationsList) {
            try {
                applicationsList = new ArrayList(this.applications.values());
                obtainedValidApplicationsList = true;
            }
            catch (ConcurrentModificationException e) {}
        }
        Iterator iterator = applicationsList.iterator();
        while (iterator.hasNext()) {
            Application app = (Application)iterator.next();
            app.hasChanged(componentsToRefresh);
        }
    }

    public void refresh() {
        String reason = "change in server.xml. Reinitializing server";
        m_logger.log(Level.FINE, "Detected change in server's configuration. Restarting the server.");
        ThreadState threadStateOfThreadCallingRestart = ThreadState.getCurrentState();
        ApplicationServerShutdownHandler restartHandle = new ApplicationServerShutdownHandler(this, true, false, reason, threadStateOfThreadCallingRestart);
        ApplicationServerThread thread = new ApplicationServerThread(null, (Runnable)restartHandle, "restartHandle", 0L);
        thread.start();
    }

    public void flushWebConfigs() {
        this.config.flushGlobalWebAppConfig();
        if (this.defaultApplication != null) {
            this.defaultApplication.flushWebAppConfigs();
        }
        ArrayList applicationsList = null;
        boolean obtainedValidApplicationsList = false;
        while (!obtainedValidApplicationsList) {
            try {
                applicationsList = new ArrayList(this.applications.values());
                obtainedValidApplicationsList = true;
            }
            catch (ConcurrentModificationException e) {}
        }
        Iterator iterator = applicationsList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Application)) continue;
            ((Application)object).flushWebAppConfigs();
        }
    }

    private String validateCheckForUpdateInput(String checkForUpdates) {
        boolean iasMode = ServerProperties.getRunningInIAS();
        if (!(checkForUpdates.equalsIgnoreCase(UPDATES_VIA_ALL_MODES) || checkForUpdates.equalsIgnoreCase(UPDATES_NONE) || checkForUpdates.equalsIgnoreCase(UPDATES_VIA_ADMIN_CLIENT_REQUESTS))) {
            if (iasMode) {
                ServerMessages.infoCheckForUpdatesIASSetting();
                checkForUpdates = UPDATES_VIA_ADMIN_CLIENT_REQUESTS;
            } else {
                ServerMessages.infoCheckForUpdatesStandaloneSetting();
                checkForUpdates = UPDATES_VIA_ALL_MODES;
            }
            return checkForUpdates;
        }
        if (iasMode && checkForUpdates.equals(UPDATES_VIA_ALL_MODES)) {
            ServerMessages.infoCheckForUpdatesIASSetting();
            checkForUpdates = UPDATES_VIA_ADMIN_CLIENT_REQUESTS;
        }
        return checkForUpdates;
    }

    public void persistConfigChange() throws IOException {
        this.config.store();
    }

    public boolean checkSharedLibraryExists(String libraryName, String libraryVersion) {
        return this.config.checkSharedLibraryExists(libraryName, libraryVersion);
    }

    public boolean checkSharedLibraryExists(String libraryName) {
        return this.config.checkSharedLibraryExists(libraryName);
    }

    public void registerApplicationServerEventsListener(ApplicationServerEventsListener listener) {
        this.eventsListeners.add(listener);
    }

    public boolean unregisterApplicationServerEventsListener(ApplicationServerEventsListener listener) {
        return this.eventsListeners.remove(listener);
    }

    private void broadcastEvent(int event, String application) {
        for (int i = 0; i < this.eventsListeners.size(); ++i) {
            if (event == 0) {
                ((ApplicationServerEventsListener)this.eventsListeners.get(i)).applicationDeployed(application);
                continue;
            }
            if (event != 1) continue;
            ((ApplicationServerEventsListener)this.eventsListeners.get(i)).applicationUndeployed(application);
        }
    }

    public static void setApplicationServerAdministrator(ApplicationServerAdministrator admin) {
        OC4JSecurity.assertIsSafe();
        _admin = admin;
    }

    public static ApplicationServerAdministrator getApplicationServerAdministrator() {
        OC4JSecurity.assertIsSafe();
        return _admin;
    }

    public Application getSystemApplication() {
        return systemApplication;
    }

    public static String getSystemApplicationName() {
        return SYSTEM_APPLICATION_NAME;
    }

    public boolean isOperationAllowed(String applicationName) {
        return !applicationName.equals(systemApplication.getName());
    }

    public String getGroupName(String applicationName) {
        Iterator itr = this.applications.values().iterator();
        while (itr.hasNext()) {
            JGroupConfig jConfig;
            Application app;
            ApplicationConfig applicationConfig;
            Object obj = itr.next();
            if (!(obj instanceof Application) || !applicationName.equalsIgnoreCase((applicationConfig = (app = (Application)obj).getConfig()).getName()) || (jConfig = applicationConfig.getClusterConfig()) == null) continue;
            return jConfig.getGroupName();
        }
        return null;
    }

    public void addApplicationToRuntime(String applicationName, Map params) throws DeployerException {
        try {
            Application app = this.getApplication(applicationName);
            if (app != null) {
                RuntimeApplicationUpdater updater = new RuntimeApplicationUpdater(applicationName, params);
                updater.addApplicationToRuntime();
            } else {
                RuntimeRarUpdater updater = new RuntimeRarUpdater(applicationName, params);
                updater.addGlobalRarToRuntime();
            }
        }
        catch (InstantiationException e) {
            throw new DeployerException(e);
        }
    }

    public void removeApplicationFromRuntime(String applicationName) throws DeployerException {
        try {
            Application app = this.getApplication(applicationName);
            if (app != null) {
                RuntimeApplicationUpdater updater = new RuntimeApplicationUpdater(applicationName);
                updater.removeApplicationFromRuntime();
            } else {
                RuntimeRarUpdater updater = new RuntimeRarUpdater(applicationName);
                updater.removeGlobalRarFromRuntime();
            }
        }
        catch (InstantiationException e) {
            throw new DeployerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getActiveApplications() {
        Lock destroyLock = this.getDestroyLock().readLock();
        destroyLock.lock();
        try {
            ApplicationServer applicationServer = this;
            synchronized (applicationServer) {
                ArrayList<Application> apps = new ArrayList<Application>();
                if (this.defaultApplication != null) {
                    apps.add(this.defaultApplication);
                }
                if (this.applications != null) {
                    Iterator itr = this.applications.values().iterator();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (!(obj instanceof Application)) continue;
                        apps.add((Application)obj);
                    }
                }
                ArrayList<Application> arrayList = apps;
                return arrayList;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPersistentProperties() {
        if (this.propPath != null) {
            String string = this.propPath;
            synchronized (string) {
                try {
                    Properties properties = new Properties();
                    FileInputStream strm = new FileInputStream(this.propPath);
                    properties.load(strm);
                    strm.close();
                    return properties;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersistentProperty(String name) {
        if (this.propPath != null && name != null) {
            String string = this.propPath;
            synchronized (string) {
                try {
                    Properties properties = new Properties();
                    FileInputStream strm = new FileInputStream(this.propPath);
                    properties.load(strm);
                    strm.close();
                    return properties.getProperty(name);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentProperty(String name, String value) {
        if (this.propPath != null && name != null && value != null) {
            String string = this.propPath;
            synchronized (string) {
                try {
                    Properties properties = new Properties();
                    FileInputStream inStrm = new FileInputStream(this.propPath);
                    properties.load(inStrm);
                    inStrm.close();
                    properties.setProperty(name, value);
                    FileOutputStream outStrm = new FileOutputStream(this.propPath);
                    properties.store(outStrm, "");
                    outStrm.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentProperty(String name) {
        if (this.propPath != null && name != null) {
            String string = this.propPath;
            synchronized (string) {
                try {
                    Properties properties = new Properties();
                    FileInputStream inStrm = new FileInputStream(this.propPath);
                    properties.load(inStrm);
                    inStrm.close();
                    properties.remove(name);
                    FileOutputStream outStrm = new FileOutputStream(this.propPath);
                    properties.store(outStrm, "");
                    outStrm.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void addWebSite(String name, String protocol, int port, String keystorePath, String keystorePassword, String sslProvider) throws IOException, InstantiationException {
        this.httpServer.addWebsite(name, protocol, port, keystorePath, keystorePassword, sslProvider);
    }

    public ReentrantReadWriteLock getDestroyLock() {
        return this.destroyRwl;
    }

    private void cleanupTaskManager() {
        if (this.taskManager != null) {
            ServerMessages.infoTaskManagerStopping();
            this.taskManager.stopAndCleanUp();
            ServerMessages.infoTaskManagerStopped();
        }
    }

    static {
        ejbSecPropPath = "config";
        embeddedMode = false;
        ENABLE_JCACHE = ServerProperties.getOracleIasJcache();
        VERSION = Server.version;
        MEANINGFUL_VERSION = " 10g (" + VERSION + ") ";
        INFO = PRODUCT_NAME + MEANINGFUL_VERSION;
        coreOut = System.out;
        systemPrintStreams = new HashMap();
        DMS_GATE = ApplicationServer.getDMSMetricsLevel() >= 5;
        dmsConsole = null;
        eventFactory = null;
        nounFactory = null;
        phaseFactory = null;
        sensorFactory = null;
        stateFactory = null;
        SECURITY_PROPERTY_PREFIX_LENGTH = SECURITY_PROPERTY_PREFIX.length();
        _admin = null;
        m_logger = TraceLogger.getLogger(ApplicationServer.class);
        ApplicationServer.initSystemProperties();
        eventChecker = false;
    }
}

