/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.mail;

import com.evermind.mail.MailUtils;
import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailLogger
implements Logger {
    protected LoggerContext context;
    protected boolean logTimestamp = true;
    protected boolean logExceptionsOnly;
    protected List addressList = new ArrayList();
    protected Session session;
    protected String subject;

    public MailLogger(String[] addresses, Session session, String subject) throws AddressException {
        this.session = session;
        this.subject = subject;
        for (int i = 0; i < addresses.length; ++i) {
            this.addressList.add(new InternetAddress(addresses[i]));
        }
    }

    public void setContext(LoggerContext context) {
        this.context = context;
    }

    public void setLogTimestamp(boolean logTimestamp) {
        this.logTimestamp = logTimestamp;
    }

    public void setLogExceptionsOnly(boolean logExceptionsOnly) {
        this.logExceptionsOnly = logExceptionsOnly;
    }

    public void log(LogEvent event) {
        if (this.logExceptionsOnly && event.getType() < 2) {
            return;
        }
        try {
            ByteArrayOutputStream textOut = new ByteArrayOutputStream();
            if (event.getThrowable() != null) {
                PrintWriter traceWriter = new PrintWriter(textOut, true);
                if (this.context != null) {
                    this.context.printStackTrace(event.getThrowable(), traceWriter);
                } else {
                    event.getThrowable().printStackTrace(traceWriter);
                }
                traceWriter.flush();
            }
            textOut.close();
            InternetAddress[] address = this.addressList.toArray(new InternetAddress[this.addressList.size()]);
            try {
                if (address.length > 0) {
                    MailUtils.send(address, address[0], this.session, this.subject, (this.logTimestamp ? DateFormat.getInstance().format(new Date()) + ' ' : "") + event.getMessage() + "\n\n" + new String(textOut.toByteArray()), null);
                }
            }
            catch (Throwable mailThrowable) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
    }

    public void init(Properties properties) {
    }
}

