/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SingleReadBufferInputStream
extends FilterInputStream {
    protected byte[] buffer;
    protected int bufferLength;
    protected int pos;

    public SingleReadBufferInputStream(InputStream in) {
        super(in);
        this.buffer = new byte[4096];
    }

    public SingleReadBufferInputStream(InputStream in, byte[] buffer) {
        super(in);
        this.pos = 0;
        this.buffer = buffer;
    }

    public int read() throws IOException {
        try {
            while (this.pos >= this.bufferLength) {
                if (this.readChunk()) continue;
                return -1;
            }
            return (char)this.buffer[this.pos++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Internal Error: ArrayIndexOutOfBoundsException in SRBIS(4)");
        }
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        try {
            for (int bytesRead = 0; length > bytesRead; bytesRead += this.bufferLength - this.pos) {
                while (this.pos >= this.bufferLength) {
                    if (this.readChunk()) continue;
                    if (bytesRead > 0) {
                        return bytesRead;
                    }
                    return -1;
                }
                if (length - bytesRead > this.bufferLength - this.pos) {
                    try {
                        System.arraycopy(this.buffer, this.pos, data, offset + bytesRead, this.bufferLength - this.pos);
                        this.pos = this.bufferLength;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new RuntimeException("Internal Error: ArrayIndexOutOfBoundsException in SRBIS(1)");
                    }
                }
                try {
                    System.arraycopy(this.buffer, this.pos, data, offset + bytesRead, length - bytesRead);
                    this.pos += length - bytesRead;
                    return length;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Internal Error: ArrayIndexOutOfBoundsException in SRBIS(2)");
                }
            }
            return length;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Internal Error: ArrayIndexOutOfBoundsException in SRBIS(3)");
        }
    }

    protected boolean readChunk() throws IOException {
        this.pos = 0;
        this.bufferLength = this.in.read(this.buffer, 0, this.buffer.length);
        return this.bufferLength >= 0;
    }
}

