/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import com.evermind.util.ServerProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.CorrelationContext;

public class OutputStreamLogger
implements Logger {
    public static final byte ROTATE_NO = 0;
    public static final byte ROTATE_HOUR = 1;
    public static final byte ROTATE_DAY = 2;
    public static final byte ROTATE_WEEK = 3;
    public static final byte ROTATE_MONTH = 4;
    public static final boolean ECID_ENABLED = ServerProperties.getOracleDmsTranstraceECIDEnabled();
    protected LoggerContext context;
    protected OutputStream out;
    protected PrintWriter logWriter;
    protected boolean logTimestamp;
    protected byte rotate;
    protected long lastRotated;
    protected Date date;
    protected DateFormat dateFormat;
    protected String dateFormatted;
    private GregorianCalendar calendar;

    public OutputStreamLogger(OutputStream out) throws IOException {
        this.logWriter = new PrintWriter((Writer)new OutputStreamWriter(out), false);
        this.date = new Date();
        this.dateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        this.dateFormatted = this.dateFormat.format(this.date);
        this.calendar = new GregorianCalendar();
    }

    public void setContext(LoggerContext context) {
        this.context = context;
    }

    public void log(LogEvent event) {
        LogMessage.InstanceId instanceId;
        String messageHeader;
        if (this.logTimestamp) {
            this.date.setTime(event.getTime());
            this.dateFormatted = this.dateFormat.format(this.date);
            this.calendar.setTime(this.date);
            Long millisec = new Long(this.calendar.get(14));
            this.dateFormatted = this.dateFormatted + "." + millisec.toString();
        }
        String string = messageHeader = this.logTimestamp ? this.dateFormatted + ' ' : "";
        if (ECID_ENABLED && (instanceId = CorrelationContext.getExecContextId()) != null) {
            messageHeader = messageHeader + "[ecid: " + instanceId.getUniqueId() + "," + instanceId.getSequenceNumber() + "] ";
        }
        this.logWriter.println(messageHeader + event.getMessage());
        if (event.getThrowable() != null) {
            if (this.context != null) {
                this.context.printStackTrace(event.getThrowable(), this.logWriter);
            } else {
                event.getThrowable().printStackTrace(this.logWriter);
            }
        }
        this.logWriter.flush();
    }

    public void setLogTimestamp(boolean timestamp) {
        this.logTimestamp = timestamp;
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void init(Properties properties) {
    }
}

