/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.IOUtils;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final int BUFFER_SIZE = 100;
    private byte[] buffer;
    private int bufferPos;
    private boolean closed;
    int maximumChunk;
    private static final byte[] EOF = "0\r\n\r\n".getBytes();

    public ChunkedOutputStream(OutputStream out) {
        this(out, 10000);
    }

    public ChunkedOutputStream(OutputStream out, int maximumChunk) {
        super(out);
        this.maximumChunk = maximumChunk;
    }

    public void write(int i) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream was closed");
        }
        if (this.buffer == null) {
            this.buffer = new byte[100];
        }
        if (this.bufferPos >= 100) {
            this.clearBuffer();
        }
        this.buffer[this.bufferPos++] = (byte)i;
    }

    private void clearBuffer() throws IOException {
        this.writeChunk(this.buffer, 0, this.bufferPos);
        this.bufferPos = 0;
    }

    public void write(byte[] array) throws IOException {
        this.write(array, 0, array.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream was closed");
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || length < 0 || data.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bufferPos > 0) {
            this.clearBuffer();
        }
        while (length > this.maximumChunk) {
            this.writeChunk(data, offset, this.maximumChunk);
            length -= this.maximumChunk;
            offset += this.maximumChunk;
        }
        this.writeChunk(data, offset, length);
    }

    private void writeChunk(byte[] data, int offset, int length) throws IOException {
        byte[] hex = Integer.toHexString(length).getBytes();
        this.out.write(hex, 0, hex.length);
        this.out.write(IOUtils.CRLF, 0, IOUtils.CRLF.length);
        this.out.write(data, offset, length);
        this.out.write(IOUtils.CRLF, 0, IOUtils.CRLF.length);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream was closed");
        }
        if (this.bufferPos > 0) {
            this.clearBuffer();
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.out.write(EOF, 0, EOF.length);
        this.closed = true;
    }
}

