/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompiledObject;
import com.evermind.compiler.CompilerFactory;
import com.evermind.compiler.FileLinkedCompiler;
import com.evermind.compiler.SourceObject;
import com.evermind.util.ByteString;
import com.evermind.util.CompilerProperties;
import com.evermind.util.JavaBeautifier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileLinkedCompilation
implements PrivilegedExceptionAction {
    public static final boolean NOGEN_WRAPPER_FILES = CompilerProperties.getDoNotReGenerateWrapperCode();
    public static final boolean LAZY_BINARIES = CompilerProperties.getLazyBinaries();
    public static final boolean NO_PRETTY_PRINT = CompilerProperties.getKeepWrapperCode();
    public static final boolean PROFILE = CompilerProperties.getBuildProfile();
    private FileLinkedCompiler compiler;
    private List sources;
    private String sourceDirectory;
    private String targetDirectory;
    private boolean custom = false;
    private Map properties;
    private Vector m_privateDependentClasses = new Vector();
    private Map pathAndSources;

    public FileLinkedCompilation(FileLinkedCompiler compiler, List sources, String sourceDirectory, String targetDirectory, Map properties) {
        this.compiler = compiler;
        this.sources = sources;
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.properties = properties;
        this.custom = true;
    }

    public FileLinkedCompilation(FileLinkedCompiler compiler, Map sources, Map properties) {
        this.compiler = compiler;
        this.pathAndSources = sources;
        this.properties = properties;
        String sourceDirectory_ = (String)properties.get("source.directory");
        String targetDirectory_ = (String)properties.get("target.directory");
        if (sourceDirectory_ != null) {
            this.sourceDirectory = sourceDirectory_;
        }
        if (targetDirectory_ != null) {
            this.targetDirectory = targetDirectory_;
        }
        if (properties.get("custom.compile") != null) {
            this.custom = properties.get("custom.compile").toString().compareToIgnoreCase("true") == 0;
        }
    }

    public void doCustomCompile() throws InstantiationException, CompilationException, IOException {
        ArrayList<SourceObject> names = new ArrayList<SourceObject>();
        HashMap<String, ArrayList<SourceObject>> mapNames = new HashMap<String, ArrayList<SourceObject>>();
        for (int i = 0; i < this.sources.size(); ++i) {
            names.add(new SourceObject(this.sources.get(i).toString(), null));
        }
        mapNames.put("no_batch_compile", names);
        this.properties.put("source.directory", this.sourceDirectory);
        this.properties.put("target.directory", this.targetDirectory);
        this.properties.put("custom.compile", "true");
        this.compiler.invokeCompiler(mapNames, this.properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object run() throws Exception {
        long stop_load;
        long start_load;
        long stop_compile;
        long start_compile;
        long stop_gen;
        long start_gen;
        long stop_run;
        long start_run;
        ArrayList retObjects;
        block23: {
            boolean error;
            block24: {
                String deployBatchStr;
                error = false;
                retObjects = null;
                start_run = System.currentTimeMillis();
                stop_run = 0L;
                start_gen = 1L;
                stop_gen = 0L;
                start_compile = 1L;
                stop_compile = 0L;
                start_load = 1L;
                stop_load = 0L;
                if (this.custom) {
                    this.doCustomCompile();
                    return null;
                }
                if (this.pathAndSources == null && this.sources.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                if (CompilerFactory.isDebug()) {
                    System.out.println("Code Formating is set to " + !NO_PRETTY_PRINT);
                }
                boolean batch = (deployBatchStr = (String)this.properties.get("deploy.batch")) != null;
                boolean generate = batch && deployBatchStr.equalsIgnoreCase("generate");
                boolean load = batch && deployBatchStr.equalsIgnoreCase("load");
                boolean compile = batch && deployBatchStr.equalsIgnoreCase("compile");
                try {
                    try {
                        String sourcePath;
                        Iterator iter;
                        ArrayList listSource;
                        if (!batch || generate) {
                            start_gen = System.currentTimeMillis();
                            if (this.pathAndSources != null) {
                                listSource = new ArrayList();
                                iter = this.pathAndSources.keySet().iterator();
                                while (iter.hasNext()) {
                                    sourcePath = (String)iter.next();
                                    listSource.addAll((List)this.doCompile((List)this.pathAndSources.get(sourcePath), this.getSourceDirectory(sourcePath)));
                                }
                                retObjects = listSource;
                            } else {
                                retObjects = this.doCompile(this.sources, null);
                            }
                            stop_gen = System.currentTimeMillis();
                        }
                        if (!batch || compile) {
                            start_compile = System.currentTimeMillis();
                            if (this.pathAndSources != null) {
                                this.compiler.invokeCompiler(this.pathAndSources, this.properties);
                                listSource = new ArrayList();
                                iter = this.pathAndSources.keySet().iterator();
                                while (iter.hasNext()) {
                                    sourcePath = (String)iter.next();
                                    listSource.addAll((List)this.pathAndSources.get(sourcePath));
                                }
                                retObjects = listSource;
                            } else {
                                HashMap<String, List> noBatchMap = new HashMap<String, List>();
                                noBatchMap.put("no_batch_compile", this.sources);
                                this.compiler.invokeCompiler(noBatchMap, this.properties);
                                retObjects = this.sources;
                            }
                            stop_compile = System.currentTimeMillis();
                        }
                        if (!batch || load) {
                            this.compiler.invokeAnyCallbacks();
                            start_load = System.currentTimeMillis();
                            if (this.pathAndSources != null) {
                                ArrayList tmpList = new ArrayList();
                                iter = this.pathAndSources.keySet().iterator();
                                while (iter.hasNext()) {
                                    String pathDir = (String)iter.next();
                                    tmpList.addAll((List)this.loadObjects((List)this.pathAndSources.get(pathDir), this.getSourceDirectory(pathDir)));
                                }
                                retObjects = tmpList;
                            } else {
                                retObjects = this.loadObjects(this.sources, this.getSourceDirectory(this.sourceDirectory));
                            }
                            stop_load = System.currentTimeMillis();
                        }
                    }
                    catch (IOException e) {
                        error = true;
                        throw new CompilationException("IO Error: " + e.getMessage());
                    }
                    Object var28_20 = null;
                    if (batch && !load) break block23;
                    if (this.pathAndSources == null) break block24;
                    this.cleanupIntermediateFiles(this.pathAndSources, error);
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var28_21 = null;
                    if (!batch || load) {
                        if (this.pathAndSources != null) {
                            this.cleanupIntermediateFiles(this.pathAndSources, error);
                        } else {
                            this.cleanupIntermediateFiles(this.sources, error);
                        }
                    }
                    stop_run = System.currentTimeMillis();
                    if (!PROFILE) throw throwable;
                    System.out.println("FileLinkedCompilation Elapsed Time:");
                    System.out.println("Run     :" + (stop_run - start_run));
                    System.out.println("Generate:" + (stop_gen - start_gen));
                    System.out.println("Compile :" + (stop_compile - start_compile));
                    System.out.println("Load    :" + (stop_load - start_load));
                    throw throwable;
                }
            }
            this.cleanupIntermediateFiles(this.sources, error);
        }
        stop_run = System.currentTimeMillis();
        if (!PROFILE) return retObjects;
        System.out.println("FileLinkedCompilation Elapsed Time:");
        System.out.println("Run     :" + (stop_run - start_run));
        System.out.println("Generate:" + (stop_gen - start_gen));
        System.out.println("Compile :" + (stop_compile - start_compile));
        System.out.println("Load    :" + (stop_load - start_load));
        return retObjects;
    }

    private String getSourceDirectory(String pathDir) {
        if (pathDir.equals("no_batch_compile")) {
            return this.sourceDirectory;
        }
        return pathDir;
    }

    private Object doCompile(Collection sources, String sourceDirectory) throws Exception {
        Compilable source;
        Iterator iterator = sources.iterator();
        ByteString sourceContent = null;
        while (iterator.hasNext()) {
            source = (Compilable)iterator.next();
            String filename = null;
            filename = sourceDirectory != null ? this.getPathForName(source, sourceDirectory) + ".java" : this.getPathForName(source) + ".java";
            File file = new File(filename);
            if (NOGEN_WRAPPER_FILES && file.exists()) {
                System.out.println("Skip re-gen of " + file.getName());
                continue;
            }
            sourceContent = source.getSource();
            if (sourceContent == null || sourceContent != null && sourceContent.data == null) continue;
            OutputStream out = new FileOutputStream(file);
            if (!FileLinkedCompiler.DELETE_INTERMEDIATE_FILES) {
                ByteArrayInputStream in = new ByteArrayInputStream(sourceContent.data, sourceContent.offset, sourceContent.length);
                out = new BufferedOutputStream(out);
                new JavaBeautifier(in, out);
            } else {
                ((OutputStream)out).write(sourceContent.data, sourceContent.offset, sourceContent.length);
            }
            ((OutputStream)out).close();
            if (source.getDependentClasses() == null) continue;
            this.m_privateDependentClasses.addAll(source.getDependentClasses());
        }
        iterator = sources.iterator();
        while (iterator.hasNext()) {
            source = (Compilable)iterator.next();
            source.cleanSource();
        }
        return sources;
    }

    private boolean cleanupIntermediateFiles(List sources, boolean error) {
        return this.cleanupIntermediateFiles(sources, null, error);
    }

    private boolean cleanupIntermediateFiles(List sources, String pathDir, boolean error) {
        if (FileLinkedCompiler.DELETE_INTERMEDIATE_FILES) {
            for (int i = 0; i < sources.size(); ++i) {
                Compilable source = (Compilable)sources.get(i);
                String fileroot = null;
                fileroot = pathDir != null ? this.getPathForName(source, pathDir) : this.getPathForName(source);
                new File(fileroot + ".java").delete();
                if (!error && LAZY_BINARIES) continue;
                new File(fileroot + ".class").delete();
            }
        }
        return true;
    }

    private boolean cleanupIntermediateFiles(Map sources, boolean error) {
        if (FileLinkedCompiler.DELETE_INTERMEDIATE_FILES) {
            if (sources != null) {
                Iterator iter = sources.keySet().iterator();
                while (iter.hasNext()) {
                    String pathDir = (String)iter.next();
                    this.cleanupIntermediateFiles((List)sources.get(pathDir), pathDir, error);
                }
            }
            this.deleteJavacParams();
        }
        return true;
    }

    private void deleteJavacParams() {
        File tmpFile = new File(CompilerFactory.instance().getTempDir() + File.separator + "javac.params." + Thread.currentThread().hashCode());
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    private String getPathForName(Compilable source, String sourceDir) {
        String filename = "";
        if (sourceDir != null && !sourceDir.equals("no_batch_compile")) {
            filename = sourceDir + File.separator;
        } else if (this.sourceDirectory != null) {
            filename = this.sourceDirectory + File.separator;
        }
        filename = filename + source.getName().replace('.', File.separatorChar);
        File parent = new File(filename).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return filename;
    }

    private String getPathForName(Compilable source) {
        return this.getPathForName(source, null);
    }

    private Object loadObjects(List sources, String sourceDirectory) throws CompilationException, IOException {
        ArrayList<CompiledObject> objects = new ArrayList<CompiledObject>();
        for (int i = 0; i < sources.size(); ++i) {
            Compilable source = (Compilable)sources.get(i);
            String fileroot = this.getPathForName(source, sourceDirectory);
            File classFile = new File(fileroot + ".class");
            if (!classFile.exists()) {
                throw new CompilationException("Syntax error in source or compilation failed in: " + fileroot + ".java" + "\n" + new String(this.compiler.errBuff, "utf-8"));
            }
            CompiledObject object = null;
            object = this.createCompiledObject(source.getName(), classFile);
            objects.add(object);
        }
        File[] files = null;
        files = sourceDirectory != null ? new File(sourceDirectory).listFiles() : new File(".").listFiles();
        if (files != null) {
            block1: for (int i = 0; i < files.length; ++i) {
                int start;
                String name = files[i].getPath();
                if (!name.endsWith(".class")) continue;
                if (name.indexOf(36) > 0) {
                    int index;
                    name = files[i].getName();
                    start = name.lastIndexOf(File.separator);
                    if (start == -1) {
                        start = 0;
                    }
                    if ((index = name.indexOf(36)) <= 0) continue;
                    String className = name.substring(start, index);
                    Iterator iterator = sources.iterator();
                    CompiledObject object = null;
                    String objName = null;
                    while (iterator.hasNext()) {
                        Compilable compilable = (Compilable)iterator.next();
                        if (!compilable.getName().equals(className)) continue;
                        objName = name.substring(start, name.length() - ".class".length());
                        object = this.createCompiledObject(objName, files[i]);
                        objects.add(object);
                        continue block1;
                    }
                    continue;
                }
                start = name.lastIndexOf(File.separator);
                start = start == -1 ? 0 : start + 1;
                String objName = name.substring(start, name.length() - ".class".length());
                if (!objName.startsWith("DoAsBlock")) continue;
                CompiledObject object = this.createCompiledObject(objName, files[i]);
                objects.add(object);
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private CompiledObject createCompiledObject(String name, File classFile) throws IOException {
        void var3_3;
        CompiledObject object;
        if (LAZY_BINARIES) {
            object = new CompiledObject(name, null, classFile.getAbsolutePath());
        } else {
            FileInputStream in = null;
            try {
                in = new FileInputStream(classFile);
                byte[] data = new byte[(int)classFile.length()];
                in.read(data);
                object = new CompiledObject(name, data);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return var3_3;
    }
}

