/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandBase;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.AdminCommandUtils;
import com.evermind.server.administration.ApplicationServerAdministrator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployConnectorCommand
extends AdminCommandBase {
    private Map _extraParams = new HashMap();
    private String _deploymentName = null;
    private String _fileName = null;

    public DeployConnectorCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("deployment subcommand");
            if (command.equals("-file")) {
                this._fileName = this.getNextArgument("deployconnector -file filename");
                continue;
            }
            if (command.equals("-name")) {
                this._deploymentName = this.getNextArgument("deployconnector -name deployment name");
                continue;
            }
            if (command.equals("-nativeLibPath")) {
                this._extraParams.put("nativeLibPath", this.getNextArgument("deployconnector -nativeLibPath"));
                continue;
            }
            if (command.equals("-grantAllPermissions")) {
                this._extraParams.put("grantAllPermissions", "true");
                continue;
            }
            throw new AdminCommandException("Unknown -deployconnector switch: " + command, 28);
        }
        this.checkArgIsNull(this._fileName, "-file");
        this.checkArgIsNull(this._deploymentName, "-name");
    }

    public void execute(ApplicationServerAdministrator admin) throws AdminCommandException {
        File packageFile = new File(this._fileName);
        if (!packageFile.exists()) {
            throw new AdminCommandException("Unable to find archive " + this._fileName, 22);
        }
        if (packageFile.isDirectory()) {
            throw new AdminCommandException(this._fileName + " is a directory, not an archive.", 23);
        }
        Map values = null;
        if (this.getIsLocalHost()) {
            try {
                values = admin.deployConnector(packageFile.getAbsolutePath(), this._deploymentName, this._extraParams);
            }
            catch (Exception e) {
                throw new AdminCommandException((Throwable)e, "Deploy error: " + e.getMessage());
            }
        }
        Integer id = AdminCommandUtils.uploadFile(admin, new File(this._fileName), this._deploymentName + ".rar");
        try {
            values = admin.deployConnector(id, this._deploymentName, this._extraParams);
        }
        catch (Exception e) {
            throw new AdminCommandException((Throwable)e, "Deploy error: " + e.getMessage());
        }
        System.out.println(values.get("output"));
    }
}

