/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared.util;

import com.evermind.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.JarTool;
import oracle.oc4j.admin.management.shared.SharedModuleType;
import oracle.oc4j.util.FileUtils;

public class EarFileUtils {
    public static File toEar(DataSink sink, SharedModuleType moduleType, String appName, String contextRoot) throws JMXRuntimeException {
        if (sink.getData() != null) {
            throw new JMXRuntimeException("EarFileUtils.toEar failed: donot support byte[] for now!");
        }
        File destDir = null;
        try {
            destDir = FileUtils.createTempDir();
        }
        catch (IOException e) {
            throw new JMXRuntimeException("EarFileUtils.toEar failed: unable to create temp dir: " + e.getMessage());
        }
        return EarFileUtils.toEar(sink, moduleType, appName, destDir, contextRoot);
    }

    public static File toEar(DataSink sink, SharedModuleType moduleType, String appName, File destDir, String contextRoot) throws JMXRuntimeException {
        File file;
        block6: {
            if (sink.getData() != null) {
                throw new JMXRuntimeException("EarFileUtils.toEar failed: donot support byte[] for now!");
            }
            File origFile = null;
            if (sink.getFilePath() != null) {
                origFile = new File(sink.getFilePath());
                return EarFileUtils.toEar(origFile, moduleType, appName, destDir, contextRoot);
            }
            try {
                InputStream origStream = sink.getInputStream();
                origFile = new File(destDir, appName + moduleType.getModuleExtention());
                FileOutputStream out = new FileOutputStream(origFile);
                IOUtils.pipe((InputStream)origStream, (OutputStream)out);
                out.close();
                file = EarFileUtils.toEar(origFile, moduleType, appName, destDir, contextRoot);
                Object var10_10 = null;
                if (origFile == null) break block6;
                origFile.delete();
            }
            catch (Exception e) {
                try {
                    throw new JMXRuntimeException(e);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var10_11 = null;
                        if (origFile == null) break block7;
                        origFile.delete();
                        origFile = null;
                    }
                    throw throwable;
                }
            }
            origFile = null;
        }
        return file;
    }

    public static File toEar(File origFile, SharedModuleType moduleType, String appName, String contextRoot) throws JMXRuntimeException {
        File destDir = null;
        try {
            destDir = FileUtils.createTempDir();
        }
        catch (IOException e) {
            throw new JMXRuntimeException("EarFileUtils.toEar failed: unable to create temp dir: " + e.getMessage());
        }
        return EarFileUtils.toEar(origFile, moduleType, appName, destDir, contextRoot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File toEar(File origFile, SharedModuleType moduleType, String appName, File destDir, String contextRoot) throws JMXRuntimeException {
        File file;
        JarTool jt;
        block18: {
            if (moduleType.equals(SharedModuleType.EAR)) {
                return origFile;
            }
            if (origFile == null) {
                throw new JMXRuntimeException("toEar: file should not be null");
            }
            if (appName == null) {
                throw new JMXRuntimeException("toEar: appName should not be null");
            }
            if (!origFile.exists()) {
                throw new JMXRuntimeException("toEar: file " + origFile.getAbsolutePath() + " does not exist!");
            }
            File earStdXml = null;
            jt = null;
            String moduleName = null;
            try {
                try {
                    earStdXml = File.createTempFile("application", ".xml");
                    PrintWriter out = new PrintWriter(new FileOutputStream(earStdXml));
                    out.println("<?xml version=\"1.0\"?>");
                    out.println("<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN\" \"http://java.sun.com/j2ee/dtds/application_1_2.dtd\">");
                    out.println("<application>");
                    out.println("\t<display-name>Oracle generated application " + appName + "</display-name>");
                    out.println("\t<module>");
                    if (moduleType.equals(SharedModuleType.EJB)) {
                        moduleName = appName + ".jar";
                        out.println("\t\t<ejb>" + moduleName + "</ejb>");
                    } else if (moduleType.equals(SharedModuleType.CAR)) {
                        moduleName = appName + ".car";
                        out.println("\t\t<java>" + moduleName + "</java>");
                    } else if (moduleType.equals(SharedModuleType.RAR)) {
                        moduleName = appName + ".rar";
                        out.println("\t\t<connector>" + moduleName + "</connector>");
                    } else if (moduleType.equals(SharedModuleType.WAR)) {
                        moduleName = appName + ".war";
                        out.println("\t\t<web>");
                        out.println("\t\t\t<web-uri>" + moduleName + "</web-uri>");
                        if (contextRoot != null) {
                            out.println("\t\t\t<context-root>" + contextRoot + "</context-root>");
                        }
                        out.println("\t\t</web>");
                    }
                    out.println("\t</module>");
                    out.println("</application>");
                    out.close();
                    File dest = new File(destDir, appName + ".ear");
                    jt = JarTool.createNewJarFile(dest.getAbsolutePath());
                    jt.addEntry("META-INF/application.xml", earStdXml);
                    jt.addEntry(moduleName, origFile);
                    file = dest;
                    Object var12_13 = null;
                    if (earStdXml == null) break block18;
                }
                catch (JMXRuntimeException de) {
                    throw (JMXRuntimeException)de.fillInStackTrace();
                }
                catch (Exception e) {
                    throw new JMXRuntimeException(e);
                }
                earStdXml.delete();
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (earStdXml != null) {
                    earStdXml.delete();
                    earStdXml = null;
                }
                if (jt == null) throw throwable;
                jt.close();
                jt = null;
                throw throwable;
            }
            earStdXml = null;
        }
        if (jt == null) return file;
        jt.close();
        return file;
    }
}

