/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared.exceptions;

import java.io.PrintWriter;
import java.rmi.RemoteException;
import javax.management.MBeanException;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.naming.NamingException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class ExceptionHelper {
    public static void printStackTrace(PrintWriter pw, Throwable t) {
        t.printStackTrace(pw);
        ExceptionHelper.printNestedStackTrace(pw, t);
        pw.flush();
    }

    public static void printNestedStackTrace(PrintWriter pw, Throwable t) {
        if (t instanceof RemoteException) {
            ExceptionHelper.handleRemoteException(pw, (RemoteException)t);
        }
        if (t instanceof MBeanException) {
            ExceptionHelper.handleMBeanException(pw, (MBeanException)t);
        }
        if (t instanceof RuntimeMBeanException) {
            ExceptionHelper.handleRuntimeMBeanException(pw, (RuntimeMBeanException)t);
        }
        if (t instanceof JMXRuntimeException) {
            ExceptionHelper.handleJMXRuntimeException(pw, (JMXRuntimeException)t);
        }
        if (t instanceof JMXException) {
            ExceptionHelper.handleJMXException(pw, (JMXException)t);
        }
        if (t instanceof ReflectionException) {
            ExceptionHelper.handleReflectionException(pw, (ReflectionException)t);
        }
        if (t instanceof OperationsException) {
            ExceptionHelper.handleOperationsException(pw, (OperationsException)t);
        }
        if (t instanceof NamingException) {
            ExceptionHelper.handleNamingException(pw, (NamingException)t);
        }
        pw.flush();
    }

    public static void handleRemoteException(PrintWriter pw, RemoteException re) {
        if (re.detail != null) {
            pw.println("---- Embedded exception");
            re.detail.printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, re.detail);
        }
    }

    public static void handleMBeanException(PrintWriter pw, MBeanException me) {
        if (me.getTargetException() != null) {
            pw.println("---- Embedded exception");
            me.getTargetException().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, me.getTargetException());
        }
    }

    public static void handleRuntimeMBeanException(PrintWriter pw, RuntimeMBeanException me) {
        if (me.getTargetException() != null) {
            pw.println("---- Embedded exception");
            me.getTargetException().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, me.getTargetException());
        }
    }

    public static void handleJMXRuntimeException(PrintWriter pw, JMXRuntimeException jre) {
        if (jre.getOriginalException() != null) {
            pw.println("---- Embedded exception");
            jre.getOriginalException().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, jre.getOriginalException());
        }
    }

    public static void handleJMXException(PrintWriter pw, JMXException jre) {
        if (jre.getOriginalException() != null) {
            pw.println("---- Embedded exception");
            jre.getOriginalException().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, jre.getOriginalException());
        }
    }

    public static void handleReflectionException(PrintWriter pw, ReflectionException jre) {
        if (jre.getTargetException() != null) {
            pw.println("---- Embedded exception");
            jre.getTargetException().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, jre.getTargetException());
        }
    }

    public static void handleOperationsException(PrintWriter pw, OperationsException jre) {
        if (jre.getCause() != null) {
            pw.println("---- Embedded exception");
            jre.getCause().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, jre.getCause());
        }
    }

    public static void handleNamingException(PrintWriter pw, NamingException jre) {
        if (jre.getRootCause() != null) {
            pw.println("---- Embedded exception");
            jre.getRootCause().printStackTrace(pw);
            ExceptionHelper.printNestedStackTrace(pw, jre.getRootCause());
        }
    }
}

