/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.remote.JMXServiceURL;
import oracle.ias.opmn.optic.OpmnConn;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticException;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiDomain;

public class Oc4jOpmnRmiDomain
extends Oc4jRmiDomain
implements ClusterDomain {
    static final long serialVersionUID = -6365827937331908727L;
    private String opmnHost_ = null;
    private int opmnPort_ = 6003;
    private String oc4jInstance_ = null;
    private String iasInstance_ = null;
    private int lastReportedPort_ = -1;
    private static final String query_ = "/dump?type=dms&dmsarg=[nountype=opmn_ias_instance&format=xml]";

    public Oc4jOpmnRmiDomain(String opmnHost, int opmnPort, String oc4jInstance, String iasInstance, String login, String pwd) {
        super(opmnHost, opmnPort, login, pwd);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
        this.iasInstance_ = iasInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, int opmnPort, String oc4jInstance, String login, String pwd) {
        super(opmnHost, opmnPort, login, pwd);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, String oc4jInstance, String iasInstance, String login, String pwd) {
        super(opmnHost, 6003, login, pwd);
        this.opmnHost_ = opmnHost;
        this.oc4jInstance_ = oc4jInstance;
        this.iasInstance_ = iasInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, String oc4jInstance, String login, String pwd) {
        super(opmnHost, 6003, login, pwd);
        this.opmnHost_ = opmnHost;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, int opmnPort, String oc4jInstance, String iasInstance) {
        super(opmnHost, opmnPort);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
        this.iasInstance_ = iasInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, int opmnPort, String oc4jInstance) {
        super(opmnHost, opmnPort);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiDomain(String opmnHost, String oc4jInstance) {
        super(opmnHost, 6003);
        this.opmnHost_ = opmnHost;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiDomain(String domain) {
        super(domain.substring(domain.indexOf(43) + 1));
        StringTokenizer st = new StringTokenizer(domain, "+");
        String opmnst = st.nextToken();
        StringTokenizer stb = new StringTokenizer(opmnst, "-");
        st.nextToken();
        if (st.countTokens() > 0) {
            this.oc4jInstance_ = st.nextToken();
        }
        if (st.countTokens() > 0) {
            this.iasInstance_ = st.nextToken();
        }
    }

    public Oc4jOpmnRmiDomain(String domain, String login, String pwd) {
        super(domain.substring(domain.indexOf(43) + 1), login, pwd);
        StringTokenizer st = new StringTokenizer(domain, "+");
        String opmnst = st.nextToken();
        StringTokenizer stb = new StringTokenizer(opmnst, "-");
        st.nextToken();
        if (st.countTokens() > 0) {
            this.oc4jInstance_ = st.nextToken();
        }
        if (st.countTokens() > 0) {
            this.iasInstance_ = st.nextToken();
        }
    }

    public String toString() {
        if (this.iasInstance_ == null) {
            return "opmn-" + this.oc4jInstance_ + "+" + super.toString();
        }
        return "opmn-" + this.oc4jInstance_ + "-" + this.iasInstance_ + "+" + super.toString();
    }

    protected String getSecureDomain() {
        if (this.iasInstance_ == null) {
            return "opmn-" + this.oc4jInstance_ + "+" + super.getSecureDomain();
        }
        return "opmn-" + this.oc4jInstance_ + "-" + this.iasInstance_ + "+" + super.getSecureDomain();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Oc4jOpmnRmiDomain) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public final String getHost() {
        List oc4jProcs = this.getOc4jProcs();
        if (oc4jProcs == null || oc4jProcs.size() == 0) {
            if (this.iasInstance_ != null) {
                throw new RuntimeException("No OC4J process up for AS instance: " + this.iasInstance_ + " and domain: " + this.toString());
            }
            throw new RuntimeException("No OC4J process up for AS instance identified by domain: " + this.toString());
        }
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        Iterator procs = oc4jProcs.iterator();
        OpmnProcess choosenProc = null;
        while (procs.hasNext()) {
            choosenProc = (OpmnProcess)procs.next();
            List conList = choosenProc.getConnList();
            Iterator it = conList.iterator();
            while (it.hasNext()) {
                OpmnConn con = (OpmnConn)it.next();
                if (!("ormis".equals(wireProtocol) ? "rmis".equals(con.getType()) : (this.getHttpTunnelingPath() == null ? "rmi".equals(con.getType()) : "ajp".equals(con.getType())))) continue;
                return con.getHost();
            }
        }
        return choosenProc.getHostName();
    }

    public final int getPort() {
        List oc4jProcs = this.getOc4jProcs();
        if (oc4jProcs == null || oc4jProcs.size() == 0) {
            if (this.iasInstance_ != null) {
                throw new RuntimeException("No OC4J process up for AS instance: " + this.iasInstance_ + " and domain: " + this.toString());
            }
            throw new RuntimeException("No OC4J process up for AS instance identified by domain: " + this.toString());
        }
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        Iterator procs = oc4jProcs.iterator();
        while (procs.hasNext()) {
            OpmnProcess choosenProc = (OpmnProcess)procs.next();
            List conList = choosenProc.getConnList();
            Iterator it = conList.iterator();
            while (it.hasNext()) {
                OpmnConn con = (OpmnConn)it.next();
                int prt = Integer.parseInt(con.getPort());
                if ("ormis".equals(wireProtocol)) {
                    if (!"rmis".equals(con.getType())) continue;
                    this.lastReportedPort_ = prt;
                    return prt;
                }
                if (this.getHttpTunnelingPath() == null) {
                    if (!"rmi".equals(con.getType())) continue;
                    this.lastReportedPort_ = prt;
                    return prt;
                }
                if (!"ajp".equals(con.getType())) continue;
                this.lastReportedPort_ = prt;
                return prt;
            }
        }
        if (this.getHttpTunnelingPath() == null) {
            throw new RuntimeException("OPMN was unable to get OC4J RMI port for instance: " + this.toString());
        }
        throw new RuntimeException("OPMN was unable to get OC4J AJP port for instance: " + this.toString());
    }

    public JMXServiceURL getJMXServiceURL() throws MalformedURLException {
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        String url = "service:jmx:";
        url = "ormis".equals(wireProtocol) ? url + "ormis" : url + "ormi";
        url = url + ":///opmn://" + this.opmnHost_ + ":" + this.opmnPort_ + "/" + this.oc4jInstance_;
        return new JMXServiceURL(url);
    }

    public int[] getPorts() {
        List oc4jProcs = this.getOc4jProcs();
        int[] ports = new int[oc4jProcs.size()];
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        if (oc4jProcs == null || oc4jProcs.size() == 0) {
            if (this.iasInstance_ != null) {
                throw new RuntimeException("No OC4J process up for AS instance: " + this.iasInstance_ + " and domain: " + this.toString());
            }
            throw new RuntimeException("No OC4J process up for AS instance identified by domain: " + this.toString());
        }
        for (int i = 0; i < oc4jProcs.size(); ++i) {
            OpmnProcess choosenProc = (OpmnProcess)oc4jProcs.get(i);
            List conList = choosenProc.getConnList();
            Iterator it = conList.iterator();
            while (it.hasNext()) {
                OpmnConn con = (OpmnConn)it.next();
                int prt = Integer.parseInt(con.getPort());
                if ("ormis".equals(wireProtocol)) {
                    if (!"rmis".equals(con.getType())) continue;
                    ports[i] = prt;
                    continue;
                }
                if (this.getHttpTunnelingPath() == null) {
                    if (!"rmi".equals(con.getType())) continue;
                    ports[i] = prt;
                    continue;
                }
                if (!"ajp".equals(con.getType())) continue;
                ports[i] = prt;
            }
        }
        return ports;
    }

    public String getOPMNHost() {
        return this.opmnHost_;
    }

    public int getOPMNPort() {
        return this.opmnPort_;
    }

    public String getOC4JComponentClusterName() {
        return this.oc4jInstance_;
    }

    public String getIASInstance() {
        return this.iasInstance_;
    }

    public Domain[] getSynchronizationDomains() {
        return this.getSynchronizationDomains(-1);
    }

    public Domain[] getSynchronizationDomains(int mainPort) {
        int[] allPorts = this.getPorts();
        if (allPorts == null || allPorts.length == 1) {
            return null;
        }
        boolean found = false;
        for (int i = 0; i < allPorts.length; ++i) {
            if (allPorts[i] != mainPort) continue;
            found = true;
        }
        int[] syncPorts = null;
        if (found) {
            syncPorts = new int[allPorts.length - 1];
            int j = 0;
            for (int i = 0; i < allPorts.length; ++i) {
                if (allPorts[i] == mainPort) continue;
                syncPorts[j++] = allPorts[i];
            }
        } else {
            syncPorts = allPorts;
        }
        Domain[] res = new Domain[syncPorts.length];
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        for (int i = 0; i < syncPorts.length; ++i) {
            res[i] = this.login_ != null && this.sagar_ != null ? new Oc4jRmiDomain(this.getHost(), syncPorts[i], this.login_, this.sagar_) : new Oc4jRmiDomain(this.getHost(), syncPorts[i]);
            if (wireProtocol != null) {
                res[i].addProperty("com.oracle.jmx.remote.oc4j.wireprotocol", wireProtocol);
            }
            if (this.getHttpTunnelingPath() == null) continue;
            res[i].setHttpTunnelingPath(this.getHttpTunnelingPath());
        }
        return res;
    }

    public List getOc4jProcs() {
        String query = null;
        ArrayList<OpmnProcess> res = new ArrayList<OpmnProcess>();
        try {
            query = this.iasInstance_ != null ? "instance:" + this.iasInstance_ + query_ : query_;
            List procList = OpmnQuery.getProc((String)this.opmnHost_, (int)this.opmnPort_, (String)query);
            for (int i = 0; i < procList.size(); ++i) {
                OpmnProcess p = (OpmnProcess)procList.get(i);
                if (this.oc4jInstance_ != null) {
                    if (!p.getType().equalsIgnoreCase("OC4J") || !p.getStatus().equalsIgnoreCase("Alive") || !p.getProcessTypeName().equalsIgnoreCase(this.oc4jInstance_)) continue;
                    res.add(p);
                    continue;
                }
                if (!p.getType().equalsIgnoreCase("OC4J") || !p.getStatus().equalsIgnoreCase("Alive")) continue;
                res.add(p);
            }
        }
        catch (OpticException oe) {
            RuntimeException re = new RuntimeException("Error getting OC4J Process for: " + this.toString());
            re.initCause(oe);
            throw re;
        }
        return res;
    }
}

