/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.remote.rmi;

import java.util.Map;
import javax.management.remote.JMXServiceURL;
import oracle.oc4j.admin.jmx.client.ClientMBeanServerProxyFactory;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.remote.JMXConnectorImpl;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.IasOpmnRmiDomain;
import oracle.oc4j.admin.jmx.shared.IasRmiDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiDomain;

public class RMIJMXConnectorImpl
extends JMXConnectorImpl {
    public RMIJMXConnectorImpl(JMXServiceURL url, Map environment) {
        super(url, environment);
    }

    protected Domain getDomain(Map env) {
        Object credentials;
        String login = null;
        Object password = null;
        if (env == null) {
            throw new SecurityException("Missing credentials");
        }
        Object credentialsObj = env.get("jmx.remote.credentials");
        if (credentialsObj == null) {
            throw new SecurityException("Missing credentials");
        }
        if (credentialsObj instanceof String[]) {
            credentials = (String[])credentialsObj;
            if (((String[])credentials).length > 0) {
                login = credentials[0];
            }
            if (((String[])credentials).length > 1) {
                password = credentials[1];
            }
        } else if (credentialsObj instanceof Map) {
            credentials = (Map)credentialsObj;
            login = (String)credentials.get("login");
            password = (String)credentials.get("password");
        }
        if (login == null) {
            throw new SecurityException("Missing login in credentials");
        }
        if (password == null) {
            throw new SecurityException("Missing password in credentials");
        }
        String proprietaryMBeanServerDomainName = (String)env.get("com.oracle.jmx.remote.oc4j.proprietarymbeanserverdomainname");
        if (!this.opmnLookup_) {
            if (this.appName_ != null) {
                if (this.domain_ == 1) {
                    Oc4jRmiApplicationLevelDomain dom = new Oc4jRmiApplicationLevelDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, (String)password, this.appName_);
                    return dom;
                }
            }
            if (this.domain_ == 1) {
                Oc4jRmiDomain dom = new Oc4jRmiDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, (String)password);
                if (proprietaryMBeanServerDomainName != null) {
                    dom.addProperty("proprietary_MBeanServer", proprietaryMBeanServerDomainName);
                }
                return dom;
            }
            if (this.appName_ == null) {
                if (this.domain_ == 2) {
                    IasRmiDomain dom = new IasRmiDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, (String)password);
                    return dom;
                }
            }
        } else {
            if (this.appName_ != null) {
                if (this.domain_ == 1) {
                    Oc4jOpmnRmiApplicationLevelDomain dom = new Oc4jOpmnRmiApplicationLevelDomain(this.opmnHost_, this.opmnPort_, this.opmnOC4JInstance_, login, (String)password, this.appName_);
                    return dom;
                }
            }
            if (this.domain_ == 1) {
                Oc4jOpmnRmiDomain dom = new Oc4jOpmnRmiDomain(this.opmnHost_, this.opmnPort_, this.opmnOC4JInstance_, login, (String)password);
                if (proprietaryMBeanServerDomainName != null) {
                    dom.addProperty("proprietary_MBeanServer", proprietaryMBeanServerDomainName);
                }
                return dom;
            }
            if (this.appName_ == null) {
                if (this.domain_ == 2) {
                    IasOpmnRmiDomain dom = new IasOpmnRmiDomain(this.opmnHost_, this.opmnPort_, this.opmnOC4JInstance_, this.opmnASInstance_, login, (String)password);
                    return dom;
                }
            }
        }
        throw new IllegalArgumentException("Invalid connection information");
    }

    protected Connector getConnector(Domain domain) {
        return ClientMBeanServerProxyFactory.getMBeanServer(domain);
    }
}

